/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.model.ITestComposite;
import org.tizen.tizenunittest.gtest.model.NotifyEvent;
import org.tizen.tizenunittest.gtest.model.TestCase;
import org.tizen.tizenunittest.gtest.model.TestElement;
import org.tizen.tizenunittest.gtest.model.TestSession;
import org.tizen.tizenunittest.gtest.model.TestStatus;
import org.tizen.tizenunittest.gtest.model.TestSuite;
import org.tizen.tizenunittest.gtest.model.listener.ISessionListener;
import org.tizen.tizenunittest.gtest.model.listener.ITestCompositeListener;
import org.tizen.tizenunittest.gtest.model.listener.ITestElementListener;
import org.tizen.tizenunittest.gtest.resultview.CuteTestLabelProvider;
import org.tizen.tizenunittest.gtest.resultview.CuteTestTreeContentProvieder;
import org.tizen.tizenunittest.gtest.resultview.TestResultView;
import org.tizen.tizenunittest.gtest.resultview.action.CuteCompareResultAction;
import org.tizen.tizenunittest.gtest.resultview.listener.CuteTestDClickListener;
import org.tizen.tizenunittest.gtest.resultview.listener.CuteTestSelecetionListener;

public class TestViewer
extends Composite
implements ITestElementListener,
ISessionListener,
ITestCompositeListener {
    private final String SHOWNEWTEST_JOBNAME = "Show new Test";
    private final String UPDATETEST_JOBNAME = "Update Test";
    private final String RESETTESTVIEWER_JOBNAME = "Reset TestViewer";
    private SashForm sashForm = null;
    private TreeViewer treeViewer = null;
    private TestResultViewer testResultViewer = null;
    private TestSession session;
    private Vector<TestElement> elemets = new Vector();
    private TestResultView viewPart;
    private boolean failureOnly = false;
    private FailuresOnlyFilter failuresOnlyFilter = new FailuresOnlyFilter();
    private CuteTestDClickListener cuteTestDClickListener;

    public TestViewer(Composite composite, int n, TestResultView testResultView) {
        super(composite, n);
        this.viewPart = testResultView;
        UnitTestPlugin.getModel().addListener(this);
        this.initialize();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UnitTestPlugin.getModel().removeListener(TestViewer.this);
            }
        });
    }

    public void reset(TestSession testSession) {
        this.testResultViewer.setText("");
        this.treeViewer.setInput((Object)testSession);
    }

    public void showTestDetails(TestElement testElement) {
        this.testResultViewer.showTestDetail(testElement);
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 0;
        this.createSashForm();
        this.setLayout((Layout)gridLayout);
    }

    private void createSashForm() {
        this.sashForm = new SashForm((Composite)this, 256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer((Composite)this.sashForm, 0x800000);
        this.treeViewer.setContentProvider((IContentProvider)new CuteTestTreeContentProvieder());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CuteTestLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new CuteTestSelecetionListener(this));
        this.cuteTestDClickListener = new CuteTestDClickListener(this.session);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this.cuteTestDClickListener);
        this.testResultViewer = new TestResultViewer((Composite)this.sashForm, 0x800000);
        this.testResultViewer.setEditable(false);
        this.testResultViewer.setIndent(5);
    }

    @Override
    public void modelChanged(TestElement testElement, NotifyEvent notifyEvent) {
        UpdateTestElement updateTestElement = null;
        switch (notifyEvent.getType()) {
            case suiteFinished: {
                updateTestElement = new UpdateTestElement("Show new Test", notifyEvent.getElement(), false);
                break;
            }
            case testFinished: {
                updateTestElement = new UpdateTestElement("Update Test", notifyEvent.getElement(), true);
                break;
            }
            default: {
                updateTestElement = null;
            }
        }
        if (updateTestElement != null) {
            updateTestElement.schedule();
        }
    }

    @Override
    public void sessionStarted(TestSession testSession) {
        this.session = testSession;
        testSession.addListener(this);
        this.cuteTestDClickListener.setSession(testSession);
        UIJob uIJob = new UIJob("Reset TestViewer"){

            public boolean belongsTo(Object object) {
                return "org.tizen.tizenunittest.gtest".equals(object);
            }

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                TestViewer.this.reset(TestViewer.this.session);
                return new Status(0, "org.tizen.tizenunittest.gtest", 0, "OK", null);
            }
        };
        uIJob.schedule();
    }

    @Override
    public void sessionFinished(TestSession testSession) {
    }

    public void setFailuresOnly(boolean bl) {
        this.failureOnly = bl;
        this.updateFilters();
    }

    private void updateFilters() {
        if (this.failureOnly) {
            this.treeViewer.addFilter((ViewerFilter)this.failuresOnlyFilter);
        } else {
            this.treeViewer.removeFilter((ViewerFilter)this.failuresOnlyFilter);
        }
    }

    public void selectNextFailure() {
        if (this.getSession().hasManagedErrorOrFailure()) {
            Object object = this.getSelectedElement();
            if (object instanceof TestCase) {
                TestCase testCase = (TestCase)object;
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.findNextFailure(testCase)), true);
            } else {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.findFirstFailure()));
            }
        }
    }

    private Object getSelectedElement() {
        StructuredSelection structuredSelection = (StructuredSelection)this.treeViewer.getSelection();
        Object object = structuredSelection.getFirstElement();
        return object;
    }

    protected TestCase getTreeSelection() {
        TreeSelection treeSelection;
        ISelection iSelection = this.treeViewer.getSelection();
        if (iSelection instanceof TreeSelection && (treeSelection = (TreeSelection)iSelection).getFirstElement() instanceof TestCase) {
            TestCase testCase = (TestCase)treeSelection.getFirstElement();
            return testCase;
        }
        return null;
    }

    public void selectFirstFailure() {
        TestElement testElement = this.findFirstFailure();
        if (testElement != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)testElement), true);
        }
    }

    private TestElement findFirstFailure() {
        Vector<TestElement> vector = this.getSession().getElements();
        for (TestElement testElement : vector) {
            if (testElement.getStatus() != TestStatus.failure && testElement.getStatus() != TestStatus.abnormal) continue;
            if (testElement instanceof ITestComposite) {
                ITestComposite iTestComposite = (ITestComposite)((Object)testElement);
                return this.findNextChildFailure(iTestComposite, false);
            }
            return testElement;
        }
        return null;
    }

    private TestSession getSession() {
        if (this.session == null) {
            this.session = UnitTestPlugin.getModel().getSession();
        }
        return this.session;
    }

    private TestElement findNextChildFailure(ITestComposite iTestComposite, boolean bl) {
        Object object;
        Object object2 = iTestComposite.getElements();
        if (bl) {
            object = new Vector();
            int n = ((Vector)object2).size() - 1;
            while (n >= 0) {
                ((Vector)object).add((TestElement)((Vector)object2).get(n));
                --n;
            }
            object2 = object;
        }
        Iterator<? extends TestElement> iterator = ((Vector)object2).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((TestElement)object).getStatus() != TestStatus.failure && ((TestElement)object).getStatus() != TestStatus.abnormal) continue;
            if (object instanceof ITestComposite) {
                ITestComposite iTestComposite2 = (ITestComposite)object;
                return this.findNextChildFailure(iTestComposite2, false);
            }
            return object;
        }
        return null;
    }

    private TestElement findNextFailure(TestCase testCase) {
        TestElement testElement = this.findNextSiblingFailure(testCase, false);
        if (testElement != null) {
            return testElement;
        }
        return this.findNextFailureInParent(testCase.getParent(), testCase, false);
    }

    private TestElement findNextFailureInParent(ITestComposite iTestComposite, TestCase testCase, boolean bl) {
        if (iTestComposite instanceof TestElement) {
            TestElement testElement = (TestElement)((Object)iTestComposite);
            TestElement testElement2 = this.findNextSiblingFailure(testElement, bl);
            if (testElement2 != null) {
                return testElement2;
            }
            return this.findNextFailureInParent(testElement.getParent(), testCase, bl);
        }
        return testCase;
    }

    private TestElement findNextSiblingFailure(TestElement testElement, boolean bl) {
        Serializable serializable;
        Serializable serializable2 = testElement.getParent().getElements();
        int n = ((Vector)serializable2).indexOf(testElement) + 1;
        if (bl) {
            serializable = new Vector();
            int n2 = ((Vector)serializable2).size() - 1;
            while (n2 >= 0) {
                ((Vector)serializable).add((TestElement)((Vector)serializable2).get(n2));
                --n2;
            }
            serializable2 = serializable;
            n = ((Vector)serializable2).size() - n + 1;
        }
        serializable = new StringBuilder("");
        Object object = ((Vector)serializable2).iterator();
        while (object.hasNext()) {
            TestElement testElement2 = object.next();
            ((StringBuilder)serializable).append(String.valueOf(testElement2.getName()) + ", ");
        }
        ListIterator<? extends TestElement> listIterator = ((Vector)serializable2).listIterator(n);
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (((TestElement)object).getStatus() != TestStatus.failure && ((TestElement)object).getStatus() != TestStatus.abnormal) continue;
            if (object instanceof ITestComposite) {
                ITestComposite iTestComposite = (ITestComposite)object;
                return this.findNextChildFailure(iTestComposite, bl);
            }
            return object;
        }
        return null;
    }

    protected void setOrientation(boolean bl) {
        if (this.sashForm == null || this.sashForm.isDisposed()) {
            return;
        }
        this.sashForm.setOrientation(bl ? 256 : 512);
    }

    public void selectPrevFailure() {
        if (this.getSession().hasManagedErrorOrFailure()) {
            Object object = this.getSelectedElement();
            TestElement testElement = null;
            if (object instanceof TestCase) {
                TestCase testCase = (TestCase)object;
                testElement = this.findPrevFailure(testCase);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)testElement), true);
            } else {
                testElement = this.findFirstFailure();
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)testElement), true);
            }
        }
    }

    private TestElement findPrevFailure(TestCase testCase) {
        TestElement testElement = this.findNextSiblingFailure(testCase, true);
        if (testElement != null) {
            return testElement;
        }
        return this.findNextFailureInParent(testCase.getParent(), testCase, true);
    }

    @Override
    public void newTestElement(ITestComposite iTestComposite, TestElement testElement) {
        Object object;
        testElement.addTestElementListener(this);
        if (testElement instanceof ITestComposite) {
            object = (ITestComposite)((Object)testElement);
            object.addListener(this);
        }
        this.elemets.add(testElement);
        object = new ShowNewTest("Show new Test", testElement.getParent(), testElement);
        object.schedule();
    }

    private final class FailuresOnlyFilter
    extends ViewerFilter {
        private FailuresOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof TestElement) {
                TestElement testElement = (TestElement)object2;
                switch (testElement.getStatus()) {
                    case failure: 
                    case abnormal: 
                    case error: {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
    }

    private final class ShowNewTest
    extends UIJob {
        private ITestComposite parent;
        private TestElement element;

        private ShowNewTest(String string, ITestComposite iTestComposite, TestElement testElement) {
            super(string);
            this.parent = iTestComposite;
            this.element = testElement;
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            TestViewer.this.treeViewer.refresh((Object)this.parent, true);
            if (TestViewer.this.viewPart.isAutoScroll()) {
                TestViewer.this.treeViewer.reveal((Object)this.element);
            }
            return new Status(0, "org.tizen.tizenunittest.gtest", 0, "OK", null);
        }
    }

    private class TestResultViewer
    extends StyledText {
        public TestResultViewer(Composite composite, int n) {
            super(composite, n);
            this.addMouseListener((MouseListener)new TestResultDClickListener());
        }

        public void showTestDetail(TestElement testElement) {
            if (testElement instanceof TestCase) {
                TestCase testCase = (TestCase)testElement;
                TestViewer.this.testResultViewer.setText(testCase.getMessage());
                this.redraw();
            } else if (testElement instanceof TestSuite) {
                TestViewer.this.testResultViewer.setText("");
                this.redraw();
            }
        }

        private class TestResultDClickListener
        extends MouseAdapter {
            private TestResultDClickListener() {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TestCase testCase = TestViewer.this.getTreeSelection();
                if (testCase != null) {
                    CuteCompareResultAction cuteCompareResultAction = new CuteCompareResultAction(testCase, TestViewer.this.getShell());
                    cuteCompareResultAction.run();
                }
            }
        }
    }

    private final class UpdateTestElement
    extends UIJob {
        private TestElement element;
        private boolean reveal;

        private UpdateTestElement(String string, TestElement testElement, boolean bl) {
            super(string);
            this.element = testElement;
            this.reveal = bl;
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            TestViewer.this.treeViewer.refresh((Object)this.element, true);
            if (this.reveal && TestViewer.this.viewPart.isAutoScroll()) {
                TestViewer.this.treeViewer.reveal((Object)this.element);
            }
            return new Status(0, "org.tizen.tizenunittest.gtest", 0, "OK", null);
        }
    }
}

