/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.swt.widgets.Composite;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;

public class CuteTextMergeViewer
extends TextMergeViewer {
    private WhitespaceCharacterPainter leftWhitespaceCharacterPainter;
    private WhitespaceCharacterPainter rightWhitespaceCharacterPainter;

    public CuteTextMergeViewer(Composite composite, int n, CompareConfiguration compareConfiguration) {
        super(composite, n, compareConfiguration);
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
    }

    protected void configureTextViewer(TextViewer textViewer) {
        super.configureTextViewer(textViewer);
        WhitespaceCharacterPainter whitespaceCharacterPainter = null;
        if (UnitTestPlugin.getDefault().getPreferenceStore().getBoolean("org.tizen.tizenunittest.SHOW_WHITESPACES")) {
            whitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)textViewer);
            textViewer.addPainter((IPainter)whitespaceCharacterPainter);
        }
    }

    private TextViewer getSourceViewer(ViewerLocation viewerLocation) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = ((Object)((Object)this)).getClass().getSuperclass();
        String string = "";
        switch (viewerLocation) {
            case CENTER: {
                string = "fLeft";
                break;
            }
            case RIGHT: {
                string = "fRight";
                break;
            }
            case LEFT: {
                string = "fAncestor";
                break;
            }
            default: {
                string = "";
            }
        }
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        TextViewer textViewer = (TextViewer)field.get((Object)this);
        return textViewer;
    }

    private void installPainter() {
        try {
            TextViewer textViewer = this.getSourceViewer(ViewerLocation.LEFT);
            TextViewer textViewer2 = this.getSourceViewer(ViewerLocation.RIGHT);
            this.leftWhitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)textViewer);
            textViewer.addPainter((IPainter)this.leftWhitespaceCharacterPainter);
            this.rightWhitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)textViewer2);
            textViewer2.addPainter((IPainter)this.rightWhitespaceCharacterPainter);
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    private void uninstallPainter() {
        try {
            TextViewer textViewer = this.getSourceViewer(ViewerLocation.LEFT);
            TextViewer textViewer2 = this.getSourceViewer(ViewerLocation.RIGHT);
            if (this.leftWhitespaceCharacterPainter == null) {
                this.leftWhitespaceCharacterPainter = this.getWhitespaceCharacterPainter(textViewer);
            }
            if (this.rightWhitespaceCharacterPainter == null) {
                this.rightWhitespaceCharacterPainter = this.getWhitespaceCharacterPainter(textViewer2);
            }
            textViewer.removePainter((IPainter)this.leftWhitespaceCharacterPainter);
            textViewer2.removePainter((IPainter)this.rightWhitespaceCharacterPainter);
            textViewer.invalidateTextPresentation();
            textViewer2.invalidateTextPresentation();
            textViewer.refresh();
            textViewer2.refresh();
        }
        catch (Exception exception) {
            this.logException(exception);
        }
    }

    private WhitespaceCharacterPainter getWhitespaceCharacterPainter(Object object) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.jface.text.TextViewer");
            Field field = clazz.getDeclaredField("fPaintManager");
            field.setAccessible(true);
            PaintManager paintManager = (PaintManager)field.get(object);
            Class<?> clazz2 = paintManager.getClass();
            Field field2 = clazz2.getDeclaredField("fPainters");
            field2.setAccessible(true);
            List list = (List)field2.get(paintManager);
            for (Object e : list) {
                if (!(e instanceof WhitespaceCharacterPainter)) continue;
                WhitespaceCharacterPainter whitespaceCharacterPainter = (WhitespaceCharacterPainter)e;
                return whitespaceCharacterPainter;
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        return null;
    }

    private void logException(Exception exception) {
        UnitTestPlugin.log((IStatus)new Status(4, "org.tizen.tizenunittest.gtest", exception.getMessage(), (Throwable)exception));
    }

    public void showWhitespaces(boolean bl) {
        if (bl) {
            this.installPainter();
        } else {
            this.uninstallPainter();
        }
        this.invalidateTextPresentation();
        this.refresh();
    }

    private static enum ViewerLocation {
        LEFT,
        CENTER,
        RIGHT;

    }
}

