/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UnitTestXml {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    IProject project;
    protected String xmlFileName = "/unittest.xml";
    protected String StrTestName = "tizen_unittest";
    static final String StrTargetProject = "targetProject";
    static final String StrTargetFile = "targetFile";
    static final String StrTargetObjectFile = "targetObjectFile";
    public static final String DEFAULT_XML_ENCODING = "UTF-8";

    public UnitTestXml(IProject iProject) {
        this.project = iProject;
    }

    public void setTargetMainName(String string) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", DEFAULT_XML_ENCODING);
        DocumentBuilder documentBuilder = null;
        Document document = null;
        if (!new File(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName).exists()) {
            return;
        }
        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = documentBuilder.parse(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName);
        NodeList nodeList = document.getElementsByTagName(this.StrTestName);
        Node node = null;
        node = document.getElementsByTagName(StrTargetFile).item(0);
        if (node != null) {
            node.setTextContent(string);
        } else {
            Element element = document.createElement(StrTargetFile);
            element.setTextContent(string);
            nodeList.item(0).appendChild(element);
        }
        transformer.transform(new DOMSource(document), new StreamResult(new FileWriter(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName, false)));
    }

    public String getTargetMainFile() throws ParserConfigurationException, SAXException, IOException {
        String string = null;
        DocumentBuilder documentBuilder = null;
        Document document = null;
        if (!new File(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName).exists()) {
            return null;
        }
        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = documentBuilder.parse(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName);
        NodeList nodeList = document.getElementsByTagName(StrTargetFile);
        if (nodeList.item(0) == null) {
            return null;
        }
        string = nodeList.item(0).getTextContent();
        return string;
    }

    public ArrayList<String> getTargetObjectFile() throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        if (!new File(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName).exists()) {
            return null;
        }
        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = documentBuilder.parse(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName);
        NodeList nodeList = document.getElementsByTagName(StrTargetObjectFile);
        if (nodeList.item(0) == null) {
            return null;
        }
        Node node = null;
        int n = 0;
        node = nodeList.item(n);
        while (n < nodeList.getLength()) {
            if (node.getTextContent() != null) {
                arrayList.add(node.getTextContent());
            }
            node = nodeList.item(++n);
        }
        return arrayList;
    }

    public void setTargetObjectFile(String string) throws SAXException, IOException, ParserConfigurationException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", DEFAULT_XML_ENCODING);
        DocumentBuilder documentBuilder = null;
        Document document = null;
        if (!new File(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName).exists()) {
            return;
        }
        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = documentBuilder.parse(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName);
        NodeList nodeList = document.getElementsByTagName(this.StrTestName);
        NodeList nodeList2 = document.getElementsByTagName(StrTargetObjectFile);
        int n = 0;
        if (nodeList2.item(0) == null) {
            Element element = document.createElement(StrTargetObjectFile);
            element.setTextContent(string);
            nodeList.item(0).appendChild(element);
        } else {
            Node node = nodeList2.item(n);
            while (n < nodeList2.getLength()) {
                if (node.getTextContent().equals(string)) {
                    return;
                }
                node = nodeList2.item(++n);
            }
            Element element = document.createElement(StrTargetObjectFile);
            element.setTextContent(string);
            nodeList.item(0).appendChild(element);
        }
        transformer.transform(new DOMSource(document), new StreamResult(new FileWriter(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName, false)));
    }

    public void removeTargetObjectFile(String string) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", DEFAULT_XML_ENCODING);
        DocumentBuilder documentBuilder = null;
        Document document = null;
        if (!new File(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName).exists()) {
            return;
        }
        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = documentBuilder.parse(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName);
        NodeList nodeList = document.getElementsByTagName(StrTargetObjectFile);
        int n = 0;
        if (nodeList.item(0) == null) {
            return;
        }
        Node node = nodeList.item(n);
        while (n < nodeList.getLength()) {
            if (node.getTextContent().equals(string)) {
                Node node2 = node.getParentNode();
                node2.removeChild(node.getNextSibling());
                node2.removeChild(node);
            }
            node = nodeList.item(++n);
        }
        transformer.transform(new DOMSource(document), new StreamResult(new FileWriter(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName, false)));
    }

    public IProject getTargetProject() throws IOException, ParserConfigurationException, SAXException {
        IProject iProject = null;
        DocumentBuilder documentBuilder = null;
        Document document = null;
        if (!new File(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName).exists()) {
            return null;
        }
        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = documentBuilder.parse(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName);
        NodeList nodeList = document.getElementsByTagName(StrTargetProject);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        iProject = iWorkspaceRoot.getProject(nodeList.item(0).getTextContent());
        return iProject;
    }

    public void createXml(IProject iProject) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", DEFAULT_XML_ENCODING);
            Element element = document.createElement(this.StrTestName);
            Element element2 = document.createElement(StrTargetProject);
            element2.setTextContent(iProject.getName());
            element.appendChild(element2);
            document.appendChild(element);
            transformer.transform(new DOMSource(document), new StreamResult(new FileWriter(String.valueOf(this.project.getLocation().toString()) + this.xmlFileName, false)));
        }
        catch (Exception exception) {
            this.logger.error("Failed to create a xml file", (Throwable)exception);
        }
    }
}

