/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.gtest.testexplorer;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestCase;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestNode;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestSuite;

public class TXLabelProvider
extends LabelProvider {
    private Image successedImage = UnitTestPlugin.getImageDescriptor("obj16/result_success.png").createImage();
    private Image failedImage = UnitTestPlugin.getImageDescriptor("obj16/failed.png").createImage();
    private Image managedImage = UnitTestPlugin.getImageDescriptor("obj16/result_abnormal.png").createImage();
    private Image timeOutImage = UnitTestPlugin.getImageDescriptor("obj16/timeout.png").createImage();
    private Image abnormalTermitationImage = UnitTestPlugin.getImageDescriptor("obj16/result_abnormal_term.png").createImage();
    private Image errorImage = UnitTestPlugin.getImageDescriptor("obj16/result_error.png").createImage();
    private Image disabledImage = UnitTestPlugin.getImageDescriptor("obj16/disabled.png").createImage();
    private Image notRunnedImage = UnitTestPlugin.getImageDescriptor("obj16/not_run.png").createImage();

    public Image getImage(Object object) {
        if (object instanceof TXTestNode) {
            TXTestNode tXTestNode = (TXTestNode)object;
            switch (tXTestNode.getStatus()) {
                case notrunned: {
                    return this.notRunnedImage;
                }
                case successed: {
                    return this.successedImage;
                }
                case disabled: {
                    return this.disabledImage;
                }
                case failed: {
                    return this.failedImage;
                }
                case abnormal: {
                    if (tXTestNode instanceof TXTestSuite) {
                        return this.managedImage;
                    }
                    TXTestCase tXTestCase = (TXTestCase)tXTestNode;
                    String string = tXTestCase.getReason().trim();
                    if (string.equals("Test time out")) {
                        return this.timeOutImage;
                    }
                    return this.abnormalTermitationImage;
                }
                case error: {
                    return this.errorImage;
                }
            }
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof TXTestNode) {
            TXTestNode tXTestNode = (TXTestNode)object;
            return tXTestNode.getName();
        }
        return null;
    }
}

