/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.model;

import org.eclipse.core.resources.IFile;
import org.tizen.tizenunittest.gtest.model.ITestComposite;
import org.tizen.tizenunittest.gtest.model.NotifyEvent;
import org.tizen.tizenunittest.gtest.model.TestElement;
import org.tizen.tizenunittest.gtest.model.TestResult;
import org.tizen.tizenunittest.gtest.model.TestStatus;

public class TestCase
extends TestElement {
    private TestStatus status;
    private String name;
    private IFile file;
    private int lineNumber = -1;
    private TestResult result;
    private ITestComposite parent = null;

    public TestCase(String string) {
        this.name = string;
        this.status = TestStatus.running;
    }

    @Override
    public ITestComposite getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITestComposite iTestComposite) {
        this.parent = iTestComposite;
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TestStatus getStatus() {
        return this.status;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        if (this.result == null) {
            return "";
        }
        return this.result.getMsg();
    }

    public String toString() {
        return this.getName();
    }

    public void endTest(IFile iFile, int n, TestResult testResult, TestStatus testStatus) {
        this.file = iFile;
        this.lineNumber = n;
        this.result = testResult;
        this.status = testStatus;
        this.notifyListeners(new NotifyEvent(NotifyEvent.EventType.testFinished, this));
    }

    public TestResult getResult() {
        return this.result;
    }
}

