/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.tizen.tizenunittest.gtest.model.CuteModel;

public class UnitTestPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.tizenunittest.gtest";
    private static UnitTestPlugin plugin;
    private static final IPath ICONS_PATH;
    private final CuteModel model = new CuteModel();
    private Display display;

    static {
        ICONS_PATH = new Path("$nl$/icons");
    }

    public UnitTestPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.display = Display.getCurrent();
        if (this.display == null) {
            this.display = Display.getDefault();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static UnitTestPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UnitTestPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return UnitTestPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        IPath iPath = ICONS_PATH.append(string);
        return UnitTestPlugin.createImageDescriptor(UnitTestPlugin.getDefault().getBundle(), iPath);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (plugin == null) {
            return null;
        }
        IWorkbench iWorkbench = plugin.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        return iWorkbench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = UnitTestPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath iPath) {
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)iPath, null);
        return ImageDescriptor.createFromURL((URL)uRL);
    }

    public static void log(Throwable throwable) {
        UnitTestPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", throwable));
    }

    public static void log(IStatus iStatus) {
        UnitTestPlugin.getDefault().getLog().log(iStatus);
    }

    public static CuteModel getModel() {
        return UnitTestPlugin.getDefault().model;
    }

    public static Display getDisplay() {
        return UnitTestPlugin.getDefault().display;
    }
}

