/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.sdblib.IDevice;

public class GtestOption {
    public static final String ATTR_UNITTEST_GEN_XML = "org.tizen.tizenunittest.gtest.launch.GEN_XML_ATTR";
    public static final String ATTR_UNITTEST_GEN_XML_PATH = "org.tizen.tizenunittest.gtest.launch.GEN_XML_PATH_ATTR";
    public static final String ATTR_UNITTEST_TIMEOUT = "org.tizen.tizenunittest.gtest.launch.TX_TIMEOUT_ATTR";
    public static final String ATTR_UNITTEST_TIMEOUT_VALUE = "org.tizen.tizenunittest.gtest.launch.TX_TIMEOUT_VALUE_ATTR";
    public static final String ATTR_UNITTEST_TX_OPTIONS = "org.tizen.tizenunittest.gtest.launch.TX_OPTIONS_ATTR";
    public static final String ATTR_UNITTEST_ELAPSED_TIME = "org.tizen.tizenunittest.gtest.launch.ELAPSED_TIME_ATTR";
    public static final String ATTR_UNITTEST_SHUFFLE_TEST = "org.tizen.tizenunittest.gtest.launch.SHUFLE_TEST_ATTR";
    public static final String ATTR_UNITTEST_RUN_DISABLE = "org.tizen.tizenunittest.gtest.launch.RUN_DISABLE_ATTR";
    protected static final String EMPTY_STRING = "";
    private ILaunchConfiguration launchConfiguration;
    private IProject project;
    private IDevice device;
    private String xmlReportPath;
    private boolean isXmlReport = false;
    private String txOptions;
    private boolean isRunDisable = false;
    private boolean isElapseTime = false;
    private boolean isShuffleTest = false;

    public GtestOption(ILaunchConfiguration iLaunchConfiguration, IProject iProject, IDevice iDevice) {
        this.launchConfiguration = iLaunchConfiguration;
        this.project = iProject;
        this.device = iDevice;
        this.readGtestOption();
    }

    private void readGtestOption() {
        this.isXmlReport = this.getAttribute(ATTR_UNITTEST_GEN_XML, false);
        this.xmlReportPath = this.getAttribute(ATTR_UNITTEST_GEN_XML_PATH, "teMp_gtEst_resUlt_fOr_tiZen.xml");
        this.txOptions = this.getAttribute(ATTR_UNITTEST_TX_OPTIONS, EMPTY_STRING);
        this.isRunDisable = this.getAttribute(ATTR_UNITTEST_RUN_DISABLE, false);
        this.isElapseTime = this.getAttribute(ATTR_UNITTEST_ELAPSED_TIME, false);
        this.isShuffleTest = this.getAttribute(ATTR_UNITTEST_SHUFFLE_TEST, false);
    }

    public String getArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getGenXmlReportArgument());
        stringBuilder.append(this.getRunDisableArgument());
        stringBuilder.append(this.getElapsedTimeArgument());
        stringBuilder.append(this.getShuffleTestArgument());
        stringBuilder.append(this.txOptions);
        return stringBuilder.toString();
    }

    private String getGenXmlReportArgument() {
        return " --gtest_output=xml:" + this.getTargetXmlReportPath();
    }

    private String getRunDisableArgument() {
        if (this.isRunDisable) {
            return " --gtest_also_run_disabled_tests";
        }
        return EMPTY_STRING;
    }

    private String getElapsedTimeArgument() {
        if (this.isElapseTime) {
            return " --gtest_print_time=0";
        }
        return EMPTY_STRING;
    }

    private String getShuffleTestArgument() {
        if (this.isShuffleTest) {
            return " --gtest_shuffle";
        }
        return EMPTY_STRING;
    }

    private String getTargetDataPath() {
        String string = ProjectUtil.getAppTmpDirectory((IProject)this.project, (IDevice)this.device);
        String string2 = String.valueOf(string) + "/data/";
        return string2;
    }

    private boolean getAttribute(String string, boolean bl) {
        try {
            return this.launchConfiguration.getAttribute(string, bl);
        }
        catch (CoreException coreException) {
            return bl;
        }
    }

    private String getAttribute(String string, String string2) {
        try {
            return this.launchConfiguration.getAttribute(string, string2);
        }
        catch (CoreException coreException) {
            return string2;
        }
    }

    public String getHostXmlReportPath() {
        if (this.isXmlReport) {
            return this.xmlReportPath;
        }
        return String.valueOf(this.project.getLocation().toString()) + "/" + "teMp_gtEst_resUlt_fOr_tiZen.xml";
    }

    public String getTargetXmlReportPath() {
        return String.valueOf(this.getTargetDataPath()) + "teMp_gtEst_resUlt_fOr_tiZen.xml";
    }
}

