/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.tizenunittest.gtest.common.UnitTestXml;
import org.xml.sax.SAXException;

public class UnitTestCommon {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String ENTRY_SYMBOL = "main";
    public static int main_num = 0;

    public static void changeBuilder(IProject iProject) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration[] iConfigurationArray = iManagedBuildInfo.getDefaultConfiguration().getManagedProject().getConfigurations();
        IBuilder[] iBuilderArray = ManagedBuildManager.getRealBuilders();
        IConfiguration[] iConfigurationArray2 = iConfigurationArray;
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration iConfiguration = iConfigurationArray2[n2];
            IBuilder[] iBuilderArray2 = iBuilderArray;
            int n3 = iBuilderArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBuilder iBuilder = iBuilderArray2[n4];
                if (iBuilder != null && iBuilder.getName().equals("Tizen TEST MAKE builder")) {
                    iConfiguration.changeBuilder(iBuilder, ManagedBuildManager.calculateChildId((String)iBuilder.getBaseId(), null), iBuilder.getName());
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static boolean equalsTargetBuildName(IProject iProject, IProject iProject2) {
        String string = UnitTestCommon.projectBuildName(iProject);
        String string2 = UnitTestCommon.projectBuildName(iProject2);
        return string.equals(string2);
    }

    public static boolean equalsArch(IProject iProject, IProject iProject2) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        String string = CommonConfigurationManager.getArchitecture((IConfiguration)iConfiguration);
        IManagedBuildInfo iManagedBuildInfo2 = ManagedBuildManager.getBuildInfo((IResource)iProject2);
        IConfiguration iConfiguration2 = iManagedBuildInfo2.getDefaultConfiguration();
        String string2 = CommonConfigurationManager.getArchitecture((IConfiguration)iConfiguration2);
        return string.equals(string2);
    }

    public static String projectBuildName(IProject iProject) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        return iManagedBuildInfo.getConfigurationName();
    }

    public static String projectConfigId(IProject iProject) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        return iConfiguration.getParent().getId();
    }

    public void setSourceEntry(IProject iProject, IProject iProject2) throws CoreException {
        String string = String.valueOf(iProject2.getName()) + "'s include";
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        IPath iPath = iProject2.getFolder("include").getLocation();
        if (iPath == null || iPath.isEmpty()) {
            return;
        }
        IFolder iFolder = iProject.getFolder(string);
        if (iFolder.exists()) {
            iFolder.delete(true, null);
        }
        iFolder.createLink(iPath, 0, null);
        CSourceEntry cSourceEntry = new CSourceEntry(string, null, 0);
        IConfiguration[] iConfigurationArray = iConfiguration.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration iConfiguration2 = iConfigurationArray[n2];
            ICSourceEntry[] iCSourceEntryArray = iConfiguration2.getSourceEntries();
            HashSet<Object> hashSet = new HashSet<Object>();
            int n3 = 0;
            while (n3 < iCSourceEntryArray.length) {
                hashSet.add(iCSourceEntryArray[n3]);
                ++n3;
            }
            if (!hashSet.contains(cSourceEntry)) {
                hashSet.add(cSourceEntry);
                iConfiguration2.setSourceEntries(hashSet.toArray(new ICSourceEntry[hashSet.size()]));
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
    }

    public ArrayList<IFile> divideCFile(List<?> list, IProject iProject, IProject iProject2, IProgressMonitor iProgressMonitor) throws CoreException, IOException, ParserConfigurationException, SAXException {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        for (IFile iFile : list) {
            ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile);
            if (iTranslationUnit == null) continue;
            ICElement[] iCElementArray = iTranslationUnit.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFunctionDeclaration iFunctionDeclaration;
                ICElement iCElement2 = iCElementArray[n2];
                if (iCElement2.getElementType() == 74 && (iFunctionDeclaration = (IFunctionDeclaration)iCElement2).getElementName().equals(ENTRY_SYMBOL) && iFunctionDeclaration.isActive()) break;
                ++n2;
            }
            long l = Arrays.asList(iTranslationUnit.getChildren()).parallelStream().filter(iCElement -> iCElement.getElementType() == 74).filter(iCElement -> ((IFunctionDeclaration)iCElement).getElementName().equals(ENTRY_SYMBOL)).filter(iCElement -> ((IFunctionDeclaration)iCElement).isActive()).count();
            if (l != 0L) {
                this.replaceTargetMain(iProject, iFile, main_num);
                continue;
            }
            arrayList.add(iFile);
        }
        return arrayList;
    }

    boolean hasEntrySymbol(ITranslationUnit iTranslationUnit) throws CModelException {
        if (iTranslationUnit == null) {
            return false;
        }
        long l = Arrays.asList(iTranslationUnit.getChildren()).parallelStream().filter(iCElement -> iCElement.getElementType() == 74).filter(iCElement -> ((IFunctionDeclaration)iCElement).getElementName().equals(ENTRY_SYMBOL)).filter(iCElement -> ((IFunctionDeclaration)iCElement).isActive()).count();
        return l != 0L;
    }

    public ArrayList<IFile> divideCFileParallel(List<IFile> list, IProject iProject, IProject iProject2, IProgressMonitor iProgressMonitor) throws CoreException, IOException, ParserConfigurationException, SAXException {
        Object object2;
        List list2 = list.parallelStream().filter(iFile -> {
            IFile iFile2 = iFile;
            ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile2);
            try {
                return this.hasEntrySymbol(iTranslationUnit);
            }
            catch (CModelException cModelException) {
                return false;
            }
        }).collect(Collectors.toList());
        for (Object object2 : list2) {
            this.replaceTargetMain(iProject, (IFile)object2, main_num);
        }
        object2 = (ArrayList)list.parallelStream().filter(iFile -> !list2.contains(iFile)).collect(Collectors.toList());
        return object2;
    }

    protected String getTargetMainFile(IProject iProject) throws ParserConfigurationException, SAXException, IOException {
        return new UnitTestXml(iProject).getTargetMainFile();
    }

    protected void setTargetMainName(IProject iProject, String string) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        new UnitTestXml(iProject).setTargetMainName(string);
    }

    public static String makePropertyOption(String string) {
        string = string.replaceAll("\\\\", "/");
        return String.format("\"%s\"", string);
    }

    private String replaceTargetMain(IProject iProject, IFile iFile, int n) throws CoreException, IOException, ParserConfigurationException, SAXException {
        Object object;
        String string = iFile.getName();
        String string2 = " main" + n;
        String string3 = "#define main" + string2 + "\n";
        String string4 = "src/." + string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(iFile.getLocation().toString());
            object = null;
            object = iProject.getFile(string4);
            if (object.exists()) {
                object.delete(true, null);
            }
            object.create((InputStream)fileInputStream, true, null);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{fileInputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{fileInputStream});
        object = new File(iProject.getFile(string4).getLocation().toString());
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile((File)object, "rwd");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.seek(0L);
            String string5 = new String(byArray);
            randomAccessFile.write(string3.getBytes());
            randomAccessFile.write(string5.getBytes());
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{randomAccessFile});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{randomAccessFile});
        try {
            this.setTargetMainName(iProject, iFile.getName());
        }
        catch (TransformerException transformerException) {
            this.logger.error("Failed to transform", (Throwable)transformerException);
        }
        return string4;
    }

    public void setStringtoFile(String string, String string2, ArrayList<IFile> arrayList) throws CoreException, IOException {
        File file = new File(string);
        StringBuilder stringBuilder = new StringBuilder();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rwd");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.seek(0L);
            String string3 = new String(byArray);
            stringBuilder.append("extern \"C\"{\n");
            for (IFile iFile : arrayList) {
                String string4 = iFile.getLocation().toString();
                if (!string4.startsWith(string2)) continue;
                stringBuilder.append(String.format("#include \"%s\"\n", string4.substring(string2.length() + 1)));
            }
            stringBuilder.append("}\n");
            randomAccessFile.write(stringBuilder.toString().getBytes());
            randomAccessFile.write(string3.getBytes());
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{randomAccessFile});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{randomAccessFile});
    }

    public static void fileCopy(String string, IFile iFile) throws CoreException, FileNotFoundException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            if (iFile.exists()) {
                iFile.delete(true, null);
            }
            iFile.create((InputStream)fileInputStream, true, null);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{fileInputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{fileInputStream});
    }
}

