/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.wizards.newWizard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.unittest.IUnitTestHandler;
import org.tizen.nativecommon.unittest.UnitTestProjectInfo;
import org.tizen.nativecommon.unittest.UnitTestRegistry;
import org.tizen.nativecore.build.makefile.NativeCoreNinjaFileGenerator;
import org.tizen.tizenunittest.gtest.Utils;
import org.tizen.tizenunittest.gtest.common.UnitTestCommon;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.common.UnitTestXml;
import org.xml.sax.SAXException;

public class UnitTestNinjaGenerator
extends NativeCoreNinjaFileGenerator {
    private static final Logger logger = LoggerFactory.getLogger(UnitTestNinjaGenerator.class);
    public static final String GNU_CPP_LINK_OPTION_ID = "gnu.cpp.link.option.libs";
    public static final String GNU_CPP_LINK_PATH = "gnu.cpp.link.option.paths";
    public boolean projectBuild = false;
    public boolean deleteFile = false;
    public boolean chUIThread = true;
    protected IProject targetProject;
    protected IProject testProject;

    public MultiStatus generateMakefiles(IResourceDelta iResourceDelta) throws CoreException {
        return this.regenerateMakefiles();
    }

    private List<String> getTargetObjectFileList(IProject iProject, IProject iProject2, boolean bl) throws ParserConfigurationException, SAXException {
        ArrayList arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        UnitTestCommon unitTestCommon = new UnitTestCommon();
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject2);
        if (iUnitTestHandler == null) {
            return arrayList2;
        }
        ArrayList arrayList3 = iUnitTestHandler.getBuildObjectFiles(iProject2);
        ArrayList arrayList4 = arrayList = iUnitTestHandler.getBuildSources(iProject2);
        ArrayList<IFile> arrayList5 = null;
        try {
            arrayList5 = bl ? unitTestCommon.divideCFileParallel(arrayList4, iProject, iProject2, null) : unitTestCommon.divideCFile(arrayList, iProject, iProject2, null);
        }
        catch (CoreException coreException) {
            logger.error("Failed to divide a file", (Throwable)coreException);
        }
        catch (IOException iOException) {
            logger.error("Failed to divide a file", (Throwable)iOException);
        }
        String string = iProject2.getLocation().toString();
        string = string.replace("\\", "/");
        int n = arrayList3.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = arrayList5.size();
            int n4 = 0;
            while (n4 < n3) {
                if (((IPath)arrayList3.get(n2)).removeFileExtension().lastSegment().equals(((IFile)arrayList5.get(n4)).getFullPath().removeFileExtension().lastSegment())) {
                    if (!new File(((IPath)arrayList3.get(n2)).toString()).exists()) break;
                    String string2 = ((IPath)arrayList3.get(n2)).toString();
                    string2 = string2.replace("\\", "/");
                    string2 = string2.substring(string.length());
                    string2 = "\"${" + iProject2.getName().toUpperCase() + "}" + string2 + "\"";
                    arrayList2.add(string2);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return arrayList2;
    }

    private void setObjectPathToLinker(IProject iProject, List<String> list) throws ParserConfigurationException, SAXException, IOException {
        List<String> list2 = this.getTargetProjectObjectListOld(iProject);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list2 != null) {
            for (String object2 : list2) {
                if (list.contains(object2)) continue;
                arrayList.add(object2);
            }
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        this.removeTargetProjectObject(iProject, arrayList);
        this.setTargetProjectObjectList(iProject, list);
        IConfiguration[] iConfigurationArray = iConfiguration.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration iConfiguration2 = iConfigurationArray[n2];
            for (String string : arrayList) {
                CommonConfigurationManager.removeOtherObjectFromLinker((IConfiguration)iConfiguration2, (String)UnitTestCommon.makePropertyOption(string));
            }
            ++n2;
        }
        for (String string : list) {
            CommonConfigurationManager.appendOtherObjectToLinker((IConfiguration)iConfiguration, (String)UnitTestCommon.makePropertyOption(string));
        }
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
    }

    protected MultiStatus preRegenerateMakefiles() throws CoreException {
        this.testProject = this.getTestProject(this.getTopBuildDir());
        this.targetProject = this.getTargetProject(this.testProject);
        if (this.targetProject == null) {
            return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, UnitTestMessages.WIZARD_ERROR_UNITTEST_XML, null);
        }
        if (!this.targetProject.exists() || !this.targetProject.isOpen()) {
            return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, NLS.bind((String)UnitTestMessages.BUILD_ERROR_TARGET_EXISTS, (Object)this.targetProject.getName()), null);
        }
        UnitTestProjectInfo unitTestProjectInfo = UnitTestRegistry.getUnitTestProjectInfo((IProject)this.targetProject);
        try {
            this.populateSettings(this.testProject, this.targetProject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        MultiStatus multiStatus = null;
        if ("share".equals(unitTestProjectInfo.getTargetProjectType())) {
            multiStatus = this.checkTargetStatus(false);
            if (multiStatus.getCode() == 4) {
                return multiStatus;
            }
            return multiStatus;
        }
        if ("static".equals(unitTestProjectInfo.getTargetProjectType())) {
            multiStatus = this.checkTargetStatus(false);
            return multiStatus;
        }
        multiStatus = this.checkTargetStatus(true);
        if (multiStatus.getCode() == 4) {
            return multiStatus;
        }
        return multiStatus;
    }

    private void populateSettings(IProject iProject2, IProject iProject3) throws Exception {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<IProject> arrayList2 = new ArrayList<IProject>();
        arrayList2.addAll(Arrays.asList(iProject3.getReferencedProjects()));
        arrayList2.add(iProject3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (IProject iProject4 : arrayList2) {
            object = iProject4.getLocation();
            if (object == null) continue;
            string = object.toString();
            string = string.replace("\\", "/");
            hashMap.put(string, iProject4.getName());
        }
        for (IProject iProject4 : arrayList2) {
            String[] stringArray;
            String string2;
            Object object22;
            Object object3;
            String[] stringArray2;
            object = ManagedBuildManager.getBuildInfo((IResource)iProject2);
            string = ManagedBuildManager.getBuildInfo((IResource)iProject4);
            if (string == null) continue;
            IConfiguration iConfiguration = object.getDefaultConfiguration();
            IConfiguration iConfiguration2 = string.getDefaultConfiguration();
            IContributedEnvironment iContributedEnvironment = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
            String string3 = iProject4.getLocation().toString();
            string3 = string3.replace("\\", "/");
            String string4 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            string4 = string4.replace("\\", "/");
            IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject3);
            String[] stringArray3 = Utils.parseOptionValue(iConfiguration, "C Compiler", iUnitTestHandler.getCOptionIncludePathId());
            int n = 0;
            while (n < stringArray3.length) {
                stringArray3[n] = stringArray3[n].replaceAll("^\"|\"$", "");
                stringArray3[n] = stringArray3[n].replace("\\", "/");
                ++n;
            }
            ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(stringArray3));
            String[] stringArray4 = Utils.parseOptionValue(iConfiguration, "C++ Compiler", iUnitTestHandler.getCPPOptionIncludePathId());
            int n2 = 0;
            while (n2 < stringArray4.length) {
                stringArray4[n2] = stringArray4[n2].replaceAll("^\"|\"$", "");
                stringArray4[n2] = stringArray4[n2].replace("\\", "/");
                ++n2;
            }
            ArrayList<String> arrayList4 = new ArrayList<String>(Arrays.asList(stringArray4));
            ICConfigurationDescription iCConfigurationDescription = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)iConfiguration);
            String[] stringArray5 = stringArray2 = Utils.parseOptionValue(iConfiguration2, "C Compiler", iUnitTestHandler.getCOptionIncludePathId());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                object3 = stringArray5[n4];
                object3 = ((String)object3).replaceAll("^\"|\"$", "");
                if (!arrayList3.contains(object3 = ((String)object3).replace("\\", "/")) || !arrayList4.contains(object3)) {
                    if (((String)object3).startsWith(string3)) {
                        String string5 = ((String)object3).substring(string3.length());
                        string5 = "\"${" + iProject4.getName().toUpperCase() + "}" + string5 + "\"";
                        if (!arrayList3.contains(object3)) {
                            iUnitTestHandler.appendIncludePathToCCompiler(iConfiguration, string5);
                            arrayList3.add((String)object3);
                        }
                        if (!arrayList4.contains(object3)) {
                            iUnitTestHandler.appendIncludePathToCPPCompiler(iConfiguration, string5);
                            arrayList4.add((String)object3);
                        }
                    } else {
                        boolean bl = false;
                        for (Object object22 : hashMap.keySet()) {
                            if (!((String)object3).startsWith((String)object22)) continue;
                            string2 = ((String)object3).substring(((String)object22).length());
                            stringArray = ((String)hashMap.get(object22)).toUpperCase();
                            string2 = "\"${" + (String)stringArray + "}" + string2 + "\"";
                            iUnitTestHandler.appendIncludePathToCCompiler(iConfiguration, string2);
                            if (!arrayList3.contains(object3)) {
                                iUnitTestHandler.appendIncludePathToCCompiler(iConfiguration, string2);
                                arrayList3.add((String)object3);
                            }
                            if (!arrayList4.contains(object3)) {
                                iUnitTestHandler.appendIncludePathToCPPCompiler(iConfiguration, string2);
                                arrayList4.add((String)object3);
                            }
                            iContributedEnvironment.addVariable((String)stringArray, (String)object22, 1, "", iCConfigurationDescription);
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            if (!arrayList3.contains(object3)) {
                                iUnitTestHandler.appendIncludePathToCCompiler(iConfiguration, (String)object3);
                                arrayList3.add((String)object3);
                            }
                            if (!arrayList4.contains(object3)) {
                                iUnitTestHandler.appendIncludePathToCPPCompiler(iConfiguration, (String)object3);
                                arrayList4.add((String)object3);
                            }
                        }
                    }
                }
                ++n4;
            }
            stringArray5 = stringArray2 = Utils.parseOptionValue(iConfiguration2, "C++ Compiler", iUnitTestHandler.getCPPOptionIncludePathId());
            n3 = stringArray2.length;
            n4 = 0;
            while (n4 < n3) {
                object3 = stringArray5[n4];
                object3 = ((String)object3).replaceAll("^\"|\"$", "");
                if (!arrayList4.contains(object3 = ((String)object3).replace("\\", "/"))) {
                    if (((String)object3).startsWith(string3)) {
                        String string6 = ((String)object3).substring(string3.length());
                        string6 = "\"${" + iProject4.getName().toUpperCase() + "}" + string6 + "\"";
                        iUnitTestHandler.appendIncludePathToCPPCompiler(iConfiguration, string6);
                    } else {
                        boolean bl = false;
                        for (Object object22 : hashMap.keySet()) {
                            if (!((String)object3).startsWith((String)object22)) continue;
                            string2 = ((String)object3).substring(((String)object22).length());
                            stringArray = ((String)hashMap.get(object22)).toUpperCase();
                            string2 = "\"${" + (String)stringArray + "}" + string2 + "\"";
                            iUnitTestHandler.appendIncludePathToCPPCompiler(iConfiguration, string2);
                            iContributedEnvironment.addVariable((String)stringArray, (String)object22, 1, "", iCConfigurationDescription);
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            iUnitTestHandler.appendIncludePathToCPPCompiler(iConfiguration, (String)object3);
                        }
                    }
                }
                ++n4;
            }
            object3 = Utils.parseOptionValue(iConfiguration2, "C++ Linker", GNU_CPP_LINK_OPTION_ID);
            List<String> list = Arrays.asList(Utils.parseOptionValue(iConfiguration, "C++ Linker", GNU_CPP_LINK_OPTION_ID));
            object22 = object3;
            int n5 = ((Object)object22).length;
            int n6 = 0;
            while (n6 < n5) {
                Object object4 = object22[n6];
                if (!list.contains(object4)) {
                    CommonConfigurationManager.appendLibraryToLinker((IConfiguration)iConfiguration, (String)object4);
                }
                ++n6;
            }
            UnitTestNinjaGenerator.copyFolder(String.valueOf(iProject4.getLocation().toString()) + File.separator + "lib", String.valueOf(iProject2.getLocation().toString()) + File.separator + "lib");
            String[] stringArray6 = Utils.parseOptionValue(iConfiguration2, "C++ Linker", GNU_CPP_LINK_PATH);
            stringArray5 = Utils.parseOptionValue(iConfiguration, "C++ Compiler", GNU_CPP_LINK_PATH);
            n5 = 0;
            while (n5 < stringArray5.length) {
                stringArray5[n5] = stringArray5[n5].replaceAll("^\"|\"$", "");
                stringArray5[n5] = stringArray5[n5].replace("\\", "/");
                ++n5;
            }
            List<String> list2 = Arrays.asList(stringArray5);
            stringArray = stringArray6;
            int n7 = stringArray6.length;
            int n8 = 0;
            while (n8 < n7) {
                object22 = stringArray[n8];
                if (((String)object22).length() != 0 && !((String)object22).equals("\"\"")) {
                    object22 = ((String)object22).replaceAll("^\"|\"$", "");
                    if (!list2.contains(object22 = ((String)object22).replace("\\", "/"))) {
                        if (((String)object22).startsWith(string3)) {
                            String string7 = ((String)object22).substring(string3.length());
                            string7 = "\"${" + iProject4.getName().toUpperCase() + "}" + string7 + "\"";
                            CommonConfigurationManager.appendLinkPathsToLinker((IConfiguration)iConfiguration, (String)string7);
                        } else {
                            boolean bl = false;
                            for (String string8 : hashMap.keySet()) {
                                if (!((String)object22).startsWith(string8)) continue;
                                String string9 = ((String)object22).substring(string8.length());
                                String string10 = ((String)hashMap.get(string8)).toUpperCase();
                                string9 = "\"${" + string10 + "}" + string9 + "\"";
                                CommonConfigurationManager.appendLinkPathsToLinker((IConfiguration)iConfiguration, (String)string9);
                                iContributedEnvironment.addVariable(string10, string8, 1, "", iCConfigurationDescription);
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                CommonConfigurationManager.appendLinkPathsToLinker((IConfiguration)iConfiguration, (String)object22);
                            }
                        }
                    }
                }
                ++n8;
            }
            iContributedEnvironment.addVariable(iProject4.getName().toUpperCase(), string3, 1, "", iCConfigurationDescription);
            ManagedBuildManager.saveBuildInfo((IProject)iProject2, (boolean)true);
        }
        ManagedBuildManager.saveBuildInfo((IProject)iProject2, (boolean)true);
        arrayList2.parallelStream().map(iProject -> iProject);
        UnitTestCommon.main_num = 0;
        for (IProject iProject4 : arrayList2) {
            ++UnitTestCommon.main_num;
            object = this.getTargetObjectFileList(iProject2, iProject4, true);
            arrayList.addAll((Collection<String>)object);
        }
        this.setObjectPathToLinker(iProject2, arrayList);
    }

    private static void copyFolder(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            if (!file2.exists()) {
                file2.mkdir();
                System.out.println("Directory created :: " + file2);
            }
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                File file3 = new File(file, string3);
                File file4 = new File(file2, string3);
                UnitTestNinjaGenerator.copyFolder(file3.getAbsolutePath(), file4.getAbsolutePath());
                ++n2;
            }
        } else {
            Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("File copied :: " + file2);
        }
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus multiStatus = this.preRegenerateMakefiles();
        if (multiStatus.getCode() == 0) {
            return super.regenerateMakefiles();
        }
        return multiStatus;
    }

    protected IProject getTestProject(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IProject iProject = iWorkspaceRoot.getProject(iPath.segment(iPath.segmentCount() - 2));
        return iProject;
    }

    protected IProject getTargetProject(IProject iProject) throws CoreException {
        IProject iProject2;
        try {
            iProject2 = this.createXml(iProject).getTargetProject();
        }
        catch (Exception exception) {
            String string = iProject.getDescription().getComment();
            if (StringUtil.isEmpty((CharSequence)string)) {
                return null;
            }
            String string2 = iProject.getDescription().getComment().substring(12);
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            iProject2 = iWorkspaceRoot.getProject(string2);
        }
        return iProject2;
    }

    protected void removeTargetProjectObject(IProject iProject, List<String> list) {
        UnitTestXml unitTestXml = this.createXml(iProject);
        for (String string : list) {
            try {
                unitTestXml.removeTargetObjectFile(string);
            }
            catch (Exception exception) {
                logger.error("Failed to remove a target object file", (Throwable)exception);
            }
        }
    }

    protected List<String> getTargetProjectObjectListOld(IProject iProject) throws ParserConfigurationException, SAXException, IOException {
        UnitTestXml unitTestXml = this.createXml(iProject);
        return unitTestXml.getTargetObjectFile();
    }

    protected void setTargetProjectObjectList(IProject iProject, List<String> list) {
        UnitTestXml unitTestXml = this.createXml(iProject);
        try {
            for (String string : list) {
                unitTestXml.setTargetObjectFile(string);
            }
        }
        catch (Exception exception) {
            logger.error("Failed to set a target object file", (Throwable)exception);
        }
    }

    protected UnitTestXml createXml(IProject iProject) {
        return new UnitTestXml(iProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBuildSuccess(IProject iProject) {
        try {
            IMarker[] iMarkerArray;
            IMarker[] iMarkerArray2 = iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IMarker iMarker = iMarkerArray2[n2];
                if (2 == iMarker.getAttribute("severity", 0)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            logger.error("Cannot read problem marker of " + iProject, (Throwable)coreException);
            return false;
        }
    }

    protected MultiStatus checkTargetStatus(Boolean bl) throws CoreException {
        MultiStatus multiStatus = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        String string = "";
        if (!this.isBuildSuccess(this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.ERROR_TARGET_BUILD_FAILURE, (Object)this.targetProject.getName());
        } else if (!UnitTestCommon.equalsTargetBuildName(this.testProject, this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.WIZARD_ERROR_CONF_MISS, (Object)this.targetProject.getName());
        } else if (!UnitTestCommon.equalsArch(this.testProject, this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.WIZARD_ERROR_ARCH_MISS, (Object)this.targetProject.getName());
        } else if (bl.booleanValue() && !this.setDynamicAnalysisOption(this.testProject, this.targetProject)) {
            string = NLS.bind((String)UnitTestMessages.WIZARD_ERROR_GCOV_OPTION_MISS, (Object)this.targetProject.getName());
        }
        if (!string.isEmpty()) {
            multiStatus = this.buildWarning(this.testProject, string);
        }
        return multiStatus;
    }

    public boolean setDynamicAnalysisOption(IProject iProject, IProject iProject2) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject2);
        IConfiguration[] iConfigurationArray = iManagedBuildInfo.getDefaultConfiguration().getManagedProject().getConfigurations();
        IConfiguration iConfiguration = ManagedBuildManager.getBuildInfo((IResource)iProject).getDefaultConfiguration();
        IUnitTestHandler iUnitTestHandler = UnitTestRegistry.getUnitTestHandler((IProject)iProject2);
        IConfiguration[] iConfigurationArray2 = iConfigurationArray;
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration iConfiguration2 = iConfigurationArray2[n2];
            if (iConfiguration2.getName().equals(iConfiguration.getName())) {
                String string = iUnitTestHandler.getDynamicAnalysisOption(iConfiguration2);
                if (!string.equals("-fprofile-arcs -ftest-coverage") && iUnitTestHandler.getDynamicAnalysisOption(iConfiguration).equals("-fprofile-arcs -ftest-coverage")) {
                    iUnitTestHandler.setDynamicAnalysisOption(iConfiguration, "");
                    ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
                    CommonProjectDependentBuilder commonProjectDependentBuilder = ProjectTypeManager.getProjectBuilderInstance((IProject)iProject);
                    try {
                        commonProjectDependentBuilder.make_clean();
                    }
                    catch (SBIException sBIException) {
                        logger.error("Failed to make clean", (Throwable)sBIException);
                    }
                }
                return string.equals(iUnitTestHandler.getDynamicAnalysisOption(iConfiguration));
            }
            ++n2;
        }
        return false;
    }

    private MultiStatus buildWarning(IProject iProject, String string) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec((Runnable)new MessageBoxRunnable(display, string));
        try {
            IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
            int n = iMarkerArray.length;
            while (n > 0) {
                iMarkerArray[n - 1].delete();
                --n;
            }
            IMarker iMarker = iProject.createMarker("org.eclipse.cdt.core.problem");
            iMarker.setAttribute("priority", 1);
            iMarker.setAttribute("severity", 2);
            iMarker.setAttribute("message", (Object)string);
        }
        catch (CoreException coreException) {
            logger.error("cannot create problem marker: " + string, (Throwable)coreException);
        }
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null);
    }

    class MessageBoxRunnable
    implements Runnable {
        private Display display;
        private String message;

        public MessageBoxRunnable(Display display, String string) {
            this.display = display;
            this.message = string;
        }

        @Override
        public void run() {
            UnitTestNinjaGenerator.this.projectBuild = false;
            Shell[] shellArray = this.display.getShells();
            Shell shell = shellArray[0];
            int n = 0;
            while (n < shellArray.length) {
                if (shellArray[n].getText().equals("Build Project")) {
                    shell = shellArray[n];
                    break;
                }
                ++n;
            }
            MessageBox messageBox = new MessageBox(shell, 65537);
            messageBox.setText("Error");
            messageBox.setMessage(this.message);
            messageBox.open();
            UnitTestNinjaGenerator.this.chUIThread = false;
        }
    }

    class YesNoDialogRunnable
    implements Runnable {
        private Display display;
        private String message;

        public YesNoDialogRunnable(Display display, String string) {
            this.display = display;
            this.message = string;
        }

        @Override
        public void run() {
            UnitTestNinjaGenerator.this.projectBuild = false;
            Shell[] shellArray = this.display.getShells();
            Shell shell = shellArray[0];
            int n = 0;
            while (n < shellArray.length) {
                if (shellArray[n].getText().equals("Build Project")) {
                    shell = shellArray[n];
                    break;
                }
                ++n;
            }
            MessageBox messageBox = new MessageBox(shell, 192);
            messageBox.setText(UnitTestMessages.WIZARD_LABEL_ERROR);
            messageBox.setMessage(this.message);
            int n2 = messageBox.open();
            if (n2 == 64) {
                UnitTestNinjaGenerator.this.deleteFile = true;
            } else if (n2 == 128) {
                UnitTestNinjaGenerator.this.deleteFile = false;
            }
        }
    }
}

