/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.resultview;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.model.TestSession;
import org.tizen.tizenunittest.gtest.model.listener.ISessionListener;
import org.tizen.tizenunittest.gtest.resultview.CounterPanel;
import org.tizen.tizenunittest.gtest.resultview.CuteProgressBar;
import org.tizen.tizenunittest.gtest.resultview.TestViewer;
import org.tizen.tizenunittest.gtest.resultview.action.ScrollLockAction;
import org.tizen.tizenunittest.gtest.resultview.action.ShowNextFailureAction;
import org.tizen.tizenunittest.gtest.resultview.action.ShowPreviousFailureAction;

public class TestResultView
extends ViewPart
implements ISessionListener {
    private final String SESSIONOVER_JOBNAME = "Session Over";
    private final String FAILURESONLYFILTER_ACTIONNAME = UnitTestMessages.RESULTVIEW_TOOLTIP_FAILURES_ONLY;
    public static final String ID = "org.tizen.tizenunittest.ResultViewId";
    private static TestResultView testResultViewPart;
    private Composite top = null;
    private Composite TopPanel = null;
    protected boolean autoScroll = true;
    private CounterPanel counterPanel = null;
    private CuteProgressBar cuteProgressBar = null;
    private TestViewer testViewer = null;
    private Composite parent;
    private Orientation currentOrientation = Orientation.horizontal;
    private ScrollLockAction scrollLockAction;
    private FailuresOnlyFilterAction failureOnlyAction;
    private Action showNextFailureAction;
    private Action showPreviousFailureAction;
    private TestSession session;

    public TestResultView() {
        testResultViewPart = this;
        UnitTestPlugin.getModel().addListener(this);
    }

    public static TestResultView getTestResultViewPart() {
        return testResultViewPart;
    }

    public void createPartControl(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tizen.ide.native.unittest_context");
        this.parent = composite;
        this.addResizeListener(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        this.top = new Composite(composite, 0);
        this.top.setLayout((Layout)gridLayout);
        this.top.setLayoutData((Object)gridData);
        this.createTopPanel();
        this.createTestViewer();
        this.configureToolbar();
    }

    private void addResizeListener(Composite composite) {
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                TestResultView.this.computeOrientation();
            }
        });
    }

    public boolean isCreated() {
        return this.counterPanel != null;
    }

    private void configureToolbar() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.scrollLockAction = new ScrollLockAction(this);
        this.scrollLockAction.setChecked(!this.autoScroll);
        this.failureOnlyAction = new FailuresOnlyFilterAction();
        this.failureOnlyAction.setChecked(false);
        this.showNextFailureAction = new ShowNextFailureAction(this);
        this.showNextFailureAction.setEnabled(false);
        this.showPreviousFailureAction = new ShowPreviousFailureAction(this);
        this.showPreviousFailureAction.setEnabled(false);
        iToolBarManager.add((IAction)this.showNextFailureAction);
        iToolBarManager.add((IAction)this.showPreviousFailureAction);
        iToolBarManager.add((IAction)this.failureOnlyAction);
        iToolBarManager.add((IAction)this.scrollLockAction);
        iToolBarManager.add((IContributionItem)new Separator());
    }

    private void createTopPanel() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.TopPanel = new Composite(this.top, 0);
        this.createCounterPanel();
        this.TopPanel.setLayout((Layout)gridLayout);
        this.TopPanel.setLayoutData((Object)gridData);
        this.createCuteProgressBar();
    }

    private void createCounterPanel() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.counterPanel = new CounterPanel(this.TopPanel, 0);
        this.counterPanel.setLayoutData(gridData);
    }

    private void createCuteProgressBar() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 35;
        gridData.horizontalAlignment = 4;
        this.cuteProgressBar = new CuteProgressBar(this.TopPanel);
        this.cuteProgressBar.setLayoutData(gridData);
    }

    private void createTestViewer() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.testViewer = new TestViewer(this.top, 0, this);
        this.testViewer.setLayoutData(gridData);
    }

    private void computeOrientation() {
        Point point = this.parent.getSize();
        if (point.x != 0 && point.y != 0) {
            if (point.x > point.y) {
                this.setOrientation(Orientation.horizontal);
            } else {
                this.setOrientation(Orientation.vertical);
            }
        }
    }

    private void setOrientation(Orientation orientation) {
        this.testViewer.setOrientation(orientation == Orientation.horizontal);
        this.currentOrientation = orientation;
        GridLayout gridLayout = (GridLayout)this.TopPanel.getLayout();
        this.setCounterColumns(gridLayout);
        this.parent.layout();
    }

    private void setCounterColumns(GridLayout gridLayout) {
        gridLayout.numColumns = this.currentOrientation == Orientation.horizontal ? 2 : 1;
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean bl) {
        this.autoScroll = bl;
    }

    public void setShowFailuresOnly(boolean bl) {
        this.testViewer.setFailuresOnly(bl);
    }

    public void selectNextFailure() {
        this.testViewer.selectNextFailure();
    }

    public void selectPrevFailure() {
        this.testViewer.selectPrevFailure();
    }

    @Override
    public void sessionFinished(TestSession testSession) {
        SessionFinishedUIJob sessionFinishedUIJob = new SessionFinishedUIJob("Session Over");
        sessionFinishedUIJob.schedule();
    }

    @Override
    public void sessionStarted(TestSession testSession) {
        this.session = testSession;
        this.showNextFailureAction.setEnabled(false);
        this.showPreviousFailureAction.setEnabled(false);
    }

    private class FailuresOnlyFilterAction
    extends Action {
        public FailuresOnlyFilterAction() {
            super(null, 2);
            this.setToolTipText(TestResultView.this.FAILURESONLYFILTER_ACTIONNAME);
            this.setImageDescriptor(UnitTestPlugin.getImageDescriptor("elcl18/failures.png"));
            this.setDisabledImageDescriptor(UnitTestPlugin.getImageDescriptor("dlcl18/failures.png"));
        }

        public void run() {
            TestResultView.this.setShowFailuresOnly(this.isChecked());
        }
    }

    private static enum Orientation {
        horizontal,
        vertical;

    }

    private final class SessionFinishedUIJob
    extends UIJob {
        private SessionFinishedUIJob(String string) {
            super(string);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (TestResultView.this.session.hasManagedErrorOrFailure()) {
                TestResultView.this.showNextFailureAction.setEnabled(true);
                TestResultView.this.showPreviousFailureAction.setEnabled(true);
                if (TestResultView.this.isAutoScroll()) {
                    TestResultView.this.testViewer.selectFirstFailure();
                }
            }
            return new Status(0, "org.tizen.tizenunittest.gtest", 0, "OK", null);
        }
    }
}

