/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.testexplorer.toolbaraction;

import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.tizen.tizenunittest.gtest.UnitTestPlugin;
import org.tizen.tizenunittest.gtest.common.UnitTestMessages;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestRoot;
import org.tizen.tizenunittest.gtest.testexplorer.model.TXTestSuite;
import org.tizen.tizenunittest.gtest.testexplorer.toolbaraction.RerunLastTestActionTX;

public class CheckTreeAction
extends Action {
    private final String CHECK_ACTIONNAME = UnitTestMessages.TXVIEW_TOOLTIP_CHECK_ALL;
    private final String CLEAR_ACTIONNAME = UnitTestMessages.TXVIEW_TOOLTIP_UNCHECK_ALL;
    private final boolean CHECK_BUTTON = true;
    private final boolean CLEAR_BUTTON = false;
    private boolean status;
    private CheckboxTreeViewer treeViewer;
    private RerunLastTestActionTX rerunLastTestActionTX;

    public CheckTreeAction(CheckboxTreeViewer checkboxTreeViewer, RerunLastTestActionTX rerunLastTestActionTX) {
        this.treeViewer = checkboxTreeViewer;
        this.rerunLastTestActionTX = rerunLastTestActionTX;
        this.init();
    }

    public void init() {
        this.setText(this.CHECK_ACTIONNAME);
        this.setToolTipText(this.CHECK_ACTIONNAME);
        this.setImageDescriptor(UnitTestPlugin.getImageDescriptor("elcl18/check.png"));
        this.setDisabledImageDescriptor(UnitTestPlugin.getImageDescriptor("dlcl18/check.png"));
        this.status = true;
    }

    public void run() {
        if (this.status) {
            TXTestRoot tXTestRoot = (TXTestRoot)this.treeViewer.getInput();
            if (tXTestRoot != null) {
                Vector<TXTestSuite> vector = tXTestRoot.getElements();
                for (TXTestSuite tXTestSuite : vector) {
                    this.treeViewer.setChecked((Object)tXTestSuite, true);
                    this.treeViewer.setSubtreeChecked((Object)tXTestSuite, true);
                }
                this.rerunLastTestActionTX.setEnabled(true);
            }
            this.status = false;
            this.setText(this.CLEAR_ACTIONNAME);
            this.setToolTipText(this.CLEAR_ACTIONNAME);
            this.setImageDescriptor(UnitTestPlugin.getImageDescriptor("elcl18/uncheck.png"));
            this.setDisabledImageDescriptor(UnitTestPlugin.getImageDescriptor("dlcl18/uncheck.png"));
        } else {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = this.treeViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                this.treeViewer.setChecked(object, false);
                ++n2;
            }
            this.rerunLastTestActionTX.setEnabled(false);
            this.status = true;
            this.setText(this.CHECK_ACTIONNAME);
            this.setToolTipText(this.CHECK_ACTIONNAME);
            this.setImageDescriptor(UnitTestPlugin.getImageDescriptor("elcl18/check.png"));
            this.setDisabledImageDescriptor(UnitTestPlugin.getImageDescriptor("dlcl18/check.png"));
        }
    }
}

