/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tizenunittest.gtest.templateengine.process;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.processes.AddFiles;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecommon.templateengine.TizenTemplateEngine;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.tizen.tizenunittest.gtest.wizards.newWizard.UnitTestWizard;

public class TizenAddFiles
extends AddFiles {
    private IProject projectHandle;
    protected Map<String, String> valueStore;
    private IPath samplePath;
    private static final Logger logger = LoggerFactory.getLogger(TizenAddFiles.class);

    public void process(TemplateCore templateCore, ProcessArgument[] processArgumentArray, String string, IProgressMonitor iProgressMonitor) throws ProcessFailureException {
        String string2 = processArgumentArray[0].getSimpleValue();
        this.projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
        this.valueStore = templateCore.getValueStore();
        ProfileInfo profileInfo = UnitTestWizard.getTargetProjectProfileInfo();
        this.valueStore.put("platform", profileInfo.getLatestPlatformName());
        this.valueStore.put("packageProfile", profileInfo.getProfile());
        this.valueStore.put("version", profileInfo.getLatestPlatformVersion());
        String string3 = string2.replaceAll("-", "_").toUpperCase();
        this.valueStore.put("projectNameWithoutHyphen", string3);
        TizenTemplateEngine.pressCommonValueStore(this.valueStore, (boolean)false, (TizenTemplate)TizenTemplate.EMPTY_TEMPLATE);
        super.process(templateCore, processArgumentArray, string, iProgressMonitor);
    }

    protected void copyFile(File file, List<ReplaceableFile> list, String string) throws ProcessFailureException {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block30: {
                File file2 = fileArray[n2];
                InputStream inputStream = null;
                String string2 = null;
                if (file2.isFile()) {
                    String string3;
                    boolean bl = false;
                    for (ReplaceableFile replaceableFile : list) {
                        string3 = null;
                        String string4 = null;
                        try {
                            string3 = replaceableFile.getSourcePath().toFile().getCanonicalPath();
                            string4 = file2.getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            throw new ProcessFailureException((Throwable)iOException);
                        }
                        if (!string3.equals(string4)) continue;
                        bl = true;
                        string2 = replaceableFile.getTargetPath();
                        if (replaceableFile.isReplaceable()) {
                            String string5 = null;
                            try {
                                string5 = FileUtil.readTextFile((File)file2, null);
                                string5 = ProcessHelper.getValueAfterExpandingMacros((String)string5, (Set)ProcessHelper.getReplaceKeys((String)string5), this.valueStore);
                                inputStream = new ByteArrayInputStream(string5.getBytes());
                            }
                            catch (Exception exception) {
                                logger.error("Failed to read file: " + exception);
                            }
                            list.remove(replaceableFile);
                            break;
                        }
                        try {
                            inputStream = file2.toURI().toURL().openStream();
                        }
                        catch (IOException iOException) {
                            logger.error("Failed to read file: " + iOException);
                        }
                    }
                    if (!bl) {
                        string2 = String.valueOf(string) + File.separator + file2.getName();
                        try {
                            inputStream = file2.toURI().toURL().openStream();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    try {
                        ReplaceableFile replaceableFile;
                        replaceableFile = this.projectHandle.getFile(string2);
                        File file3 = replaceableFile.getLocation().toFile();
                        if (!replaceableFile.getParent().exists()) {
                            ProcessHelper.mkdirs((IProject)this.projectHandle, (IFolder)this.projectHandle.getFolder(replaceableFile.getParent().getProjectRelativePath()));
                        }
                        if (replaceableFile.exists()) {
                            string3 = replaceableFile.getResourceAttributes();
                            if (string3 != null && !string3.isReadOnly()) {
                                replaceableFile.setContents(inputStream, true, true, null);
                            } else if (string3 == null) {
                                replaceableFile.setContents(inputStream, true, true, null);
                            }
                            break block30;
                        }
                        if (file3.exists()) {
                            if (!file3.canWrite()) {
                                file3.delete();
                                replaceableFile.create(inputStream, true, null);
                                replaceableFile.refreshLocal(1, null);
                            } else {
                                replaceableFile.create(inputStream, true, null);
                                replaceableFile.refreshLocal(1, null);
                            }
                            break block30;
                        }
                        replaceableFile.create(inputStream, true, null);
                        replaceableFile.refreshLocal(1, null);
                    }
                    catch (CoreException coreException) {
                        logger.error("Failed to generate file: " + (Object)((Object)coreException));
                    }
                } else if (file2.isDirectory()) {
                    string2 = String.valueOf(string) + File.separator + file2.getName();
                    if (file2.listFiles().length == 0) {
                        try {
                            if (!this.projectHandle.getFolder(string2).exists()) {
                                ProcessHelper.mkdirs((IProject)this.projectHandle, (IFolder)this.projectHandle.getFolder(string2));
                            }
                        }
                        catch (CoreException coreException) {
                            logger.error("Failed to create file: " + (Object)((Object)coreException));
                        }
                    } else {
                        this.copyFile(file2, list, string2);
                    }
                }
            }
            ++n2;
        }
    }

    public static class ReplaceableFile {
        private IPath sourcePath;
        private String targetPath;
        private boolean replaceable;

        public ReplaceableFile(IPath iPath, String string, boolean bl) {
            this.sourcePath = iPath;
            this.targetPath = string;
            this.replaceable = bl;
        }

        public IPath getSourcePath() {
            return this.sourcePath;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public boolean isReplaceable() {
            return this.replaceable;
        }
    }
}

