#!/bin/bash -e

tizen_sdk_version=`sed -e "s;.*SDK_VERSION=\(.*\);\1;g" < "${INSTALLED_PATH}/sdk.version"`

modify_ide_version()
{
    echo "Modify ide version..."
    product_version="${tizen_sdk_version}"

    ide_path="${INSTALLED_PATH}/TizeStudio.app/Contents/Eclipse"

    if [ -e ${ide_path} ]
    then
        echo "Set product's version (${product_version})"

        config_file_path="${ide_path}/configuration/config.ini"
        if [ -e ${config_file_path} ]
        then
            sed -e "s;\(^eclipse.buildId=\).*;\1${product_version}                    ;g" < "${config_file_path}" > "${config_file_path}.mod"
            mv "${config_file_path}.mod" "${config_file_path}"
        fi

        count=`ls ${ide_path}/plugins | grep --color=none org.tizen.product.plugin_ | wc -l`
        if [ $count -le 0 ]
        then
            return
        fi
        branding_plugin=`ls -tr ${ide_path}/plugins | grep --color=none org.tizen.product.plugin_`

        about_mapping_path="${ide_path}/plugins/${branding_plugin}/about.mappings"
        about_version_parameter="1"

        if [ -e ${about_mapping_path} ]
        then
            sed -e "s;\(^${about_version_parameter}=\).*;\1${product_version};g" < "${about_mapping_path}" > "${about_mapping_path}.mod"
            mv "${about_mapping_path}.mod" "${about_mapping_path}"
        fi
    fi
}

modify_emulator_version()
{
    echo "Modify emulator version..."
    product_version="${tizen_sdk_version}"

	emulator_version_path="${INSTALLED_PATH}/tools/emulator/etc"

	echo "Set emulator's version (${product_version})"
	mkdir -p "${emulator_version_path}"
	echo "${product_version}" > "${emulator_version_path}/version"
}

main()
{
    modify_ide_version
}

main
