@ECHO OFF

:: Set parameter
set ide_path=%INSTALLED_PATH%\ide
set config_file_path=%ide_path%\configuration\config.ini
set splash_version_parameter=eclipse.buildId


:: Get version
set version_path=%INSTALLED_PATH%\sdk.version
IF NOT EXIST "%version_path%" (
    exit
)

:: Added double quotation marks to the version path and modified to recognize it as a file
:: by lee.sujin(lee.sujin@samsung.com)  2017.3.24

FOR /F "usebackq tokens=1,2* delims==" %%A IN ("%version_path%") DO (SET %%A=%%B)

set tizen_sdk_version=%TIZEN_SDK_VERSION%

echo "Set product's version (%tizen_sdk_version%)"
::set branding_plugin

set base_ide_platform_path=%ide_path%\plugins\org.tizen.product.plugin*
IF EXIST "%base_ide_platform_path%" (
    for /f %%R in ('dir /B /A:D /O:D "%base_ide_platform_path%"') do (set branding_plugin=%%R)
)
echo "branding plugin: %branding_plugin%"

set about_mapping_path=%ide_path%\plugins\%branding_plugin%\about.mappings
echo "about_mapping_path: %about_mapping_path%"

set about_version_parameter=1

:: modify splash version
IF EXIST "%config_file_path%" (
    Type "%config_file_path%" | findstr /I /V /C:%splash_version_parameter%= > "%config_file_path%.modi"
)
IF EXIST "%config_file_path%.modi" (
    for %%^" in ("") do (echo %splash_version_parameter%=%%~"%tizen_sdk_version%                    %%~" >>"%config_file_path%.modi")

    del "%config_file_path%"

    move "%config_file_path%.modi" "%config_file_path%"
)

:: modify about dialog version
IF EXIST "%about_mapping_path%" (
    Type "%about_mapping_path%" | findstr /I /V /C:%about_version_parameter%= > "%about_mapping_path%.modi"
)

IF EXIST "%about_mapping_path%.modi" (
    for %%^" in ("") do (echo %about_version_parameter%=%%~"%tizen_sdk_version%%%~" >>"%about_mapping_path%.modi")

    del "%about_mapping_path%"

    move "%about_mapping_path%.modi" "%about_mapping_path%"
)
