/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.appmanager;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.tizen.ecp.appmanager.AppConstants;
import org.tizen.ecp.appmanager.AppData;
import org.tizen.ecp.appmanager.AppInfo;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.sdb.IShellOutputReceiver;
import org.tizen.ecp.sdb.MultiLineReceiver;
import org.tizen.ecp.sdb.SDBCommandRejectedException;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.sdb.SDBNotExistException;
import org.tizen.ecp.string.ApplicationConstants;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.LogUtil;

public class AppManagerController
implements Initializable {
    @FXML
    Button buttonUninstall;
    @FXML
    Button buttonRefresh;
    @FXML
    TableView<AppData> tableAppList;
    @FXML
    TableColumn<AppData, String> columnType;
    @FXML
    TableColumn<AppData, String> columnLabel;
    @FXML
    TableColumn<AppData, String> columnVersion;
    @FXML
    private ProgressIndicator progressIndicator;
    private static Logger logger = LogUtil.getECPLogger(AppManagerController.class).getLogger();
    private final ObservableList<AppData> data = FXCollections.observableArrayList();
    private static String patternLs = "\\[(.*?)\\]";
    private static Pattern sLsPattern = Pattern.compile(".*pkg_type " + patternLs + "\tpkgid " + patternLs + "\tname " + patternLs + "\tversion " + patternLs + ".*");
    private String shellResult = null;
    private final ArrayList<AppInfo> appList = new ArrayList();

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.buttonRefresh.getStylesheets().add((Object)this.getClass().getResource("resources/refreshButton.css").toExternalForm());
        this.tableAppList.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableAppList.setItems(this.data);
        this.columnType.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.columnLabel.setCellValueFactory((Callback)new PropertyValueFactory("label"));
        this.columnVersion.setCellValueFactory((Callback)new PropertyValueFactory("version"));
        this.buttonUninstall.setDisable(true);
        this.tableAppList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<AppData>(){

            public void changed(ObservableValue<? extends AppData> observableValue, AppData appData, AppData appData2) {
                if (AppManagerController.this.tableAppList.getSelectionModel().getSelectedItem() != null) {
                    AppManagerController.this.buttonUninstall.setDisable(false);
                }
            }
        });
        this.refresh();
    }

    public int removeApp(AppInfo appInfo) {
        MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                AppManagerController.this.shellResult = stringArray[0];
                logger.info("Remove: " + stringArray[0]);
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellCommand(String.format("/usr/bin/pkgcmd -q -u -t %s -n %s", appInfo.getPkg_type(), appInfo.getPkgid()), (IShellOutputReceiver)multiLineReceiver);
            this.closeMultiLineReceiver(multiLineReceiver);
        }
        catch (SDBNotExistException sDBNotExistException) {
            this.closeMultiLineReceiver(multiLineReceiver);
            return 5;
        }
        catch (TimeoutException timeoutException) {
            this.closeMultiLineReceiver(multiLineReceiver);
            logger.severe(timeoutException.getMessage());
            return 3;
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            this.closeMultiLineReceiver(multiLineReceiver);
            logger.severe(sDBCommandRejectedException.getMessage());
            return 2;
        }
        catch (IOException iOException) {
            this.closeMultiLineReceiver(multiLineReceiver);
            logger.severe(iOException.getMessage());
            return 1;
        }
        return 0;
    }

    public AppInfo getPackageByid(String string) {
        for (AppInfo appInfo : this.appList) {
            if (!appInfo.getPkgid().equals(string)) continue;
            return appInfo;
        }
        return null;
    }

    private void restoreItems() {
        this.tableAppList.setDisable(false);
        this.buttonUninstall.setDisable(true);
        this.buttonRefresh.setDisable(false);
    }

    private void restoreSelections() {
        this.tableAppList.getSelectionModel().clearSelection();
        this.restoreItems();
    }

    public void onUninstallButtonClicked(ActionEvent actionEvent) {
        this.buttonUninstall.setDisable(true);
        this.buttonRefresh.setDisable(true);
        this.tableAppList.setDisable(true);
        Thread thread = new Thread(new Runnable(){
            String errorMsg = null;

            @Override
            public void run() {
                for (AppData appData : AppManagerController.this.tableAppList.getSelectionModel().getSelectedItems()) {
                    AppInfo appInfo = AppManagerController.this.getPackageByid(appData.getPkgId());
                    if (appInfo == null) {
                        logger.warning("Cannot find matching app");
                        MessageBox.error((String)DeviceMessages.getString("UninstallerDisplay.18"));
                        break;
                    }
                    int n = AppManagerController.this.removeApp(appInfo);
                    switch (n) {
                        case 2: {
                            this.errorMsg = DeviceMessages.getString("UninstallerDisplay.18");
                            break;
                        }
                        case 3: {
                            this.errorMsg = DeviceMessages.getString("UninstallerDisplay.19");
                            break;
                        }
                        case 4: {
                            this.errorMsg = DeviceMessages.getString("UninstallerDisplay.20");
                            break;
                        }
                        case 1: {
                            this.errorMsg = DeviceMessages.getString("UninstallerDisplay.21");
                            break;
                        }
                        case 5: {
                            this.errorMsg = DeviceMessages.getString("UninstallerDisplay.22");
                            break;
                        }
                        default: {
                            logger.info("Succeeded to uninstall.");
                        }
                    }
                    if (this.errorMsg == null) {
                        logger.info("uninstalled: " + appData.getLabel());
                        continue;
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.error((String)errorMsg);
                            AppManagerController.this.restoreSelections();
                        }
                    });
                    return;
                }
                AppManagerController.this.data.removeAll((Collection)AppManagerController.this.tableAppList.getSelectionModel().getSelectedItems());
                AppManagerController.this.restoreSelections();
            }
        });
        thread.start();
    }

    public void onRefreshButtonClicked(ActionEvent actionEvent) {
        this.refresh();
    }

    private void closeMultiLineReceiver(MultiLineReceiver multiLineReceiver) {
        if (multiLineReceiver != null) {
            try {
                multiLineReceiver.close();
            }
            catch (IOException iOException) {
                logger.warning(iOException.getMessage());
            }
            multiLineReceiver = null;
        }
    }

    public boolean isRemovable(String string) {
        boolean bl = false;
        MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                AppManagerController.this.shellResult = stringArray[0];
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellCommand(String.format("/usr/bin/pkginfo --pkg %s | grep -i Removable", string), (IShellOutputReceiver)multiLineReceiver);
        }
        catch (SDBNotExistException sDBNotExistException) {
            MessageBox.error((String)sDBNotExistException.getMessage());
            bl = false;
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            logger.severe(sDBCommandRejectedException.getMessage());
            MessageBox.error((String)ApplicationConstants.EMULATOR_NOT_READY);
            bl = false;
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
            MessageBox.error((String)(AppConstants.FAIL_REMOVE + DeviceMessages.getString("UninstallerDisplay.15") + timeoutException.getMessage()));
            bl = false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            MessageBox.error((String)(AppConstants.FAIL_REMOVE + DeviceMessages.getString("UninstallerDisplay.15") + iOException.getMessage()));
            bl = false;
        }
        this.closeMultiLineReceiver(multiLineReceiver);
        if (this.shellResult != null) {
            if (this.shellResult.equals(AppConstants.REMOVAVLE0)) {
                bl = false;
            } else if (this.shellResult.equals(AppConstants.REMOVAVLE1)) {
                bl = true;
            } else {
                logger.severe("wrong message: " + this.shellResult);
            }
            this.shellResult = null;
        }
        return bl;
    }

    public void refresh() {
        this.progressIndicator.getParent().setVisible(true);
        this.progressIndicator.setVisible(true);
        this.tableAppList.getItems().clear();
        this.tableAppList.setDisable(true);
        this.buttonRefresh.setDisable(true);
        final MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                for (String string : stringArray) {
                    Matcher matcher = sLsPattern.matcher(string);
                    if (!matcher.matches()) {
                        logger.info("not matched: " + string);
                        continue;
                    }
                    if (!AppManagerController.this.isRemovable(matcher.group(2))) continue;
                    AppInfo appInfo = new AppInfo(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
                    AppManagerController.this.appList.add(appInfo);
                    AppManagerController.this.data.add((Object)new AppData(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)));
                    logger.info("refreshing");
                }
            }
        };
        Thread thread = new Thread(new Runnable(){
            String errorMsg = null;

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        thread.start();
    }

    static /* synthetic */ void access$600(AppManagerController appManagerController, MultiLineReceiver multiLineReceiver) {
        appManagerController.closeMultiLineReceiver(multiLineReceiver);
    }
}

