/*
 * Video for Linux Two header file for samsung
 *
 * Copyright (C) 2009, Dongsoo Nathaniel Kim<dongsoo45.kim@samsung.com>
 *
 * This header file contains several v4l2 APIs to be proposed to v4l2
 * community and until bein accepted, will be used restrictly in Samsung's
 * camera interface driver FIMC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __LINUX_VIDEODEV2_EXYNOS_CAMERA_H
#define __LINUX_VIDEODEV2_EXYNOS_CAMERA_H

/* Values for 'capabilities' field */
/* Object detection device */
#define V4L2_CAP_OBJ_RECOGNITION	0x10000000
/* strobe control */
#define V4L2_CAP_STROBE			0x20000000

#define V4L2_CID_FOCUS_MODE		(V4L2_CID_CAMERA_CLASS_BASE+17)
/* Focus Methods */
enum v4l2_focus_mode {
	V4L2_FOCUS_MODE_AUTO		= 0,
	V4L2_FOCUS_MODE_MACRO		= 1,
	V4L2_FOCUS_MODE_MANUAL		= 2,
	V4L2_FOCUS_MODE_LASTP		= 2,
	V4L2_FOCUS_MODE_FACEDETECT,
	V4L2_FOCUS_MODE_AUTO_DEFAULT,
	V4L2_FOCUS_MODE_MACRO_DEFAULT,
	V4L2_FOCUS_MODE_FACEDETECT_DEFAULT,
	V4L2_FOCUS_MODE_INFINITY,
	V4L2_FOCUS_MODE_FIXED,
	V4L2_FOCUS_MODE_CONTINUOUS,
	V4L2_FOCUS_MODE_CONTINUOUS_PICTURE,
	V4L2_FOCUS_MODE_CONTINUOUS_PICTURE_MACRO,
	V4L2_FOCUS_MODE_CONTINUOUS_VIDEO,
	V4L2_FOCUS_MODE_TOUCH,
	V4L2_FOCUS_MODE_MAX,
	V4L2_FOCUS_MODE_DEFAULT = (1 << 8),
};

#define V4L2_CID_ZOOM_MODE		(V4L2_CID_CAMERA_CLASS_BASE+18)
/* Zoom Methods */
enum v4l2_zoom_mode {
	V4L2_ZOOM_MODE_CONTINUOUS	= 0,
	V4L2_ZOOM_MODE_OPTICAL		= 1,
	V4L2_ZOOM_MODE_DIGITAL		= 2,
	V4L2_ZOOM_MODE_LASTP		= 2,
};

/* Exposure Methods */
#define V4L2_CID_PHOTOMETRY		(V4L2_CID_CAMERA_CLASS_BASE+19)
enum v4l2_photometry_mode {
	V4L2_PHOTOMETRY_MULTISEG	= 0, /*Multi Segment*/
	V4L2_PHOTOMETRY_CWA		= 1, /*Centre Weighted Average*/
	V4L2_PHOTOMETRY_SPOT		= 2,
	V4L2_PHOTOMETRY_AFSPOT		= 3, /*Spot metering on focused point*/
	V4L2_PHOTOMETRY_LASTP		= V4L2_PHOTOMETRY_AFSPOT,
};

/* Manual exposure control items menu type: iris, shutter, iso */
#define V4L2_CID_CAM_APERTURE	(V4L2_CID_CAMERA_CLASS_BASE+20)
#define V4L2_CID_CAM_SHUTTER	(V4L2_CID_CAMERA_CLASS_BASE+21)
#define V4L2_CID_CAM_ISO	(V4L2_CID_CAMERA_CLASS_BASE+22)
enum v4l2_iso {
	V4L2_ISO_AUTO,
	V4L2_ISO_50,
	V4L2_ISO_100,
	V4L2_ISO_200,
	V4L2_ISO_400,
	V4L2_ISO_800,
	V4L2_ISO_1600,
	V4L2_ISO_MAX
};

/* Following CIDs are menu type */
#define V4L2_CID_SCENEMODE	(V4L2_CID_CAMERA_CLASS_BASE+23)
enum v4l2_camera_scene_mode {
	V4L2_SCENE_MODE_BASE,
	V4L2_SCENE_MODE_NONE,
	V4L2_SCENE_MODE_PORTRAIT,
	V4L2_SCENE_MODE_NIGHTSHOT,
	V4L2_SCENE_MODE_BACK_LIGHT,
	V4L2_SCENE_MODE_LANDSCAPE,
	V4L2_SCENE_MODE_SPORTS,
	V4L2_SCENE_MODE_PARTY_INDOOR,
	V4L2_SCENE_MODE_BEACH_SNOW,
	V4L2_SCENE_MODE_SUNSET,
	V4L2_SCENE_MODE_DUSK_DAWN,
	V4L2_SCENE_MODE_FALL_COLOR,
	V4L2_SCENE_MODE_FIREWORKS,
	V4L2_SCENE_MODE_TEXT,
	V4L2_SCENE_MODE_CANDLE_LIGHT,
	V4L2_SCENE_MODE_MAX,
};

#define V4L2_CID_CAM_STABILIZE	(V4L2_CID_CAMERA_CLASS_BASE+24)
#define V4L2_CID_CAM_MULTISHOT	(V4L2_CID_CAMERA_CLASS_BASE+25)

/* Control dynamic range */
#define V4L2_CID_CAM_DR		(V4L2_CID_CAMERA_CLASS_BASE+26)

/* White balance preset control */
#define V4L2_CID_WHITE_BALANCE_PRESET	(V4L2_CID_CAMERA_CLASS_BASE+27)
enum v4l2_wb_preset {
	V4L2_WHITE_BALANCE_BASE = 0,
	V4L2_WHITE_BALANCE_AUTO,
	V4L2_WHITE_BALANCE_SUNNY,
	V4L2_WHITE_BALANCE_CLOUDY,
	V4L2_WHITE_BALANCE_TUNGSTEN,
	V4L2_WHITE_BALANCE_FLUORESCENT,
	V4L2_WHITE_BALANCE_MAX,
};
#define V4L2_CID_CAM_SENSOR_FW_VER	(V4L2_CID_CAMERA_CLASS_BASE + 28)
#define V4L2_CID_CAM_PHONE_FW_VER	(V4L2_CID_CAMERA_CLASS_BASE + 29)

/* CID extensions */
#define V4L2_CID_ROTATION		(V4L2_CID_PRIVATE_BASE + 0)
#define V4L2_CID_PADDR_Y		(V4L2_CID_PRIVATE_BASE + 1)
#define V4L2_CID_PADDR_CB		(V4L2_CID_PRIVATE_BASE + 2)
#define V4L2_CID_PADDR_CR		(V4L2_CID_PRIVATE_BASE + 3)
#define V4L2_CID_PADDR_CBCR		(V4L2_CID_PRIVATE_BASE + 4)
#define V4L2_CID_OVERLAY_AUTO		(V4L2_CID_PRIVATE_BASE + 5)
#define V4L2_CID_OVERLAY_VADDR0		(V4L2_CID_PRIVATE_BASE + 6)
#define V4L2_CID_OVERLAY_VADDR1		(V4L2_CID_PRIVATE_BASE + 7)
#define V4L2_CID_OVERLAY_VADDR2		(V4L2_CID_PRIVATE_BASE + 8)
#define V4L2_CID_OVLY_MODE		(V4L2_CID_PRIVATE_BASE + 9)
#define V4L2_CID_DST_INFO		(V4L2_CID_PRIVATE_BASE + 10)
/* UMP secure id control */
#define V4L2_CID_GET_UMP_SECURE_ID	(V4L2_CID_PRIVATE_BASE + 11)
#define V4L2_CID_GET_PHY_SRC_YADDR	(V4L2_CID_PRIVATE_BASE + 12)
#define V4L2_CID_GET_PHY_SRC_CADDR	(V4L2_CID_PRIVATE_BASE + 13)
#define V4L2_CID_IMAGE_EFFECT_FN	(V4L2_CID_PRIVATE_BASE + 16)
#define V4L2_CID_IMAGE_EFFECT_APPLY	(V4L2_CID_PRIVATE_BASE + 17)
#define V4L2_CID_IMAGE_EFFECT_CB	(V4L2_CID_PRIVATE_BASE + 18)
#define V4L2_CID_IMAGE_EFFECT_CR	(V4L2_CID_PRIVATE_BASE + 19)
#define V4L2_CID_RESERVED_MEM_BASE_ADDR	(V4L2_CID_PRIVATE_BASE + 20)
#define V4L2_CID_FIMC_VERSION		(V4L2_CID_PRIVATE_BASE + 21)

#define V4L2_CID_STREAM_PAUSE			(V4L2_CID_PRIVATE_BASE + 53)
#define V4L2_CID_CACHE_FLUSH			(V4L2_CID_PRIVATE_BASE + 61)
#define V4L2_CID_RESERVED_MEM_SIZE		(V4L2_CID_PRIVATE_BASE + 63)

/* CID Extensions for camera sensor operations */
#define V4L2_CID_CAM_PREVIEW_ONOFF	(V4L2_CID_PRIVATE_BASE + 64)
#define V4L2_CID_CAM_CAPTURE		(V4L2_CID_PRIVATE_BASE + 65)
/* #define V4L2_CID_CAM_JPEG_MEMSIZE	(V4L2_CID_PRIVATE_BASE + 66) */

#define V4L2_CID_CAM_DATE_INFO_YEAR	(V4L2_CID_PRIVATE_BASE + 14)
#define V4L2_CID_CAM_DATE_INFO_MONTH	(V4L2_CID_PRIVATE_BASE + 15)
#define V4L2_CID_CAM_DATE_INFO_DATE	(V4L2_CID_PRIVATE_BASE + 22)
#define V4L2_CID_CAM_SENSOR_VER		(V4L2_CID_PRIVATE_BASE + 23)
#define V4L2_CID_CAM_FW_MINOR_VER	(V4L2_CID_PRIVATE_BASE + 24)
#define V4L2_CID_CAM_FW_MAJOR_VER	(V4L2_CID_PRIVATE_BASE + 25)
#define V4L2_CID_CAM_PRM_MINOR_VER	(V4L2_CID_PRIVATE_BASE + 26)
#define V4L2_CID_CAM_PRM_MAJOR_VER	(V4L2_CID_PRIVATE_BASE + 27)
#define V4L2_CID_CAM_FW_VER		(V4L2_CID_PRIVATE_BASE + 28)
#define V4L2_CID_CAM_SET_FW_ADDR	(V4L2_CID_PRIVATE_BASE + 29)
#define V4L2_CID_CAM_SET_FW_SIZE	(V4L2_CID_PRIVATE_BASE + 30)
#define V4L2_CID_CAM_UPDATE_FW		(V4L2_CID_PRIVATE_BASE + 31)
enum v4l2_firmware_mode {
	FW_MODE_UPDATE,
	FW_MODE_VERSION,
	FW_MODE_DUMP,
};

#define V4L2_CID_CAM_JPEG_MAIN_SIZE		(V4L2_CID_PRIVATE_BASE + 32)
#define V4L2_CID_CAM_JPEG_MAIN_OFFSET		(V4L2_CID_PRIVATE_BASE + 33)
#define V4L2_CID_CAM_JPEG_THUMB_SIZE		(V4L2_CID_PRIVATE_BASE + 34)
#define V4L2_CID_CAM_JPEG_THUMB_OFFSET		(V4L2_CID_PRIVATE_BASE + 35)
#define V4L2_CID_CAM_JPEG_POSTVIEW_OFFSET	(V4L2_CID_PRIVATE_BASE + 36)
#define V4L2_CID_CAM_JPEG_QUALITY	(V4L2_CID_PRIVATE_BASE + 37)
#define V4L2_CID_CAM_SENSOR_MAKER	(V4L2_CID_PRIVATE_BASE + 38)
#define V4L2_CID_CAM_SENSOR_OPTICAL	(V4L2_CID_PRIVATE_BASE + 39)
#define V4L2_CID_CAM_AF_VER_LOW		(V4L2_CID_PRIVATE_BASE + 40)
#define V4L2_CID_CAM_AF_VER_HIGH	(V4L2_CID_PRIVATE_BASE + 41)
#define V4L2_CID_CAM_GAMMA_RG_LOW	(V4L2_CID_PRIVATE_BASE + 42)
#define V4L2_CID_CAM_GAMMA_RG_HIGH	(V4L2_CID_PRIVATE_BASE + 43)
#define V4L2_CID_CAM_GAMMA_BG_LOW	(V4L2_CID_PRIVATE_BASE + 44)
#define V4L2_CID_CAM_GAMMA_BG_HIGH	(V4L2_CID_PRIVATE_BASE + 45)
#define V4L2_CID_CAM_DUMP_FW		(V4L2_CID_PRIVATE_BASE + 46)
#define V4L2_CID_CAM_GET_DUMP_SIZE	(V4L2_CID_PRIVATE_BASE + 47)
#define V4L2_CID_CAMERA_VT_MODE		(V4L2_CID_PRIVATE_BASE + 48)
#define V4L2_CID_CAMERA_VGA_BLUR	(V4L2_CID_PRIVATE_BASE + 49)
#define V4L2_CID_CAMERA_CAPTURE		(V4L2_CID_PRIVATE_BASE + 50)
#define V4L2_CID_CAMERA_HDR		(V4L2_CID_PRIVATE_BASE + 51)

#define V4L2_CID_MAIN_SW_DATE_INFO_YEAR		(V4L2_CID_PRIVATE_BASE + 54)
#define V4L2_CID_MAIN_SW_DATE_INFO_MONTH	(V4L2_CID_PRIVATE_BASE + 55)
#define V4L2_CID_MAIN_SW_DATE_INFO_DATE		(V4L2_CID_PRIVATE_BASE + 56)
#define V4L2_CID_MAIN_SW_FW_MINOR_VER		(V4L2_CID_PRIVATE_BASE + 57)
#define V4L2_CID_MAIN_SW_FW_MAJOR_VER		(V4L2_CID_PRIVATE_BASE + 58)
#define V4L2_CID_MAIN_SW_PRM_MINOR_VER		(V4L2_CID_PRIVATE_BASE + 59)
#define V4L2_CID_MAIN_SW_PRM_MAJOR_VER		(V4L2_CID_PRIVATE_BASE + 60)

#define V4L2_CID_FIMC_IS_BASE		(V4L2_CTRL_CLASS_CAMERA | 0x1000)
#define V4L2_CID_FIMC_IS_TUNE_BASE	(V4L2_CTRL_CLASS_CAMERA | 0x2000)
#define V4L2_CID_SENSOR_BASE		(V4L2_CTRL_CLASS_CAMERA | 0x3000)

#define V4L2_CID_IS_LOAD_FW			(V4L2_CID_FIMC_IS_BASE + 10)
#define V4L2_CID_IS_INIT_PARAM			(V4L2_CID_FIMC_IS_BASE + 11)
#define V4L2_CID_IS_RESET			(V4L2_CID_FIMC_IS_BASE + 12)
#define V4L2_CID_IS_S_POWER			(V4L2_CID_FIMC_IS_BASE + 13)
enum is_set_power {
	IS_POWER_OFF,
	IS_POWER_ON
};

#define V4L2_CID_IS_S_STREAM			(V4L2_CID_FIMC_IS_BASE + 14)
enum is_set_stream {
	IS_DISABLE_STREAM,
	IS_ENABLE_STREAM
};

#define V4L2_CID_IS_G_STREAM			(V4L2_CID_FIMC_IS_BASE + 15)
#define V4L2_CID_IS_S_FORMAT_SCENARIO		(V4L2_CID_FIMC_IS_BASE + 16)
enum scenario_mode {
	IS_MODE_PREVIEW_STILL,
	IS_MODE_PREVIEW_VIDEO,
	IS_MODE_CAPTURE_STILL,
	IS_MODE_CAPTURE_VIDEO,
	IS_MODE_MAX
};

#define V4L2_CID_IS_G_CAPABILITY		(V4L2_CID_FIMC_IS_BASE + 17)
#define V4L2_CID_IS_G_COMPLETES			(V4L2_CID_FIMC_IS_BASE + 18)
#define V4L2_CID_IS_BDS_WIDTH			(V4L2_CID_FIMC_IS_BASE + 19)
#define V4L2_CID_IS_BDS_HEIGHT			(V4L2_CID_FIMC_IS_BASE + 20)
#define V4L2_CID_IS_DVFS_LOCK			(V4L2_CID_FIMC_IS_BASE + 21)
#define V4L2_CID_IS_DVFS_UNLOCK			(V4L2_CID_FIMC_IS_BASE + 22)
#define V4L2_CID_IS_FORCE_DONE			(V4L2_CID_FIMC_IS_BASE + 50)
#define V4L2_CID_IS_SET_SETFILE			(V4L2_CID_FIMC_IS_BASE + 51)
#define V4L2_CID_IS_S_BNS			(V4L2_CID_FIMC_IS_BASE + 52)
#define V4L2_CID_IS_G_BNS_SIZE			(V4L2_CID_FIMC_IS_BASE + 53)
#define V4L2_CID_IS_COLOR_RANGE			(V4L2_CID_FIMC_IS_BASE + 54)
#define V4L2_CID_IS_MIN_TARGET_FPS		(V4L2_CID_FIMC_IS_BASE + 55)
#define V4L2_CID_IS_MAX_TARGET_FPS		(V4L2_CID_FIMC_IS_BASE + 56)

/* global */
#define V4L2_CID_IS_CAMERA_SHOT_MODE_NORMAL	(V4L2_CID_FIMC_IS_BASE + 101)
/* value : 1 : single shot , >=2 : continuous shot */

#define V4L2_CID_IS_CAMERA_SENSOR_NUM		(V4L2_CID_FIMC_IS_BASE + 201)

#define V4L2_CID_IS_CAMERA_FOCUS_MODE		(V4L2_CID_FIMC_IS_BASE + 401)
enum is_focus_mode {
	IS_FOCUS_MODE_AUTO,
	IS_FOCUS_MODE_MACRO,
	IS_FOCUS_MODE_INFINITY,
	IS_FOCUS_MODE_CONTINUOUS,
	IS_FOCUS_MODE_TOUCH,
	IS_FOCUS_MODE_FACEDETECT,
	IS_FOCUS_MODE_IDLE,
	IS_FOCUS_MODE_MAX,
};

#define V4L2_CID_IS_CAMERA_FOCUS_START_STOP	(V4L2_CID_FIMC_IS_BASE + 670)
enum is_focus_start_stop {
	IS_FOCUS_STOP,
	IS_FOCUS_START,
	IS_FOCUS_MAX
};

#define V4L2_CID_IS_CAMERA_FLASH_MODE		(V4L2_CID_FIMC_IS_BASE + 402)
enum is_flash_mode {
	IS_FLASH_MODE_OFF,
	IS_FLASH_MODE_AUTO,
	IS_FLASH_MODE_AUTO_REDEYE,
	IS_FLASH_MODE_ON,
	IS_FLASH_MODE_TORCH,
	IS_FLASH_MODE_MAX
};

#define V4L2_CID_IS_CAMERA_AWB_MODE		(V4L2_CID_FIMC_IS_BASE + 403)
enum is_awb_mode {
	IS_AWB_AUTO,
	IS_AWB_DAYLIGHT,
	IS_AWB_CLOUDY,
	IS_AWB_TUNGSTEN,
	IS_AWB_FLUORESCENT,
	IS_AWB_MAX
};

#define V4L2_CID_IS_CAMERA_IMAGE_EFFECT		(V4L2_CID_FIMC_IS_BASE + 404)
enum is_image_effect {
	IS_IMAGE_EFFECT_DISABLE,
	IS_IMAGE_EFFECT_MONOCHROME,
	IS_IMAGE_EFFECT_NEGATIVE_MONO,
	IS_IMAGE_EFFECT_NEGATIVE_COLOR,
	IS_IMAGE_EFFECT_SEPIA,
	IS_IMAGE_EFFECT_SEPIA_CB,
	IS_IMAGE_EFFECT_SEPIA_CR,
	IS_IMAGE_EFFECT_NEGATIVE,
	IS_IMAGE_EFFECT_ARTFREEZE,
	IS_IMAGE_EFFECT_EMBOSSING,
	IS_IMAGE_EFFECT_SILHOUETTE,
	IS_IMAGE_EFFECT_MAX
};

#define V4L2_CID_IS_CAMERA_ISO			(V4L2_CID_FIMC_IS_BASE + 405)
enum is_iso {
	IS_ISO_AUTO,
	IS_ISO_50,
	IS_ISO_100,
	IS_ISO_200,
	IS_ISO_400,
	IS_ISO_800,
	IS_ISO_1600,
	IS_ISO_MAX
};

#define V4L2_CID_IS_CAMERA_CONTRAST		(V4L2_CID_FIMC_IS_BASE + 406)
enum is_contrast {
	IS_CONTRAST_AUTO,
	IS_CONTRAST_MINUS_2,
	IS_CONTRAST_MINUS_1,
	IS_CONTRAST_DEFAULT,
	IS_CONTRAST_PLUS_1,
	IS_CONTRAST_PLUS_2,
	IS_CONTRAST_MAX
};

#define V4L2_CID_IS_CAMERA_SATURATION		(V4L2_CID_FIMC_IS_BASE + 407)
enum is_saturation {
	IS_SATURATION_MINUS_2,
	IS_SATURATION_MINUS_1,
	IS_SATURATION_DEFAULT,
	IS_SATURATION_PLUS_1,
	IS_SATURATION_PLUS_2,
	IS_SATURATION_MAX
};

#define V4L2_CID_IS_CAMERA_SHARPNESS		(V4L2_CID_FIMC_IS_BASE + 408)
enum is_sharpness {
	IS_SHARPNESS_MINUS_2,
	IS_SHARPNESS_MINUS_1,
	IS_SHARPNESS_DEFAULT,
	IS_SHARPNESS_PLUS_1,
	IS_SHARPNESS_PLUS_2,
	IS_SHARPNESS_MAX
};

#define V4L2_CID_IS_CAMERA_EXPOSURE		(V4L2_CID_FIMC_IS_BASE + 409)
enum is_exposure {
	IS_EXPOSURE_MINUS_4,
	IS_EXPOSURE_MINUS_3,
	IS_EXPOSURE_MINUS_2,
	IS_EXPOSURE_MINUS_1,
	IS_EXPOSURE_DEFAULT,
	IS_EXPOSURE_PLUS_1,
	IS_EXPOSURE_PLUS_2,
	IS_EXPOSURE_PLUS_3,
	IS_EXPOSURE_PLUS_4,
	IS_EXPOSURE_MAX
};

#define V4L2_CID_IS_CAMERA_BRIGHTNESS		(V4L2_CID_FIMC_IS_BASE + 410)
enum is_brightness {
	IS_BRIGHTNESS_MINUS_2,
	IS_BRIGHTNESS_MINUS_1,
	IS_BRIGHTNESS_DEFAULT,
	IS_BRIGHTNESS_PLUS_1,
	IS_BRIGHTNESS_PLUS_2,
	IS_BRIGHTNESS_MAX
};

#define V4L2_CID_IS_CAMERA_HUE			(V4L2_CID_FIMC_IS_BASE + 411)
enum is_hue {
	IS_HUE_MINUS_2,
	IS_HUE_MINUS_1,
	IS_HUE_DEFAULT,
	IS_HUE_PLUS_1,
	IS_HUE_PLUS_2,
	IS_HUE_MAX
};

#define V4L2_CID_IS_CAMERA_METERING		(V4L2_CID_FIMC_IS_BASE + 412)
enum is_metering {
	IS_METERING_AVERAGE,
	IS_METERING_SPOT,
	IS_METERING_MATRIX,
	IS_METERING_CENTER,
	IS_METERING_MAX
};
#define V4L2_CID_IS_CAMERA_METERING_POSITION_X	(V4L2_CID_FIMC_IS_BASE + 500)
#define V4L2_CID_IS_CAMERA_METERING_POSITION_Y	(V4L2_CID_FIMC_IS_BASE + 501)
#define V4L2_CID_IS_CAMERA_METERING_WINDOW_X	(V4L2_CID_FIMC_IS_BASE + 502)
#define V4L2_CID_IS_CAMERA_METERING_WINDOW_Y	(V4L2_CID_FIMC_IS_BASE + 503)

#define V4L2_CID_IS_CAMERA_AFC_MODE		(V4L2_CID_FIMC_IS_BASE + 413)
enum is_afc_mode {
	IS_AFC_DISABLE,
	IS_AFC_AUTO,
	IS_AFC_MANUAL_50HZ,
	IS_AFC_MANUAL_60HZ,
	IS_AFC_MAX
};

#define V4L2_CID_IS_AWB_LOCK_UNLOCK		(V4L2_CID_FIMC_IS_BASE + 496)
enum is_awb_lock_unlock {
	IS_AWB_LOCK,
	IS_AWB_UNLOCK,
	IS_AWB_LOCK_UNLOCK_MAX
};

#define V4L2_CID_IS_AE_LOCK_UNLOCK		(V4L2_CID_FIMC_IS_BASE + 497)
enum is_ae_lock_unlock {
	IS_AE_LOCK,
	IS_AE_UNLOCK,
	IS_AE_LOCK_UNLOCK_MAX
};

#define V4L2_CID_IS_AE_AWB_LOCK_UNLOCK		(V4L2_CID_FIMC_IS_BASE + 665)
enum is_ae_awb_lock_unlock {
	IS_AE_UNLOCK_AWB_UNLOCK,
	IS_AE_LOCK_AWB_UNLOCK,
	IS_AE_UNLOCK_AWB_LOCK,
	IS_AE_LOCK_AWB_LOCK,
	IS_AE_AWB_LOCK_UNLOCK_MAX
};

#define V4L2_CID_IS_FD_GET_FACE_COUNT		(V4L2_CID_FIMC_IS_BASE + 600)
#define V4L2_CID_IS_FD_GET_FACE_FRAME_NUMBER	(V4L2_CID_FIMC_IS_BASE + 601)
#define V4L2_CID_IS_FD_GET_FACE_CONFIDENCE	(V4L2_CID_FIMC_IS_BASE + 602)
#define V4L2_CID_IS_FD_GET_FACE_SMILE_LEVEL	(V4L2_CID_FIMC_IS_BASE + 603)
#define V4L2_CID_IS_FD_GET_FACE_BLINK_LEVEL	(V4L2_CID_FIMC_IS_BASE + 604)
#define V4L2_CID_IS_FD_GET_FACE_TOPLEFT_X	(V4L2_CID_FIMC_IS_BASE + 605)
#define V4L2_CID_IS_FD_GET_FACE_TOPLEFT_Y	(V4L2_CID_FIMC_IS_BASE + 606)
#define V4L2_CID_IS_FD_GET_FACE_BOTTOMRIGHT_X	(V4L2_CID_FIMC_IS_BASE + 607)
#define V4L2_CID_IS_FD_GET_FACE_BOTTOMRIGHT_Y	(V4L2_CID_FIMC_IS_BASE + 608)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_TOPLEFT_X	(V4L2_CID_FIMC_IS_BASE + 609)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_TOPLEFT_Y	(V4L2_CID_FIMC_IS_BASE + 610)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_BOTTOMRIGHT_X	\
					(V4L2_CID_FIMC_IS_BASE + 611)
#define V4L2_CID_IS_FD_GET_LEFT_EYE_BOTTOMRIGHT_Y	\
					(V4L2_CID_FIMC_IS_BASE + 612)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_TOPLEFT_X		\
					(V4L2_CID_FIMC_IS_BASE + 613)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_TOPLEFT_Y		\
					(V4L2_CID_FIMC_IS_BASE + 614)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_BOTTOMRIGHT_X	\
					(V4L2_CID_FIMC_IS_BASE + 615)
#define V4L2_CID_IS_FD_GET_RIGHT_EYE_BOTTOMRIGHT_Y	\
					(V4L2_CID_FIMC_IS_BASE + 616)
#define V4L2_CID_IS_FD_GET_MOUTH_TOPLEFT_X		\
					(V4L2_CID_FIMC_IS_BASE + 617)
#define V4L2_CID_IS_FD_GET_MOUTH_TOPLEFT_Y		\
					(V4L2_CID_FIMC_IS_BASE + 618)
#define V4L2_CID_IS_FD_GET_MOUTH_BOTTOMRIGHT_X		\
					(V4L2_CID_FIMC_IS_BASE + 619)
#define V4L2_CID_IS_FD_GET_MOUTH_BOTTOMRIGHT_Y		\
					(V4L2_CID_FIMC_IS_BASE + 620)
#define V4L2_CID_IS_FD_GET_ANGLE		(V4L2_CID_FIMC_IS_BASE + 621)
#define V4L2_CID_IS_FD_GET_YAW_ANGLE		(V4L2_CID_FIMC_IS_BASE + 622)
#define V4L2_CID_IS_FD_GET_NEXT			(V4L2_CID_FIMC_IS_BASE + 623)
#define V4L2_CID_IS_FD_GET_DATA			(V4L2_CID_FIMC_IS_BASE + 624)

#define V4L2_CID_IS_FD_SET_MAX_FACE_NUMBER	(V4L2_CID_FIMC_IS_BASE + 650)
#define V4L2_CID_IS_FD_SET_ROLL_ANGLE		(V4L2_CID_FIMC_IS_BASE + 651)
enum is_fd_roll_angle {
	/* 0, 45, 0, -45 */
	IS_FD_ROLL_ANGLE_BASIC		= 0,
	/* 0, 30, 0, -30, 0, 45, 0, -45 */
	IS_FD_ROLL_ANGLE_PRECISE_BASIC	= 1,
	/* 0, 90, 0, -90 */
	IS_FD_ROLL_ANGLE_SIDES		= 2,
	/* 0, 90, 0, -90 0, 45, 0, -45 */
	IS_FD_ROLL_ANGLE_PRECISE_SIDES	= 3,
	/* 0, 90, 0, -90, 0, 180 */
	IS_FD_ROLL_ANGLE_FULL		= 4,
	/* 0, 90, 0, -90, 0, 180, 0, 135, 0, -135 */
	IS_FD_ROLL_ANGLE_PRECISE_FULL	= 5,
};

#define V4L2_CID_IS_FD_SET_YAW_ANGLE		(V4L2_CID_FIMC_IS_BASE + 652)
enum is_fd_yaw_angle {
	IS_FD_YAW_ANGLE_0	= 0,
	IS_FD_YAW_ANGLE_45	= 1,
	IS_FD_YAW_ANGLE_90	= 2,
	IS_FD_YAW_ANGLE_45_90	= 3,
};

#define V4L2_CID_IS_FD_SET_SMILE_MODE		(V4L2_CID_FIMC_IS_BASE + 653)
enum is_fd_smile_mode {
	IS_FD_SMILE_MODE_DISABLE	= 0,
	IS_FD_SMILE_MODE_ENABLE		= 1,
};

#define V4L2_CID_IS_FD_SET_BLINK_MODE		(V4L2_CID_FIMC_IS_BASE + 654)
enum is_fd_blink_mode {
	IS_FD_BLINK_MODE_DISABLE	= 0,
	IS_FD_BLINK_MODE_ENABLE		= 1,
};

#define V4L2_CID_IS_FD_SET_EYE_DETECT_MODE	(V4L2_CID_FIMC_IS_BASE + 655)
enum is_fd_eye_detect_mode {
	IS_FD_EYE_DETECT_DISABLE	= 0,
	IS_FD_EYE_DETECT_ENABLE		= 1,
};

#define V4L2_CID_IS_FD_SET_MOUTH_DETECT_MODE	(V4L2_CID_FIMC_IS_BASE + 656)
enum is_fd_mouth_detect_mode {
	IS_FD_MOUTH_DETECT_DISABLE	= 0,
	IS_FD_MOUTH_DETECT_ENABLE	= 1,
};

#define V4L2_CID_IS_FD_SET_ORIENTATION_MODE	(V4L2_CID_FIMC_IS_BASE + 657)
enum is_fd_orientation_mode {
	IS_FD_ORIENTATION_DISABLE	= 0,
	IS_FD_ORIENTATION_ENABLE	= 1,
};

#define V4L2_CID_IS_FD_SET_ORIENTATION		(V4L2_CID_FIMC_IS_BASE + 658)
#define V4L2_CID_IS_FD_SET_DATA_ADDRESS		(V4L2_CID_FIMC_IS_BASE + 659)

#define V4L2_CID_IS_SET_ISP			(V4L2_CID_FIMC_IS_BASE + 440)
enum is_isp_bypass_mode {
	IS_ISP_BYPASS_DISABLE,
	IS_ISP_BYPASS_ENABLE,
	IS_ISP_BYPASS_MAX
};

#define V4L2_CID_IS_SET_DRC			(V4L2_CID_FIMC_IS_BASE + 441)
enum is_drc_bypass_mode {
	IS_DRC_BYPASS_DISABLE,
	IS_DRC_BYPASS_ENABLE,
	IS_DRC_BYPASS_MAX
};

#define V4L2_CID_IS_SET_FD			(V4L2_CID_FIMC_IS_BASE + 442)
enum is_fd_bypass_mode {
	IS_FD_BYPASS_DISABLE,
	IS_FD_BYPASS_ENABLE,
	IS_FD_BYPASS_MAX
};

#define V4L2_CID_IS_SET_ODC			(V4L2_CID_FIMC_IS_BASE + 443)
enum is_odc_bypass_mode {
	IS_ODC_BYPASS_DISABLE,
	IS_ODC_BYPASS_ENABLE,
	IS_ODC_BYPASS_MAX
};

#define V4L2_CID_IS_SET_DIS			(V4L2_CID_FIMC_IS_BASE + 444)
enum is_dis_bypass_mode {
	IS_DIS_BYPASS_DISABLE,
	IS_DIS_BYPASS_ENABLE,
	IS_DIS_BYPASS_MAX
};

#define V4L2_CID_IS_SET_3DNR			(V4L2_CID_FIMC_IS_BASE + 445)
enum is_tdnr_bypass_mode {
	IS_TDNR_BYPASS_DISABLE,
	IS_TDNR_BYPASS_ENABLE,
	IS_TDNR_BYPASS_MAX
};

#define V4L2_CID_IS_SET_SCALERC			(V4L2_CID_FIMC_IS_BASE + 446)
enum is_scalerc_bypass_mode {
	IS_SCALERC_BYPASS_DISABLE,
	IS_SCALERC_BYPASS_ENABLE,
	IS_SCALERC_BYPASS_MAX
};

#define V4L2_CID_IS_SET_SCALERP			(V4L2_CID_FIMC_IS_BASE + 446)
enum is_scalerp_bypass_mode {
	IS_SCALERP_BYPASS_DISABLE,
	IS_SCALERP_BYPASS_ENABLE,
	IS_SCALERP_BYPASS_MAX
};

#define V4L2_CID_IS_ROTATION_MODE		(V4L2_CID_FIMC_IS_BASE + 450)
enum is_rotation_mode {
	IS_ROTATION_0,
	IS_ROTATION_90,
	IS_ROTATION_180,
	IS_ROTATION_270,
	IS_ROTATION_MAX
};

#define V4L2_CID_IS_3DNR_1ST_FRAME_MODE		(V4L2_CID_FIMC_IS_BASE + 451)
enum is_tdnr_1st_frame_mode {
	IS_TDNR_1ST_FRAME_NOPROCESSING,
	IS_TDNR_1ST_FRAME_2DNR,
	IS_TDNR_MAX
};

#define V4L2_CID_IS_CAMERA_OBJECT_POSITION_X	(V4L2_CID_FIMC_IS_BASE + 452)
#define V4L2_CID_IS_CAMERA_OBJECT_POSITION_Y	(V4L2_CID_FIMC_IS_BASE + 453)
#define V4L2_CID_IS_CAMERA_WINDOW_SIZE_X	(V4L2_CID_FIMC_IS_BASE + 454)
#define V4L2_CID_IS_CAMERA_WINDOW_SIZE_Y	(V4L2_CID_FIMC_IS_BASE + 455)

#define V4L2_CID_IS_CAMERA_EXIF_EXPTIME		(V4L2_CID_FIMC_IS_BASE + 456)
#define V4L2_CID_IS_CAMERA_EXIF_FLASH		(V4L2_CID_FIMC_IS_BASE + 457)
#define V4L2_CID_IS_CAMERA_EXIF_ISO		(V4L2_CID_FIMC_IS_BASE + 458)
#define V4L2_CID_IS_CAMERA_EXIF_SHUTTERSPEED	(V4L2_CID_FIMC_IS_BASE + 459)
#define V4L2_CID_IS_CAMERA_EXIF_BRIGHTNESS	(V4L2_CID_FIMC_IS_BASE + 460)

#define V4L2_CID_IS_CAMERA_ISP_SEL_INPUT	(V4L2_CID_FIMC_IS_BASE + 461)
enum is_isp_sel_input {
	IS_ISP_INPUT_OTF,
	IS_ISP_INPUT_DMA1,
	IS_ISP_INPUT_DMA2,
	IS_ISP_INPUT_DMA12,
	IS_ISP_INPUT_MAX
};

#define V4L2_CID_IS_CAMERA_ISP_SEL_OUTPUT	(V4L2_CID_FIMC_IS_BASE + 462)
enum is_isp_sel_output {
	IS_ISP_OUTPUT_OTF,
	IS_ISP_OUTPUT_DMA1,
	IS_ISP_OUTPUT_DMA2,
	IS_ISP_OUTPUT_DMA12,
	IS_ISP_OUTPUT_OTF_DMA1,
	IS_ISP_OUTPUT_OTF_DMA2,
	IS_ISP_OUTPUT_OTF_DMA12,
	IS_ISP_OUTPUT_MAX
};

#define V4L2_CID_IS_CAMERA_DRC_SEL_INPUT	(V4L2_CID_FIMC_IS_BASE + 463)
enum is_drc_sel_input {
	IS_DRC_INPUT_OTF,
	IS_DRC_INPUT_DMA,
	IS_DRC_INPUT_MAX
};

#define V4L2_CID_IS_CAMERA_FD_SEL_INPUT		(V4L2_CID_FIMC_IS_BASE + 464)
enum is_fd_sel_input {
	IS_FD_INPUT_OTF,
	IS_FD_INPUT_DMA,
	IS_FD_INPUT_MAX
};

#define V4L2_CID_IS_CAMERA_INIT_WIDTH		(V4L2_CID_FIMC_IS_BASE + 465)
#define V4L2_CID_IS_CAMERA_INIT_HEIGHT		(V4L2_CID_FIMC_IS_BASE + 466)

#define V4L2_CID_IS_CMD_ISP			(V4L2_CID_FIMC_IS_BASE + 467)
enum is_isp_cmd_mode {
	IS_ISP_COMMAND_STOP,
	IS_ISP_COMMAND_START,
	IS_ISP_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_DRC			(V4L2_CID_FIMC_IS_BASE + 468)
enum is_drc_cmd_mode {
	IS_DRC_COMMAND_STOP,
	IS_DRC_COMMAND_START,
	IS_DRC_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_FD			(V4L2_CID_FIMC_IS_BASE + 469)
enum is_fd_cmd_mode {
	IS_FD_COMMAND_STOP,
	IS_FD_COMMAND_START,
	IS_FD_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_ODC			(V4L2_CID_FIMC_IS_BASE + 470)
enum is_odc_cmd_mode {
	IS_ODC_COMMAND_STOP,
	IS_ODC_COMMAND_START,
	IS_ODC_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_DIS			(V4L2_CID_FIMC_IS_BASE + 471)
enum is_dis_cmd_mode {
	IS_DIS_COMMAND_STOP,
	IS_DIS_COMMAND_START,
	IS_DIS_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_TDNR			(V4L2_CID_FIMC_IS_BASE + 472)
enum is_tdnr_cmd_mode {
	IS_TDNR_COMMAND_STOP,
	IS_TDNR_COMMAND_START,
	IS_TDNR_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_SCALERC			(V4L2_CID_FIMC_IS_BASE + 473)
enum is_scalerc_cmd_mode {
	IS_SCALERC_COMMAND_STOP,
	IS_SCALERC_COMMAND_START,
	IS_SCALERC_COMMAND_MAX
};

#define V4L2_CID_IS_CMD_SCALERP			(V4L2_CID_FIMC_IS_BASE + 474)
enum is_scalerp_cmd_mode {
	IS_SCALERP_COMMAND_STOP,
	IS_SCALERP_COMMAND_START,
	IS_SCALERP_COMMAND_MAX
};

#define V4L2_CID_IS_GET_SENSOR_OFFSET_X		(V4L2_CID_FIMC_IS_BASE + 480)
#define V4L2_CID_IS_GET_SENSOR_OFFSET_Y		(V4L2_CID_FIMC_IS_BASE + 481)
#define V4L2_CID_IS_GET_SENSOR_WIDTH		(V4L2_CID_FIMC_IS_BASE + 482)
#define V4L2_CID_IS_GET_SENSOR_HEIGHT		(V4L2_CID_FIMC_IS_BASE + 483)

#define V4L2_CID_IS_GET_FRAME_VALID		(V4L2_CID_FIMC_IS_BASE + 484)
#define V4L2_CID_IS_SET_FRAME_VALID		(V4L2_CID_FIMC_IS_BASE + 485)
#define V4L2_CID_IS_GET_FRAME_BADMARK		(V4L2_CID_FIMC_IS_BASE + 486)
#define V4L2_CID_IS_SET_FRAME_BADMARK		(V4L2_CID_FIMC_IS_BASE + 487)
#define V4L2_CID_IS_GET_FRAME_CAPTURED		(V4L2_CID_FIMC_IS_BASE + 488)
#define V4L2_CID_IS_SET_FRAME_CAPTURED		(V4L2_CID_FIMC_IS_BASE + 489)
#define V4L2_CID_IS_SET_FRAME_NUMBER		(V4L2_CID_FIMC_IS_BASE + 490)
#define V4L2_CID_IS_GET_FRAME_NUMBER		(V4L2_CID_FIMC_IS_BASE + 491)
#define V4L2_CID_IS_CLEAR_FRAME_NUMBER		(V4L2_CID_FIMC_IS_BASE + 492)
#define V4L2_CID_IS_GET_LOSTED_FRAME_NUMBER	(V4L2_CID_FIMC_IS_BASE + 493)
#define V4L2_CID_IS_ISP_DMA_BUFFER_NUM		(V4L2_CID_FIMC_IS_BASE + 494)
#define V4L2_CID_IS_ISP_DMA_BUFFER_ADDRESS	(V4L2_CID_FIMC_IS_BASE + 495)

#define V4L2_CID_IS_ZOOM_STATE			(V4L2_CID_FIMC_IS_BASE + 660)
#define V4L2_CID_IS_ZOOM_MAX_LEVEL		(V4L2_CID_FIMC_IS_BASE + 661)
#define V4L2_CID_IS_ZOOM			(V4L2_CID_FIMC_IS_BASE + 662)
#define V4L2_CID_IS_FW_DEBUG_REGION_ADDR	(V4L2_CID_FIMC_IS_BASE + 663)

#define V4L2_CID_IS_TUNE_SEL_ENTRY		(V4L2_CID_FIMC_IS_TUNE_BASE)
#define V4L2_CID_IS_TUNE_SENSOR_EXPOSURE	(V4L2_CID_FIMC_IS_TUNE_BASE + 1)
#define V4L2_CID_IS_TUNE_SENSOR_ANALOG_GAIN	(V4L2_CID_FIMC_IS_TUNE_BASE + 2)
#define V4L2_CID_IS_TUNE_SENSOR_FRAME_RATE	(V4L2_CID_FIMC_IS_TUNE_BASE + 3)
#define V4L2_CID_IS_TUNE_SENSOR_ACTUATOR_POS	(V4L2_CID_FIMC_IS_TUNE_BASE + 4)

#define V4L2_CID_IS_FRAME_RATE			(V4L2_CID_FIMC_IS_BASE + 664)
#define V4L2_CID_IS_SCENE_MODE			(V4L2_CID_FIMC_IS_BASE + 667)
enum is_scene_mode {
	IS_SCENE_MODE_BASE,
	IS_SCENE_MODE_NONE,
	IS_SCENE_MODE_PORTRAIT,
	IS_SCENE_MODE_NIGHTSHOT,
	IS_SCENE_MODE_BACK_LIGHT,
	IS_SCENE_MODE_LANDSCAPE,
	IS_SCENE_MODE_SPORTS,
	IS_SCENE_MODE_PARTY_INDOOR,
	IS_SCENE_MODE_BEACH_SNOW,
	IS_SCENE_MODE_SUNSET,
	IS_SCENE_MODE_DUSK_DAWN,
	IS_SCENE_MODE_FALL_COLOR,
	IS_SCENE_MODE_FIREWORKS,
	IS_SCENE_MODE_TEXT,
	IS_SCENE_MODE_CANDLE_LIGHT,
	IS_SCENE_MODE_MAX,
};

#define V4L2_CID_IS_VT_MODE			(V4L2_CID_FIMC_IS_BASE + 668)
#define V4L2_CID_IS_CAMERA_AUTO_FOCUS_RESULT	(V4L2_CID_FIMC_IS_BASE + 669)

enum v4l2_blur {
	BLUR_LEVEL_0 = 0,
	BLUR_LEVEL_1,
	BLUR_LEVEL_2,
	BLUR_LEVEL_3,
	BLUR_LEVEL_MAX,
};

#define V4L2_CID_SENSOR_SET_AE_TARGET			(V4L2_CID_SENSOR_BASE + 1)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_1x1_2		(V4L2_CID_SENSOR_BASE + 2)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_1x3_4		(V4L2_CID_SENSOR_BASE + 3)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_2x1_2		(V4L2_CID_SENSOR_BASE + 4)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_2x3_4		(V4L2_CID_SENSOR_BASE + 5)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_3x1_2		(V4L2_CID_SENSOR_BASE + 6)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_3x3_4		(V4L2_CID_SENSOR_BASE + 7)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_4x1_2		(V4L2_CID_SENSOR_BASE + 8)
#define V4L2_CID_SENSOR_SET_AE_WEIGHT_4x3_4		(V4L2_CID_SENSOR_BASE + 9)
#define V4L2_CID_SENSOR_SET_RG_WEIGHT			(V4L2_CID_SENSOR_BASE + 10)
#define V4L2_CID_SENSOR_SET_AE_SPEED			(V4L2_CID_SENSOR_BASE + 11)
#define V4L2_CID_SENSOR_SET_SHUTTER				(V4L2_CID_SENSOR_BASE + 12)
#define V4L2_CID_SENSOR_SET_GAIN				(V4L2_CID_SENSOR_BASE + 13)
#define V4L2_CID_SENSOR_SET_BIT_CONVERTING		(V4L2_CID_SENSOR_BASE + 14)
#define V4L2_CID_SENSOR_SET_AUTO_EXPOSURE		(V4L2_CID_SENSOR_BASE + 15)
#define V4L2_CID_SENSOR_SET_FRAME_RATE			(V4L2_CID_SENSOR_BASE + 16)

#if 1
#define V4L2_CID_CAMERA_SCENE_MODE		(V4L2_CID_PRIVATE_BASE+70)
enum v4l2_scene_mode {
	SCENE_MODE_BASE,
	SCENE_MODE_NONE,
	SCENE_MODE_PORTRAIT,
	SCENE_MODE_NIGHTSHOT,
	SCENE_MODE_BACK_LIGHT,
	SCENE_MODE_LANDSCAPE,
	SCENE_MODE_SPORTS,
	SCENE_MODE_PARTY_INDOOR,
	SCENE_MODE_BEACH_SNOW,
	SCENE_MODE_SUNSET,
	SCENE_MODE_DUSK_DAWN,
	SCENE_MODE_FALL_COLOR,
	SCENE_MODE_FIREWORKS,
	SCENE_MODE_TEXT,
	SCENE_MODE_CANDLE_LIGHT,
	SCENE_MODE_MAX,
};

#define V4L2_CID_CAMERA_FLASH_MODE		(V4L2_CID_PRIVATE_BASE+71)
enum v4l2_flash_mode {
	FLASH_MODE_BASE,
	FLASH_MODE_OFF,
	FLASH_MODE_AUTO,
	FLASH_MODE_ON,
	FLASH_MODE_TORCH,
	FLASH_MODE_MAX,
};

#define V4L2_CID_CAMERA_BRIGHTNESS		(V4L2_CID_PRIVATE_BASE+72)
enum v4l2_ev_mode {
	EV_MINUS_4	= -4,
	EV_MINUS_3	= -3,
	EV_MINUS_2	= -2,
	EV_MINUS_1	= -1,
	EV_DEFAULT	= 0,
	EV_PLUS_1	= 1,
	EV_PLUS_2	= 2,
	EV_PLUS_3	= 3,
	EV_PLUS_4	= 4,
	EV_MAX,
};

#define V4L2_CID_CAMERA_WHITE_BALANCE	(V4L2_CID_PRIVATE_BASE+73)
enum v4l2_wb_mode {
	WHITE_BALANCE_BASE = 0,
	WHITE_BALANCE_AUTO,
	WHITE_BALANCE_SUNNY,
	WHITE_BALANCE_CLOUDY,
	WHITE_BALANCE_TUNGSTEN,
	WHITE_BALANCE_FLUORESCENT,
	WHITE_BALANCE_MAX,
};

#define V4L2_CID_CAMERA_EFFECT			(V4L2_CID_PRIVATE_BASE+74)
enum v4l2_effect_mode {
	IMAGE_EFFECT_BASE = 0,
	IMAGE_EFFECT_NONE,
	IMAGE_EFFECT_BNW,
	IMAGE_EFFECT_SEPIA,
	IMAGE_EFFECT_AQUA,
	IMAGE_EFFECT_ANTIQUE,
	IMAGE_EFFECT_NEGATIVE,
	IMAGE_EFFECT_SHARPEN,
	IMAGE_EFFECT_MAX,
};

#define V4L2_CID_CAMERA_ISO			(V4L2_CID_PRIVATE_BASE+75)
enum v4l2_iso_mode {
	ISO_AUTO = 0,
	ISO_50,
	ISO_100,
	ISO_200,
	ISO_400,
	ISO_800,
	ISO_1600,
	ISO_SPORTS,
	ISO_NIGHT,
	ISO_MOVIE,
	ISO_MAX,
};

#define V4L2_CID_CAMERA_METERING		(V4L2_CID_PRIVATE_BASE+76)
enum v4l2_metering_mode {
	METERING_BASE = 0,
	METERING_MATRIX,
	METERING_CENTER,
	METERING_SPOT,
	METERING_MAX,
};

#define V4L2_CID_CAMERA_CONTRAST		(V4L2_CID_PRIVATE_BASE+77)
enum v4l2_contrast_mode {
	CONTRAST_MINUS_2 = 0,
	CONTRAST_MINUS_1,
	CONTRAST_DEFAULT,
	CONTRAST_PLUS_1,
	CONTRAST_PLUS_2,
	CONTRAST_MAX,
};

#define V4L2_CID_CAMERA_SATURATION		(V4L2_CID_PRIVATE_BASE+78)
enum v4l2_saturation_mode {
	SATURATION_MINUS_2 = 0,
	SATURATION_MINUS_1,
	SATURATION_DEFAULT,
	SATURATION_PLUS_1,
	SATURATION_PLUS_2,
	SATURATION_MAX,
};

#define V4L2_CID_CAMERA_SHARPNESS		(V4L2_CID_PRIVATE_BASE+79)
enum v4l2_sharpness_mode {
	SHARPNESS_MINUS_2 = 0,
	SHARPNESS_MINUS_1,
	SHARPNESS_DEFAULT,
	SHARPNESS_PLUS_1,
	SHARPNESS_PLUS_2,
	SHARPNESS_MAX,
};

#define V4L2_CID_CAMERA_WDR			(V4L2_CID_PRIVATE_BASE+80)
enum v4l2_wdr_mode {
	WDR_OFF,
	WDR_ON,
	WDR_MAX,
};

#define V4L2_CID_CAMERA_ANTI_SHAKE		(V4L2_CID_PRIVATE_BASE+81)
enum v4l2_anti_shake_mode {
	ANTI_SHAKE_OFF,
	ANTI_SHAKE_STILL_ON,
	ANTI_SHAKE_MOVIE_ON,
	ANTI_SHAKE_MAX,
};

#define V4L2_CID_CAMERA_TOUCH_AF_START_STOP	(V4L2_CID_PRIVATE_BASE+82)
enum v4l2_touch_af {
	TOUCH_AF_STOP = 0,
	TOUCH_AF_START,
	TOUCH_AF_MAX,
};

#define V4L2_CID_CAMERA_SMART_AUTO		(V4L2_CID_PRIVATE_BASE+83)
enum v4l2_smart_auto {
	SMART_AUTO_OFF = 0,
	SMART_AUTO_ON,
	SMART_AUTO_MAX,
};

#define V4L2_CID_CAMERA_VINTAGE_MODE		(V4L2_CID_PRIVATE_BASE+84)
enum v4l2_vintage_mode {
	VINTAGE_MODE_BASE,
	VINTAGE_MODE_OFF,
	VINTAGE_MODE_NORMAL,
	VINTAGE_MODE_WARM,
	VINTAGE_MODE_COOL,
	VINTAGE_MODE_BNW,
	VINTAGE_MODE_MAX,
};

#define V4L2_CID_CAMERA_JPEG_QUALITY		(V4L2_CID_PRIVATE_BASE+85)
/* (V4L2_CID_PRIVATE_BASE+86) */
#define V4L2_CID_CAMERA_GPS_LATITUDE		(V4L2_CID_CAMERA_CLASS_BASE+30)
/* (V4L2_CID_PRIVATE_BASE+87) */
#define V4L2_CID_CAMERA_GPS_LONGITUDE	(V4L2_CID_CAMERA_CLASS_BASE + 31)
/* (V4L2_CID_PRIVATE_BASE+88) */
#define V4L2_CID_CAMERA_GPS_TIMESTAMP	(V4L2_CID_CAMERA_CLASS_BASE + 32)
/* (V4L2_CID_PRIVATE_BASE+89)*/
#define V4L2_CID_CAMERA_GPS_ALTITUDE	(V4L2_CID_CAMERA_CLASS_BASE + 33)
#define V4L2_CID_CAMERA_EXIF_TIME_INFO	(V4L2_CID_CAMERA_CLASS_BASE + 34)
#define V4L2_CID_CAMERA_GPS_PROCESSINGMETHOD	(V4L2_CID_CAMERA_CLASS_BASE+35)

#define V4L2_CID_FOCUS_AUTO_MODE		(V4L2_CID_CAMERA_CLASS_BASE+36)
enum  v4l2_focus_mode_type {
	V4L2_FOCUS_AUTO_NORMAL = 0,
	V4L2_FOCUS_AUTO_MACRO,
	V4L2_FOCUS_AUTO_CONTINUOUS,
	V4L2_FOCUS_AUTO_FACE_DETECTION,
	V4L2_FOCUS_AUTO_RECTANGLE,
	V4L2_FOCUS_AUTO_MAX,
};
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_LEFT	(V4L2_CID_CAMERA_CLASS_BASE+37)
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_TOP	(V4L2_CID_CAMERA_CLASS_BASE+38)
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_WIDTH	(V4L2_CID_CAMERA_CLASS_BASE+39)
#define V4L2_CID_FOCUS_AUTO_RECTANGLE_HEIGHT	(V4L2_CID_CAMERA_CLASS_BASE+40)
#define V4L2_CID_IMAGE_EFFECT			(V4L2_CID_CAMERA_CLASS_BASE+41)
enum v4l2_image_effect {
	V4L2_IMAGE_EFFECT_BASE = 0,
	V4L2_IMAGE_EFFECT_NONE,
	V4L2_IMAGE_EFFECT_BNW,
	V4L2_IMAGE_EFFECT_SEPIA,
	V4L2_IMAGE_EFFECT_AQUA,
	V4L2_IMAGE_EFFECT_ANTIQUE,
	V4L2_IMAGE_EFFECT_NEGATIVE,
	V4L2_IMAGE_EFFECT_SHARPEN,
	V4L2_IMAGE_EFFECT_SOLARIZE,
	V4L2_IMAGE_EFFECT_MAX,
};

#define V4L2_CID_CAM_CONTRAST			(V4L2_CID_CAMERA_CLASS_BASE+42)
enum v4l2_contrast {
	V4L2_CONTRAST_AUTO,
	V4L2_CONTRAST_MINUS_4,
	V4L2_CONTRAST_MINUS_3,
	V4L2_CONTRAST_MINUS_2,
	V4L2_CONTRAST_MINUS_1,
	V4L2_CONTRAST_DEFAULT,
	V4L2_CONTRAST_PLUS_1,
	V4L2_CONTRAST_PLUS_2,
	V4L2_CONTRAST_PLUS_3,
	V4L2_CONTRAST_PLUS_4,
	V4L2_CONTRAST_MAX
};

#define V4L2_CID_CAM_SATURATION			(V4L2_CID_CAMERA_CLASS_BASE+43)
enum v4l2_saturation {
	V4L2_SATURATION_MINUS_3,
	V4L2_SATURATION_MINUS_2,
	V4L2_SATURATION_MINUS_1,
	V4L2_SATURATION_DEFAULT,
	V4L2_SATURATION_PLUS_1,
	V4L2_SATURATION_PLUS_2,
	V4L2_SATURATION_PLUS_3,
	V4L2_SATURATION_MAX
};

#define V4L2_CID_CAM_SHARPNESS			(V4L2_CID_CAMERA_CLASS_BASE+44)
enum v4l2_sharpness {
	V4L2_SHARPNESS_MINUS_2,
	V4L2_SHARPNESS_MINUS_1,
	V4L2_SHARPNESS_DEFAULT,
	V4L2_SHARPNESS_PLUS_1,
	V4L2_SHARPNESS_PLUS_2,
	V4L2_SHARPNESS_MAX,
};

#define V4L2_CID_CAM_BRIGHTNESS			(V4L2_CID_CAMERA_CLASS_BASE+45)
enum v4l2_brightness {
	V4L2_BRIGHTNESS_MINUS_2,
	V4L2_BRIGHTNESS_MINUS_1,
	V4L2_BRIGHTNESS_DEFAULT,
	V4L2_BRIGHTNESS_PLUS_1,
	V4L2_BRIGHTNESS_PLUS_2,
	V4L2_BRIGHTNESS_MAX,
};

#define V4L2_CID_CAPTURE			(V4L2_CID_CAMERA_CLASS_BASE+46)
#define V4L2_CID_CAM_METERING			(V4L2_CID_CAMERA_CLASS_BASE+47)
enum v4l2_cam_metering_mode {
	V4L2_METERING_BASE = 0,
	V4L2_METERING_MATRIX,
	V4L2_METERING_CENTER,
	V4L2_METERING_SPOT,
	V4L2_METERING_MAX,
};

#define V4L2_CID_CAM_SET_AUTO_FOCUS		(V4L2_CID_CAMERA_CLASS_BASE+48)
enum v4l2_cam_auto_focus {
	V4L2_AUTO_FOCUS_OFF = 0,
	V4L2_AUTO_FOCUS_ON,
	V4L2_AUTO_FOCUS_MAX,
};

#define V4L2_CID_CAM_FRAME_RATE			(V4L2_CID_CAMERA_CLASS_BASE+49)
enum v4l2_cam_frame_rate {
	V4L2_FRAME_RATE_AUTO = 0,
	V4L2_FRAME_RATE_7 = 7,
	V4L2_FRAME_RATE_15 = 15,
	V4L2_FRAME_RATE_30 = 30,
	V4L2_FRAME_RATE_MAX
};

#define V4L2_CID_CAM_OBJECT_POSITION_X		(V4L2_CID_CAMERA_CLASS_BASE+50)
#define V4L2_CID_CAM_OBJECT_POSITION_Y		(V4L2_CID_CAMERA_CLASS_BASE+51)
#define V4L2_CID_CAM_FACE_DETECTION		(V4L2_CID_CAMERA_CLASS_BASE+52)
enum v4l2_cam_face_detection {
	V4L2_FACE_DETECTION_OFF = 0,
	V4L2_FACE_DETECTION_ON,
	V4L2_FACE_DETECTION_NOLINE,
	V4L2_FACE_DETECTION_ON_BEAUTY,
	V4L2_FACE_DETECTION_MAX,
};
#define V4L2_CID_CAM_WDR			(V4L2_CID_CAMERA_CLASS_BASE+53)
enum v4l2_cam_wdr_mode {
	V4L2_WDR_OFF = 0,
	V4L2_WDR_ON,
	V4L2_WDR_MAX,
};
#define V4L2_CID_CAM_AUTO_FOCUS_RESULT		(V4L2_CID_CAMERA_CLASS_BASE+54)
enum v4l2_cam_af_status {
	V4L2_CAMERA_AF_STATUS_IN_PROGRESS = 0,
	V4L2_CAMERA_AF_STATUS_SUCCESS,
	V4L2_CAMERA_AF_STATUS_FAIL,
	V4L2_CAMERA_AF_STATUS_1ST_SUCCESS,
	V4L2_CAMERA_AF_STATUS_MAX,
};
#define V4L2_CID_JPEG_QUALITY			(V4L2_CID_CAMERA_CLASS_BASE+55)
#define V4L2_CID_CAM_GET_ISO			(V4L2_CID_CAMERA_CLASS_BASE+56)
#define V4L2_CID_CAM_GET_SHT_TIME		(V4L2_CID_CAMERA_CLASS_BASE+57)
#define V4L2_CID_CAM_AEAWB_LOCK_UNLOCK		(V4L2_CID_CAMERA_CLASS_BASE+58)
enum v4l2_cam_ae_awb_lockunlock {
	V4L2_AE_UNLOCK_AWB_UNLOCK = 0,
	V4L2_AE_LOCK_AWB_UNLOCK,
	V4L2_AE_UNLOCK_AWB_LOCK,
	V4L2_AE_LOCK_AWB_LOCK,
	V4L2_AE_AWB_MAX
};
#define V4L2_CID_CAM_ZOOM			(V4L2_CID_CAMERA_CLASS_BASE+59)
enum v4l2_cam_zoom_level {
	V4L2_ZOOM_LEVEL_0 = 0,
	V4L2_ZOOM_LEVEL_1,
	V4L2_ZOOM_LEVEL_2,
	V4L2_ZOOM_LEVEL_3,
	V4L2_ZOOM_LEVEL_4,
	V4L2_ZOOM_LEVEL_5,
	V4L2_ZOOM_LEVEL_6,
	V4L2_ZOOM_LEVEL_7,
	V4L2_ZOOM_LEVEL_8,
	V4L2_ZOOM_LEVEL_9,
	V4L2_ZOOM_LEVEL_10,
	V4L2_ZOOM_LEVEL_11,
	V4L2_ZOOM_LEVEL_12,
	V4L2_ZOOM_LEVEL_MAX = 31,
};

#define V4L2_CID_CAM_GET_FRAME_COUNT		(V4L2_CID_CAMERA_CLASS_BASE+60)
#define V4L2_CID_CAM_CAF_START_STOP		(V4L2_CID_CAMERA_CLASS_BASE+61)
enum v4l2_cam_caf_start_stop {
	V4L2_CAF_STOP = 0,
	V4L2_CAF_START,
	V4L2_CAF_MAX,
};

#define V4L2_CID_CAM_FLASH_MODE			(V4L2_CID_CAMERA_CLASS_BASE+62)
enum v4l2_cam_flash_mode {
	V4L2_FLASH_MODE_BASE,
	V4L2_FLASH_MODE_OFF,
	V4L2_FLASH_MODE_AUTO,
	V4L2_FLASH_MODE_ON,
	V4L2_FLASH_MODE_TORCH,
	V4L2_FLASH_MODE_MAX,
};

#define V4L2_CID_CAM_SINGLE_AUTO_FOCUS		(V4L2_CID_CAMERA_CLASS_BASE+63)

#define V4L2_CID_CAMERA_ZOOM			(V4L2_CID_PRIVATE_BASE+90)
enum v4l2_zoom_level {
	ZOOM_LEVEL_0 = 0,
	ZOOM_LEVEL_1,
	ZOOM_LEVEL_2,
	ZOOM_LEVEL_3,
	ZOOM_LEVEL_4,
	ZOOM_LEVEL_5,
	ZOOM_LEVEL_6,
	ZOOM_LEVEL_7,
	ZOOM_LEVEL_8,
	ZOOM_LEVEL_9,
	ZOOM_LEVEL_10,
	ZOOM_LEVEL_11,
	ZOOM_LEVEL_12,
	ZOOM_LEVEL_MAX = 31,
};

#define V4L2_CID_CAMERA_FACE_DETECTION		(V4L2_CID_PRIVATE_BASE+91)
enum v4l2_face_detection {
	FACE_DETECTION_OFF = 0,
	FACE_DETECTION_ON,
	FACE_DETECTION_NOLINE,
	FACE_DETECTION_ON_BEAUTY,
	FACE_DETECTION_MAX,
};

#define V4L2_CID_CAMERA_SMART_AUTO_STATUS	(V4L2_CID_PRIVATE_BASE+92)
enum v4l2_smart_auto_status {
	SMART_AUTO_STATUS_AUTO = 0,
	SMART_AUTO_STATUS_LANDSCAPE,
	SMART_AUTO_STATUS_PORTRAIT,
	SMART_AUTO_STATUS_MACRO,
	SMART_AUTO_STATUS_NIGHT,
	SMART_AUTO_STATUS_PORTRAIT_NIGHT,
	SMART_AUTO_STATUS_BACKLIT,
	SMART_AUTO_STATUS_PORTRAIT_BACKLIT,
	SMART_AUTO_STATUS_ANTISHAKE,
	SMART_AUTO_STATUS_PORTRAIT_ANTISHAKE,
	SMART_AUTO_STATUS_MAX,
};

#define V4L2_CID_CAMERA_SET_AUTO_FOCUS		(V4L2_CID_PRIVATE_BASE+93)
enum v4l2_auto_focus {
	AUTO_FOCUS_OFF = 0,
	AUTO_FOCUS_ON,
	AUTO_FOCUS_MAX,
};

#define V4L2_CID_CAMERA_BEAUTY_SHOT		(V4L2_CID_PRIVATE_BASE+94)
enum v4l2_beauty_shot {
	BEAUTY_SHOT_OFF = 0,
	BEAUTY_SHOT_ON,
	BEAUTY_SHOT_MAX,
};

#define V4L2_CID_CAMERA_AEAWB_LOCK_UNLOCK	(V4L2_CID_PRIVATE_BASE+95)
enum v4l2_ae_awb_lockunlock {
	AE_UNLOCK_AWB_UNLOCK = 0,
	AE_LOCK_AWB_UNLOCK,
	AE_UNLOCK_AWB_LOCK,
	AE_LOCK_AWB_LOCK,
	AE_AWB_MAX
};

#define V4L2_CID_CAMERA_FACEDETECT_LOCKUNLOCK	(V4L2_CID_PRIVATE_BASE+96)
enum v4l2_face_lock {
	FACE_LOCK_OFF = 0,
	FACE_LOCK_ON,
	FIRST_FACE_TRACKING,
	FACE_LOCK_MAX,
};

#define V4L2_CID_CAMERA_OBJECT_POSITION_X	(V4L2_CID_PRIVATE_BASE+97)
#define V4L2_CID_CAMERA_OBJECT_POSITION_Y	(V4L2_CID_PRIVATE_BASE+98)
#define V4L2_CID_CAMERA_FOCUS_MODE		(V4L2_CID_PRIVATE_BASE+99)
enum v4l2_focusmode {
	FOCUS_MODE_AUTO = 0,
	FOCUS_MODE_MACRO,
	FOCUS_MODE_FACEDETECT,
	FOCUS_MODE_AUTO_DEFAULT,
	FOCUS_MODE_MACRO_DEFAULT,
	FOCUS_MODE_FACEDETECT_DEFAULT,
	FOCUS_MODE_INFINITY,
	FOCUS_MODE_FIXED,
	FOCUS_MODE_CONTINUOUS,
	FOCUS_MODE_CONTINUOUS_PICTURE,
	FOCUS_MODE_CONTINUOUS_PICTURE_MACRO,
	FOCUS_MODE_CONTINUOUS_VIDEO,
	FOCUS_MODE_TOUCH,
	FOCUS_MODE_MAX,
	FOCUS_MODE_DEFAULT = (1 << 8),
};

#define V4L2_CID_CAMERA_OBJ_TRACKING_STATUS	(V4L2_CID_PRIVATE_BASE+100)
enum v4l2_obj_tracking_status {
	OBJECT_TRACKING_STATUS_BASE,
	OBJECT_TRACKING_STATUS_PROGRESSING,
	OBJECT_TRACKING_STATUS_SUCCESS,
	OBJECT_TRACKING_STATUS_FAIL,
	OBJECT_TRACKING_STATUS_MISSING,
	OBJECT_TRACKING_STATUS_MAX,
};

#define V4L2_CID_CAMERA_OBJ_TRACKING_START_STOP	(V4L2_CID_PRIVATE_BASE+101)
enum v4l2_ot_start_stop {
	OT_STOP = 0,
	OT_START,
	OT_MAX,
};

#define V4L2_CID_CAMERA_CAF_START_STOP	(V4L2_CID_PRIVATE_BASE+102)
enum v4l2_caf_start_stop {
	CAF_STOP = 0,
	CAF_START,
	CAF_MAX,
};

#define V4L2_CID_CAMERA_AUTO_FOCUS_RESULT	(V4L2_CID_PRIVATE_BASE+103)
enum v4l2_af_status {
	CAMERA_AF_STATUS_IN_PROGRESS = 0,
	CAMERA_AF_STATUS_SUCCESS,
	CAMERA_AF_STATUS_FAIL,
	CAMERA_AF_STATUS_1ST_SUCCESS,
	CAMERA_AF_STATUS_MAX,
};
#define V4L2_CID_CAMERA_FRAME_RATE		(V4L2_CID_PRIVATE_BASE+104)
enum v4l2_frame_rate {
	FRAME_RATE_AUTO = 0,
	FRAME_RATE_7 = 7,
	FRAME_RATE_15 = 15,
	FRAME_RATE_20 = 20,
	FRAME_RATE_30 = 30,
	FRAME_RATE_60 = 60,
	FRAME_RATE_120 = 120,
	FRAME_RATE_MAX
};

#define V4L2_CID_CAMERA_ANTI_BANDING		(V4L2_CID_PRIVATE_BASE+105)
enum v4l2_anti_banding {
	ANTI_BANDING_AUTO = 0,
	ANTI_BANDING_50HZ = 1,
	ANTI_BANDING_60HZ = 2,
	ANTI_BANDING_OFF = 3,
};

#define V4L2_CID_CAMERA_SET_GAMMA	(V4L2_CID_PRIVATE_BASE+106)
enum v4l2_gamma_mode {
	GAMMA_OFF = 0,
	GAMMA_ON = 1,
	GAMMA_MAX,
};

#define V4L2_CID_CAMERA_SET_SLOW_AE	(V4L2_CID_PRIVATE_BASE+107)
enum v4l2_slow_ae_mode {
	SLOW_AE_OFF,
	SLOW_AE_ON,
	SLOW_AE_MAX,
};

#define V4L2_CID_CAMERA_BATCH_REFLECTION	(V4L2_CID_PRIVATE_BASE+108)
#define V4L2_CID_CAMERA_EXIF_ORIENTATION	(V4L2_CID_PRIVATE_BASE+109)

/* s1_camera [ Defense process by ESD input ] */
#define V4L2_CID_CAMERA_RESET			(V4L2_CID_PRIVATE_BASE+111)
#define V4L2_CID_CAMERA_CHECK_DATALINE		(V4L2_CID_PRIVATE_BASE+112)
#define V4L2_CID_CAMERA_CHECK_DATALINE_STOP	(V4L2_CID_PRIVATE_BASE+113)

#endif

/* Modify NTTS1 */
#if defined(CONFIG_ARIES_NTT)
#define V4L2_CID_CAMERA_AE_AWB_DISABLE_LOCK	(V4L2_CID_PRIVATE_BASE+114)
#endif
#define V4L2_CID_CAMERA_THUMBNAIL_NULL		(V4L2_CID_PRIVATE_BASE+115)
#define V4L2_CID_CAMERA_SENSOR_MODE		(V4L2_CID_PRIVATE_BASE+116)
enum v4l2_sensor_mode {
	SENSOR_CAMERA,
	SENSOR_MOVIE,
};

enum stream_mode_t {
	STREAM_MODE_CAM_OFF,
	STREAM_MODE_CAM_ON,
	STREAM_MODE_MOVIE_OFF,
	STREAM_MODE_MOVIE_ON,
};

#define V4L2_CID_CAMERA_EXIF_EXPTIME		(V4L2_CID_PRIVATE_BASE+117)
#define V4L2_CID_CAMERA_EXIF_FLASH		(V4L2_CID_PRIVATE_BASE+118)
#define V4L2_CID_CAMERA_EXIF_ISO		(V4L2_CID_PRIVATE_BASE+119)
#define V4L2_CID_CAMERA_EXIF_TV			(V4L2_CID_PRIVATE_BASE+120)
#define V4L2_CID_CAMERA_EXIF_BV			(V4L2_CID_PRIVATE_BASE+121)
#define V4L2_CID_CAMERA_EXIF_EBV		(V4L2_CID_PRIVATE_BASE+122)
#define V4L2_CID_CAMERA_CHECK_ESD		(V4L2_CID_PRIVATE_BASE+123)
#define V4L2_CID_CAMERA_APP_CHECK		(V4L2_CID_PRIVATE_BASE+124)

#define V4L2_CID_CAMERA_FACE_ZOOM  (V4L2_CID_PRIVATE_BASE + 132)
enum v4l2_face_zoom {
	FACE_ZOOM_STOP = 0,
	FACE_ZOOM_START
};
/* control for post processing block in ISP */
#define V4L2_CID_CAMERA_SET_ODC			(V4L2_CID_PRIVATE_BASE+127)
enum set_odc_mode {
	CAMERA_ODC_ON,
	CAMERA_ODC_OFF
};

#define V4L2_CID_CAMERA_SET_DIS			(V4L2_CID_PRIVATE_BASE+128)
enum set_dis_mode {
	CAMERA_DIS_ON,
	CAMERA_DIS_OFF
};

#define V4L2_CID_CAMERA_SET_3DNR		(V4L2_CID_PRIVATE_BASE+129)
enum set_3dnr_mode {
	CAMERA_3DNR_ON,
	CAMERA_3DNR_OFF
};

#define V4L2_CID_EMBEDDEDDATA_ENABLE		(V4L2_CID_PRIVATE_BASE+130)

#define V4L2_CID_CAMERA_CHECK_SENSOR_STATUS	(V4L2_CID_PRIVATE_BASE+150)
#define V4L2_CID_CAMERA_DEFAULT_FOCUS_POSITION	(V4L2_CID_PRIVATE_BASE+151)
/*      Pixel format FOURCC depth  Description  */
enum v4l2_pix_format_mode {
	V4L2_PIX_FMT_MODE_PREVIEW,
	V4L2_PIX_FMT_MODE_CAPTURE,
	V4L2_PIX_FMT_MODE_HDR,
	V4L2_PIX_FMT_MODE_VT_MIRROR,
	V4L2_PIX_FMT_MODE_VT_NONMIRROR,
};

/* 12  Y/CbCr 4:2:0 64x32 macroblocks */
#define V4L2_PIX_FMT_NV12T    v4l2_fourcc('T', 'V', '1', '2')
#define V4L2_PIX_FMT_NV21T    v4l2_fourcc('T', 'V', '2', '1')
#define V4L2_PIX_FMT_INTERLEAVED    v4l2_fourcc('I', 'T', 'L', 'V')


/*
 *  * V4L2 extention for digital camera
 *   */
/* Strobe flash light */
enum v4l2_strobe_control {
	/* turn off the flash light */
	V4L2_STROBE_CONTROL_OFF		= 0,
	/* turn on the flash light */
	V4L2_STROBE_CONTROL_ON		= 1,
	/* act guide light before splash */
	V4L2_STROBE_CONTROL_AFGUIDE	= 2,
	/* charge the flash light */
	V4L2_STROBE_CONTROL_CHARGE	= 3,
};

enum v4l2_strobe_conf {
	V4L2_STROBE_OFF			= 0,	/* Always off */
	V4L2_STROBE_ON			= 1,	/* Always splashes */
	/* Auto control presets */
	V4L2_STROBE_AUTO		= 2,
	V4L2_STROBE_REDEYE_REDUCTION	= 3,
	V4L2_STROBE_SLOW_SYNC		= 4,
	V4L2_STROBE_FRONT_CURTAIN	= 5,
	V4L2_STROBE_REAR_CURTAIN	= 6,
	/* Extra manual control presets */
	/* keep turned on until turning off */
	V4L2_STROBE_PERMANENT		= 7,
	V4L2_STROBE_EXTERNAL		= 8,
};

enum v4l2_strobe_status {
	V4L2_STROBE_STATUS_OFF		= 0,
	/* while processing configurations */
	V4L2_STROBE_STATUS_BUSY		= 1,
	V4L2_STROBE_STATUS_ERR		= 2,
	V4L2_STROBE_STATUS_CHARGING	= 3,
	V4L2_STROBE_STATUS_CHARGED	= 4,
};

/* capabilities field */
/* No strobe supported */
#define V4L2_STROBE_CAP_NONE		0x0000
/* Always flash off mode */
#define V4L2_STROBE_CAP_OFF		0x0001
/* Always use flash light mode */
#define V4L2_STROBE_CAP_ON		0x0002
/* Flashlight works automatic */
#define V4L2_STROBE_CAP_AUTO		0x0004
/* Red-eye reduction */
#define V4L2_STROBE_CAP_REDEYE		0x0008
/* Slow sync */
#define V4L2_STROBE_CAP_SLOWSYNC	0x0010
/* Front curtain */
#define V4L2_STROBE_CAP_FRONT_CURTAIN	0x0020
/* Rear curtain */
#define V4L2_STROBE_CAP_REAR_CURTAIN	0x0040
/* keep turned on until turning off */
#define V4L2_STROBE_CAP_PERMANENT	0x0080
/* use external strobe */
#define V4L2_STROBE_CAP_EXTERNAL	0x0100

/* Set mode and Get status */
struct v4l2_strobe {
	/* off/on/charge:0/1/2 */
	enum	v4l2_strobe_control control;
	/* supported strobe capabilities */
	__u32	capabilities;
	enum	v4l2_strobe_conf mode;
	enum	v4l2_strobe_status status;	/* read only */
	/* default is 0 and range of value varies from each models */
	__u32	flash_ev;
	__u32	reserved[4];
};

#define VIDIOC_S_STROBE     _IOWR('V', 83, struct v4l2_strobe)
#define VIDIOC_G_STROBE     _IOR('V', 84, struct v4l2_strobe)

/* Object recognition and collateral actions */
enum v4l2_recog_mode {
	V4L2_RECOGNITION_MODE_OFF	= 0,
	V4L2_RECOGNITION_MODE_ON	= 1,
	V4L2_RECOGNITION_MODE_LOCK	= 2,
};

enum v4l2_recog_action {
	V4L2_RECOGNITION_ACTION_NONE	= 0,	/* only recognition */
	V4L2_RECOGNITION_ACTION_BLINK	= 1,	/* Capture on blinking */
	V4L2_RECOGNITION_ACTION_SMILE	= 2,	/* Capture on smiling */
};

enum v4l2_recog_pattern {
	V4L2_RECOG_PATTERN_FACE		= 0, /* Face */
	V4L2_RECOG_PATTERN_HUMAN	= 1, /* Human */
	V4L2_RECOG_PATTERN_CHAR		= 2, /* Character */
};

struct v4l2_recog_rect {
	enum	v4l2_recog_pattern  p;	/* detected pattern */
	struct	v4l2_rect  o;	/* detected area */
	__u32	reserved[4];
};

struct v4l2_recog_data {
	__u8	detect_cnt;		/* detected object counter */
	struct	v4l2_rect	o;	/* detected area */
	__u32	reserved[4];
};

struct v4l2_recognition {
	enum v4l2_recog_mode	mode;

	/* Which pattern to detect */
	enum v4l2_recog_pattern  pattern;

	/* How many object to detect */
	__u8	obj_num;

	/* select detected object */
	__u32	detect_idx;

	/* read only :Get object coordination */
	struct v4l2_recog_data	data;

	enum v4l2_recog_action	action;
	__u32	reserved[4];
};

#define VIDIOC_S_RECOGNITION	_IOWR('V', 85, struct v4l2_recognition)
#define VIDIOC_G_RECOGNITION	_IOR('V', 86, struct v4l2_recognition)
/* We use this struct as the v4l2_streamparm raw_data for
 * VIDIOC_G_PARM and VIDIOC_S_PARM
 */
struct sec_cam_parm {
	struct v4l2_captureparm capture;
	int contrast;
	int effects;
	int brightness;
	int flash_mode;
	int focus_mode;
	int iso;
	int metering;
	int saturation;
	int scene_mode;
	int sharpness;
	int white_balance;
	int fps;
	int aeawb_lockunlock;
	int zoom_ratio;
};

#endif /* __LINUX_VIDEODEV2_EXYNOS_CAMERA_H */
