/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.swing;

import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.concurrent.IncrementalTaskController;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.WrappedException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<R, I>
extends IncrementalTaskController<I, R> {
    private CompletionMonitor _continueMonitor = new CompletionMonitor(false);
    private Thread _workerThread = new Thread("SwingWorker"){

        public void run() {
            SwingWorker.this.started();
            try {
                SwingWorker.this.finishedCleanly(SwingWorker.this.doInBackground());
            }
            catch (InterruptedException e) {
                SwingWorker.this.stopped();
            }
            catch (Exception e) {
                SwingWorker.this.finishedWithTaskException(e);
            }
            catch (Throwable t) {
                SwingWorker.this.finishedWithImplementationException(new WrappedException(t));
            }
        }
    };

    public SwingWorker() {
        this.finishListeners().add(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SwingWorker.this.done();
                    }
                });
            }
        });
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IntermediateListener
        implements Runnable1<I> {
            IntermediateListener() {
            }

            @Override
            public void run(I val) {
                SwingWorker.this.intermediateListeners().remove(this);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LinkedList vals = new LinkedList();
                        SwingWorker.this.intermediateListeners().add(this);
                        SwingWorker.this.intermediateQueue().drainTo(vals);
                        SwingWorker.this.process(vals);
                    }
                });
            }
        }
        IntermediateListener listener = new IntermediateListener();
        this.intermediateListeners().add(listener);
    }

    public final void execute() {
        this.start();
    }

    protected abstract R doInBackground() throws Exception;

    protected void process(List<I> chunks) {
    }

    protected void done() {
    }

    protected final void publish(I ... chunks) {
        BlockingQueue queue = this.intermediateQueue();
        try {
            for (I val : chunks) {
                queue.put(val);
            }
        }
        catch (InterruptedException e) {
            throw new WrappedException(e);
        }
    }

    protected void authorizeContinue() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this._continueMonitor.isSignaled()) {
            this.paused();
            this._continueMonitor.ensureSignaled();
            this.started();
        }
    }

    @Override
    protected final void doStart() {
        this._continueMonitor.signal();
        this._workerThread.start();
    }

    @Override
    protected final void doPause() {
        this._continueMonitor.reset();
    }

    @Override
    protected final void doResume() {
        this._continueMonitor.signal();
    }

    @Override
    protected final void doStop() {
        this._workerThread.interrupt();
    }
}

