/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf;

import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.tuple.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kr.ac.kaist.jsaf.ShellParameters;
import kr.ac.kaist.jsaf.analysis.typing.Config;
import kr.ac.kaist.jsaf.bug_detector.ASTCodingChecker;
import kr.ac.kaist.jsaf.bug_detector.AnalysisResult;
import kr.ac.kaist.jsaf.bug_detector.BugInfo;
import kr.ac.kaist.jsaf.bug_detector.BugItem;
import kr.ac.kaist.jsaf.bug_detector.StrictModeChecker;
import kr.ac.kaist.jsaf.compiler.Disambiguator;
import kr.ac.kaist.jsaf.compiler.Hoister;
import kr.ac.kaist.jsaf.compiler.Parser;
import kr.ac.kaist.jsaf.compiler.Predefined;
import kr.ac.kaist.jsaf.compiler.Translator;
import kr.ac.kaist.jsaf.compiler.WithRewriter;
import kr.ac.kaist.jsaf.compiler.module.ModuleRewriter;
import kr.ac.kaist.jsaf.concolic.static_concolic.StaticConcolicInterface;
import kr.ac.kaist.jsaf.exceptions.MultipleStaticError;
import kr.ac.kaist.jsaf.exceptions.ParserError;
import kr.ac.kaist.jsaf.exceptions.StaticError;
import kr.ac.kaist.jsaf.exceptions.UserError;
import kr.ac.kaist.jsaf.exceptions.WrappedException;
import kr.ac.kaist.jsaf.nodes.IRRoot;
import kr.ac.kaist.jsaf.nodes.Program;
import kr.ac.kaist.jsaf.nodes_util.IRFactory;
import kr.ac.kaist.jsaf.nodes_util.JSAstToConcrete;
import kr.ac.kaist.jsaf.nodes_util.JSFromHTML;
import kr.ac.kaist.jsaf.nodes_util.NodeUtil;
import kr.ac.kaist.jsaf.nodes_util.VoltAPIExtractor;
import kr.ac.kaist.jsaf.scala_src.useful.WorkManager;
import kr.ac.kaist.jsaf.shell.AnalyzeMain;
import kr.ac.kaist.jsaf.shell.CFGMain;
import kr.ac.kaist.jsaf.shell.ClosureConvertMain;
import kr.ac.kaist.jsaf.shell.CompileMain;
import kr.ac.kaist.jsaf.shell.ConcolicMain;
import kr.ac.kaist.jsaf.shell.InterpreterMain;
import kr.ac.kaist.jsaf.shell.JUnitMain;
import kr.ac.kaist.jsaf.shell.JsClocResultExport;
import kr.ac.kaist.jsaf.shell.ModuleMain;
import kr.ac.kaist.jsaf.shell.OptimizeMain;
import kr.ac.kaist.jsaf.shell.ParseMain;
import kr.ac.kaist.jsaf.shell.SamsungDTVMain;
import kr.ac.kaist.jsaf.shell.SamsungVoltMain;
import kr.ac.kaist.jsaf.shell.SamsungWebappConvertMain;
import kr.ac.kaist.jsaf.shell.SvaceResultFormatter;
import kr.ac.kaist.jsaf.shell.TSMain;
import kr.ac.kaist.jsaf.shell.URLMain;
import kr.ac.kaist.jsaf.shell.UnparseMain;
import kr.ac.kaist.jsaf.shell.WIDLMain;
import kr.ac.kaist.jsaf.shell.WithMain;
import kr.ac.kaist.jsaf.useful.Pair;
import kr.ac.kaist.jsaf.useful.Triple;
import kr.ac.kaist.jsaf.useful.Useful;

public final class Shell {
    public static boolean debug = false;
    public static ShellParameters params = new ShellParameters();
    public static boolean opt_DisambiguateOnly = false;
    public static String printTimeTitle = null;
    private static long startTime;
    private static boolean isTimeout;
    private static boolean isSpaceout;
    public static WorkManager workManager;
    public static Predefined pred;

    public static void main(String[] tokens) throws Throwable {
        Shell.main(false, tokens);
    }

    public static void main(boolean runFromTests, String[] tokens) throws Throwable {
        int return_code = -1;
        if (tokens.length == 0) {
            Shell.printUsageMessage();
        } else {
            return_code = Shell.subMain(tokens);
        }
        if (return_code != 0 && !runFromTests) {
            System.exit(return_code);
        }
    }

    public static int subMain(String[] tokens) throws Throwable {
        int return_code = 0;
        try {
            String errorMessage = params.Set(tokens);
            if (errorMessage != null) {
                throw new UserError(errorMessage);
            }
            pred = new Predefined(params);
            startTime = System.currentTimeMillis();
            isTimeout = false;
            isSpaceout = false;
            switch (Shell.params.command) {
                default: {
                    Shell.printUsageMessage();
                    break;
                }
                case 1: {
                    return_code = ParseMain.parse();
                    break;
                }
                case 2: {
                    return_code = UnparseMain.unparse();
                    break;
                }
                case 22: {
                    return_code = TSMain.tsparse();
                    break;
                }
                case 21: {
                    return_code = WIDLMain.widlparse();
                    break;
                }
                case 5: {
                    Config.setSSMode();
                    Config.unsetCodingGuide();
                    Config.setDtvMode();
                    Config.setQuietMode();
                    NodeUtil.setKeepComments(true);
                    return_code = ConcolicMain.concolicAPI();
                    break;
                }
                case 7: {
                    return_code = WithMain.withRewriter();
                    break;
                }
                case 8: {
                    return_code = ModuleMain.module();
                    break;
                }
                case 9: {
                    return_code = JUnitMain.junit();
                    break;
                }
                case 10: {
                    opt_DisambiguateOnly = true;
                    return_code = CompileMain.compile();
                    break;
                }
                case 11: {
                    CompileMain.compile();
                    break;
                }
                case 12: {
                    return_code = CFGMain.cfgBuilder();
                    break;
                }
                case 13: {
                    return_code = InterpreterMain.interpret();
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 19: {
                    return_code = AnalyzeMain.analyze();
                    break;
                }
                case 17: 
                case 18: {
                    return_code = AnalyzeMain.analyze();
                    break;
                }
                case 20: 
                case 23: {
                    return_code = AnalyzeMain.analyze();
                    break;
                }
                case 24: {
                    return_code = ClosureConvertMain.convert();
                    break;
                }
                case 25: {
                    return_code = OptimizeMain.optimize();
                    break;
                }
                case 98: {
                    ArrayList<BugItem> list;
                    AnalysisResult resultSet;
                    PrintStream oldStream = System.out;
                    if (Shell.params.opt_OutFileName != null && !Shell.params.opt_JSAPluginMode) {
                        System.out.println("# Analysis logs will be stored in '" + Shell.params.opt_OutFileName + ".result" + "'");
                        File printOut = new File(Shell.params.opt_OutFileName + ".result");
                        PrintStream pStream = new PrintStream(new FileOutputStream(printOut));
                        System.setOut(pStream);
                        System.setErr(pStream);
                    }
                    Config.setSSMode();
                    Config.unsetCodingGuide();
                    Config.setDtvMode();
                    Config.setQuietMode();
                    NodeUtil.setKeepComments(true);
                    return_code = SamsungDTVMain.analyze();
                    if (Shell.params.opt_JSAPluginMode) {
                        resultSet = SamsungDTVMain.getAnalysisResult();
                        list = resultSet.getBugInfoList();
                        for (BugItem item : list) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("@BUG ");
                            sb.append(item.bugLevel);
                            sb.append("@" + item.bugCategory);
                            sb.append("@" + item.message);
                            sb.append("@" + item.filePath);
                            sb.append("@" + item.lineNumber);
                            System.out.println(sb.toString());
                        }
                    }
                    if (Shell.params.opt_OutFileName != null) {
                        System.out.println("\n* CSV Result Formatter *");
                        System.out.println("# Result File Path : " + Shell.params.opt_OutFileName);
                        resultSet = SamsungDTVMain.getAnalysisResult();
                        list = resultSet.getBugInfoList();
                        try {
                            Pair<FileWriter, BufferedWriter> pair = Useful.filenameToBufferedWriter(Shell.params.opt_OutFileName);
                            FileWriter fw = pair.first();
                            BufferedWriter writer = pair.second();
                            writer.write("CATEGORY,GROUP_NAME,SEVERITY,CHECKER_NAME,BUG_LOCATION,BUG_MESSAGE\n");
                            for (BugItem item : list) {
                                StringBuilder sb = new StringBuilder();
                                ArrayList<String> listInfo = resultSet.getBugGroupDetail(item.bugCategory);
                                if (listInfo != null) {
                                    sb.append(listInfo.get(0));
                                    sb.append(",\"" + listInfo.get(1) + "\"");
                                    sb.append("," + listInfo.get(2));
                                    sb.append("," + item.checkerName);
                                    sb.append("," + item.spanLocation);
                                    sb.append(",\"" + item.message + "\"" + "\n");
                                }
                                writer.write(sb.toString());
                            }
                            writer.close();
                            fw.close();
                        }
                        catch (IOException e) {
                            throw new IOException("IOException " + e + "while writing " + Shell.params.opt_OutFileName);
                        }
                        System.setOut(oldStream);
                        System.out.println("# Analysis has been completed.");
                    }
                    if (Shell.params.opt_svaceOut != null) {
                        System.out.println("\n* Svace Result Formatter *");
                        resultSet = SamsungDTVMain.getAnalysisResult();
                        list = resultSet.getBugInfoList();
                        String svaceProejctDir = Shell.params.opt_Dir;
                        String projectName = "";
                        if (svaceProejctDir == null) {
                            svaceProejctDir = Shell.params.opt_JS_base;
                        }
                        if (svaceProejctDir != null) {
                            String dirName = svaceProejctDir;
                            String[] splited = dirName.split(File.separator);
                            projectName = splited[splited.length - 1];
                        } else {
                            projectName = "Some JavaScript Files";
                        }
                        SvaceResultFormatter formatter = new SvaceResultFormatter(projectName, svaceProejctDir);
                        formatter.printOutSvaceResult(list, Shell.params.opt_svaceOut);
                        List<String> files = SamsungDTVMain.getSourceFileList();
                        formatter.printOutTargetJsFils(files, Shell.params.opt_svaceOut + ".list");
                        System.out.println("# Project Name : " + projectName);
                        System.out.println("# Result File Path : " + Shell.params.opt_svaceOut);
                    }
                    if (Shell.params.opt_clocOut != null) {
                        System.out.println("\n* Count lines of code result *");
                        System.out.println("# Result File Path : " + Shell.params.opt_clocOut);
                        List<String> files = SamsungDTVMain.getSourceFileList();
                        JsClocResultExport cloc = new JsClocResultExport();
                        cloc.printOutClocResult(files, Shell.params.opt_clocOut);
                    }
                    break;
                }
                case 102: {
                    SamsungVoltMain.preprocess();
                    break;
                }
                case 103: {
                    PrintStream stream = System.out;
                    if (Shell.params.opt_JSAPluginMode) {
                        if (Shell.params.opt_OutFileName != null) {
                            File printOut = new File(Shell.params.opt_OutFileName);
                            PrintStream pStream = new PrintStream(new FileOutputStream(printOut));
                            System.setOut(pStream);
                            System.setErr(pStream);
                        } else {
                            PrintStream pStream = new PrintStream(new OutputStream(){

                                @Override
                                public void write(int b) throws IOException {
                                }
                            });
                            System.setOut(pStream);
                            System.setErr(pStream);
                        }
                    }
                    Config.setSSMode();
                    Config.unsetCodingGuide();
                    Config.setDtvMode();
                    Config.setQuietMode();
                    NodeUtil.setKeepComments(true);
                    Shell.params.opt_jQuery = false;
                    ArrayList<BugItem> bugList = new ArrayList<BugItem>();
                    return_code = SamsungDTVMain.analyze();
                    AnalysisResult resultSet = SamsungDTVMain.getAnalysisResult();
                    bugList.addAll(resultSet.getBugInfoList());
                    if (Shell.params.opt_JSAPluginMode) {
                        System.setOut(stream);
                        String targetDirStr = Shell.params.opt_Dir;
                        if (!Shell.params.opt_Dir.endsWith(File.separator)) {
                            targetDirStr = targetDirStr + File.separator;
                        }
                        String targetDir = new File(targetDirStr).getCanonicalPath();
                        for (BugItem item : bugList) {
                            StringBuilder sb = new StringBuilder();
                            File fPath = new File(item.filePath);
                            File canonicalFPath = new File(fPath.getCanonicalPath());
                            sb.append(new File(targetDir).toURI().relativize(canonicalFPath.toURI()).getPath());
                            sb.append(":" + item.lineNumber);
                            sb.append(":" + item.columnNumber);
                            if (item.bugLevel == 8) {
                                sb.append(" E ");
                            } else if (item.bugLevel == 9) {
                                sb.append(" W ");
                            } else {
                                sb.append(" " + item.bugLevel + " ");
                            }
                            sb.append(item.message);
                            System.out.println(sb.toString());
                        }
                    }
                    break;
                }
                case 6: {
                    return_code = URLMain.url();
                    break;
                }
                case 100: {
                    Pair<Program, List<BugInfo>> pair = Parser.fileToASTCheck(Shell.params.opt_JS);
                    Program program = pair.first();
                    System.out.println(" >>> " + Shell.params.opt_JS.get(0));
                    System.out.println("----------------------------------------------------");
                    ASTCodingChecker.doitForDev(program);
                    System.out.println("----------------------------------------------------");
                    System.out.print(VoltAPIExtractor.doitInternal(program));
                    System.out.println("----------------------------------------------------");
                    break;
                }
                case 101: {
                    System.out.println("\n* Count lines of code result *");
                    JsClocResultExport cloc = new JsClocResultExport();
                    cloc.printOutClocResult(Shell.params.opt_JS);
                    break;
                }
                case 96: 
                case 97: {
                    NodeUtil.setKeepComments(true);
                    return_code = SamsungWebappConvertMain.convert();
                    break;
                }
                case 99: {
                    Shell.printHelpMessage();
                }
            }
        }
        catch (ParserError e) {
            System.err.println(e);
            return_code = -1;
        }
        catch (StaticError e) {
            System.err.println(e);
            return_code = -1;
        }
        catch (UserError e) {
            System.err.println(e);
            return_code = -1;
        }
        if (printTimeTitle != null) {
            System.out.println(printTimeTitle + " took " + (System.currentTimeMillis() - startTime) + "ms.");
        }
        return return_code;
    }

    private static void printUsageMessage() {
        System.err.print("Usage:\n ss-analysis {-js somefile.js ... | -dir somedir} -widldb api1.db ... [-tsdb lib1.db ...]\n");
    }

    private static void printHelpMessage() {
        System.err.print("");
    }

    public static Option<IRRoot> scriptToIR(List<Triple<String, Integer, String>> scripts, Option<String> out) throws UserError, IOException {
        return Shell.scriptToIR(scripts, out, (Option<StaticConcolicInterface>)Option.none());
    }

    public static Option<IRRoot> scriptToIR(List<Triple<String, Integer, String>> scripts, Option<String> out, Option<StaticConcolicInterface> staticConcolic) throws UserError, IOException {
        Pair<Program, List<BugInfo>> pair = Parser.scriptToASTCheck(scripts);
        return Shell.ASTtoIR(scripts.get(0).first(), pair.first(), pair.second(), out, staticConcolic).first();
    }

    public static Option<IRRoot> fileToIR(List<String> files, Option<String> out) throws UserError, IOException {
        return Shell.fileToIR(files, out, (Option<StaticConcolicInterface>)Option.none());
    }

    public static Option<IRRoot> fileToIR(List<String> files, Option<String> out, Option<StaticConcolicInterface> staticConcolic) throws UserError, IOException {
        Program program;
        ArrayList<BugInfo> parsingErrors = new ArrayList();
        if (files.size() == 1 && (files.get(0).toLowerCase().endsWith(".html") || files.get(0).toLowerCase().endsWith(".xhtml") || files.get(0).toLowerCase().endsWith(".htm"))) {
            Config.setDomMode();
            JSFromHTML jshtml = new JSFromHTML(files.get(0));
            program = jshtml.parseScripts();
        } else if (Shell.params.command == 98) {
            Config.setDomMode();
            Pair<Program, List<BugInfo>> pair = Parser.fileToASTCheck(files);
            program = pair.first();
            parsingErrors = pair.second();
        } else {
            Pair<Program, List<BugInfo>> pair = Parser.fileToASTCheck(files);
            program = pair.first();
            parsingErrors = pair.second();
        }
        return Shell.ASTtoIR(files.get(0), program, parsingErrors, out, staticConcolic).first();
    }

    public static Triple<Option<IRRoot>, List<BugInfo>, Program> ASTtoIR(String file, Program pgm, Option<String> out, Option<StaticConcolicInterface> staticConcolic) throws UserError, IOException {
        return Shell.ASTtoIR(file, pgm, new ArrayList<BugInfo>(), out, staticConcolic);
    }

    public static Triple<Option<IRRoot>, List<BugInfo>, Program> ASTtoIR(String file, Program pgm, List<BugInfo> parsingErrors, Option<String> out, Option<StaticConcolicInterface> staticConcolic) throws UserError, IOException {
        try {
            Program program = pgm;
            List<BugInfo> frontEndErrors = parsingErrors;
            if (Shell.params.opt_Module) {
                ModuleRewriter moduleRewriter = new ModuleRewriter(program);
                program = moduleRewriter.doit();
            }
            Hoister hoister = new Hoister(program);
            program = hoister.doit();
            frontEndErrors.addAll(hoister.getErrors());
            Disambiguator disambiguator = new Disambiguator(program, opt_DisambiguateOnly);
            program = disambiguator.doit();
            List<StaticError> errors = disambiguator.getErrors();
            frontEndErrors.addAll(disambiguator.getBugDetectorErrors());
            switch (Shell.params.command) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 23: {
                    StrictModeChecker.clear();
                    StrictModeChecker.checkSimple(program);
                }
            }
            if (opt_DisambiguateOnly) {
                if (out.isSome()) {
                    String outfile = (String)out.unwrap();
                    try {
                        Pair<FileWriter, BufferedWriter> pair = Useful.filenameToBufferedWriter(outfile);
                        FileWriter fw = pair.first();
                        BufferedWriter writer = pair.second();
                        writer.write(JSAstToConcrete.doitInternal(program));
                        writer.close();
                        fw.close();
                    }
                    catch (IOException e) {
                        throw new IOException("IOException " + e + "while writing " + outfile);
                    }
                } else if (errors.isEmpty()) {
                    System.out.println(JSAstToConcrete.doit(program));
                }
                Shell.reportErrors(NodeUtil.getFileName(program), Shell.flattenErrors(errors), (Option<Pair<FileWriter, BufferedWriter>>)Option.none());
                if (opt_DisambiguateOnly && errors.isEmpty()) {
                    return new Triple<Option<IRRoot>, List<BugInfo>, Program>(Option.some((Object)IRFactory.makeRoot()), Useful.list(), program);
                }
                return new Triple<Option<IRRoot>, List<BugInfo>, Program>(Option.none(), Useful.list(), program);
            }
            WithRewriter withRewriter = new WithRewriter(program, false);
            program = withRewriter.doit();
            errors.addAll(withRewriter.getErrors());
            Translator translator = new Translator(program, staticConcolic);
            IRRoot ir = translator.doit();
            errors.addAll(translator.getErrors());
            if (errors.isEmpty()) {
                return new Triple<Option<IRRoot>, List<BugInfo>, Program>(Option.some((Object)ir), frontEndErrors, program);
            }
            Shell.reportErrors(NodeUtil.getFileName(program), Shell.flattenErrors(errors), (Option<Pair<FileWriter, BufferedWriter>>)Option.none());
            return new Triple<Option<IRRoot>, List<BugInfo>, Program>(Shell.params.opt_IgnoreErrorOnAST ? Option.some((Object)ir) : Option.none(), Useful.list(), program);
        }
        catch (FileNotFoundException f) {
            throw new UserError(file + " not found");
        }
    }

    public static List<? extends StaticError> flattenErrors(Iterable<? extends StaticError> ex) {
        LinkedList<? extends StaticError> result = new LinkedList<StaticError>();
        for (StaticError staticError : ex) {
            result.addAll(Shell.flattenErrors(staticError));
        }
        return result;
    }

    public static List<? extends StaticError> flattenErrors(StaticError ex) {
        LinkedList<? extends StaticError> result = new LinkedList<StaticError>();
        if (ex instanceof MultipleStaticError) {
            for (StaticError err : ((MultipleStaticError)ex).toJList()) {
                result.addAll(Shell.flattenErrors(err));
            }
        } else {
            result.add(new WrappedException(ex));
        }
        return result;
    }

    public static int reportErrors(String file_name, List<? extends StaticError> errors, Option<Pair<FileWriter, BufferedWriter>> pair) throws IOException {
        int return_code = 0;
        if (!IterUtil.isEmpty(errors)) {
            for (StaticError error : IterUtil.sort(errors)) {
                if (pair.isSome()) {
                    ((BufferedWriter)((Pair)pair.unwrap()).second()).write(error.getMessage());
                    continue;
                }
                System.out.println(error.getMessage());
            }
            int num_errors = IterUtil.sizeOf(errors);
            String err_string = num_errors == 0 ? "File " + file_name + " compiled successfully." : "File " + file_name + " has " + num_errors + " error" + (num_errors == 1 ? "." : "s.");
            if (pair.isSome()) {
                ((BufferedWriter)((Pair)pair.unwrap()).second()).write(err_string);
            } else {
                System.out.println(err_string);
            }
            return_code = -2;
        }
        if (pair.isSome()) {
            ((BufferedWriter)((Pair)pair.unwrap()).second()).close();
            ((FileWriter)((Pair)pair.unwrap()).first()).close();
        }
        return return_code;
    }

    public static Option<String> toOption(String str) {
        if (str == null) {
            return Option.none();
        }
        return Option.some((Object)str);
    }

    public static long getStartTime() {
        return startTime;
    }

    public static void setIsTimeout() {
        isTimeout = true;
    }

    public static boolean getIsTimeout() {
        return isTimeout;
    }

    public static void setIsSpaceout() {
        isSpaceout = true;
    }

    public static boolean getIsSpaceout() {
        return isSpaceout;
    }

    static {
        workManager = new WorkManager();
    }
}

