/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import kr.ac.kaist.jsaf.nodes.ASTSpanInfo;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.Literal;
import kr.ac.kaist.jsaf.nodes.NodeVisitor;
import kr.ac.kaist.jsaf.nodes.NodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class StringLiteral
extends Literal {
    private final String _quote;
    private final String _escaped;

    public StringLiteral(ASTSpanInfo in_info, String in_quote, String in_escaped) {
        super(in_info);
        if (in_quote == null) {
            throw new IllegalArgumentException("Parameter 'quote' to the StringLiteral constructor was null");
        }
        this._quote = in_quote.intern();
        if (in_escaped == null) {
            throw new IllegalArgumentException("Parameter 'escaped' to the StringLiteral constructor was null");
        }
        this._escaped = in_escaped.intern();
    }

    public final String getQuote() {
        return this._quote;
    }

    public final String getEscaped() {
        return this._escaped;
    }

    @Override
    public <RetType> RetType accept(AbstractNodeVisitor<RetType> visitor) {
        return visitor.forStringLiteral(this);
    }

    @Override
    public <RetType> RetType accept(NodeVisitor<RetType> visitor) {
        return visitor.forStringLiteral(this);
    }

    @Override
    public void accept(AbstractNodeVisitor_void visitor) {
        visitor.forStringLiteral(this);
    }

    @Override
    public void accept(NodeVisitor_void visitor) {
        visitor.forStringLiteral(this);
    }

    public boolean equals(Object obj) {
        String casted_escaped;
        String casted_quote;
        ASTSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        StringLiteral casted = (StringLiteral)obj;
        ASTSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        String temp_quote = this.getQuote();
        if (temp_quote != (casted_quote = casted.getQuote())) {
            return false;
        }
        String temp_escaped = this.getEscaped();
        return temp_escaped == (casted_escaped = casted.getEscaped());
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        ASTSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        String temp_quote = this.getQuote();
        code ^= temp_quote.hashCode();
        String temp_escaped = this.getEscaped();
        return code ^= temp_escaped.hashCode();
    }

    protected StringLiteral() {
        this._quote = null;
        this._escaped = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "StringLiteral", 3)) {
            String temp_escaped;
            String temp_quote;
            ASTSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("quote", temp_quote = this.getQuote())) {
                w.visitString(temp_quote);
                w.endNodeField("quote", temp_quote);
            }
            if (w.visitNodeField("escaped", temp_escaped = this.getEscaped())) {
                w.visitString(temp_escaped);
                w.endNodeField("escaped", temp_escaped);
            }
            w.endNode(this, "StringLiteral", 3);
        }
    }
}

