#/bin/bash

######################################################################################
#
#    JSA 1.0.2 : JavaScript Analyzer
#      - Wiget Validator 
#
#    Software Center, SQE Lab : kwangwon.sun@samsung.com, inho0212.lim@samsung.com
#
######################################################################################

setJavaExecPath(){
    # jdk directory exixts
    if [ ! -d "$JDK_PATH" ]; then 
        JAVA_EXEC="java"
    else
        UNAME=$(uname)
        case "$UNAME" in
        Linux)
                JAVA_EXEC="$JDK_PATH/bin/java"
            ;;
        Darwin)
                JAVA_EXEC="$JDK_PATH/Contents/Home/bin/java"
            ;;
        esac
    fi
}

#set JAVA_EXEC : relative path to embedded jdk
# Root path of JSA tools
# "/home/jsa/RuleChecker"
TIZEN_INSTALL_PATH=$1
JDK_PATH="${TIZEN_INSTALL_PATH}/jdk"

setJavaExecPath
export JSA_HOME="${TIZEN_INSTALL_PATH}/tools/web-widget-validator"

#java -Xss32m -Xmx512m -cp ${JSA_HOME}/jsa-engine-1.1.jar:${JSA_HOME}/lib/*:. kr.ac.kaist.jsaf.Shell ss-wcv-analysis "$@" -nostop -tizen -wcv -jsa-plugin -context-5-callsite -context-loop -locclone -forin-unroll 1

"$JAVA_EXEC" -Xss32m -Xmx512m -cp ${JSA_HOME}/jsa-wcv-engine-1.1.jar:${JSA_HOME}/lib/*:. kr.ac.kaist.jsaf.Shell ss-wcv-analysis -dir "$2" -nostop -tizen -wcv -jsa-plugin

