/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.DelegatingList;
import edu.rice.cs.plt.lambda.CachedThunk;
import edu.rice.cs.plt.lambda.Thunk;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotSynchronizedList<E>
extends DelegatingList<E> {
    private final Object _lock;
    private final CachedThunk<List<E>> _copy;

    public SnapshotSynchronizedList(List<E> delegate) {
        this(Collections.synchronizedList(delegate), null);
    }

    private SnapshotSynchronizedList(List<E> synchronizedDelegate, Object lock) {
        super(synchronizedDelegate);
        this._lock = lock == null ? synchronizedDelegate : lock;
        this._copy = CachedThunk.make(new Thunk<List<E>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<E> value() {
                Object object = SnapshotSynchronizedList.this._lock;
                synchronized (object) {
                    return new ArrayList(SnapshotSynchronizedList.this._delegate);
                }
            }
        });
    }

    public void discardSnapshot() {
        this._copy.reset();
    }

    private boolean reset(boolean changed) {
        if (changed) {
            this.discardSnapshot();
        }
        return changed;
    }

    @Override
    public Iterator<E> iterator() {
        return this._copy.value().iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this._copy.value().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this._copy.value().listIterator(index);
    }

    @Override
    public boolean add(E o) {
        return this.reset(this._delegate.add(o));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.reset(this._delegate.addAll(c));
    }

    @Override
    public void clear() {
        this._delegate.clear();
        this.discardSnapshot();
    }

    @Override
    public boolean remove(Object o) {
        return this.reset(this._delegate.remove(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.reset(this._delegate.removeAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.reset(this._delegate.retainAll(c));
    }

    @Override
    public void add(int index, E element) {
        this._delegate.add(index, element);
        this.discardSnapshot();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.reset(this._delegate.addAll(index, c));
    }

    @Override
    public E set(int index, E element) {
        E result = this._delegate.set(index, element);
        this.discardSnapshot();
        return result;
    }

    @Override
    public E remove(int index) {
        Object result = this._delegate.remove(index);
        this.discardSnapshot();
        return result;
    }

    @Override
    public List<E> subList(int from, int to) {
        return new SnapshotSynchronizedList<E>(this._delegate.subList(from, to), this._lock){

            @Override
            public void discardSnapshot() {
                SnapshotSynchronizedList.this.discardSnapshot();
                super.discardSnapshot();
            }
        };
    }

    public static <T> Thunk<List<T>> factory(Thunk<? extends List<T>> delegateFactory) {
        return new Factory(delegateFactory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory<T>
    implements Thunk<List<T>>,
    Serializable {
        private final Thunk<? extends List<T>> _delegateFactory;

        private Factory(Thunk<? extends List<T>> delegateFactory) {
            this._delegateFactory = delegateFactory;
        }

        @Override
        public List<T> value() {
            return new SnapshotSynchronizedList<T>(this._delegateFactory.value());
        }
    }
}

