/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.EmptyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathClassLoader
extends ClassLoader {
    private final Iterable<? extends File> _path;
    private URLClassLoader _urlLoader;
    private Iterable<File> _urlLoaderPath;

    public static URL getResourceInPath(String name, File ... path) {
        return PathClassLoader.getResourceInPath(name, IterUtil.asIterable(path));
    }

    public static URL getResourceInPath(String name, Iterable<File> path) {
        return new PathClassLoader((ClassLoader)EmptyClassLoader.INSTANCE, path).getResource(name);
    }

    public static InputStream getResourceInPathAsStream(String name, File ... path) {
        return PathClassLoader.getResourceInPathAsStream(name, IterUtil.asIterable(path));
    }

    public static InputStream getResourceInPathAsStream(String name, Iterable<File> path) {
        return new PathClassLoader((ClassLoader)EmptyClassLoader.INSTANCE, path).getResourceAsStream(name);
    }

    public PathClassLoader(File ... path) {
        this(IterUtil.asIterable(path));
    }

    public PathClassLoader(Iterable<? extends File> path) {
        this._path = path;
        this.updateURLLoader();
    }

    public PathClassLoader(ClassLoader parent, File ... path) {
        this(parent, IterUtil.asIterable(path));
    }

    public PathClassLoader(ClassLoader parent, Iterable<? extends File> path) {
        super(parent);
        this._path = path;
        this.updateURLLoader();
    }

    private void updateURLLoader() {
        this._urlLoaderPath = IterUtil.snapshot(this._path);
        LinkedList<URL> urls = new LinkedList<URL>();
        for (File f : this._urlLoaderPath) {
            try {
                urls.add(f.toURI().toURL());
            }
            catch (IllegalArgumentException e) {
                DebugUtil.error.log(e);
            }
            catch (MalformedURLException e) {
                DebugUtil.error.log(e);
            }
        }
        this._urlLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)EmptyClassLoader.INSTANCE);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        URL resource = this.findResource(name.replace('.', '/') + ".class");
        if (resource == null) {
            throw new ClassNotFoundException();
        }
        try {
            byte[] bytes = IOUtil.toByteArray(resource.openStream());
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException();
        }
    }

    @Override
    protected URL findResource(String name) {
        if (!IterUtil.isEqual(this._path, this._urlLoaderPath)) {
            this.updateURLLoader();
        }
        return this._urlLoader.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (!IterUtil.isEqual(this._path, this._urlLoaderPath)) {
            this.updateURLLoader();
        }
        return this._urlLoader.findResources(name);
    }
}

