/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.bug_detector;

import java.util.ArrayList;
import kr.ac.kaist.jsaf.nodes_util.Span;

public class CheckPoint {
    private String fileName;
    private int lineNum;
    private int indent;
    private ArrayList<String> ruleList;
    private ArrayList<Span> commentList;
    private String ruleArrStr;
    private Span span;

    public CheckPoint() {
    }

    public CheckPoint(Span spanInfo, String aFileName, int aLine, int aIndent, String ruleStr) {
        String[] ruleArr;
        this.fileName = aFileName;
        this.lineNum = aLine;
        this.indent = aIndent - 1;
        this.ruleList = new ArrayList();
        this.commentList = new ArrayList();
        this.ruleArrStr = ruleStr;
        this.span = spanInfo;
        for (String rule : ruleArr = ruleStr.split(",")) {
            this.ruleList.add(rule);
        }
    }

    public void addRule(String rule) {
        this.ruleList.add(rule);
    }

    public void addComment(Span span) {
        this.commentList.add(span);
    }

    public Span getSpan() {
        return this.span;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public boolean containsRule(String rule) {
        return this.ruleList.contains(rule);
    }

    public void setIndent(int num) {
        this.indent = num;
    }

    public int getIndent() {
        return this.indent;
    }

    public ArrayList<String> getRuleList() {
        return this.ruleList;
    }

    public ArrayList<Span> getCommentList() {
        return this.commentList;
    }

    public void sumRuleList(ArrayList<String> ruleSet) {
        for (String rule : ruleSet) {
            if (this.ruleList.contains(rule)) continue;
            this.ruleList.add(rule);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fileName + ":" + this.lineNum + " (" + this.indent + ") ");
        for (String str : this.ruleList) {
            sb.append(str + ", ");
        }
        return sb.toString();
    }
}

