/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRPVal;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRNumber
extends IRPVal {
    private final String _text;
    private final Double _num;

    public IRNumber(IRSpanInfo in_info, String in_text, Double in_num) {
        super(in_info);
        if (in_text == null) {
            throw new IllegalArgumentException("Parameter 'text' to the IRNumber constructor was null");
        }
        this._text = in_text;
        if (in_num == null) {
            throw new IllegalArgumentException("Parameter 'num' to the IRNumber constructor was null");
        }
        this._num = in_num;
    }

    public final String getText() {
        return this._text;
    }

    public final Double getNum() {
        return this._num;
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRNumber(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRNumber(this);
    }

    public boolean equals(Object obj) {
        Double casted_num;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRNumber casted = (IRNumber)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        Double temp_num = this.getNum();
        return temp_num == (casted_num = casted.getNum()) || temp_num.equals(casted_num);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        Double temp_num = this.getNum();
        return code ^= temp_num.hashCode();
    }

    protected IRNumber() {
        this._text = null;
        this._num = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRNumber", 3)) {
            Double temp_num;
            String temp_text;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("text", temp_text = this.getText())) {
                w.visitString(temp_text);
                w.endNodeField("text", temp_text);
            }
            if (w.visitNodeField("num", temp_num = this.getNum())) {
                w.visitUnknownObject(temp_num);
                w.endNodeField("num", temp_num);
            }
            w.endNode(this, "IRNumber", 3);
        }
    }
}

