/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import kr.ac.kaist.jsaf.nodes_util.CharVector;
import kr.ac.kaist.jsaf.nodes_util.SourceLoc;
import kr.ac.kaist.jsaf.nodes_util.Unprinter;
import kr.ac.kaist.jsaf.useful.HasAt;
import kr.ac.kaist.jsaf.useful.NI;

public class Span
implements Serializable,
HasAt {
    public SourceLoc begin;
    public SourceLoc end;
    public CharVector cvec;

    public int hashCode() {
        return this.begin.hashCode() * 898956301 + this.end.hashCode() * 727519901;
    }

    public boolean equals(Object o) {
        if (o instanceof Span) {
            Span sp2 = (Span)o;
            return this.begin.equals(sp2.begin) && this.end.equals(sp2.end);
        }
        return false;
    }

    public Span(SourceLoc b, SourceLoc e) {
        this.begin = b;
        this.end = e;
        this.cvec = new CharVector();
    }

    public Span addLines(int line) {
        return new Span(this.begin.addLines(line), this.end.addLines(line));
    }

    public static boolean beginsEarlierThan(Span a, Span b) {
        return a.getBegin().getLine() < b.getBegin().getLine() || a.getBegin().getLine() == b.getBegin().getLine() && a.getBegin().column() < b.getBegin().column();
    }

    public static boolean endsLaterThan(Span a, Span b) {
        return a.getEnd().getLine() > b.getEnd().getLine() || a.getEnd().getLine() == b.getEnd().getLine() && a.getEnd().column() > b.getEnd().column();
    }

    public Span(Span a, Span b) {
        this.begin = Span.beginsEarlierThan(a, b) ? a.getBegin() : b.getBegin();
        this.end = Span.endsLaterThan(a, b) ? a.getEnd() : b.getEnd();
        this.cvec = a.getCharVector();
        this.cvec.merge(b.getCharVector().getVector());
    }

    public String getFileName() {
        return this.begin.getFileName();
    }

    public String getFileNameOnly() {
        return this.begin.getFileNameOnly();
    }

    public String convertNameSeparatorToSlash(String fileName) {
        if (File.separatorChar == '/') {
            return fileName;
        }
        return fileName.replace(File.separatorChar, '/');
    }

    public SourceLoc getBegin() {
        return this.begin;
    }

    public SourceLoc getEnd() {
        return this.end;
    }

    public CharVector getCharVector() {
        return this.cvec;
    }

    public String toString() {
        try {
            return this.appendTo(new StringBuilder(), true).toString();
        }
        catch (IOException ex) {
            return (String)NI.np();
        }
    }

    public String toStringFileNameOnly() {
        try {
            String fileName = this.appendTo(new StringBuilder(), true).toString();
            fileName = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1);
            return fileName;
        }
        catch (IOException ex) {
            return (String)NI.np();
        }
    }

    public String toStringWithoutFiles() {
        try {
            return this.appendTo(new StringBuilder(), false).toString();
        }
        catch (IOException ex) {
            return (String)NI.np();
        }
    }

    @Override
    public String at() {
        return this.toString();
    }

    @Override
    public String stringName() {
        return "";
    }

    public Appendable appendTo(Appendable w, boolean do_files) throws IOException {
        return this.appendTo(w, do_files, false);
    }

    public Appendable appendTo(Appendable w, boolean do_files, boolean printer) throws IOException {
        int left_col = this.begin.column();
        int right_col = this.end.column();
        boolean file_names_differ = !this.begin.getFileName().equals(this.end.getFileName());
        do_files |= file_names_differ;
        if (printer) {
            w.append(" @");
        }
        if (do_files) {
            if (printer) {
                w.append("\"");
            }
            String beginFileName = printer ? this.convertNameSeparatorToSlash(Unprinter.enQuote(this.begin.getFileName())) : this.convertNameSeparatorToSlash(this.begin.getFileName());
            w.append(beginFileName);
            if (printer) {
                w.append("\"");
            }
            w.append(":");
        }
        w.append(String.valueOf(this.begin.getLine()));
        w.append(":");
        w.append(String.valueOf(left_col));
        if (file_names_differ || this.begin.getLine() != this.end.getLine() || left_col != right_col) {
            w.append(printer ? "~" : "-");
            if (file_names_differ) {
                if (printer) {
                    w.append("\"");
                }
                String endFileName = printer ? this.convertNameSeparatorToSlash(Unprinter.enQuote(this.end.getFileName())) : this.convertNameSeparatorToSlash(this.end.getFileName());
                w.append(endFileName);
                if (printer) {
                    w.append("\"");
                }
                w.append(":");
            }
            if (file_names_differ || this.begin.getLine() != this.end.getLine()) {
                w.append(String.valueOf(this.end.getLine()));
                w.append(":");
            }
            w.append(String.valueOf(right_col));
        }
        return w;
    }
}

