/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.shell;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintWriter;
import kr.ac.kaist.jsaf.ProjectProperties$;
import kr.ac.kaist.jsaf.Shell;
import kr.ac.kaist.jsaf.exceptions.UserError;
import kr.ac.kaist.jsaf.nodes_util.DynamicLoadUtil;
import kr.ac.kaist.jsaf.nodes_util.NodeUtil$;
import kr.ac.kaist.jsaf.scala_src.useful.Lists$;
import kr.ac.kaist.jsaf.useful.Files;
import kr.ac.kaist.jsaf.useful.Triple;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SamsungVoltMain$
implements ScalaObject {
    public static final SamsungVoltMain$ MODULE$;
    private final String SEP;
    private final String SafeTempDir;
    private List<Triple<String, Integer, String>> tripleList;
    private final List<String> SafeVoltModels;

    static {
        new SamsungVoltMain$();
    }

    public String SEP() {
        return this.SEP;
    }

    public String SafeTempDir() {
        return this.SafeTempDir;
    }

    public List<Triple<String, Integer, String>> tripleList() {
        return this.tripleList;
    }

    public void tripleList_$eq(List<Triple<String, Integer, String>> list) {
        this.tripleList = list;
    }

    public List<String> SafeVoltModels() {
        return this.SafeVoltModels;
    }

    public int preprocess() {
        this.checkSafeTempDir();
        System.out.println("\n* Preprocessing Volt JavaScript Files *");
        Shell.params.opt_JS = this.jsLibraryFilter();
        Lists$.MODULE$.toList(Shell.params.opt_JS).foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String path) {
                File newfile = new File(path);
                BufferedSource newsource = Source$.MODULE$.fromFile(newfile, "UTF-8");
                SamsungVoltMain$.MODULE$.tripleList_$eq((List<Triple<String, Integer, String>>)((List)SamsungVoltMain$.MODULE$.tripleList().$colon$plus(new Triple<String, Integer, String>(path, new Integer(1), newsource.mkString()), List$.MODULE$.canBuildFrom())));
            }
        });
        DynamicLoadUtil dynamicload = new DynamicLoadUtil();
        List<String> distributionModuleList$1 = dynamicload.getDistributedModuleFileNames(this.tripleList());
        int beforeCount = this.tripleList().size();
        this.tripleList_$eq((List<Triple<String, Integer, String>>)((List)this.tripleList().filter((Function1)new Serializable(distributionModuleList$1){
            public static final long serialVersionUID;
            private final List distributionModuleList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Triple<String, Integer, String> triple$1) {
                BooleanRef flag$1 = new BooleanRef(true);
                this.distributionModuleList$1.foreach((Function1)new Serializable(this, triple$1, flag$1){
                    public static final long serialVersionUID;
                    private final Triple triple$1;
                    private final BooleanRef flag$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(String fileNameonly) {
                        if (((String)this.triple$1.first()).contains(fileNameonly)) {
                            this.flag$1.elem = false;
                        }
                    }
                    {
                        this.triple$1 = triple;
                        this.flag$1 = booleanRef;
                    }
                });
                if (flag$1.elem) {
                    System.out.println(new StringBuilder().append((Object)"# \"").append((Object)triple$1.first()).append((Object)"\" : OK").toString());
                }
                return flag$1.elem;
            }
            {
                this.distributionModuleList$1 = list;
            }
        })));
        System.out.println(new StringBuilder().append((Object)"\n# Selected JavaScript Files : ").append((Object)BoxesRunTime.boxToInteger((int)this.tripleList().size())).toString());
        System.out.println("\n* Analysing JavaScript Modules *");
        List<String> modulesOrderList = dynamicload.getDynamicLoadedFileNames(this.tripleList());
        System.out.println(new StringBuilder().append((Object)"# Successfully analyzed modules : ").append((Object)BoxesRunTime.boxToInteger((int)modulesOrderList.length())).toString());
        if (modulesOrderList.length() == 0) {
            System.out.println("# Error : Can not find modules.");
            return -1;
        }
        this.writeIndexFile(modulesOrderList);
        this.rewriteJSFiles(modulesOrderList);
        this.copySafeModelFiles();
        return 0;
    }

    public void rewriteJSFiles(List<String> modules) {
        modules.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String module) {
                String destPath = SamsungVoltMain$.MODULE$.createFilePath(module);
                SamsungVoltMain$.MODULE$.modifyJSFile(new File(new StringBuilder().append((Object)Shell.params.opt_JS_base).append((Object)SamsungVoltMain$.MODULE$.SEP()).append((Object)module).toString()), destPath, module);
            }
        });
    }

    public String createFilePath(String modulePath) {
        ObjectRef temp$1 = new ObjectRef((Object)this.SafeTempDir());
        Predef$.MODULE$.refArrayOps((Object[])modulePath.split(File.separator)).foreach((Function1)new Serializable(temp$1){
            public static final long serialVersionUID;
            private final ObjectRef temp$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(String dir) {
                File dirFile;
                this.temp$1.elem = new StringBuilder().append((Object)((String)this.temp$1.elem)).append((Object)SamsungVoltMain$.MODULE$.SEP()).append((Object)dir).toString();
                return dir.contains(".js") ? BoxedUnit.UNIT : ((dirFile = new File((String)this.temp$1.elem)).exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)dirFile.mkdir()));
            }
            {
                this.temp$1 = objectRef;
            }
        });
        return (String)temp$1.elem;
    }

    public void copySafeModelFiles() {
        String base$1 = new StringBuilder().append((Object)ProjectProperties$.MODULE$.BASEDIR()).append((Object)this.SEP()).append((Object)"bin").append((Object)this.SEP()).append((Object)"models").append((Object)this.SEP()).append((Object)"volt").toString();
        this.SafeVoltModels().foreach((Function1)new Serializable(base$1){
            public static final long serialVersionUID;
            private final String base$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String file) {
                String modelPath = new StringBuilder().append((Object)this.base$1).append((Object)SamsungVoltMain$.MODULE$.SEP()).append((Object)file).toString();
                String destPath = new StringBuilder().append((Object)SamsungVoltMain$.MODULE$.SafeTempDir()).append((Object)SamsungVoltMain$.MODULE$.SEP()).append((Object)file).toString();
                Files.cp(modelPath, destPath);
            }
            {
                this.base$1 = string;
            }
        });
    }

    public void modifyJSFile(File file, String destPath, String moduleKey) {
        PrintWriter pw$1 = new PrintWriter(new File(destPath));
        BufferedSource source = Source$.MODULE$.fromFile(file, "UTF-8");
        source.getLines().foreach((Function1)new Serializable(pw$1){
            public static final long serialVersionUID;
            private final PrintWriter pw$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String line) {
                this.pw$1.write(line);
                this.pw$1.write("\n");
            }
            {
                this.pw$1 = printWriter;
            }
        });
        if (moduleKey.equals("distribution.min.js")) {
            pw$1.write(new StringBuilder().append((Object)"SAFE_Modules['").append((Object)moduleKey).append((Object)"'] = {};").toString());
        } else {
            pw$1.write(new StringBuilder().append((Object)"SAFE_Modules['").append((Object)moduleKey).append((Object)"'] = exports;").toString());
        }
        source.close();
        pw$1.close();
    }

    public void writeIndexFile(List<String> modules$1) {
        String base = new StringBuilder().append((Object)ProjectProperties$.MODULE$.BASEDIR()).append((Object)this.SEP()).toString();
        String emptyHtml = new StringBuilder().append((Object)base).append((Object)"bin").append((Object)this.SEP()).append((Object)"models").append((Object)this.SEP()).append((Object)"empty_index.html").toString();
        File html = new File(emptyHtml);
        String htmlPath = html.getParent();
        Document htmlDoc$1 = this.loadDocument(html.getAbsolutePath());
        NodeList headElements = htmlDoc$1.getElementsByTagName("head");
        if (headElements.getLength() != 0) {
            Node head$1 = headElements.item(0);
            Predef$.MODULE$.intWrapper(0).to(this.SafeVoltModels().length() - 1).foreach((Function1)new Serializable(htmlDoc$1, head$1){
                public static final long serialVersionUID;
                private final Document htmlDoc$1;
                private final Node head$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Node apply(int idx) {
                    String model = Lists$.MODULE$.toJavaList(SamsungVoltMain$.MODULE$.SafeVoltModels()).get(idx);
                    Element scriptElem = this.htmlDoc$1.createElement("script");
                    scriptElem.setAttribute("src", model);
                    return this.head$1.appendChild(scriptElem);
                }
                {
                    this.htmlDoc$1 = document;
                    this.head$1 = node;
                }
            });
            Predef$.MODULE$.intWrapper(modules$1.length() - 1).to(0).by(-1).foreach((Function1)new Serializable(modules$1, htmlDoc$1, head$1){
                public static final long serialVersionUID;
                private final List modules$1;
                private final Document htmlDoc$1;
                private final Node head$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Node apply(int idx) {
                    String module = (String)Lists$.MODULE$.toJavaList(this.modules$1).get(idx);
                    Element scriptElem = this.htmlDoc$1.createElement("script");
                    scriptElem.setAttribute("src", module);
                    return this.head$1.appendChild(scriptElem);
                }
                {
                    this.modules$1 = list;
                    this.htmlDoc$1 = document;
                    this.head$1 = node;
                }
            });
        } else {
            System.out.println("Error > writeIndexFile()");
        }
        this.writeToFile(htmlDoc$1, new StringBuilder().append((Object)this.SafeTempDir()).append((Object)this.SEP()).append((Object)"index.html").toString());
    }

    public Document loadDocument(String fileName) {
        DOMParser domParser = new DOMParser();
        try {
            domParser.parse(fileName);
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UserError(new StringBuilder().append((Object)"File ").append((Object)fileNotFoundException).append((Object)" is not found.").toString());
        }
        return domParser.getDocument();
    }

    public void writeToFile(Document htmlDoc, String fileName) {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("XML 3.0 LS 3.0"));
        LSSerializer serializer = impl.createLSSerializer();
        String str = serializer.writeToString(htmlDoc);
        String retStr = this.NormalizeDOM(str);
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
        bw.write(retStr);
        bw.close();
    }

    public String NormalizeDOM(String domstr) {
        List NoEndTag$1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AREA", "BASE", "BASEFONT", "BR", "COL", "FRAME", "HR", "IMG", "INPUT", "LINK", "META", "PARAM"}));
        char[] charArray$1 = domstr.toCharArray();
        IntRef state$1 = new IntRef(0);
        ObjectRef namesb$1 = new ObjectRef(null);
        StringBuilder ret$1 = new StringBuilder();
        int len = domstr.length() - 1;
        Predef$.MODULE$.intWrapper(0).to(len).foreach((Function1)new Serializable(NoEndTag$1, charArray$1, state$1, namesb$1, ret$1){
            public static final long serialVersionUID;
            private final List NoEndTag$1;
            private final char[] charArray$1;
            private final IntRef state$1;
            private final ObjectRef namesb$1;
            private final StringBuilder ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(int i) {
                char c = this.charArray$1[i];
                int n = this.state$1.elem;
                switch (n) {
                    default: {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    case 0: {
                        if (c == '<') {
                            this.state$1.elem = this.charArray$1[i + 1] == '/' ? 3 : 1;
                            this.namesb$1.elem = new StringBuilder();
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    case 2: {
                        if (c == '>') {
                            BoxedUnit boxedUnit;
                            if (this.charArray$1[i - 1] == '/') {
                                String name = ((StringBuilder)this.namesb$1.elem).toString();
                                if (this.NoEndTag$1.contains((Object)name)) {
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.ret$1.setLength(this.ret$1.length() - 1);
                                    this.ret$1.append('>');
                                    this.ret$1.append("</");
                                    boxedUnit = this.ret$1.append(name);
                                }
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            this.state$1.elem = 0;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    case 1: {
                        BoxedUnit boxedUnit;
                        if (Character.isWhitespace(c) || c == '/') {
                            this.state$1.elem = 2;
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        if (c == '>') {
                            this.state$1.elem = 0;
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        boxedUnit = ((StringBuilder)this.namesb$1.elem).append(c);
                        break;
                    }
                    case 3: {
                        if (c == '>') {
                            this.state$1.elem = 0;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                return this.ret$1.append(c);
            }
            {
                this.NoEndTag$1 = list;
                this.charArray$1 = cArray;
                this.state$1 = intRef;
                this.namesb$1 = objectRef;
                this.ret$1 = stringBuilder;
            }
        });
        String reStr = ret$1.toString().replace("<?xml version=\"1.0\" encoding=\"UTF-16\"?>", "<!DOCTYPE html>");
        return reStr.replace("</SCRIPT>", "</SCRIPT>\n");
    }

    public java.util.List<String> jsLibraryFilter() {
        List filelist = (List)Lists$.MODULE$.toList(Shell.params.opt_JS).foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<String> apply(List<String> list, String filePath) {
                List list2;
                String jsName = NodeUtil$.MODULE$.getRelativeJsPath(Shell.params.opt_JS_base, filePath);
                if (NodeUtil$.MODULE$.isjQueryLibraryModel(jsName) || NodeUtil$.MODULE$.isJSLibraryModel(jsName)) {
                    System.out.println(new StringBuilder().append((Object)"# \"").append((Object)jsName).append((Object)"\" : JS library were excluded").toString());
                    list2 = list;
                } else if (NodeUtil$.MODULE$.isExcludedJsFiles(jsName)) {
                    System.out.println(new StringBuilder().append((Object)"# \"").append((Object)jsName).append((Object)"\" : Excluded by user options").toString());
                    list2 = list;
                } else {
                    list2 = (List)list.$colon$plus((Object)filePath, List$.MODULE$.canBuildFrom());
                }
                return list2;
            }
        });
        return Lists$.MODULE$.toJavaList(filelist);
    }

    public void checkSafeTempDir() {
        File safeDir = new File(this.SafeTempDir());
        Object object = safeDir.exists() ? BoxesRunTime.boxToBoolean((boolean)this.deleteDir$1(safeDir)) : BoxedUnit.UNIT;
        safeDir.mkdir();
    }

    public List<String> getSafeVoltModels() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SAFE_Model_Volt.js", "SAFE_Model_require.js", "SAFE_Model_voltapi.js", "SAFE_Model_Widget.js", "SAFE_Model_Vconf.js", "SAFE_Model_SystemInfo.js", "SAFE_Model_Animation.js", "SAFE_Model_ImageWidget.js", "SAFE_Model_VideoWidget.js", "SAFE_Model_AUL.js", "SAFE_Model_LayoutWidgets.js", "SAFE_Model_scene.js", "SAFE_Model_TextWidget.js", "SAFE_Model_Image.js", "SAFE_Model_NinePatchWidget.js", "SAFE_Model_SEF.js", "SAFE_Model_HALOUtil.js", "SAFE_Model_VDUtil.js", "SAFE_Model_Action.js", "SAFE_Model_AsyncTask.js", "SAFE_Model_BinLayout.js", "SAFE_Model_BoxLayout.js", "SAFE_Model_Button.js", "SAFE_Model_CategoryTab.js", "SAFE_Model_CompositeImage.js", "SAFE_Model_DataList.js", "SAFE_Model_Device.js", "SAFE_Model_DimWindow.js", "SAFE_Model_Event.js", "SAFE_Model_EventManager.js", "SAFE_Model_FixedLayout.js", "SAFE_Model_FlowLayout.js", "SAFE_Model_GridLayout.js", "SAFE_Model_GridList.js", "SAFE_Model_InputBox.js", "SAFE_Model_LayoutManager.js", "SAFE_Model_Listener.js", "SAFE_Model_LoadingControl.js", "SAFE_Model_MessageBox.js", "SAFE_Model_MultiObjectTransition.js", "SAFE_Model_PageControl.js", "SAFE_Model_PinBox.js", "SAFE_Model_PinPopup.js", "SAFE_Model_PopupRating.js", "SAFE_Model_Progress.js", "SAFE_Model_RichText.js", "SAFE_Model_SafBackground.js", "SAFE_Model_SafButton.js", "SAFE_Model_SafCategoryTab.js", "SAFE_Model_SafCheckBox.js", "SAFE_Model_SafInputBox.js", "SAFE_Model_SafLoading.js", "SAFE_Model_SafMessageBox.js", "SAFE_Model_SafPinPopup.js", "SAFE_Model_SafProgress.js", "SAFE_Model_SafRatingPopup.js", "SAFE_Model_SafScroll.js", "SAFE_Model_SafSubList.js", "SAFE_Model_SafTooltip.js", "SAFE_Model_Scroll.js", "SAFE_Model_SelectButton.js", "SAFE_Model_SingleLineListControl.js", "SAFE_Model_SubList.js", "SAFE_Model_ThreadPool.js", "SAFE_Model_Thumbnail.js", "SAFE_Model_Tooltip.js", "SAFE_Model_VideoActor.js"}));
    }

    public final boolean deleteDir$1(File path) {
        if (path.exists()) {
            Predef$.MODULE$.refArrayOps((Object[])path.listFiles()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File file) {
                    return file.isDirectory() ? SamsungVoltMain$.MODULE$.deleteDir$1(file) : file.delete();
                }
            });
            return path.delete();
        }
        return false;
    }

    private SamsungVoltMain$() {
        MODULE$ = this;
        this.SEP = File.separator;
        this.SafeTempDir = new StringBuilder().append((Object)Shell.params.opt_JS_base).append((Object)this.SEP()).append((Object)".safeTemp").toString();
        this.tripleList = Nil$.MODULE$;
        this.SafeVoltModels = this.getSafeVoltModels();
    }
}

