/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.shell;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kr.ac.kaist.jsaf.bug_detector.BugItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvaceResultFormatter {
    private DocumentBuilderFactory docFactory = null;
    private DocumentBuilder docBuilder = null;
    private Document doc = null;
    private String projectName = null;
    private String projectPath = null;

    public SvaceResultFormatter(String projName, String projPath) {
        try {
            this.projectName = projName;
            this.projectPath = projPath != null ? projPath : "";
            this.docFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docFactory.newDocumentBuilder();
            this.doc = this.docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printOutTargetJsFils(List<String> fileList, String outPath) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String str : fileList) {
            if (str.contains("SAFE_Model_") || str.contains(".safeTemp/index.html")) continue;
            File tempFile = new File(str);
            if (tempFile.exists()) {
                sb.append(tempFile.getCanonicalPath().replace(".safeTemp/", "") + "\n");
                continue;
            }
            System.out.println("[SvaceResultFormatter] ERROR : Not found '" + str + "'.");
        }
        try (OutputStreamWriter fw = null;){
            fw = new FileWriter(new File(outPath));
            fw.write(sb.toString());
        }
    }

    public void printOutSvaceResult(ArrayList<BugItem> alarmList, String outPath) {
        try {
            Element warningsXml = this.buildWarnings(alarmList);
            Element warningsExXml = this.buildEXWarnings(alarmList);
            Document docXml = this.buildSvresXml(warningsXml, warningsExXml);
            this.fileOut(docXml, outPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Element buildWarnings(ArrayList<BugItem> alarmList) {
        int id = 1000;
        Document warningDoc = this.doc;
        Element rootElement = warningDoc.createElement("warnings");
        for (BugItem item : alarmList) {
            Element info = warningDoc.createElement("WarnInfo");
            info.setAttribute("id", String.valueOf(id));
            info.setAttribute("warnClass", this.convertToManagerCheckerName(item.checkerName));
            info.setAttribute("line", String.valueOf(item.lineNumber));
            info.setAttribute("file", this.getSourcePath(item.filePath));
            info.setAttribute("msg", item.message);
            info.setAttribute("status", "Default");
            info.setAttribute("details", "");
            info.setAttribute("comment", "");
            rootElement.appendChild(info);
            ++id;
        }
        return rootElement;
    }

    private Element buildEXWarnings(ArrayList<BugItem> alarmList) {
        int id = 1000;
        Document warningDoc = this.doc;
        Element rootElement = warningDoc.createElement("warnings");
        for (BugItem item : alarmList) {
            Element infoEx = warningDoc.createElement("WarnInfoEx");
            rootElement.appendChild(infoEx);
            infoEx.setAttribute("id", String.valueOf(id));
            infoEx.setAttribute("zRate", "0.0");
            Element traces = warningDoc.createElement("traces");
            infoEx.appendChild(traces);
            Element RoleTraceInfo = warningDoc.createElement("RoleTraceInfo");
            RoleTraceInfo.setAttribute("role", "Defect");
            traces.appendChild(RoleTraceInfo);
            Element locations = warningDoc.createElement("locations");
            RoleTraceInfo.appendChild(locations);
            Element LocInfo2 = warningDoc.createElement("LocInfo");
            LocInfo2.setAttribute("file", this.getSourcePath(item.filePath));
            LocInfo2.setAttribute("line", String.valueOf(item.lineNumber));
            LocInfo2.setAttribute("spec", "false");
            LocInfo2.setAttribute("info", "defect");
            locations.appendChild(LocInfo2);
            Element userAttributes = warningDoc.createElement("userAttributes");
            userAttributes.setAttribute("class", "tree-map");
            infoEx.appendChild(userAttributes);
            Element entry_01 = warningDoc.createElement("entry");
            userAttributes.appendChild(entry_01);
            Element string_01 = warningDoc.createElement("string");
            string_01.setTextContent(".comment");
            Element string_02 = warningDoc.createElement("string");
            entry_01.appendChild(string_01);
            entry_01.appendChild(string_02);
            Element entry_02 = warningDoc.createElement("entry");
            userAttributes.appendChild(entry_02);
            Element string_03 = warningDoc.createElement("string");
            string_03.setTextContent(".status");
            Element string_04 = warningDoc.createElement("string");
            string_04.setTextContent("Default");
            entry_02.appendChild(string_03);
            entry_02.appendChild(string_04);
            rootElement.appendChild(infoEx);
            ++id;
        }
        return rootElement;
    }

    private Document buildSvresXml(Element warningsXml, Element exWarningsXml) {
        Element rootElement = this.doc.createElement("object-stream");
        this.doc.appendChild(rootElement);
        Element svresVer = this.doc.createElement("SvResVersion");
        svresVer.setTextContent("2.1:Svace results format");
        Element svresResults = this.doc.createElement("SvResResults");
        rootElement.appendChild(svresVer);
        rootElement.appendChild(svresResults);
        Element resultNode = this.doc.createElement("results");
        Element svResProResultNode = this.doc.createElement("SvResProjResults");
        resultNode.appendChild(svResProResultNode);
        svresResults.appendChild(resultNode);
        Element projectName = this.doc.createElement("projectName");
        projectName.setTextContent(this.projectName);
        Element projectSrcDir = this.doc.createElement("projectSrcDir");
        projectSrcDir.setTextContent(this.projectPath);
        svResProResultNode.appendChild(projectName);
        svResProResultNode.appendChild(projectSrcDir);
        svResProResultNode.appendChild(warningsXml);
        Element svresResultsEx = this.doc.createElement("SvResResultsEx");
        rootElement.appendChild(svresResultsEx);
        Element resultNodeEx = this.doc.createElement("results");
        Element svResProResultNodeEx = this.doc.createElement("SvResProjResultsEx");
        Element projectNameEx = this.doc.createElement("projectName");
        projectNameEx.setTextContent(this.projectName);
        svResProResultNodeEx.appendChild(projectNameEx);
        resultNodeEx.appendChild(svResProResultNodeEx);
        svResProResultNodeEx.appendChild(exWarningsXml);
        svresResultsEx.appendChild(resultNodeEx);
        return this.doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileOut(Document docXml, String outPath) throws IOException {
        try (OutputStreamWriter fw = null;){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(docXml);
            StringWriter sw = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, new StreamResult(sw));
            String SvResContent = sw.getBuffer().toString();
            SvResContent = SvResContent.substring(55);
            fw = new FileWriter(new File(outPath));
            fw.write(SvResContent);
        }
    }

    private String getSourcePath(String path) {
        File src = new File(path);
        String srcPath = "";
        try {
            if (src.exists()) {
                srcPath = src.getCanonicalPath();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return srcPath;
    }

    private String convertToManagerCheckerName(String checker) {
        if (checker.equals("AbsentReadProperty")) {
            return "ABSENT_READ_PROPERTY";
        }
        if (checker.equals("AbsentReadVariable")) {
            return "ABSENT_READ_VARIABLE";
        }
        if (checker.equals("BuiltinRegExpConst")) {
            return "BUILTIN_REG_EXP_CONST";
        }
        if (checker.equals("BuiltinCallable")) {
            return "BUILTIN_CALLABLE";
        }
        if (checker.equals("BuiltinWrongArgType")) {
            return "BUILTIN_WRONG_ARG_TYPE";
        }
        if (checker.equals("CallNonConstructor")) {
            return "CALL_NON_CONSTRUCTOR";
        }
        if (checker.equals("CallNonFunction")) {
            return "CALL_NON_FUNCTION";
        }
        if (checker.equals("CallConstFunc")) {
            return "CALL_CONST_FUNCTION";
        }
        if (checker.equals("ConcatUndefinedToString")) {
            return "CONCAT_UNDEFINED_TO_STRING";
        }
        if (checker.equals("StringToNaN")) {
            return "STRING_TO_NAN";
        }
        if (checker.equals("ObjectNullOrUndef")) {
            return "OBJECT_NULL_OR_UNDEFINED";
        }
        if (checker.equals("ConvertUndefToNum")) {
            return "CONVERT_UNDEFINED_TO_NUM";
        }
        if (checker.equals("DefaultValue")) {
            return "DEFAULT_VALUE";
        }
        if (checker.equals("ImplicitTypeConvert")) {
            return "IMPLICIT_TYPE_CONVERT";
        }
        if (checker.equals("ShadowedFuncByFunc")) {
            return "SHADOWED_FUNC_BY_FUNC";
        }
        if (checker.equals("ShadowedFuncByVar")) {
            return "SHADOWED_FUNC_BY_VAR";
        }
        if (checker.equals("ShadowedParamByFunc")) {
            return "SHADOWED_PARAM_BY_FUNC";
        }
        if (checker.equals("ShadowedParamByParam")) {
            return "SHADOWED_PARAM_BY_PARAM";
        }
        if (checker.equals("ShadowedParamByVar")) {
            return "SHADOWED_PARAM_BY_VAR";
        }
        if (checker.equals("ShadowedVarByFunc")) {
            return "SHADOWED_VAR_BY_FUNC";
        }
        if (checker.equals("ShadowedVarByVar")) {
            return "SHADOWED_VAR_BY_VAR";
        }
        if (checker.equals("CondBranch")) {
            return "CONDITION_BRANCH";
        }
        if (checker.equals("GlobalThis")) {
            return "GLOBAL_THIS";
        }
        if (checker.equals("Range15_9_5_43")) {
            return "DATE_RANGE";
        }
        if (checker.equals("ArrayConstLength")) {
            return "ARRAY_CONST_LENGTH";
        }
        if (checker.equals("BuiltinRange")) {
            return "BUILTIN_RANGE";
        }
        if (checker.equals("BinaryOpSecondType")) {
            return "BINARY_OP_SECOND_TYPE";
        }
        if (checker.equals("ToPropertyDescriptor")) {
            return "TO_PROPERTY_DESCRIPTOR";
        }
        if (checker.equals("ToPropertyDescriptors")) {
            return "TO_PROPERTY_DESCRIPTORS";
        }
        if (checker.equals("URIErrorArg")) {
            return "URI_ERROR_ARG";
        }
        if (checker.equals("JSONStringify")) {
            return "JSON_STRINGIFY";
        }
        if (checker.equals("StrictMode10_2_1_2_4")) {
            return "STRICT_MODE";
        }
        if (checker.equals("DefaultValue")) {
            return "DEFAULT_VALUE";
        }
        if (checker.equals("WebAPIInvalidNamespace")) {
            return "ACCESSING_UNDEFINED_API";
        }
        if (checker.equals("WebAPIWrongArgs")) {
            return "WRONG_ARGUMENTS_NUMBER";
        }
        if (checker.equals("WebAPIMissingErrorCB")) {
            return "MISSING_ERROR_HANDLING";
        }
        if (checker.equals("WebAPINoExceptionHandling")) {
            return "MISSING_EXCEPTION_HANDLING";
        }
        if (checker.equals("WebAPIWrongArgType")) {
            return "WRONG_ARGUMENT_TYPE";
        }
        if (checker.equals("WebAPIWrongDictionaryType")) {
            return "WRONG_DICTIONARY_TYPE";
        }
        if (checker.equals("TizenAPIVersion")) {
            return "API_VERSION_COMPATIBILITY";
        }
        if (checker.equals("TizenAPIPrivilege")) {
            return "API_PRIVILEGE_MISSING";
        }
        if (checker.equals("GuideVarArg")) {
            return "DO_NOT_DECLARE_ARGUMENTS_ARRAY_IN_FUNCTIONS";
        }
        if (checker.equals("GuideVarVar")) {
            return "USE_VAR_TO_DECLARE_VARIABLES";
        }
        if (checker.equals("GuideClosure")) {
            return "DO_NOT_CAPTURE_VARIABLES_IN_FUNCTIONS";
        }
        if (checker.equals("GuideExtraSemicolon")) {
            return "DO_NOT_USE_EXTRA_SEMICOLONS";
        }
        if (checker.equals("GuideNoDelete")) {
            return "DO_NOT_USE_THE_DELETE_KEYWORD";
        }
        if (checker.equals("GuideNoLongStr")) {
            return "DO_NOT_USE_MULTI-LINE_STRING_LITERALS";
        }
        if (checker.equals("GuideNoArrayObjectConstr")) {
            return "DO_NOT_USE_ARRAY_OR_OBJECT_CONSTRUCTORS";
        }
        if (checker.equals("GuideNoBuiltinProto")) {
            return "DO_NOT_MODIFY_PROTOTYPES_OF_BUILTIN_OBJECTS";
        }
        if (checker.equals("GuideNoObjToPrimitive")) {
            return "DO_NOT_CONVERT_WRAPPER_OBJECTS_TO_PRIMITIVES";
        }
        if (checker.equals("GuideNoForInArrays")) {
            return "DO_NOT_USE_FOR-IN_WITH_ARRAYS";
        }
        if (checker.equals("GuideNoDoubleQuotes")) {
            return "DO_NOT_USE_DOUBLE-QUOTED_STRINGS";
        }
        if (checker.equals("GuideMissingSemicolon")) {
            return "DO_NOT_OMIT_SEMICOLONS";
        }
        if (checker.equals("GuideNoBeginOp")) {
            return "DO_NOT_BEGIN_WITH_OPERATORS";
        }
        if (checker.equals("GuideNoLastComma")) {
            return "DO_NOT_END_WITH_COMMAS_IN_LITERALS";
        }
        if (checker.equals("GuideOpeningBrace")) {
            return "DO_NOT_USE_WRONG_OPENING_BRACE";
        }
        if (checker.equals("GuideMaxLineLength")) {
            return "DO_NOT_EXCEED_81_CHARACTERS_IN_A_LINE";
        }
        if (checker.equals("GuideWrongIndent")) {
            return "DO_NOT_USE_WRONG_INDENTATION";
        }
        return "";
    }
}

