/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.concurrent.IncrementalTask;
import edu.rice.cs.plt.concurrent.IncrementalTaskController;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessIncrementalTaskController<I, R>
extends IncrementalTaskController<I, R> {
    private JVMBuilder _jvmBuilder;
    private Executor _executor;
    private IncrementalTask<? extends I, ? extends R> _task;
    private Runnable1<? super Process> _onExit;
    private volatile Thread _t;
    private volatile ObjectOutputStream _commandSink;

    public ProcessIncrementalTaskController(JVMBuilder jvmBuilder, Executor executor, IncrementalTask<? extends I, ? extends R> task, boolean ignoreIntermediate) {
        super(ignoreIntermediate);
        this._jvmBuilder = jvmBuilder;
        this._executor = executor;
        this._task = task;
        this._onExit = null;
        this._t = null;
        this._commandSink = null;
    }

    public ProcessIncrementalTaskController(JVMBuilder jvmBuilder, Executor executor, IncrementalTask<? extends I, ? extends R> task, boolean ignoreIntermediate, Runnable1<? super Process> onExit) {
        super(ignoreIntermediate);
        this._jvmBuilder = jvmBuilder;
        this._executor = executor;
        this._task = task;
        this._onExit = onExit;
        this._t = null;
        this._commandSink = null;
    }

    @Override
    protected void doStart() {
        this._executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProcessIncrementalTaskController.this._t = Thread.currentThread();
                try {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Process p = ProcessIncrementalTaskController.this._jvmBuilder.start(Runner.class.getName(), IterUtil.empty());
                    try {
                        InputStream in = p.getInputStream();
                        int matching = 0;
                        while (matching < Runner.PREFIX.length) {
                            int read = in.read();
                            if (read == -1) {
                                throw new EOFException("Data prefix not found");
                            }
                            if ((byte)read == Runner.PREFIX[matching]) {
                                ++matching;
                                continue;
                            }
                            if ((byte)read == Runner.PREFIX[0]) {
                                matching = 1;
                                continue;
                            }
                            matching = 0;
                        }
                        ObjectInputStream objIn = new ObjectInputStream(in);
                        try {
                            ObjectOutputStream objOut = new ObjectOutputStream(p.getOutputStream());
                            try {
                                Result r;
                                objOut.writeObject(ProcessIncrementalTaskController.this._task);
                                objOut.writeObject((Object)Command.RUN);
                                objOut.flush();
                                ProcessIncrementalTaskController.this._commandSink = objOut;
                                do {
                                    r = (Result)objIn.readObject();
                                    r.handle(ProcessIncrementalTaskController.this);
                                } while (!(r instanceof FinishResult));
                                if (r instanceof CleanFinishResult) {
                                    Runnable1 onExit = ProcessIncrementalTaskController.this._onExit;
                                    if (onExit != null) {
                                        p.waitFor();
                                        onExit.run(p);
                                    }
                                } else {
                                    p.destroy();
                                }
                            }
                            finally {
                                objOut.close();
                            }
                        }
                        finally {
                            objIn.close();
                        }
                    }
                    catch (EOFException e) {
                        throw new IOException("Unable to run process; class path may need to be adjusted");
                    }
                    finally {
                        p.destroy();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (InterruptedIOException e) {
                }
                catch (RuntimeException e) {
                    ProcessIncrementalTaskController.this.finishedWithImplementationException(e);
                }
                catch (Throwable t) {
                    ProcessIncrementalTaskController.this.finishedWithImplementationException(new WrappedException(t));
                }
            }
        });
    }

    @Override
    protected void doStop() {
        this.writeCommand(Command.CANCEL);
    }

    @Override
    protected void doPause() {
        this.writeCommand(Command.PAUSE);
    }

    @Override
    protected void doResume() {
        this.writeCommand(Command.RUN);
    }

    private void writeCommand(Command c) {
        try {
            this._commandSink.writeObject((Object)c);
            this._commandSink.flush();
        }
        catch (IOException e) {
            this.finishedWithImplementationException(new WrappedException(e));
            this._t.interrupt();
        }
    }

    @Override
    protected void discard() {
        this._jvmBuilder = null;
        this._executor = null;
        this._task = null;
        this._onExit = null;
        this._t = null;
        this._commandSink = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Runner {
        public static final byte[] PREFIX = new byte[]{0, 127, 3, -128};
        private final IncrementalTask<?, ?> _task;
        private final ObjectOutputStream _objOut;
        private final ObjectInputStream _objIn;
        private final CompletionMonitor _continueMonitor;
        private final BlockingQueue<Result> _results;
        private final Thread _taskThread;
        private final Thread _objInReader;

        public Runner(IncrementalTask<?, ?> task, ObjectOutputStream objOut, ObjectInputStream objIn) {
            this._task = task;
            this._objOut = objOut;
            this._objIn = objIn;
            this._continueMonitor = new CompletionMonitor(false);
            this._results = new ArrayBlockingQueue<Result>(256);
            this._taskThread = new Thread("task runner"){

                public void run() {
                    block9: {
                        try {
                            try {
                                while (!Runner.this._task.isResolved()) {
                                    Runner.this.authorizeContinue();
                                    Runner.this._results.put(new StepResult(Runner.this._task.step()));
                                }
                                Runner.this.authorizeContinue();
                                Runner.this._results.put(new CleanFinishResult(Runner.this._task.value()));
                            }
                            catch (InterruptedException e) {
                                Runner.this._results.put(new CanceledResult());
                            }
                            catch (WrappedException e) {
                                if (e.getCause() instanceof InterruptedException) {
                                    Runner.this._results.put(new CanceledResult());
                                    break block9;
                                }
                                Runner.this._results.put(new TaskExceptionResult(e));
                            }
                            catch (RuntimeException e) {
                                Runner.this._results.put(new TaskExceptionResult(e));
                            }
                            catch (Throwable t) {
                                Runner.this._results.put(new ImplementationExceptionResult(t));
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            this._objInReader = new Thread("objIn reader"){

                public void run() {
                    try {
                        try {
                            while (!Thread.interrupted()) {
                                Command c = (Command)((Object)Runner.this._objIn.readObject());
                                switch (c) {
                                    case RUN: {
                                        Runner.this._continueMonitor.signal();
                                        break;
                                    }
                                    case PAUSE: {
                                        Runner.this._continueMonitor.reset();
                                        break;
                                    }
                                    case CANCEL: {
                                        Runner.this._taskThread.interrupt();
                                    }
                                }
                            }
                        }
                        catch (InterruptedIOException e) {
                        }
                        catch (Throwable t) {
                            Runner.this._results.put(new ImplementationExceptionResult(t));
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException, InterruptedException {
            this._objInReader.start();
            this._taskThread.start();
            try {
                Result r;
                do {
                    r = this._results.take();
                    this._objOut.writeObject(r);
                    this._objOut.flush();
                } while (!(r instanceof FinishResult));
            }
            finally {
                this._objInReader.interrupt();
                this._taskThread.interrupt();
            }
        }

        private void authorizeContinue() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!this._continueMonitor.isSignaled()) {
                this._results.put(new PausedResult());
                this._continueMonitor.ensureSignaled();
                this._results.put(new StartedResult());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String ... args) {
            PrintStream out = System.out;
            IOUtil.attemptClose(System.err);
            IOUtil.ignoreSystemOut();
            IOUtil.ignoreSystemErr();
            try {
                ((OutputStream)out).write(PREFIX);
                ((OutputStream)out).flush();
                ObjectOutputStream objOut = new ObjectOutputStream(out);
                try {
                    objOut.writeObject(new StartedResult());
                    objOut.flush();
                    ObjectInputStream objIn = new ObjectInputStream(System.in);
                    try {
                        IncrementalTask task = (IncrementalTask)objIn.readObject();
                        Runner runner = new Runner(task, objOut, objIn);
                        runner.run();
                    }
                    finally {
                        objIn.close();
                    }
                }
                catch (RuntimeException e) {
                    objOut.writeObject(new ImplementationExceptionResult(e));
                }
                catch (Throwable t) {
                    objOut.writeObject(new ImplementationExceptionResult(t));
                }
                finally {
                    objOut.close();
                }
            }
            catch (IOException e) {
                DebugUtil.error.log("Error writing to System.out", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CanceledResult
    extends FinishResult {
        private CanceledResult() {
        }

        @Override
        public <I, R> void handle(ProcessIncrementalTaskController<I, R> c) {
            c.stopped();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplementationExceptionResult
    extends FinishResult {
        private final RuntimeException _e;

        public ImplementationExceptionResult(Throwable t) {
            this._e = t instanceof RuntimeException ? (RuntimeException)t : new WrappedException(t);
        }

        @Override
        public <I, R> void handle(ProcessIncrementalTaskController<I, R> c) {
            c.finishedWithImplementationException(this._e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskExceptionResult
    extends FinishResult {
        private final Exception _e;

        public TaskExceptionResult(Exception e) {
            this._e = e;
        }

        @Override
        public <I, R> void handle(ProcessIncrementalTaskController<I, R> c) {
            c.finishedWithTaskException(this._e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CleanFinishResult
    extends FinishResult {
        private final Object _value;

        public CleanFinishResult(Object value) {
            this._value = value;
        }

        @Override
        public <I, R> void handle(ProcessIncrementalTaskController<I, R> c) {
            c.finishedCleanly(this._value);
        }
    }

    private static abstract class FinishResult
    extends Result {
        private FinishResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StepResult
    extends Result {
        private final Object _value;

        public StepResult(Object value) {
            this._value = value;
        }

        @Override
        public <I, R> void handle(ProcessIncrementalTaskController<I, R> c) {
            c.stepped(this._value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PausedResult
    extends Result {
        private PausedResult() {
        }

        @Override
        public <I, R> void handle(ProcessIncrementalTaskController<I, R> c) {
            c.paused();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StartedResult
    extends Result {
        private StartedResult() {
        }

        @Override
        public <I, R> void handle(ProcessIncrementalTaskController<I, R> c) {
            c.started();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Result
    implements Serializable {
        private Result() {
        }

        public abstract <I, R> void handle(ProcessIncrementalTaskController<I, R> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        RUN,
        PAUSE,
        CANCEL;

    }
}

