/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import kr.ac.kaist.jsaf.ProjectProperties;

public class JsClocResultExport {
    static final int OS_WINDOW = 11;
    static final int OS_LINUX = 12;
    static final int OS_MAC = 13;

    public void printOutClocResult(List<String> jsList, String outPath) {
        StringBuilder sb = new StringBuilder();
        FileWriter fw = null;
        sb.append("* JavaScript Files *\n");
        for (String path : jsList) {
            sb.append("# " + path + "\n");
        }
        sb.append("\n");
        try {
            fw = new FileWriter(new File(outPath));
            fw.write(sb.toString());
            String clocResult = this.excuteCloc(jsList);
            fw.write(clocResult);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printOutClocResult(List<String> jsList) {
        System.out.println("* JavaScript Files *\n");
        if (jsList.size() == 0) {
            System.out.println("# Error : Can't find JavaScript files.\n");
        }
        for (String path : jsList) {
            System.out.println("# " + path);
        }
        System.out.println("\n");
        try {
            String clocResult = this.excuteCloc(jsList);
            System.out.println(clocResult.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String excuteCloc(List<String> jsList) throws IOException {
        String line;
        String base = ProjectProperties.JS_HOME() + File.separator;
        ArrayList<String> command = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int osName = this.OSCheck();
        switch (osName) {
            case 11: {
                command.add("cmd");
                command.add("/c");
                command.add(base + "bin" + File.separator + "cloc-1.64.exe");
                break;
            }
            case 12: {
                command.add(base + "bin" + File.separator + "cloc-1.64.pl");
                break;
            }
            default: {
                System.out.println(" ERROR : JsClocResultExport.excuteCloc()");
            }
        }
        command.add("--by-file");
        command.addAll(jsList);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        Process process2 = pb.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(process2.getInputStream()));
        while ((line = input.readLine()) != null) {
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    private int OSCheck() {
        String curOSName = System.getProperty("os.name").toUpperCase();
        if (curOSName.indexOf("WINDOWS") >= 0) {
            return 11;
        }
        if (curOSName.indexOf("LINUX") >= 0) {
            return 12;
        }
        if (curOSName.indexOf("MAC OS") >= 0) {
            return 13;
        }
        return 0;
    }
}

