/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.astgen;

import edu.rice.cs.astgen.ASTModel;
import edu.rice.cs.astgen.CodeGenerator;
import edu.rice.cs.astgen.Field;
import edu.rice.cs.astgen.NodeClass;
import edu.rice.cs.astgen.NodeInterface;
import edu.rice.cs.astgen.NodeType;
import edu.rice.cs.astgen.TabPrintWriter;
import edu.rice.cs.astgen.Types;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionUnwrapException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ScalaAstGenerator
extends CodeGenerator {
    public ScalaAstGenerator(ASTModel ast) {
        super(ast);
    }

    public Iterable<Class<? extends CodeGenerator>> dependencies() {
        return new ArrayList<Class<? extends CodeGenerator>>();
    }

    public void generateInterfaceMembers(TabPrintWriter writer, NodeInterface i) {
    }

    public void generateClassMembers(TabPrintWriter writer, NodeClass c) {
    }

    private List<? extends NodeInterface> getInterfaces() {
        return this.mkList(this.ast.interfaces());
    }

    private String extendsClause(NodeInterface box) {
        List interfaces = box.interfaces();
        if (interfaces.isEmpty()) {
            return "";
        }
        if (interfaces.size() == 1) {
            return "extends " + this.fieldType((Types.TypeName)interfaces.get(0));
        }
        StringBuilder buffer = new StringBuilder("extends ");
        boolean first = true;
        for (Types.TypeName name : interfaces) {
            if (first) {
                first = false;
            } else {
                buffer.append(" with ");
            }
            buffer.append(this.fieldType(name));
        }
        return buffer.toString();
    }

    private String extendsClause(NodeClass box) {
        Option parent = this.ast.parent((NodeType)box);
        Object superFields = IterUtil.empty();
        if (parent.isSome() && parent.unwrap() instanceof NodeClass) {
            superFields = ((NodeType)parent.unwrap()).allFields(this.ast);
        }
        Types.TypeName superName = box.superClass();
        StringBuilder buffer = new StringBuilder("extends " + superName.name());
        buffer.append("(");
        boolean first = true;
        Iterator i$ = superFields.iterator();
        while (i$.hasNext()) {
            Field f = (Field)i$.next();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(f.getGetterName());
        }
        buffer.append(")");
        ArrayList<String> names = new ArrayList<String>();
        for (Types.TypeName typeName : box.interfaces()) {
            names.add(this.fieldType(typeName));
        }
        for (String string : names) {
            buffer.append(" with ");
            buffer.append(string);
        }
        return buffer.toString();
    }

    private String javaFieldType(Types.TypeName type) {
        return (String)type.accept((Types.TypeNameVisitor)new Types.TypeNameVisitor<String>(){

            public String forTreeNode(Types.ClassName t) {
                return "kr.ac.kaist.jsaf.nodes." + t.name();
            }

            public String forPrimitive(Types.PrimitiveName t) {
                String name = t.name();
                if (name.equals("int")) {
                    return "Int";
                }
                if (name.equals("boolean")) {
                    return "Boolean";
                }
                throw new RuntimeException("Unknown primitive " + name);
            }

            public String forString(Types.ClassName t) {
                return "String";
            }

            public String forPrimitiveArray(Types.PrimitiveArrayName t) {
                throw new RuntimeException("Can't handle primitive array");
            }

            public String forReferenceArray(Types.ReferenceArrayName t) {
                throw new RuntimeException("Can't handle reference array");
            }

            public String forSequenceClass(Types.SequenceClassName t) {
                return ScalaAstGenerator.this.sub("_root_.java.util.List[@type]", new String[]{"@type", (String)t.elementType().accept((Types.TypeNameVisitor)this)});
            }

            public String forOptionClass(Types.OptionClassName t) {
                return ScalaAstGenerator.this.sub("edu.rice.cs.plt.tuple.Option[@type]", new String[]{"@type", (String)t.elementType().accept((Types.TypeNameVisitor)this)});
            }

            public String forTupleClass(Types.TupleClassName t) {
                throw new RuntimeException("Can't handle tuple");
            }

            public String forGeneralClass(Types.ClassName t) {
                StringBuilder name = new StringBuilder();
                if (t.className().equals("Map")) {
                    name.append("_root_.java.util.Map");
                } else if (t.className().equals("BigInteger")) {
                    name.append("_root_.java.math.BigInteger");
                } else if (t.className().equals("Double")) {
                    name.append("_root_.java.lang.Double");
                } else if (t.className().equals("Object")) {
                    name.append("_root_.java.lang.Object");
                } else if (t.className().equals("Span")) {
                    name.append("kr.ac.kaist.jsaf.nodes_util.Span");
                } else if (t.className().equals("Integer")) {
                    name.append("_root_.java.lang.Integer");
                } else if (t.className().equals("SpanInfo")) {
                    name.append("kr.ac.kaist.jsaf.nodes_util.SpanInfo");
                } else {
                    name.append("kr.ac.kaist.jsaf.nodes." + t.className());
                }
                boolean first = true;
                for (Types.TypeArgumentName arg : t.typeArguments()) {
                    if (first) {
                        name.append("[");
                        first = false;
                    } else {
                        name.append(", ");
                    }
                    if (arg.name().equals("String")) {
                        name.append(arg.name());
                        continue;
                    }
                    if (arg.name().equals("Integer")) {
                        name.append("_root_.java.lang.Integer");
                        continue;
                    }
                    if (arg.name().equals("SpanInfo")) {
                        name.append("kr.ac.kaist.jsaf.nodes_util.SpanInfo");
                        continue;
                    }
                    name.append("kr.ac.kaist.jsaf.nodes." + arg.name());
                }
                if (!first) {
                    name.append("]");
                }
                return name.toString();
            }
        });
    }

    private String fieldType(Types.TypeName type) {
        return (String)type.accept((Types.TypeNameVisitor)new Types.TypeNameVisitor<String>(){

            public String forTreeNode(Types.ClassName t) {
                return "kr.ac.kaist.jsaf.nodes." + t.name();
            }

            public String forPrimitive(Types.PrimitiveName t) {
                String name = t.name();
                if (name.equals("int")) {
                    return "Int";
                }
                if (name.equals("boolean")) {
                    return "Boolean";
                }
                throw new RuntimeException("Unknown primitive " + name);
            }

            public String forString(Types.ClassName t) {
                return "String";
            }

            public String forPrimitiveArray(Types.PrimitiveArrayName t) {
                throw new RuntimeException("Can't handle primitive array");
            }

            public String forReferenceArray(Types.ReferenceArrayName t) {
                throw new RuntimeException("Can't handle reference array");
            }

            public String forSequenceClass(Types.SequenceClassName t) {
                return ScalaAstGenerator.this.sub("List[@type]", new String[]{"@type", (String)t.elementType().accept((Types.TypeNameVisitor)this)});
            }

            public String forOptionClass(Types.OptionClassName t) {
                return ScalaAstGenerator.this.sub("Option[@type]", new String[]{"@type", (String)t.elementType().accept((Types.TypeNameVisitor)this)});
            }

            public String forTupleClass(Types.TupleClassName t) {
                throw new RuntimeException("Can't handle tuple");
            }

            public String forGeneralClass(Types.ClassName t) {
                StringBuilder name = new StringBuilder();
                if (t.className().equals("Map")) {
                    name.append("Map");
                } else if (t.className().equals("BigInteger")) {
                    name.append("_root_.java.math.BigInteger");
                } else if (t.className().equals("Double")) {
                    name.append("_root_.java.lang.Double");
                } else if (t.className().equals("Object")) {
                    name.append("_root_.java.lang.Object");
                } else if (t.className().equals("Span")) {
                    name.append("kr.ac.kaist.jsaf.nodes_util.Span");
                } else if (t.className().equals("SpanInfo")) {
                    name.append("kr.ac.kaist.jsaf.nodes_util.SpanInfo");
                } else if (t.className().equals("Integer")) {
                    name.append("Int");
                } else {
                    name.append("kr.ac.kaist.jsaf.nodes." + t.className());
                }
                boolean first = true;
                for (Types.TypeArgumentName arg : t.typeArguments()) {
                    if (first) {
                        name.append("[");
                        first = false;
                    } else {
                        name.append(", ");
                    }
                    if (arg.name().equals("String")) {
                        name.append(arg.name());
                        continue;
                    }
                    if (arg.name().equals("Integer")) {
                        name.append("Int");
                        continue;
                    }
                    if (arg.name().equals("SpanInfo")) {
                        name.append("kr.ac.kaist.jsaf.nodes_util.SpanInfo");
                        continue;
                    }
                    name.append("kr.ac.kaist.jsaf.nodes." + arg.name());
                }
                if (!first) {
                    name.append("]");
                }
                return name.toString();
            }
        });
    }

    private String traitFields(List<Field> fields) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Field field : fields) {
            if (first) {
                buffer.append("\n");
                first = false;
            }
            buffer.append(this.sub("  def @name:@type\n", "@name", field.getGetterName(), "@type", this.fieldType(field.type())));
        }
        return buffer.toString();
    }

    private String fields(NodeClass box) {
        return "(" + this.fieldsNoParens(box, true) + ")";
    }

    private String fieldsNoParens(NodeClass box, boolean firstPass) {
        if (this.mkList(box.allFields(this.ast)).isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Field field : box.allFields(this.ast)) {
            if (firstPass) {
                firstPass = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.sub("@name:@type", "@name", field.getGetterName(), "@type", this.fieldType(field.type())));
        }
        return buffer.toString();
    }

    public String allFields(NodeClass box) {
        return "(" + this.allFieldsNoParens(box, true) + ")";
    }

    private StringBuilder allFieldsNoParens(NodeClass box, boolean firstPass) {
        StringBuilder buffer = new StringBuilder();
        if (this.ast.isTopClass(box)) {
            return buffer;
        }
        for (Field field : box.allFields(this.ast)) {
            if (firstPass) {
                firstPass = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.sub("@name:@type", "@name", field.getGetterName(), "@type", this.fieldType(field.type())));
        }
        try {
            buffer.append(this.fieldsNoParens((NodeClass)this.ast.typeForName(box.superClass()).unwrap(), firstPass));
        }
        catch (OptionUnwrapException e) {
            throw new RuntimeException("Missing supertype definition in JS.ast: " + box.superClass());
        }
        return buffer;
    }

    private String fieldsNoTypes(NodeType box) {
        if (this.mkList(box.allFields(this.ast)).isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("(");
        boolean first = true;
        for (Field field : box.allFields(this.ast)) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.sub("javaify(@name).asInstanceOf[@type]", "@name", field.getGetterName(), "@type", this.javaFieldType(field.type())));
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String fieldsNames(NodeType box) {
        if (this.mkList(box.allFields(this.ast)).isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("(");
        boolean first = true;
        for (Field field : box.allFields(this.ast)) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.sub("@name", "@name", field.getGetterName()));
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String fieldsNamesSS(NodeType box) {
        if (this.mkList(box.allFields(this.ast)).isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("(");
        boolean first = true;
        for (Field field : box.allFields(this.ast)) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.sub("@name", "@name", field.getGetterName()));
        }
        buffer.append(", getSpan)");
        return buffer.toString();
    }

    private String getterCalls(String receiverName, NodeType box) {
        if (this.mkList(box.allFields(this.ast)).isEmpty()) {
            return "()";
        }
        StringBuilder buffer = new StringBuilder("(");
        boolean first = true;
        for (Field field : box.allFields(this.ast)) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.sub("scalaify(@receiver.@getter()).asInstanceOf[@type]", "@receiver", receiverName, "@getter", field.getGetterName(), "@type", this.fieldType(field.type())));
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String wrappedFieldCalls(String wrapper, NodeType box, boolean isUnit) {
        return this.wrappedFieldCalls("", wrapper, box, isUnit);
    }

    private String wrappedFieldCalls(String receiver, String wrapper, NodeType box, boolean isUnit) {
        String middle;
        String close;
        String open;
        if (this.mkList(box.allFields(this.ast)).isEmpty()) {
            return "";
        }
        if (!receiver.equals("")) {
            receiver = receiver + ".";
        }
        if (isUnit) {
            open = "";
            close = "";
            middle = "; ";
        } else {
            open = "(";
            close = ")";
            middle = ", ";
        }
        StringBuilder buffer = new StringBuilder(open);
        boolean first = true;
        for (Field field : box.allFields(this.ast)) {
            if (first) {
                first = false;
            } else {
                buffer.append(middle);
            }
            if (isUnit) {
                buffer.append(this.sub("@wrapper(@receiver@name)", "@wrapper", wrapper, "@receiver", receiver, "@name", field.getGetterName()));
                continue;
            }
            buffer.append(this.sub("@wrapper(@receiver@name).asInstanceOf[@type]", "@wrapper", wrapper, "@receiver", receiver, "@name", field.getGetterName(), "@type", this.fieldType(field.type())));
        }
        buffer.append(close);
        return buffer.toString();
    }

    private String wrappedFieldCallsSS(NodeType box) {
        StringBuilder buffer = new StringBuilder("(");
        boolean first = true;
        for (Field field : box.allFields(this.ast)) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.sub("walk(@name).asInstanceOf[@type]", "@name", field.getGetterName(), "@type", this.fieldType(field.type())));
        }
        buffer.append(", walk(getSpan).asInstanceOf[kr.ac.kaist.jsaf.nodes_util.Span])");
        return buffer.toString();
    }

    private String sub(String s, String ... args) {
        if (args.length == 0) {
            return s;
        }
        return this.sub(String.format(s.replaceAll(args[0], "%1\\$s"), args[1]), Arrays.asList(args).subList(2, args.length).toArray(new String[0]));
    }

    private <T> List<T> mkList(Iterable<T> iter2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T i : iter2) {
            list.add(i);
        }
        return list;
    }

    private <T extends NodeType> Iterable<T> sort(Iterable<T> boxes) {
        List<T> list = this.mkList(boxes);
        Collections.sort(list, new Comparator<NodeType>(){

            @Override
            public int compare(NodeType b1, NodeType b2) {
                return b1.name().compareTo(b2.name());
            }
        });
        return list;
    }

    private boolean isSamsungNode(String name) {
        return name.endsWith("SS");
    }

    private boolean isSamsungNodeParent(String name) {
        return name.equals("Functional") || name.equals("If") || name.equals("Switch") || name.equals("Try") || name.equals("DoWhile");
    }

    private boolean ignoreClass(String name) {
        if (name.startsWith("_Rewrite")) {
            return false;
        }
        if (name.startsWith("_SyntaxTransformation")) {
            return true;
        }
        if (name.startsWith("_Ellipses")) {
            return true;
        }
        return name.startsWith("TemplateGap");
    }

    private void generateBody(PrintWriter writer) {
        for (NodeInterface nodeInterface : this.sort(this.getInterfaces())) {
            writer.println(this.sub("object S@name {", "@name", nodeInterface.name()));
            writer.println(this.sub("   def unapply(node:kr.ac.kaist.jsaf.nodes.@name) = ", "@name", nodeInterface.name()));
            writer.println(this.sub("      Some(@getterCalls)", "@getterCalls", this.getterCalls("node", (NodeType)nodeInterface)));
            writer.println(this.sub("}", new String[0]));
        }
        for (NodeClass nodeClass : this.sort(this.ast.classes())) {
            if (this.ignoreClass(nodeClass.name())) continue;
            writer.println(this.sub("object S@name {", "@name", nodeClass.name()));
            writer.println(this.sub("   def unapply(node:kr.ac.kaist.jsaf.nodes.@name) = ", "@name", nodeClass.name()));
            writer.println(this.sub("      Some(@getterCalls)", "@getterCalls", this.getterCalls("node", (NodeType)nodeClass)));
            if (!nodeClass.isAbstract()) {
                writer.println(this.sub("   def apply@fields = ", "@fields", this.fields(nodeClass)));
                writer.println(this.sub("      new kr.ac.kaist.jsaf.nodes.@name@fieldsNoTypes", "@name", nodeClass.name(), "@fieldsNoTypes", this.fieldsNoTypes((NodeType)nodeClass)));
            }
            writer.println(this.sub("}", new String[0]));
        }
        writer.println();
        writer.println("trait Walker {");
        writer.println("   def apply(node:Any):Any = walk(node)");
        writer.println("   def walk(node:Any):Any = {");
        writer.println("       node match {");
        for (NodeClass nodeClass : this.sort(this.ast.classes())) {
            if (this.ignoreClass(nodeClass.name()) || nodeClass.isAbstract() || this.isSamsungNode(nodeClass.name())) continue;
            if (this.isSamsungNodeParent(nodeClass.name())) {
                writer.println(this.sub("         case S@name@fieldsNoTypes => node match {", "@name", nodeClass.name(), "@fieldsNoTypes", this.fieldsNames((NodeType)nodeClass)));
                writer.println(this.sub("         case S@nameSS@fieldsNoTypes =>", "@name", nodeClass.name(), "@fieldsNoTypes", this.fieldsNamesSS((NodeType)nodeClass)));
                writer.println(this.sub("             S@nameSS@fieldsNoTypes", "@name", nodeClass.name(), "@fieldsNoTypes", this.wrappedFieldCallsSS((NodeType)nodeClass)));
                writer.println("           case _ =>");
                writer.println(this.sub("             S@name@fieldsNoTypes", "@name", nodeClass.name(), "@fieldsNoTypes", this.wrappedFieldCalls("walk", (NodeType)nodeClass, false)));
                writer.println("         }");
                continue;
            }
            writer.println(this.sub("         case S@name@fieldsNoTypes =>", "@name", nodeClass.name(), "@fieldsNoTypes", this.fieldsNames((NodeType)nodeClass)));
            writer.println(this.sub("             S@name@fieldsNoTypes", "@name", nodeClass.name(), "@fieldsNoTypes", this.wrappedFieldCalls("walk", (NodeType)nodeClass, false)));
        }
        writer.println("         case xs:List[_] => xs.map(walk _)");
        writer.println("         case xs:Option[_] => xs.map(walk _)");
        writer.println("         case _ => node");
        writer.println("      }");
        writer.println("   }");
        writer.println("   def walkUnit(node:Any):Unit = {");
        writer.println("       node match {");
        for (NodeClass nodeClass : this.sort(this.ast.classes())) {
            if (this.ignoreClass(nodeClass.name()) || nodeClass.isAbstract()) continue;
            writer.println(this.sub("         case S@name@fieldsNoTypes =>", "@name", nodeClass.name(), "@fieldsNoTypes", this.fieldsNames((NodeType)nodeClass)));
            writer.println(this.sub("             @fieldsNoTypes", "@fieldsNoTypes", this.wrappedFieldCalls("walkUnit", (NodeType)nodeClass, true)));
        }
        writer.println("         case xs:List[_] => xs.foreach(walkUnit _)");
        writer.println("         case xs:Option[_] => xs.foreach(walkUnit _)");
        writer.println("         case _:Span => ");
        writer.println("         case _ => ");
        writer.println("      }");
        writer.println("   }");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFile(String file, String preamble) {
        FileWriter out = null;
        PrintWriter writer = null;
        try {
            out = this.options.createFileInOutDir(file);
            writer = new PrintWriter(out);
            writer.println(this.copyright());
            writer.println(preamble);
            writer.println();
            this.generateBody(writer);
            writer.println();
            writer.close();
            out.close();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    private void generateScalaFile() {
        this.generateFile("JSAst.scala", "package kr.ac.kaist.jsaf.scala_src.nodes\nimport kr.ac.kaist.jsaf.scala_src.useful._\nimport kr.ac.kaist.jsaf.nodes_util._\nimport kr.ac.kaist.jsaf.useful.HasAt\nimport _root_.scala.collection.mutable.ListBuffer\nimport _root_.java.math.BigInteger\nimport _root_.java.lang.Double\nimport kr.ac.kaist.jsaf.scala_src.useful.ASTGenHelper._\n\nobject JSAst {}\n");
    }

    public void generateAdditionalCode() {
        this.generateScalaFile();
    }

    private String copyright() {
        StringWriter string = new StringWriter();
        PrintWriter writer = new PrintWriter(string);
        writer.println("/* THIS FILE WAS AUTOMATICALLY GENERATED BY");
        writer.println(this.sub("   @class FROM JS.ast */", "@class", ((Object)((Object)this)).getClass().getName()));
        return string.toString();
    }
}

