/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.analysis.string.regex;

import java.util.HashSet;
import kr.ac.kaist.jsaf.analysis.string.automata.Automata;
import kr.ac.kaist.jsaf.analysis.string.automata.State;
import kr.ac.kaist.jsaf.analysis.string.cfg.Token;
import kr.ac.kaist.jsaf.analysis.string.regex.Closure;
import kr.ac.kaist.jsaf.analysis.string.regex.Concat;
import kr.ac.kaist.jsaf.analysis.string.regex.Empty;
import kr.ac.kaist.jsaf.analysis.string.regex.Epsilon;
import kr.ac.kaist.jsaf.analysis.string.regex.Symbol;
import kr.ac.kaist.jsaf.analysis.string.regex.Union;

public abstract class Regex {
    public static final int EMPTY = 0;
    public static final int EPSILON = 1;
    public static final int SYMBOL = 2;
    public static final int UNION = 3;
    public static final int CONCAT = 4;
    public static final int CLOSURE = 5;
    protected int type;

    public static Regex empty() {
        return new Empty();
    }

    public static Regex epsilon() {
        return new Epsilon();
    }

    public static Regex symbol(Token symbol) {
        return new Symbol(symbol);
    }

    public static Regex union(Regex r1, Regex r2) {
        return new Union(r1, r2);
    }

    public static Regex concat(Regex r1, Regex r2) {
        return new Concat(r1, r2);
    }

    public static Regex closure(Regex r) {
        return new Closure(r);
    }

    public int type() {
        return this.type;
    }

    public Automata toAutomata() {
        State start = new State();
        State accept = new State();
        HashSet<State> acceptSet = new HashSet<State>();
        acceptSet.add(accept);
        Automata A = new Automata(start, acceptSet);
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                A.addEdge(start, accept, Automata.epsilon);
                break;
            }
            case 2: {
                A.addEdge(start, accept, ((Symbol)this).symbol());
                break;
            }
            case 3: {
                Automata l = ((Union)this).left().toAutomata();
                Automata r = ((Union)this).right().toAutomata();
                A.addStates(l.getStates());
                A.addEdges(l.getTransition());
                A.addStates(r.getStates());
                A.addEdges(r.getTransition());
                A.addEdge(start, l.getStart(), Automata.epsilon);
                A.addEdge(start, r.getStart(), Automata.epsilon);
                A.addEdge(l.getEnds().iterator().next(), accept, Automata.epsilon);
                A.addEdge(r.getEnds().iterator().next(), accept, Automata.epsilon);
                break;
            }
            case 4: {
                Automata l = ((Union)this).left().toAutomata();
                Automata r = ((Union)this).right().toAutomata();
                A = new Automata(l.getStart(), r.getEnds());
                A.addStates(l.getStates());
                A.addEdges(l.getTransition());
                A.addStates(r.getStates());
                A.addEdges(r.getTransition());
                A.addEdge(l.getEnds().iterator().next(), r.getStart(), Automata.epsilon);
                break;
            }
            case 5: {
                Automata l = ((Union)this).left().toAutomata();
                A.addStates(l.getStates());
                A.addEdges(l.getTransition());
                A.addEdge(start, accept, Automata.epsilon);
                A.addEdge(start, l.getStart(), Automata.epsilon);
                State lfinal = l.getEnds().iterator().next();
                A.addEdge(lfinal, l.getStart(), Automata.epsilon);
                A.addEdge(lfinal, accept, Automata.epsilon);
            }
        }
        return A;
    }
}

