/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kr.ac.kaist.jsaf.analysis.typing.Worklist;
import kr.ac.kaist.jsaf.widl.TizenDBMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ShellParameters {
    public static final int CMD_USAGE = 0;
    public static final int CMD_PARSE = 1;
    public static final int CMD_UNPARSE = 2;
    public static final int CMD_COVERAGE = 4;
    public static final int CMD_CONCOLIC = 5;
    public static final int CMD_URL = 6;
    public static final int CMD_WITH = 7;
    public static final int CMD_MODULE = 8;
    public static final int CMD_JUNIT = 9;
    public static final int CMD_DISAMBIGUATE = 10;
    public static final int CMD_COMPILE = 11;
    public static final int CMD_CFG = 12;
    public static final int CMD_INTERPRET = 13;
    public static final int CMD_ANALYZE = 14;
    public static final int CMD_PREANALYZE = 15;
    public static final int CMD_SPARSE = 16;
    public static final int CMD_HTML = 17;
    public static final int CMD_HTML_SPARSE = 18;
    public static final int CMD_NEW_SPARSE = 19;
    public static final int CMD_BUG_DETECTOR = 20;
    public static final int CMD_WIDLPARSE = 21;
    public static final int CMD_TSPARSE = 22;
    public static final int CMD_WEBAPP_BUG_DETECTOR = 23;
    public static final int CMD_CLOSURE_CONVERTER = 24;
    public static final int CMD_OPTIMIZE = 25;
    public static final int CMD_CONVERT_TIZEN2SEC = 96;
    public static final int CMD_CONVERT_SEC2TIZEN = 97;
    public static final int CMD_SAMSUNG = 98;
    public static final int CMD_HELP = 99;
    public static final int CMD_SAMSUNG_INFO = 100;
    public static final int CMD_SAMSUNG_CLOC = 101;
    public static final int CMD_SAMSUNG_VOLT = 102;
    public static final int CMD_SAMSUNG_WCV = 103;
    public int command;
    public String opt_OutFileName;
    public String opt_PrettyFileName;
    public String opt_Dir;
    public String opt_HTML;
    public String opt_dumpFileName;
    public List<String> opt_dynamicPath;
    public List<String> opt_JS;
    public String opt_JS_base;
    public List<String> opt_WIDLDB;
    public List<String> opt_TSDB;
    public List<String> opt_PreJS;
    public List<String> opt_PostJS;
    public List<String> opt_Surpass;
    public boolean opt_Time;
    public boolean opt_Module;
    public boolean opt_IgnoreErrorOnAST;
    public boolean opt_Model;
    public boolean opt_Mozilla;
    public boolean opt_Verbose1;
    public boolean opt_Verbose2;
    public boolean opt_Verbose3;
    public boolean opt_LocClone;
    public boolean opt_Pretty;
    public boolean opt_TryCatch;
    public boolean opt_Test;
    public boolean opt_DeveloperMode;
    public boolean opt_ErrorOnly;
    public boolean opt_Library;
    public boolean opt_MemDump;
    public boolean opt_ExitDump;
    public boolean opt_StatDump;
    public boolean opt_BottomDump;
    public boolean opt_ScriptDump;
    public boolean opt_Visual;
    public boolean opt_CheckResult;
    public boolean opt_NoAssert;
    public boolean opt_Compare;
    public boolean opt_ContextTrace;
    public boolean opt_ContextLoop;
    public boolean opt_ContextInsensitive;
    public boolean opt_Context1Callsite;
    public boolean opt_Context2Callsite;
    public boolean opt_Context3Callsite;
    public boolean opt_Context4Callsite;
    public boolean opt_Context5Callsite;
    public boolean opt_Context10Callsite;
    public boolean opt_ContextCallsiteSet;
    public boolean opt_Context1Object;
    public boolean opt_ContextTAJS;
    public boolean opt_Context1CallsiteAndObject;
    public boolean opt_Context2CallsiteAndObject;
    public boolean opt_Context3CallsiteAndObject;
    public boolean opt_Context4CallsiteAndObject;
    public boolean opt_Context5CallsiteAndObject;
    public boolean opt_Context1CallsiteAndIdentity;
    public boolean opt_Context2CallsiteAndIdentity;
    public boolean opt_Context3CallsiteAndIdentity;
    public boolean opt_Context4CallsiteAndIdentity;
    public boolean opt_Context5CallsiteAndIdentity;
    public boolean opt_Context1CallsiteOrObject;
    public boolean opt_ContextIdentity;
    public boolean opt_PreContextSensitive;
    public boolean opt_Unsound;
    public boolean opt_Dom;
    public boolean opt_Domprop;
    public boolean opt_disEvent;
    public boolean opt_useDump;
    public boolean opt_referencephone;
    public boolean opt_jssnapshot;
    public boolean opt_loop;
    public boolean opt_Tizen;
    public boolean opt_jQuery;
    public boolean opt_SingleThread;
    public boolean opt_MultiThread;
    public boolean opt_ReturnStateOn;
    public boolean opt_ReturnStateOff;
    public boolean opt_noStop;
    public boolean opt_codingGuide;
    public int opt_Timeout;
    public int opt_MaxStrSetSize;
    public int opt_MaxLocCount;
    public boolean opt_FunctionCoverage;
    public boolean opt_debugger;
    public int opt_unrollingCount;
    public int opt_forinunrollingCount;
    public int opt_WorklistOrder;
    public String opt_DDGFileName;
    public String opt_DDG0FileName;
    public String opt_FGFileName;
    public String[] FileNames;
    public boolean opt_Loud;
    public boolean opt_WebAPIException_noNameSpace;
    public String opt_Option;
    public String opt_LoadHeap;
    public boolean opt_Detect;
    public boolean opt_NoHTMLNetworkResource;
    public boolean opt_NoAddingFieldsIrregularly;
    public boolean opt_NoStructureObjectsCorrectly;
    public String[] opt_proxy;
    public boolean opt_timeinstrument;
    public boolean opt_JSAPluginMode;
    public String opt_resourceConfig;
    public String opt_content;
    public boolean opt_allcontents;
    public boolean opt_coverageinstrument;
    public boolean opt_APICount;
    public boolean opt_wcv;
    private String ErrorMessage = null;
    public List<String> opt_enableTypeChecker;
    public List<String> opt_enableWebapiChecker;
    public List<String> opt_enableCodingChecker;
    public String opt_TizenApiVersion;
    public String opt_TizenPrivilege;
    public List<TizenDBMap> opt_TizenApisDB;
    public String opt_svaceOut;
    public HashMap<String, String> opt_SnapshotList;
    public String opt_compatibleCheck;
    public String opt_clocOut;

    public ShellParameters() {
        this.Clear();
    }

    public void Clear() {
        this.command = 0;
        this.opt_OutFileName = null;
        this.opt_PrettyFileName = null;
        this.opt_Dir = null;
        this.opt_HTML = null;
        this.opt_dynamicPath = new ArrayList<String>();
        this.opt_JS = new ArrayList<String>();
        this.opt_JS_base = null;
        this.opt_WIDLDB = new ArrayList<String>();
        this.opt_TSDB = new ArrayList<String>();
        this.opt_PreJS = new ArrayList<String>();
        this.opt_PostJS = new ArrayList<String>();
        this.opt_Surpass = new ArrayList<String>();
        this.opt_Time = false;
        this.opt_Module = false;
        this.opt_IgnoreErrorOnAST = false;
        this.opt_Model = false;
        this.opt_Mozilla = false;
        this.opt_Verbose1 = false;
        this.opt_Verbose2 = false;
        this.opt_Verbose3 = false;
        this.opt_LocClone = false;
        this.opt_Pretty = false;
        this.opt_TryCatch = false;
        this.opt_Test = false;
        this.opt_DeveloperMode = false;
        this.opt_ErrorOnly = false;
        this.opt_Library = false;
        this.opt_MemDump = false;
        this.opt_ExitDump = false;
        this.opt_StatDump = false;
        this.opt_BottomDump = false;
        this.opt_ScriptDump = false;
        this.opt_Visual = false;
        this.opt_CheckResult = false;
        this.opt_NoAssert = false;
        this.opt_Compare = false;
        this.opt_ContextTrace = false;
        this.opt_ContextInsensitive = false;
        this.opt_Context1Callsite = false;
        this.opt_Context2Callsite = false;
        this.opt_Context3Callsite = false;
        this.opt_Context4Callsite = false;
        this.opt_Context5Callsite = false;
        this.opt_ContextCallsiteSet = false;
        this.opt_Context1Object = false;
        this.opt_ContextTAJS = false;
        this.opt_Context1CallsiteAndObject = false;
        this.opt_Context2CallsiteAndObject = false;
        this.opt_Context3CallsiteAndObject = false;
        this.opt_Context4CallsiteAndObject = false;
        this.opt_Context5CallsiteAndObject = false;
        this.opt_Context1CallsiteOrObject = false;
        this.opt_ContextIdentity = false;
        this.opt_PreContextSensitive = false;
        this.opt_Unsound = false;
        this.opt_Dom = false;
        this.opt_Domprop = false;
        this.opt_Tizen = false;
        this.opt_jQuery = false;
        this.opt_SingleThread = false;
        this.opt_MultiThread = false;
        this.opt_ReturnStateOn = false;
        this.opt_ReturnStateOff = false;
        this.opt_noStop = false;
        this.opt_codingGuide = false;
        this.opt_Timeout = 0;
        this.opt_MaxStrSetSize = 1;
        this.opt_MaxLocCount = 0;
        this.opt_FunctionCoverage = false;
        this.opt_debugger = false;
        this.opt_unrollingCount = 0;
        this.opt_forinunrollingCount = 0;
        this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_DEFAULT();
        this.opt_DDGFileName = null;
        this.opt_DDG0FileName = null;
        this.opt_FGFileName = null;
        this.FileNames = new String[0];
        this.opt_Loud = false;
        this.opt_WebAPIException_noNameSpace = false;
        this.opt_Option = null;
        this.opt_LoadHeap = null;
        this.opt_Detect = false;
        this.opt_NoHTMLNetworkResource = false;
        this.opt_NoAddingFieldsIrregularly = false;
        this.opt_NoStructureObjectsCorrectly = false;
        this.opt_proxy = new String[0];
        this.opt_timeinstrument = false;
        this.opt_resourceConfig = null;
        this.opt_content = null;
        this.opt_allcontents = false;
        this.opt_coverageinstrument = false;
        this.opt_APICount = false;
        this.opt_useDump = false;
        this.opt_dumpFileName = null;
        this.opt_TizenApiVersion = null;
        this.opt_TizenPrivilege = null;
        this.opt_TizenApisDB = new ArrayList<TizenDBMap>();
        this.opt_svaceOut = null;
        this.opt_clocOut = null;
        this.opt_SnapshotList = new HashMap();
        this.opt_compatibleCheck = null;
        this.opt_wcv = false;
    }

    public String Set(String[] args) {
        this.ErrorMessage = null;
        this.Clear();
        this.Parse(args);
        return this.ErrorMessage;
    }

    private void Parse(String[] args) {
        if (args.length == 0) {
            return;
        }
        ArrayList<String> feasibleOptions = new ArrayList<String>();
        feasibleOptions.add("-module");
        feasibleOptions.add("-ignoreErrorOnAST");
        String cmd = args[0];
        if (cmd.compareTo("parse") == 0) {
            this.command = 1;
            feasibleOptions.add("-out");
            feasibleOptions.add("-time");
        } else if (cmd.compareTo("unparse") == 0) {
            this.command = 2;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("tsparse") == 0) {
            this.command = 22;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("widlparse") == 0) {
            this.command = 21;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("coverage") == 0) {
            this.command = 4;
        } else if (cmd.compareTo("concolic") == 0) {
            this.command = 5;
            this.opt_jQuery = true;
            feasibleOptions.add("-js");
            feasibleOptions.add("-dir");
            feasibleOptions.add("-loud");
            feasibleOptions.add("-showall");
            feasibleOptions.add("-widldb");
            feasibleOptions.add("-tsdb");
            feasibleOptions.add("-console");
            feasibleOptions.add("-locclone");
            feasibleOptions.add("-domprop");
            feasibleOptions.add("-context-loop");
            feasibleOptions.add("-context-insensitive");
            feasibleOptions.add("-context-1-callsite");
            feasibleOptions.add("-context-2-callsite");
            feasibleOptions.add("-context-3-callsite");
            feasibleOptions.add("-context-4-callsite");
            feasibleOptions.add("-context-5-callsite");
            feasibleOptions.add("-context-callsite-set");
            feasibleOptions.add("-context-1-object");
            feasibleOptions.add("-context-tajs");
            feasibleOptions.add("-context-1-callsite-and-object");
            feasibleOptions.add("-context-2-callsite-and-object");
            feasibleOptions.add("-context-3-callsite-and-object");
            feasibleOptions.add("-context-4-callsite-and-object");
            feasibleOptions.add("-context-5-callsite-and-object");
            feasibleOptions.add("-context-1-callsite-and-identity");
            feasibleOptions.add("-context-2-callsite-and-identity");
            feasibleOptions.add("-context-3-callsite-and-identity");
            feasibleOptions.add("-context-4-callsite-and-identity");
            feasibleOptions.add("-context-5-callsite-and-identity");
            feasibleOptions.add("-context-1-callsite-or-object");
            feasibleOptions.add("-context-identity");
            feasibleOptions.add("-max-strset-size");
            feasibleOptions.add("-forin-unroll");
            feasibleOptions.add("-dev");
            feasibleOptions.add("-nojq");
            feasibleOptions.add("-timeout");
            feasibleOptions.add("-fcov");
            feasibleOptions.add("-prejs");
            feasibleOptions.add("-surpass");
            feasibleOptions.add("-postjs");
            feasibleOptions.add("-max-loc-count");
            feasibleOptions.add("-nostop");
            feasibleOptions.add("-codingGuide");
            feasibleOptions.add("-tizen");
            feasibleOptions.add("-disableEvent");
            feasibleOptions.add("-memdump");
            feasibleOptions.add("-exitdump");
            feasibleOptions.add("-option");
            feasibleOptions.add("-loadheap");
            feasibleOptions.add("-option");
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("url") == 0) {
            this.command = 6;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("with") == 0) {
            this.command = 7;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("module") == 0) {
            this.command = 8;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("junit") == 0) {
            this.command = 9;
        } else if (cmd.compareTo("disambiguate") == 0) {
            this.command = 10;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("compile") == 0) {
            this.command = 11;
            feasibleOptions.add("-out");
            feasibleOptions.add("-time");
        } else if (cmd.compareTo("cfg") == 0) {
            this.command = 12;
            feasibleOptions.add("-out");
            feasibleOptions.add("-dom");
            feasibleOptions.add("-tizen");
            feasibleOptions.add("-test");
            feasibleOptions.add("-model");
            feasibleOptions.add("-jq");
            feasibleOptions.add("-library");
            feasibleOptions.add("-unroll");
            feasibleOptions.add("-visual");
            feasibleOptions.add("-forin-unroll");
            feasibleOptions.add("-loop");
        } else if (cmd.compareTo("interpret") == 0) {
            this.command = 13;
            feasibleOptions.add("-out");
            feasibleOptions.add("-time");
            feasibleOptions.add("-mozilla");
        } else if (cmd.compareTo("interpret_mozilla") == 0) {
            this.command = 13;
            feasibleOptions.add("-out");
            feasibleOptions.add("-time");
            feasibleOptions.add("-mozilla");
            this.opt_Mozilla = true;
        } else if (cmd.compareTo("analyze") == 0 || cmd.compareTo("preanalyze") == 0 || cmd.compareTo("sparse") == 0 || cmd.compareTo("sparse-ddg") == 0 || cmd.compareTo("html") == 0 || cmd.compareTo("html-sparse") == 0) {
            if (cmd.compareTo("analyze") == 0) {
                this.command = 14;
            } else if (cmd.compareTo("preanalyze") == 0) {
                this.command = 15;
            } else if (cmd.compareTo("sparse") == 0) {
                this.command = 16;
            } else if (cmd.compareTo("sparse-ddg") == 0) {
                this.command = 19;
            } else if (cmd.compareTo("html") == 0) {
                this.command = 17;
            } else if (cmd.compareTo("html-sparse") == 0) {
                this.command = 18;
            }
            feasibleOptions.add("-dev");
            feasibleOptions.add("-verbose1");
            feasibleOptions.add("-verbose2");
            feasibleOptions.add("-verbose3");
            feasibleOptions.add("-locclone");
            feasibleOptions.add("-pretty");
            feasibleOptions.add("-trycatch");
            feasibleOptions.add("-test");
            feasibleOptions.add("-library");
            feasibleOptions.add("-memdump");
            feasibleOptions.add("-exitdump");
            feasibleOptions.add("-statdump");
            feasibleOptions.add("-bottomdump");
            feasibleOptions.add("-scriptdump");
            feasibleOptions.add("-visual");
            feasibleOptions.add("-checkResult");
            feasibleOptions.add("-no-assert");
            feasibleOptions.add("-compare");
            feasibleOptions.add("-context-loop");
            feasibleOptions.add("-context-insensitive");
            feasibleOptions.add("-context-1-callsite");
            feasibleOptions.add("-context-2-callsite");
            feasibleOptions.add("-context-3-callsite");
            feasibleOptions.add("-context-4-callsite");
            feasibleOptions.add("-context-5-callsite");
            feasibleOptions.add("-context-callsite-set");
            feasibleOptions.add("-context-1-object");
            feasibleOptions.add("-context-tajs");
            feasibleOptions.add("-context-1-callsite-and-object");
            feasibleOptions.add("-context-2-callsite-and-object");
            feasibleOptions.add("-context-3-callsite-and-object");
            feasibleOptions.add("-context-4-callsite-and-object");
            feasibleOptions.add("-context-5-callsite-and-object");
            feasibleOptions.add("-context-1-callsite-and-identity");
            feasibleOptions.add("-context-2-callsite-and-identity");
            feasibleOptions.add("-context-3-callsite-and-identity");
            feasibleOptions.add("-context-4-callsite-and-identity");
            feasibleOptions.add("-context-5-callsite-and-identity");
            feasibleOptions.add("-context-1-callsite-or-object");
            feasibleOptions.add("-context-identity");
            feasibleOptions.add("-pre-context-sensitive");
            feasibleOptions.add("-unsound");
            feasibleOptions.add("-single-thread");
            feasibleOptions.add("-multi-thread");
            feasibleOptions.add("-return-state-on");
            feasibleOptions.add("-return-state-off");
            feasibleOptions.add("-timeout");
            feasibleOptions.add("-max-strset-size");
            feasibleOptions.add("-max-loc-count");
            feasibleOptions.add("-fcov");
            feasibleOptions.add("-worklist-order-default");
            feasibleOptions.add("-worklist-order-fifo");
            feasibleOptions.add("-worklist-order-lifo");
            feasibleOptions.add("-worklist-order-count");
            feasibleOptions.add("-unroll");
            feasibleOptions.add("-forin-unroll");
            feasibleOptions.add("-ddgout");
            feasibleOptions.add("-ddg0out");
            feasibleOptions.add("-fgout");
            feasibleOptions.add("-tizen");
            feasibleOptions.add("-jq");
            feasibleOptions.add("-console");
            feasibleOptions.add("-domprop");
            feasibleOptions.add("-out");
            feasibleOptions.add("-disableEvent");
            feasibleOptions.add("-loop");
            feasibleOptions.add("-nostop");
        } else if (cmd.compareTo("bug-detector") == 0) {
            this.command = 20;
            feasibleOptions.add("-dev");
            feasibleOptions.add("-erroronly");
            feasibleOptions.add("-locclone");
            feasibleOptions.add("-pretty");
            feasibleOptions.add("-trycatch");
            feasibleOptions.add("-library");
            feasibleOptions.add("-context-trace");
            feasibleOptions.add("-context-loop");
            feasibleOptions.add("-context-insensitive");
            feasibleOptions.add("-context-1-callsite");
            feasibleOptions.add("-context-2-callsite");
            feasibleOptions.add("-context-3-callsite");
            feasibleOptions.add("-context-4-callsite");
            feasibleOptions.add("-context-5-callsite");
            feasibleOptions.add("-context-callsite-set");
            feasibleOptions.add("-context-1-object");
            feasibleOptions.add("-context-1-callsite-and-object");
            feasibleOptions.add("-context-2-callsite-and-object");
            feasibleOptions.add("-context-3-callsite-and-object");
            feasibleOptions.add("-context-4-callsite-and-object");
            feasibleOptions.add("-context-5-callsite-and-object");
            feasibleOptions.add("-context-1-callsite-and-identity");
            feasibleOptions.add("-context-2-callsite-and-identity");
            feasibleOptions.add("-context-3-callsite-and-identity");
            feasibleOptions.add("-context-4-callsite-and-identity");
            feasibleOptions.add("-context-5-callsite-and-identity");
            feasibleOptions.add("-context-1-callsite-or-object");
            feasibleOptions.add("-unroll");
            feasibleOptions.add("-forin-unroll");
            feasibleOptions.add("-nostop");
            feasibleOptions.add("-tizen");
            feasibleOptions.add("-disableEvent");
        } else if (cmd.compareTo("webapp-bug-detector") == 0) {
            this.command = 23;
            feasibleOptions.add("-dev");
            feasibleOptions.add("-exitdump");
            feasibleOptions.add("-disableEvent");
            feasibleOptions.add("-timeout");
            feasibleOptions.add("-nostop");
        } else if (cmd.compareTo("closure-converter") == 0) {
            this.command = 24;
            feasibleOptions.add("-out");
        } else if (cmd.compareTo("optimize") == 0) {
            this.command = 25;
            feasibleOptions.add("-detect");
            feasibleOptions.add("-noHTMLNetworkResource");
            feasibleOptions.add("-noAddingFieldsIrregularly");
            feasibleOptions.add("-noStructureObjectsCorrectly");
            feasibleOptions.add("-proxy");
            feasibleOptions.add("-option");
            feasibleOptions.add("-timeinstrument");
            feasibleOptions.add("-resourceconfig");
            feasibleOptions.add("-content");
            feasibleOptions.add("-allcontents");
            feasibleOptions.add("-coverageinstrument");
        } else if (cmd.compareTo("ss-analysis") == 0) {
            this.command = 98;
            this.opt_jQuery = true;
            feasibleOptions.add("-js");
            feasibleOptions.add("-dir");
            feasibleOptions.add("-loud");
            feasibleOptions.add("-showall");
            feasibleOptions.add("-widldb");
            feasibleOptions.add("-tsdb");
            feasibleOptions.add("-jq");
            feasibleOptions.add("-console");
            feasibleOptions.add("-locclone");
            feasibleOptions.add("-domprop");
            feasibleOptions.add("-context-loop");
            feasibleOptions.add("-context-insensitive");
            feasibleOptions.add("-context-1-callsite");
            feasibleOptions.add("-context-2-callsite");
            feasibleOptions.add("-context-3-callsite");
            feasibleOptions.add("-context-4-callsite");
            feasibleOptions.add("-context-5-callsite");
            feasibleOptions.add("-context-10-callsite");
            feasibleOptions.add("-context-callsite-set");
            feasibleOptions.add("-context-1-object");
            feasibleOptions.add("-context-tajs");
            feasibleOptions.add("-context-1-callsite-and-object");
            feasibleOptions.add("-context-2-callsite-and-object");
            feasibleOptions.add("-context-3-callsite-and-object");
            feasibleOptions.add("-context-4-callsite-and-object");
            feasibleOptions.add("-context-5-callsite-and-object");
            feasibleOptions.add("-context-1-callsite-and-identity");
            feasibleOptions.add("-context-2-callsite-and-identity");
            feasibleOptions.add("-context-3-callsite-and-identity");
            feasibleOptions.add("-context-4-callsite-and-identity");
            feasibleOptions.add("-context-5-callsite-and-identity");
            feasibleOptions.add("-context-1-callsite-or-object");
            feasibleOptions.add("-context-identity");
            feasibleOptions.add("-max-strset-size");
            feasibleOptions.add("-forin-unroll");
            feasibleOptions.add("-dev");
            feasibleOptions.add("-nojq");
            feasibleOptions.add("-timeout");
            feasibleOptions.add("-fcov");
            feasibleOptions.add("-prejs");
            feasibleOptions.add("-surpass");
            feasibleOptions.add("-postjs");
            feasibleOptions.add("-max-loc-count");
            feasibleOptions.add("-nostop");
            feasibleOptions.add("-codingGuide");
            feasibleOptions.add("-tizen");
            feasibleOptions.add("-disableEvent");
            feasibleOptions.add("-memdump");
            feasibleOptions.add("-exitdump");
            feasibleOptions.add("-option");
            feasibleOptions.add("-loadheap");
            feasibleOptions.add("-jsa-plugin");
            feasibleOptions.add("-ast-checker-on");
            feasibleOptions.add("-ast-checker-off");
            feasibleOptions.add("-cfg-checker-on");
            feasibleOptions.add("-cfg-checker-off");
            feasibleOptions.add("-apicount");
            feasibleOptions.add("-tizen-version-check");
            feasibleOptions.add("-tizen-privilege-check");
            feasibleOptions.add("-load-heap");
            feasibleOptions.add("-dynamic-path");
            feasibleOptions.add("-referencephone");
            feasibleOptions.add("-jssnapshot");
            feasibleOptions.add("-svace-out");
            feasibleOptions.add("-cloc-out");
            feasibleOptions.add("-out");
            feasibleOptions.add("-browser-compatible");
            feasibleOptions.add("-wcv");
        } else if (cmd.compareTo("cloc") == 0) {
            this.command = 101;
            feasibleOptions.add("-js");
        } else if (cmd.compareTo("ss-volt-analysis") == 0) {
            this.command = 102;
            feasibleOptions.add("-js");
            feasibleOptions.add("-dir");
        } else if (cmd.compareTo("ss-wcv-analysis") == 0) {
            this.command = 103;
            this.opt_jQuery = true;
            feasibleOptions.add("-dir");
            feasibleOptions.add("-widldb");
            feasibleOptions.add("-timeout");
            feasibleOptions.add("-fcov");
            feasibleOptions.add("-prejs");
            feasibleOptions.add("-surpass");
            feasibleOptions.add("-postjs");
            feasibleOptions.add("-max-loc-count");
            feasibleOptions.add("-nostop");
            feasibleOptions.add("-tizen");
            feasibleOptions.add("-jsa-plugin");
            feasibleOptions.add("-out");
            feasibleOptions.add("-locclone");
            feasibleOptions.add("-domprop");
            feasibleOptions.add("-context-loop");
            feasibleOptions.add("-context-insensitive");
            feasibleOptions.add("-context-1-callsite");
            feasibleOptions.add("-context-2-callsite");
            feasibleOptions.add("-context-3-callsite");
            feasibleOptions.add("-context-4-callsite");
            feasibleOptions.add("-context-5-callsite");
            feasibleOptions.add("-context-10-callsite");
            feasibleOptions.add("-context-callsite-set");
            feasibleOptions.add("-context-1-object");
            feasibleOptions.add("-context-tajs");
            feasibleOptions.add("-context-1-callsite-and-object");
            feasibleOptions.add("-context-2-callsite-and-object");
            feasibleOptions.add("-context-3-callsite-and-object");
            feasibleOptions.add("-context-4-callsite-and-object");
            feasibleOptions.add("-context-5-callsite-and-object");
            feasibleOptions.add("-context-1-callsite-and-identity");
            feasibleOptions.add("-context-2-callsite-and-identity");
            feasibleOptions.add("-context-3-callsite-and-identity");
            feasibleOptions.add("-context-4-callsite-and-identity");
            feasibleOptions.add("-context-5-callsite-and-identity");
            feasibleOptions.add("-context-1-callsite-or-object");
            feasibleOptions.add("-context-identity");
            feasibleOptions.add("-max-strset-size");
            feasibleOptions.add("-forin-unroll");
            feasibleOptions.add("-dev");
            feasibleOptions.add("-nojq");
            feasibleOptions.add("-wcv");
        } else if (cmd.compareTo("info") == 0) {
            this.command = 100;
            feasibleOptions.add("-js");
            feasibleOptions.add("-out");
            feasibleOptions.add("-dev");
        } else if (cmd.compareTo("convert-sec2tizen") == 0) {
            this.command = 97;
        } else if (cmd.compareTo("convert-tizen2sec") == 0) {
            this.command = 96;
            feasibleOptions.add("-opt_WebAPIException_noNameSpace");
        } else if (cmd.compareTo("help") == 0) {
            this.command = 99;
        } else {
            this.command = 0;
            return;
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (!feasibleOptions.contains(args[i])) {
                    this.ErrorMessage = args[i] + " is not a valid flag for `jsaf " + cmd + "`";
                } else {
                    i += this.SetOption(args, i);
                }
                if (this.ErrorMessage != null) break;
                ArrayList<String> childFiles = new ArrayList<String>();
                if (!this.opt_JS.isEmpty()) {
                    for (String path : this.opt_JS) {
                        File jsDir = new File(path);
                        if (!jsDir.isDirectory()) continue;
                        this.opt_JS_base = jsDir.getAbsolutePath();
                        childFiles = this.getSubJsFileList(jsDir);
                    }
                }
                if (childFiles.isEmpty()) continue;
                this.opt_JS = childFiles;
                continue;
            }
            int Rest = args.length - i;
            this.FileNames = new String[Rest];
            for (int j = 0; j < Rest; ++j) {
                this.FileNames[j] = args[i + j];
            }
            break;
        }
        if (this.ErrorMessage != null) {
            this.Clear();
        }
    }

    private ArrayList<String> getSubJsFileList(File dirPath) {
        File[] listJsFiles;
        ArrayList<String> list = new ArrayList<String>();
        for (File file : listJsFiles = dirPath.listFiles()) {
            if (file.isFile() && file.getAbsolutePath().endsWith(".js")) {
                list.add(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory() || file.isHidden()) continue;
            ArrayList<String> subList = this.getSubJsFileList(file);
            list.addAll(subList);
        }
        return list;
    }

    private ArrayList<String> getStringArrayListFromJSONArray(JSONArray arr) {
        Iterator iterator = arr.iterator();
        ArrayList<String> res = new ArrayList<String>();
        while (iterator.hasNext()) {
            res.add((String)iterator.next());
        }
        return res;
    }

    private String[] getStringArrayFromJSONArray(JSONArray arr) {
        Iterator iterator = arr.iterator();
        int Length = 0;
        while (iterator.hasNext()) {
            ++Length;
            iterator.next();
        }
        String[] res = new String[Length];
        iterator = arr.iterator();
        for (int i = 0; i < Length; ++i) {
            res[i] = String.valueOf(iterator.next());
            System.out.println("val = " + res[i]);
        }
        System.out.println("JSONARRAY = " + Length);
        return res;
    }

    private ArrayList<String> ReadDynamicPathJSON(String jsonFileName) {
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse((Reader)new FileReader(jsonFileName));
            JSONArray jsonArray = (JSONArray)obj;
            return this.getStringArrayListFromJSONArray(jsonArray);
        }
        catch (FileNotFoundException e) {
            System.out.println("Cannot find " + jsonFileName);
        }
        catch (IOException e) {
            System.out.println("IOException occurs while opening " + jsonFileName);
        }
        catch (ParseException e) {
            System.out.println("Failed to parse " + jsonFileName);
        }
        return new ArrayList<String>();
    }

    private void ReadJSONOption(String jsonFileName) {
        JSONParser parser = new JSONParser();
        try {
            String path;
            boolean flag;
            Object obj = parser.parse((Reader)new FileReader(jsonFileName));
            JSONObject jsonObject = (JSONObject)obj;
            if (jsonObject.get((Object)"out") != null) {
                this.opt_OutFileName = (String)jsonObject.get((Object)"out");
            }
            if (jsonObject.get((Object)"pretty") != null) {
                this.opt_Pretty = (Boolean)jsonObject.get((Object)"pretty");
                this.opt_PrettyFileName = (String)jsonObject.get((Object)"pretty");
            }
            if (jsonObject.get((Object)"load-heap") != null) {
                this.opt_useDump = (Boolean)jsonObject.get((Object)"load-heap");
                this.opt_dumpFileName = (String)jsonObject.get((Object)"load-heap");
            }
            if (jsonObject.get((Object)"referencephone") != null) {
                this.opt_referencephone = (Boolean)jsonObject.get((Object)"referencephone");
            }
            if (jsonObject.get((Object)"jssnapshot") != null) {
                this.opt_jssnapshot = (Boolean)jsonObject.get((Object)"jssnapshot");
            }
            if (jsonObject.get((Object)"dynamic-path") != null) {
                this.opt_dynamicPath = this.ReadDynamicPathJSON((String)jsonObject.get((Object)"dynamic-path"));
            }
            if (jsonObject.get((Object)"timeout") != null) {
                this.opt_Timeout = ((Long)jsonObject.get((Object)"timeout")).intValue();
            }
            if (jsonObject.get((Object)"max-strset-size") != null) {
                this.opt_MaxStrSetSize = ((Long)jsonObject.get((Object)"max-strset-size")).intValue();
            }
            if (jsonObject.get((Object)"max-loc-count") != null) {
                this.opt_MaxLocCount = ((Long)jsonObject.get((Object)"max-loc-count")).intValue();
            }
            if (jsonObject.get((Object)"unroll") != null) {
                this.opt_unrollingCount = ((Long)jsonObject.get((Object)"unroll")).intValue();
            }
            if (jsonObject.get((Object)"forin-unroll") != null) {
                this.opt_forinunrollingCount = ((Long)jsonObject.get((Object)"forin-unroll")).intValue();
            }
            if (jsonObject.get((Object)"ddgout") != null) {
                this.opt_DDGFileName = (String)jsonObject.get((Object)"ddgout");
            }
            if (jsonObject.get((Object)"ddg0out") != null) {
                this.opt_DDG0FileName = (String)jsonObject.get((Object)"ddg0out");
            }
            if (jsonObject.get((Object)"fgout") != null) {
                this.opt_FGFileName = (String)jsonObject.get((Object)"fgout");
            }
            if (jsonObject.get((Object)"dir") != null) {
                this.opt_Dir = (String)jsonObject.get((Object)"dir");
            }
            if (jsonObject.get((Object)"html") != null) {
                this.opt_HTML = (String)jsonObject.get((Object)"html");
            }
            if (jsonObject.get((Object)"js") != null) {
                this.opt_JS = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"js"));
            }
            if (jsonObject.get((Object)"widldb") != null) {
                this.opt_WIDLDB = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"widldb"));
            }
            if (jsonObject.get((Object)"tsdb") != null) {
                this.opt_TSDB = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"tsdb"));
            }
            if (jsonObject.get((Object)"prejs") != null) {
                this.opt_PreJS = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"prejs"));
            }
            if (jsonObject.get((Object)"postjs") != null) {
                this.opt_PostJS = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"postjs"));
            }
            if (jsonObject.get((Object)"surpass") != null) {
                this.opt_Surpass = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"surpass"));
            }
            if (jsonObject.get((Object)"time") != null) {
                this.opt_Time = (Boolean)jsonObject.get((Object)"time");
            }
            if (jsonObject.get((Object)"module") != null) {
                this.opt_Module = (Boolean)jsonObject.get((Object)"module");
            }
            if (jsonObject.get((Object)"ignoreErrorOnAST") != null) {
                this.opt_IgnoreErrorOnAST = (Boolean)jsonObject.get((Object)"ignoreErrorOnAST");
            }
            if (jsonObject.get((Object)"model") != null) {
                this.opt_Model = (Boolean)jsonObject.get((Object)"model");
            }
            if (jsonObject.get((Object)"mozilla") != null) {
                this.opt_Mozilla = (Boolean)jsonObject.get((Object)"mozilla");
            }
            if (jsonObject.get((Object)"verbose1") != null) {
                this.opt_Verbose1 = (Boolean)jsonObject.get((Object)"verbose1");
            }
            if (jsonObject.get((Object)"verbose2") != null) {
                this.opt_Verbose2 = (Boolean)jsonObject.get((Object)"verbose2");
            }
            if (jsonObject.get((Object)"verbose3") != null) {
                this.opt_Verbose3 = (Boolean)jsonObject.get((Object)"verbose3");
            }
            if (jsonObject.get((Object)"locclone") != null) {
                this.opt_LocClone = (Boolean)jsonObject.get((Object)"locclone");
            }
            if (jsonObject.get((Object)"pretty") != null) {
                this.opt_Pretty = (Boolean)jsonObject.get((Object)"pretty");
            }
            if (jsonObject.get((Object)"trycatch") != null) {
                this.opt_TryCatch = (Boolean)jsonObject.get((Object)"trycatch");
            }
            if (jsonObject.get((Object)"dev") != null) {
                this.opt_DeveloperMode = (Boolean)jsonObject.get((Object)"dev");
            }
            if (jsonObject.get((Object)"erroronly") != null) {
                this.opt_ErrorOnly = (Boolean)jsonObject.get((Object)"erroronly");
            }
            if (jsonObject.get((Object)"test") != null) {
                this.opt_Test = (Boolean)jsonObject.get((Object)"test");
            }
            if (jsonObject.get((Object)"library") != null) {
                this.opt_Library = (Boolean)jsonObject.get((Object)"library");
            }
            if (jsonObject.get((Object)"memdump") != null) {
                this.opt_MemDump = (Boolean)jsonObject.get((Object)"memdump");
            }
            if (jsonObject.get((Object)"exitdump") != null) {
                this.opt_ExitDump = (Boolean)jsonObject.get((Object)"exitdump");
            }
            if (jsonObject.get((Object)"statdump") != null) {
                this.opt_StatDump = (Boolean)jsonObject.get((Object)"statdump");
            }
            if (jsonObject.get((Object)"bottomdump") != null) {
                this.opt_BottomDump = (Boolean)jsonObject.get((Object)"bottomdump");
            }
            if (jsonObject.get((Object)"scriptdump") != null) {
                this.opt_ScriptDump = (Boolean)jsonObject.get((Object)"scriptdump");
            }
            if (jsonObject.get((Object)"visual") != null) {
                this.opt_Visual = (Boolean)jsonObject.get((Object)"visual");
            }
            if (jsonObject.get((Object)"checkResult") != null) {
                this.opt_CheckResult = (Boolean)jsonObject.get((Object)"checkResult");
            }
            if (jsonObject.get((Object)"no-assert") != null) {
                this.opt_NoAssert = (Boolean)jsonObject.get((Object)"no-assert");
            }
            if (jsonObject.get((Object)"compare") != null) {
                this.opt_Compare = (Boolean)jsonObject.get((Object)"compare");
            }
            if (jsonObject.get((Object)"context-loop") != null) {
                this.opt_ContextLoop = (Boolean)jsonObject.get((Object)"context-loop");
            }
            if (jsonObject.get((Object)"context-trace") != null) {
                this.opt_ContextTrace = (Boolean)jsonObject.get((Object)"context-trace");
            }
            if (jsonObject.get((Object)"context-insensitive") != null) {
                this.opt_ContextInsensitive = (Boolean)jsonObject.get((Object)"context-insensitive");
            }
            if (jsonObject.get((Object)"context-1-callsite") != null) {
                this.opt_Context1Callsite = (Boolean)jsonObject.get((Object)"context-1-callsite");
            }
            if (jsonObject.get((Object)"context-2-callsite") != null) {
                this.opt_Context2Callsite = (Boolean)jsonObject.get((Object)"context-2-callsite");
            }
            if (jsonObject.get((Object)"context-3-callsite") != null) {
                this.opt_Context3Callsite = (Boolean)jsonObject.get((Object)"context-3-callsite");
            }
            if (jsonObject.get((Object)"context-4-callsite") != null) {
                this.opt_Context4Callsite = (Boolean)jsonObject.get((Object)"context-4-callsite");
            }
            if (jsonObject.get((Object)"context-5-callsite") != null) {
                this.opt_Context5Callsite = (Boolean)jsonObject.get((Object)"context-5-callsite");
            }
            if (jsonObject.get((Object)"context-10-callsite") != null) {
                this.opt_Context10Callsite = (Boolean)jsonObject.get((Object)"context-10-callsite");
            }
            if (jsonObject.get((Object)"context-callsite-set") != null) {
                this.opt_ContextCallsiteSet = (Boolean)jsonObject.get((Object)"context-callsite-set");
            }
            if (jsonObject.get((Object)"context-1-object") != null) {
                this.opt_Context1Object = (Boolean)jsonObject.get((Object)"context-1-object");
            }
            if (jsonObject.get((Object)"context-tajs") != null) {
                this.opt_ContextTAJS = (Boolean)jsonObject.get((Object)"context-tajs");
            }
            if (jsonObject.get((Object)"context-1-callsite-and-object") != null) {
                this.opt_Context1CallsiteAndObject = (Boolean)jsonObject.get((Object)"context-1-callsite-and-object");
            }
            if (jsonObject.get((Object)"context-2-callsite-and-object") != null) {
                this.opt_Context2CallsiteAndObject = (Boolean)jsonObject.get((Object)"context-2-callsite-and-object");
            }
            if (jsonObject.get((Object)"context-3-callsite-and-object") != null) {
                this.opt_Context3CallsiteAndObject = (Boolean)jsonObject.get((Object)"context-3-callsite-and-object");
            }
            if (jsonObject.get((Object)"loud") != null) {
                this.opt_Loud = (Boolean)jsonObject.get((Object)"loud");
            }
            if (jsonObject.get((Object)"opt_WebAPIException_noNameSpace") != null) {
                this.opt_WebAPIException_noNameSpace = (Boolean)jsonObject.get((Object)"opt_WebAPIException_noNameSpace");
            }
            if (jsonObject.get((Object)"context-4-callsite-and-object") != null) {
                this.opt_Context4CallsiteAndObject = (Boolean)jsonObject.get((Object)"context-4-callsite-and-object");
            }
            if (jsonObject.get((Object)"context-5-callsite-and-object") != null) {
                this.opt_Context5CallsiteAndObject = (Boolean)jsonObject.get((Object)"context-5-callsite-and-object");
            }
            if (jsonObject.get((Object)"context-1-callsite-and-identity") != null) {
                this.opt_Context1CallsiteAndIdentity = (Boolean)jsonObject.get((Object)"context-1-callsite-and-identity");
            }
            if (jsonObject.get((Object)"context-2-callsite-and-identity") != null) {
                this.opt_Context2CallsiteAndIdentity = (Boolean)jsonObject.get((Object)"context-2-callsite-and-identity");
            }
            if (jsonObject.get((Object)"context-3-callsite-and-identity") != null) {
                this.opt_Context3CallsiteAndIdentity = (Boolean)jsonObject.get((Object)"context-3-callsite-and-identity");
            }
            if (jsonObject.get((Object)"context-4-callsite-and-identity") != null) {
                this.opt_Context4CallsiteAndIdentity = (Boolean)jsonObject.get((Object)"context-4-callsite-and-identity");
            }
            if (jsonObject.get((Object)"context-5-callsite-and-identity") != null) {
                this.opt_Context5CallsiteAndIdentity = (Boolean)jsonObject.get((Object)"context-5-callsite-and-identity");
            }
            if (jsonObject.get((Object)"context-1-callsite-or-object") != null) {
                this.opt_Context1CallsiteOrObject = (Boolean)jsonObject.get((Object)"context-1-callsite-or-object");
            }
            if (jsonObject.get((Object)"context-identity") != null) {
                this.opt_ContextIdentity = (Boolean)jsonObject.get((Object)"context-identity");
            }
            if (jsonObject.get((Object)"pre-context-sensitive") != null) {
                this.opt_PreContextSensitive = (Boolean)jsonObject.get((Object)"pre-context-sensitive");
            }
            if (jsonObject.get((Object)"unsound") != null) {
                this.opt_Unsound = (Boolean)jsonObject.get((Object)"unsound");
            }
            if (jsonObject.get((Object)"nostop") != null) {
                this.opt_noStop = (Boolean)jsonObject.get((Object)"nostop");
            }
            if (jsonObject.get((Object)"codingGuide") != null) {
                this.opt_codingGuide = (Boolean)jsonObject.get((Object)"codingGuide");
            }
            if (jsonObject.get((Object)"dom") != null) {
                this.opt_Dom = (Boolean)jsonObject.get((Object)"dom");
            }
            if (jsonObject.get((Object)"domprop") != null) {
                this.opt_Domprop = (Boolean)jsonObject.get((Object)"domprop");
            }
            if (jsonObject.get((Object)"disableEvent") != null) {
                this.opt_disEvent = (Boolean)jsonObject.get((Object)"disableEvent");
            }
            if (jsonObject.get((Object)"loop") != null) {
                this.opt_loop = (Boolean)jsonObject.get((Object)"loop");
            }
            if (jsonObject.get((Object)"tizen") != null) {
                this.opt_Tizen = (Boolean)jsonObject.get((Object)"tizen");
            }
            if (jsonObject.get((Object)"jq") != null) {
                this.opt_jQuery = (Boolean)jsonObject.get((Object)"jq");
            }
            if (jsonObject.get((Object)"nojq") != null) {
                boolean bl = this.opt_jQuery = (Boolean)jsonObject.get((Object)"nojq") == false;
            }
            if (jsonObject.get((Object)"single-thread") != null) {
                this.opt_SingleThread = (Boolean)jsonObject.get((Object)"single-thread");
            }
            if (jsonObject.get((Object)"multi-thread") != null) {
                this.opt_MultiThread = (Boolean)jsonObject.get((Object)"multi-thread");
            }
            if (jsonObject.get((Object)"return-state-on") != null) {
                this.opt_ReturnStateOn = (Boolean)jsonObject.get((Object)"return-state-on");
            }
            if (jsonObject.get((Object)"return-state-off") != null) {
                this.opt_ReturnStateOff = (Boolean)jsonObject.get((Object)"return-state-off");
            }
            if (jsonObject.get((Object)"fcov") != null) {
                this.opt_FunctionCoverage = (Boolean)jsonObject.get((Object)"fcov");
            }
            if (jsonObject.get((Object)"worklist-order-default") != null && (flag = ((Boolean)jsonObject.get((Object)"worklist-order-default")).booleanValue())) {
                this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_DEFAULT();
            }
            if (jsonObject.get((Object)"worklist-order-fifo") != null && (flag = ((Boolean)jsonObject.get((Object)"worklist-order-fifo")).booleanValue())) {
                this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_FIFO();
            }
            if (jsonObject.get((Object)"worklist-order-lifo") != null && (flag = ((Boolean)jsonObject.get((Object)"worklist-order-lifo")).booleanValue())) {
                this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_LIFO();
            }
            if (jsonObject.get((Object)"worklist-order-count") != null && (flag = ((Boolean)jsonObject.get((Object)"worklist-order-count")).booleanValue())) {
                this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_COUNT();
            }
            if (jsonObject.get((Object)"console") != null) {
                this.opt_debugger = (Boolean)jsonObject.get((Object)"console");
            }
            if (jsonObject.get((Object)"loadheap") != null) {
                this.opt_LoadHeap = (String)jsonObject.get((Object)"loadheap");
            }
            if (jsonObject.get((Object)"detect") != null) {
                this.opt_Detect = (Boolean)jsonObject.get((Object)"detect");
            }
            if (jsonObject.get((Object)"noHTMLNetworkResource") != null) {
                this.opt_NoHTMLNetworkResource = (Boolean)jsonObject.get((Object)"noHTMLNetworkResource");
            }
            if (jsonObject.get((Object)"noAddingFieldsIrregularly") != null) {
                this.opt_NoAddingFieldsIrregularly = (Boolean)jsonObject.get((Object)"noAddingFieldsIrregularly");
            }
            if (jsonObject.get((Object)"noStructureObjectsCorrectly") != null) {
                this.opt_NoStructureObjectsCorrectly = (Boolean)jsonObject.get((Object)"noStructureObjectsCorrectly");
            }
            if (jsonObject.get((Object)"proxy") != null) {
                this.opt_proxy = this.getStringArrayFromJSONArray((JSONArray)jsonObject.get((Object)"proxy"));
            }
            if (jsonObject.get((Object)"timeinstrument") != null) {
                this.opt_timeinstrument = (Boolean)jsonObject.get((Object)"timeinstrument");
            }
            if (jsonObject.get((Object)"resourceconfig") != null) {
                this.opt_resourceConfig = (String)jsonObject.get((Object)"resourceconfig");
            }
            if (jsonObject.get((Object)"content") != null) {
                this.opt_content = (String)jsonObject.get((Object)"content");
            }
            if (jsonObject.get((Object)"allcontents") != null) {
                this.opt_allcontents = (Boolean)jsonObject.get((Object)"allcontents");
            }
            if (jsonObject.get((Object)"coverageinstrument") != null) {
                this.opt_coverageinstrument = (Boolean)jsonObject.get((Object)"coverageinstrument");
            }
            if (jsonObject.get((Object)"apicount") != null) {
                this.opt_APICount = (Boolean)jsonObject.get((Object)"apicount");
            }
            if (jsonObject.get((Object)"tizen-apis") != null) {
                JSONArray arr = (JSONArray)jsonObject.get((Object)"tizen-apis");
                for (JSONObject item : arr) {
                    for (String verName : item.keySet()) {
                        path = item.get((Object)verName).toString();
                        this.opt_TizenApisDB.add(new TizenDBMap(verName, path));
                    }
                }
            }
            if (jsonObject.get((Object)"type-rule-checker") != null) {
                ArrayList<String> checkerList = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"type-rule-checker"));
                this.opt_enableTypeChecker = new ArrayList<String>();
                for (String num : checkerList) {
                    this.opt_enableTypeChecker.add(num);
                }
            }
            if (jsonObject.get((Object)"webapi-rule-checker") != null) {
                ArrayList<String> checkerList = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"webapi-rule-checker"));
                this.opt_enableWebapiChecker = new ArrayList<String>();
                for (String num : checkerList) {
                    this.opt_enableWebapiChecker.add(num);
                }
            }
            if (jsonObject.get((Object)"coding-rule-checker") != null) {
                ArrayList<String> checkerList = this.getStringArrayListFromJSONArray((JSONArray)jsonObject.get((Object)"coding-rule-checker"));
                this.opt_enableCodingChecker = new ArrayList<String>();
                for (String num : checkerList) {
                    this.opt_enableCodingChecker.add(num);
                }
            }
            if (jsonObject.get((Object)"snapshots") != null) {
                JSONArray arr = (JSONArray)jsonObject.get((Object)"snapshots");
                for (JSONObject item : arr) {
                    for (String snapName : item.keySet()) {
                        path = item.get((Object)snapName).toString();
                        this.opt_SnapshotList.put(snapName, path);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Cannot find " + jsonFileName);
        }
        catch (IOException e) {
            System.out.println("IOException occurs while opening " + jsonFileName);
        }
        catch (ParseException e) {
            System.out.println("Failed to parse " + jsonFileName);
        }
    }

    private int SetOption(String[] args, int index) {
        int ConsumedParameterCount = 0;
        String opt = args[index];
        if (opt.compareTo("-out") == 0 || opt.compareTo("-pretty") == 0 || opt.compareTo("-timeout") == 0 || opt.compareTo("-max-strset-size") == 0 || opt.compareTo("-max-loc-count") == 0 || opt.compareTo("-unroll") == 0 || opt.compareTo("-forin-unroll") == 0 || opt.compareTo("-ddgout") == 0 || opt.compareTo("-ddg0out") == 0 || opt.compareTo("-fgout") == 0 || opt.compareTo("-option") == 0 || opt.compareTo("-load-heap") == 0 || opt.compareTo("-dynamic-path") == 0 || opt.compareTo("-resourceconfig") == 0 || opt.compareTo("-content") == 0 || opt.compareTo("-tizen-version-check") == 0 || opt.compareTo("-tizen-privilege-check") == 0 || opt.compareTo("-svace-out") == 0 || opt.compareTo("-cloc-out") == 0 || opt.compareTo("-browser-compatible") == 0) {
            if (index + 1 >= args.length) {
                this.ErrorMessage = "`" + opt + "` parameter needs an output filename. See help.";
            } else {
                if (opt.compareTo("-out") == 0) {
                    this.opt_OutFileName = args[index + 1];
                } else if (opt.compareTo("-pretty") == 0) {
                    this.opt_Pretty = true;
                    this.opt_PrettyFileName = args[index + 1];
                } else if (opt.compareTo("-load-heap") == 0) {
                    this.opt_useDump = true;
                    this.opt_dumpFileName = args[index + 1];
                } else if (opt.compareTo("-dynamic-path") == 0) {
                    this.opt_dynamicPath = this.ReadDynamicPathJSON(args[index + 1]);
                } else if (opt.compareTo("-timeout") == 0) {
                    this.opt_Timeout = Integer.parseInt(args[index + 1]);
                } else if (opt.compareTo("-max-strset-size") == 0) {
                    this.opt_MaxStrSetSize = Integer.parseInt(args[index + 1]);
                } else if (opt.compareTo("-max-loc-count") == 0) {
                    this.opt_MaxLocCount = Integer.parseInt(args[index + 1]);
                } else if (opt.compareTo("-unroll") == 0) {
                    this.opt_unrollingCount = Integer.parseInt(args[index + 1]);
                } else if (opt.compareTo("-forin-unroll") == 0) {
                    this.opt_forinunrollingCount = Integer.parseInt(args[index + 1]);
                } else if (opt.compareTo("-ddgout") == 0) {
                    this.opt_DDGFileName = args[index + 1];
                } else if (opt.compareTo("-ddg0out") == 0) {
                    this.opt_DDG0FileName = args[index + 1];
                } else if (opt.compareTo("-fgout") == 0) {
                    this.opt_FGFileName = args[index + 1];
                } else if (opt.compareTo("-option") == 0) {
                    this.opt_Option = args[index + 1];
                    this.ReadJSONOption(this.opt_Option);
                } else if (opt.compareTo("-load-heap") == 0) {
                    this.opt_LoadHeap = args[index + 1];
                } else if (opt.compareTo("-resourceconfig") == 0) {
                    this.opt_resourceConfig = args[index + 1];
                } else if (opt.compareTo("-content") == 0) {
                    this.opt_content = args[index + 1];
                } else if (opt.compareTo("-tizen-version-check") == 0) {
                    this.opt_TizenApiVersion = args[index + 1];
                } else if (opt.compareTo("-tizen-privilege-check") == 0) {
                    this.opt_TizenPrivilege = args[index + 1];
                    if (this.opt_Dir == null && !this.opt_JS.isEmpty()) {
                        System.out.println("# [WARNING] : Tizen API privilege checker can't enable in '-js' mode.");
                        this.opt_TizenPrivilege = null;
                    }
                } else if (opt.compareTo("-svace-out") == 0) {
                    this.opt_svaceOut = args[index + 1];
                } else if (opt.compareTo("-browser-compatible") == 0) {
                    this.opt_compatibleCheck = args[index + 1];
                } else if (opt.compareTo("-cloc-out") == 0) {
                    this.opt_clocOut = args[index + 1];
                }
                ConsumedParameterCount = 1;
            }
        } else if (opt.compareTo("-dir") == 0) {
            if (index + 1 >= args.length) {
                this.ErrorMessage = "`" + opt + "` parameter needs an output filename. See help.";
            } else {
                this.opt_Dir = args[index + 1];
                ConsumedParameterCount = 1;
            }
        } else if (opt.compareTo("-html") == 0) {
            if (index + 1 >= args.length) {
                this.ErrorMessage = "`" + opt + "` parameter needs an output filename. See help.";
            } else {
                this.opt_HTML = args[index + 1];
                ConsumedParameterCount = 1;
            }
        } else if (opt.compareTo("-js") == 0 || opt.compareTo("-widldb") == 0 || opt.compareTo("-tsdb") == 0 || opt.compareTo("-prejs") == 0 || opt.compareTo("-postjs") == 0 || opt.compareTo("-surpass") == 0) {
            if (index + 1 >= args.length) {
                this.ErrorMessage = "`" + opt + "` parameter needs an output filename. See help.";
            } else {
                List<String> lst = null;
                lst = opt.compareTo("-js") == 0 ? this.opt_JS : (opt.compareTo("-widldb") == 0 ? this.opt_WIDLDB : (opt.compareTo("-prejs") == 0 ? this.opt_PreJS : (opt.compareTo("-postjs") == 0 ? this.opt_PostJS : (opt.compareTo("-surpass") == 0 ? this.opt_Surpass : (opt.compareTo("-tsdb") == 0 ? this.opt_TSDB : new ArrayList<String>())))));
                for (int i = index + 1; i < args.length; ++i) {
                    if (args[i].length() > 0 && args[i].charAt(0) == '-') {
                        ConsumedParameterCount = i - index - 1;
                        break;
                    }
                    lst.add(args[i]);
                }
            }
        } else if (opt.compareTo("-proxy") == 0) {
            if (index + 2 >= args.length) {
                this.ErrorMessage = "`" + opt + "` parameter needs an IP address and a port number. See help.";
            } else {
                this.opt_proxy = new String[2];
                this.opt_proxy[0] = args[index + 1];
                this.opt_proxy[1] = args[index + 2];
                ConsumedParameterCount = 2;
            }
        } else if (opt.compareTo("-referencephone") == 0) {
            this.opt_referencephone = true;
        } else if (opt.compareTo("-jssnapshot") == 0) {
            this.opt_jssnapshot = true;
        } else if (opt.compareTo("-time") == 0) {
            this.opt_Time = true;
        } else if (opt.compareTo("-module") == 0) {
            this.opt_Module = true;
        } else if (opt.compareTo("-ignoreErrorOnAST") == 0) {
            this.opt_IgnoreErrorOnAST = true;
        } else if (opt.compareTo("-model") == 0) {
            this.opt_Model = true;
        } else if (opt.compareTo("-mozilla") == 0) {
            this.opt_Mozilla = true;
        } else if (opt.compareTo("-verbose1") == 0) {
            this.opt_Verbose1 = true;
        } else if (opt.compareTo("-verbose2") == 0) {
            this.opt_Verbose2 = true;
        } else if (opt.compareTo("-verbose3") == 0) {
            this.opt_Verbose3 = true;
        } else if (opt.compareTo("-locclone") == 0) {
            this.opt_LocClone = true;
        } else if (opt.compareTo("-pretty") == 0) {
            this.opt_Pretty = true;
        } else if (opt.compareTo("-trycatch") == 0) {
            this.opt_TryCatch = true;
        } else if (opt.compareTo("-dev") == 0) {
            this.opt_DeveloperMode = true;
        } else if (opt.compareTo("-erroronly") == 0) {
            this.opt_ErrorOnly = true;
        } else if (opt.compareTo("-test") == 0) {
            this.opt_Test = true;
        } else if (opt.compareTo("-library") == 0) {
            this.opt_Library = true;
        } else if (opt.compareTo("-memdump") == 0) {
            this.opt_MemDump = true;
        } else if (opt.compareTo("-exitdump") == 0) {
            this.opt_ExitDump = true;
        } else if (opt.compareTo("-statdump") == 0) {
            this.opt_StatDump = true;
        } else if (opt.compareTo("-bottomdump") == 0) {
            this.opt_BottomDump = true;
        } else if (opt.compareTo("-scriptdump") == 0) {
            this.opt_ScriptDump = true;
        } else if (opt.compareTo("-visual") == 0) {
            this.opt_Visual = true;
        } else if (opt.compareTo("-checkResult") == 0) {
            this.opt_CheckResult = true;
        } else if (opt.compareTo("-no-assert") == 0) {
            this.opt_NoAssert = true;
        } else if (opt.compareTo("-compare") == 0) {
            this.opt_Compare = true;
        } else if (opt.compareTo("-context-loop") == 0) {
            this.opt_ContextLoop = true;
        } else if (opt.compareTo("-context-trace") == 0) {
            this.opt_ContextTrace = true;
        } else if (opt.compareTo("-context-insensitive") == 0) {
            this.opt_ContextInsensitive = true;
        } else if (opt.compareTo("-context-1-callsite") == 0) {
            this.opt_Context1Callsite = true;
        } else if (opt.compareTo("-context-2-callsite") == 0) {
            this.opt_Context2Callsite = true;
        } else if (opt.compareTo("-context-3-callsite") == 0) {
            this.opt_Context3Callsite = true;
        } else if (opt.compareTo("-context-4-callsite") == 0) {
            this.opt_Context4Callsite = true;
        } else if (opt.compareTo("-context-5-callsite") == 0) {
            this.opt_Context5Callsite = true;
        } else if (opt.compareTo("-context-10-callsite") == 0) {
            this.opt_Context10Callsite = true;
        } else if (opt.compareTo("-context-callsite-set") == 0) {
            this.opt_ContextCallsiteSet = true;
        } else if (opt.compareTo("-context-1-object") == 0) {
            this.opt_Context1Object = true;
        } else if (opt.compareTo("-context-tajs") == 0) {
            this.opt_ContextTAJS = true;
        } else if (opt.compareTo("-context-1-callsite-and-object") == 0) {
            this.opt_Context1CallsiteAndObject = true;
        } else if (opt.compareTo("-context-2-callsite-and-object") == 0) {
            this.opt_Context2CallsiteAndObject = true;
        } else if (opt.compareTo("-context-3-callsite-and-object") == 0) {
            this.opt_Context3CallsiteAndObject = true;
        } else if (opt.compareTo("-loud") == 0) {
            this.opt_Loud = true;
        } else if (opt.compareTo("-opt_WebAPIException_noNameSpace") == 0) {
            this.opt_WebAPIException_noNameSpace = true;
        } else if (opt.compareTo("-context-4-callsite-and-object") == 0) {
            this.opt_Context4CallsiteAndObject = true;
        } else if (opt.compareTo("-context-5-callsite-and-object") == 0) {
            this.opt_Context5CallsiteAndObject = true;
        } else if (opt.compareTo("-context-1-callsite-and-identity") == 0) {
            this.opt_Context1CallsiteAndIdentity = true;
        } else if (opt.compareTo("-context-2-callsite-and-identity") == 0) {
            this.opt_Context2CallsiteAndIdentity = true;
        } else if (opt.compareTo("-context-3-callsite-and-identity") == 0) {
            this.opt_Context3CallsiteAndIdentity = true;
        } else if (opt.compareTo("-context-4-callsite-and-identity") == 0) {
            this.opt_Context4CallsiteAndIdentity = true;
        } else if (opt.compareTo("-context-5-callsite-and-identity") == 0) {
            this.opt_Context5CallsiteAndIdentity = true;
        } else if (opt.compareTo("-context-1-callsite-or-object") == 0) {
            this.opt_Context1CallsiteOrObject = true;
        } else if (opt.compareTo("-context-identity") == 0) {
            this.opt_ContextIdentity = true;
        } else if (opt.compareTo("-pre-context-sensitive") == 0) {
            this.opt_PreContextSensitive = true;
        } else if (opt.compareTo("-unsound") == 0) {
            this.opt_Unsound = true;
        } else if (opt.compareTo("-nostop") == 0) {
            this.opt_noStop = true;
        } else if (opt.compareTo("-codingGuide") == 0) {
            this.opt_codingGuide = true;
        } else if (opt.compareTo("-dom") == 0) {
            this.opt_Dom = true;
        } else if (opt.compareTo("-domprop") == 0) {
            this.opt_Domprop = true;
        } else if (opt.compareTo("-disableEvent") == 0) {
            this.opt_disEvent = true;
        } else if (opt.compareTo("-loop") == 0) {
            this.opt_loop = true;
        } else if (opt.compareTo("-tizen") == 0) {
            this.opt_Tizen = true;
        } else if (opt.compareTo("-jq") == 0) {
            this.opt_jQuery = true;
        } else if (opt.compareTo("-nojq") == 0) {
            this.opt_jQuery = false;
        } else if (opt.compareTo("-single-thread") == 0) {
            this.opt_SingleThread = true;
        } else if (opt.compareTo("-multi-thread") == 0) {
            this.opt_MultiThread = true;
        } else if (opt.compareTo("-return-state-on") == 0) {
            this.opt_ReturnStateOn = true;
        } else if (opt.compareTo("-return-state-off") == 0) {
            this.opt_ReturnStateOff = true;
        } else if (opt.compareTo("-fcov") == 0) {
            this.opt_FunctionCoverage = true;
        } else if (opt.compareTo("-worklist-order-default") == 0) {
            this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_DEFAULT();
        } else if (opt.compareTo("-worklist-order-fifo") == 0) {
            this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_FIFO();
        } else if (opt.compareTo("-worklist-order-lifo") == 0) {
            this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_LIFO();
        } else if (opt.compareTo("-worklist-order-count") == 0) {
            this.opt_WorklistOrder = Worklist.WORKLIST_ORDER_COUNT();
        } else if (opt.compareTo("-console") == 0) {
            this.opt_debugger = true;
        } else if (opt.compareTo("-detect") == 0) {
            this.opt_Detect = true;
        } else if (opt.compareTo("-noHTMLNetworkResource") == 0) {
            this.opt_NoHTMLNetworkResource = true;
        } else if (opt.compareTo("-noAddingFieldsIrregularly") == 0) {
            this.opt_NoAddingFieldsIrregularly = true;
        } else if (opt.compareTo("-noStructureObjectsCorrectly") == 0) {
            this.opt_NoStructureObjectsCorrectly = true;
        } else if (opt.compareTo("-timeinstrument") == 0) {
            this.opt_timeinstrument = true;
        } else if (opt.compareTo("-allcontents") == 0) {
            this.opt_allcontents = true;
        } else if (opt.compareTo("-coverageinstrument") == 0) {
            this.opt_coverageinstrument = true;
        } else if (opt.compareTo("-apicount") == 0) {
            this.opt_APICount = true;
        } else if (opt.compareTo("-jsa-plugin") == 0) {
            this.opt_JSAPluginMode = true;
        } else if (opt.compareTo("-wcv") == 0) {
            this.opt_wcv = true;
        } else {
            this.ErrorMessage = "`" + opt + "` is no match for option parameter.";
        }
        return ConsumedParameterCount;
    }
}

