/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.bug_detector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import kr.ac.kaist.jsaf.bug_detector.BugItem;
import kr.ac.kaist.jsaf.nodes_util.Span;

public class AnalysisResult {
    public static final int BUG_TYPE_REFERENCE_ERROR = 1;
    public static final int BUG_TYPE_ERROR = 2;
    public static final int BUG_TYPE_WARNING = 3;
    public static final int BUG_API_ERROR = 4;
    public static final int BUG_API_WARNING = 5;
    public static final int BUG_CODING_GUIDE = 6;
    public static final int BUG_BROWSER_COMPATIBLE = 7;
    public static final int BUG_WIDGET_CONTENT_ERROR = 8;
    public static final int BUG_WIDGET_CONTENT_WARNING = 9;
    public static final int BUG_TERMINATION = 100;
    static final int CATEGORY_TYPE_ABSENT_READ = 10;
    static final int CATEGORY_TYPE_BUILT_IN = 11;
    static final int CATEGORY_TYPE_CALL_CONSTRUCTOR = 12;
    static final int CATEGORY_TYPE_DEFAULT_VALUE = 15;
    static final int CATEGORY_TYPE_TYPE_CONVERSION = 16;
    static final int CATEGORY_TYPE_SHADOW_FUNC = 20;
    static final int CATEGORY_TYPE_SHADOW_PARAM = 21;
    static final int CATEGORY_TYPE_SHADOW_VAR = 22;
    static final int CATEGORY_TYPE_COND_BRANCH = 23;
    static final int CATEGORY_TYPE_GLOBAL_THIS = 24;
    static final int CATEGORY_TYPE_UNDEFINED_USE = 25;
    static final int CATEGORY_TYPE_RANGE_ERROR = 26;
    static final int CATEGORY_TYPE_OBJECT_API = 27;
    static final int CATEGORY_TYPE_BINARY_OP = 29;
    static final int CATEGORY_TYPE_URI_ERROR = 200;
    static final int CATEGORY_TYPE_JSON_ERROR = 201;
    static final int CATEGORY_STRICT_MODE = 202;
    static final int CATEGORY_API_INVALID_NAMESPACE = 30;
    static final int CATEGORY_API_WRONG_ARGUMENTS = 31;
    static final int CATEGORY_API_MISSING_ERROR_CB = 32;
    static final int CATEGORY_API_NO_EXECPTION_HANDLING = 33;
    static final int CATEGORY_API_WRONG_ARGUMENTS_TYPE = 34;
    static final int CATEGORY_API_WRONG_DICTIONARY_TYPE = 36;
    static final int CATEGORY_API_NO_MODIFY_OBJECT = 37;
    static final int CATEGORY_API_TIZEN_VERSION = 38;
    static final int CATEGORY_API_TIZEN_PRIVILEGE = 39;
    static final int CATEGORY_CODING_01_ARRAY = 50;
    static final int CATEGORY_CODING_02_VAR = 51;
    static final int CATEGORY_CODING_03_CAPTURE = 52;
    static final int CATEGORY_CODING_04_SEMI = 53;
    static final int CATEGORY_CODING_05_DEL = 54;
    static final int CATEGORY_CODING_06_STR = 55;
    static final int CATEGORY_CODING_07_CONST = 56;
    static final int CATEGORY_CODING_08_BUILT = 57;
    static final int CATEGORY_CODING_09_PIM = 58;
    static final int CATEGORY_CODING_10_FONIN = 59;
    static final int CATEGORY_CODING_11_DOUBLE_QUOTE = 60;
    static final int CATEGORY_CODING_12_OMIT_SEMI = 61;
    static final int CATEGORY_CODING_13_BEGIN_OP = 62;
    static final int CATEGORY_CODING_14_END_COMMA = 63;
    static final int CATEGORY_CODING_15_OPEN_BRACE = 64;
    static final int CATEGORY_CODING_16_MAX_LENGTH = 65;
    static final int CATEGORY_CODING_17_WRONG_INDENT = 66;
    static final int CATEGORY_TIME_LIMIT_EXCEEDED_ERROR = 100;
    static final int CATEGORY_SPACE_LIMIT_EXCEEDED_ERROR = 101;
    static final int CATEGORY_OTHER_ERROR = 102;
    static final int CATEGORY_BROWSER_COMPATIBLE_ERROR = 300;
    private ArrayList<BugItem> bugInfoList;
    private static HashMap<Integer, ArrayList<String>> bugCategoryMap = new HashMap();
    private static final String timeOutMsg = "Time limit %s(min) is exceeded while analyzing.";
    private static final String spaceOutMsg = "Max location count is exceeded while analyzing.";

    private static ArrayList<String> createArrayList(String bug, String checkerGroup, String severity) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(bug);
        temp.add(checkerGroup);
        temp.add(severity);
        return temp;
    }

    public ArrayList<String> getBugGroupDetail(int id) {
        Integer num = new Integer(id);
        if (bugCategoryMap.containsKey(num)) {
            return bugCategoryMap.get(num);
        }
        return null;
    }

    public void initBugInfoList() {
        this.bugInfoList = new ArrayList();
    }

    public ArrayList<BugItem> getBugInfoList() {
        Collections.sort(this.bugInfoList, new Comparator<BugItem>(){

            @Override
            public int compare(BugItem bug1, BugItem bug2) {
                return bug1.filePath.compareTo(bug2.filePath);
            }
        });
        Collections.sort(this.bugInfoList, new Comparator<BugItem>(){

            @Override
            public int compare(BugItem bug1, BugItem bug2) {
                return bug1.lineNumber < bug2.lineNumber ? -1 : (bug1.lineNumber == bug2.lineNumber ? 0 : 1);
            }
        });
        return this.bugInfoList;
    }

    public void addBug(int bugLevel, int bugCategory, String checkerName, String message, String filePath, int lineNumber, int columnNumber, Span span) {
        this.bugInfoList.add(new BugItem(bugLevel, bugCategory, checkerName, message, filePath, lineNumber, columnNumber, span.toString()));
    }

    public void addInfo(String message) {
        this.bugInfoList.add(new BugItem(100, 102, "", message, "ERR", 0, 0, ""));
    }

    public void setTimeOut(int timeOut) {
        this.bugInfoList.add(new BugItem(100, 100, "", String.format(timeOutMsg, Integer.toString(timeOut)), "TIMEOUT", 0, 0, ""));
    }

    public void setSpaceOut() {
        this.bugInfoList.add(new BugItem(100, 101, "", String.format(spaceOutMsg, new Object[0]), "MEMORYERR", 0, 0, ""));
    }

    static {
        bugCategoryMap.put(new Integer(10), AnalysisResult.createArrayList("Type Error", "Reading absent property and variable", "High"));
        bugCategoryMap.put(new Integer(11), AnalysisResult.createArrayList("Type Error", "Browser, DOM, Built-in API misuse", "High"));
        bugCategoryMap.put(new Integer(12), AnalysisResult.createArrayList("Type Error", "Calling function as a constructor error", "Medium"));
        bugCategoryMap.put(new Integer(25), AnalysisResult.createArrayList("Type Error", "Improper 'undefined' value use", "Medium"));
        bugCategoryMap.put(new Integer(15), AnalysisResult.createArrayList("Type Error", "Assigning a non-function value", "Medium"));
        bugCategoryMap.put(new Integer(16), AnalysisResult.createArrayList("Type Error", "Implicit type-conversion in equality comparison", "Medium"));
        bugCategoryMap.put(new Integer(20), AnalysisResult.createArrayList("Type Error", "Function is shadowed", "Medium"));
        bugCategoryMap.put(new Integer(21), AnalysisResult.createArrayList("Type Error", "Parameter is shadowed", "Medium"));
        bugCategoryMap.put(new Integer(22), AnalysisResult.createArrayList("Type Error", "Variable is shadowed", "Medium"));
        bugCategoryMap.put(new Integer(23), AnalysisResult.createArrayList("Type Error", "Conditional expression is always true or false", "Medium"));
        bugCategoryMap.put(new Integer(24), AnalysisResult.createArrayList("Type Error", "'this' refers the global object", "Medium"));
        bugCategoryMap.put(new Integer(26), AnalysisResult.createArrayList("Type Error", "Browser, DOM, Built-in API range warring", "Medium"));
        bugCategoryMap.put(new Integer(29), AnalysisResult.createArrayList("Type Error", "Right-hand side operand is Type error", "Medium"));
        bugCategoryMap.put(new Integer(27), AnalysisResult.createArrayList("Type Error", "'Object' API misuse", "Low"));
        bugCategoryMap.put(new Integer(200), AnalysisResult.createArrayList("Type Error", "Invalid URI argument", "Low"));
        bugCategoryMap.put(new Integer(201), AnalysisResult.createArrayList("Type Error", "Calling JSON.stringify with a cyclic value", "Low"));
        bugCategoryMap.put(new Integer(202), AnalysisResult.createArrayList("Type Error", "Not initialized in strict mode", "Low"));
        bugCategoryMap.put(new Integer(30), AnalysisResult.createArrayList("Web API Usage", "Accessing undefined API", "High"));
        bugCategoryMap.put(new Integer(31), AnalysisResult.createArrayList("Web API Usage", "Wrong arguments number", "High"));
        bugCategoryMap.put(new Integer(32), AnalysisResult.createArrayList("Web API Usage", "Missing error handling", "Medium"));
        bugCategoryMap.put(new Integer(33), AnalysisResult.createArrayList("Web API Usage", "Missing exception handling", "Medium"));
        bugCategoryMap.put(new Integer(34), AnalysisResult.createArrayList("Web API Usage", "Wrong argument type", "High"));
        bugCategoryMap.put(new Integer(36), AnalysisResult.createArrayList("Web API Usage", "Wrong dictionary type", "High"));
        bugCategoryMap.put(new Integer(38), AnalysisResult.createArrayList("Web API Usage", "API version compatibility", "High"));
        bugCategoryMap.put(new Integer(39), AnalysisResult.createArrayList("Web API Usage", "API privilege missing", "High"));
        bugCategoryMap.put(new Integer(51), AnalysisResult.createArrayList("Coding Rule", "Use var to declare variables", "High"));
        bugCategoryMap.put(new Integer(52), AnalysisResult.createArrayList("Coding Rule", "Don't capture variables in functions", "Medium"));
        bugCategoryMap.put(new Integer(50), AnalysisResult.createArrayList("Coding Rule", "Don't declare arguments Array in functions", "Medium"));
        bugCategoryMap.put(new Integer(53), AnalysisResult.createArrayList("Coding Rule", "Don't use extra semicolon", "Medium"));
        bugCategoryMap.put(new Integer(54), AnalysisResult.createArrayList("Coding Rule", "Don't use the delete keyword", "Low"));
        bugCategoryMap.put(new Integer(55), AnalysisResult.createArrayList("Coding Rule", "Don't use multi-line string literals", "Low"));
        bugCategoryMap.put(new Integer(56), AnalysisResult.createArrayList("Coding Rule", "Don't use Array or Object constructors", "Low"));
        bugCategoryMap.put(new Integer(57), AnalysisResult.createArrayList("Coding Rule", "Don't modify prototypes of built-in objects", "Low"));
        bugCategoryMap.put(new Integer(58), AnalysisResult.createArrayList("Coding Rule", "Don't convert wrapper objects to primitives", "Low"));
        bugCategoryMap.put(new Integer(59), AnalysisResult.createArrayList("Coding Rule", "Don't use for-in with arrays", "Low"));
        bugCategoryMap.put(new Integer(60), AnalysisResult.createArrayList("Coding Rule", "Don't use double-quoted strings", "Low"));
        bugCategoryMap.put(new Integer(61), AnalysisResult.createArrayList("Coding Rule", "Don't omit semicolons", "Medium"));
        bugCategoryMap.put(new Integer(62), AnalysisResult.createArrayList("Coding Rule", "Don't begin with operators", "Low"));
        bugCategoryMap.put(new Integer(63), AnalysisResult.createArrayList("Coding Rule", "Don't end with commas in literals", "Medium"));
        bugCategoryMap.put(new Integer(64), AnalysisResult.createArrayList("Coding Rule", "Don't use wrong opening brace", "Low"));
        bugCategoryMap.put(new Integer(65), AnalysisResult.createArrayList("Coding Rule", "Don't exceed 81 characters in a line", "Low"));
        bugCategoryMap.put(new Integer(66), AnalysisResult.createArrayList("Coding Rule", "Don't use wrong indentation", "Low"));
        bugCategoryMap.put(new Integer(67), AnalysisResult.createArrayList("Coding Rule", "Don't use unclosed Strings", "High(Syntax Error)"));
        bugCategoryMap.put(new Integer(68), AnalysisResult.createArrayList("Coding Rule", "Don't use unclosed Comments", "High(Syntax Error)"));
        bugCategoryMap.put(new Integer(69), AnalysisResult.createArrayList("Coding Rule", "Don't use unclosed Braces", "High(Syntax Error)"));
        bugCategoryMap.put(new Integer(300), AnalysisResult.createArrayList("Browser Compatibility", "Not supported APIs", "High"));
    }
}

