/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import kr.ac.kaist.jsaf.useful.Useful;

public class Path {
    static String pathSep = File.pathSeparator;
    List<File> dirs;

    public Path(String path) {
        this(Path.stringToFiles(path));
    }

    public static String toDotted(Object o) {
        String s = String.valueOf(o);
        return s;
    }

    private static List<File> stringToFiles(String path) {
        ArrayList<File> dirs = new ArrayList<File>();
        String p = pathSep;
        if (path.startsWith(":")) {
            p = ":";
            path = path.substring(1);
        } else if (path.startsWith(";")) {
            p = ";";
            path = path.substring(1);
        }
        path = Useful.substituteVars(path);
        StringTokenizer st = new StringTokenizer(path, p);
        while (st.hasMoreTokens()) {
            File f;
            String e = st.nextToken();
            if ("".equals(e) || !(f = new File(e)).isDirectory()) continue;
            dirs.add(f);
        }
        return dirs;
    }

    public Path(List<File> dirs) {
        this.dirs = dirs;
    }

    public String toString() {
        return Useful.listInDelimiters("", this.dirs, "", pathSep);
    }

    public Path prepend(Path other) {
        return new Path(Useful.concat(other.dirs, this.dirs));
    }

    public Path append(Path other) {
        return new Path(Useful.concat(this.dirs, other.dirs));
    }

    public Path prepend(String s) {
        return this.prepend(new File(s));
    }

    public Path prepend(File f) {
        return new Path(Useful.prepend(f, this.dirs));
    }

    public File munch(File prefix, String slashedSuffix, String dottedSuffix) {
        File f = new File(prefix, dottedSuffix);
        if (f.isFile()) {
            return f;
        }
        int seploc = slashedSuffix.lastIndexOf(47);
        while (seploc > 0) {
            File trial;
            String dirsuffix = dottedSuffix.substring(0, seploc);
            File dir = new File(prefix, dirsuffix);
            if (dir.isDirectory() && (trial = this.munch(dir, slashedSuffix.substring(seploc + 1), dottedSuffix.substring(seploc + 1))) != null) {
                return trial;
            }
            seploc = dirsuffix.lastIndexOf(46);
        }
        return null;
    }

    public File findFile(String s) throws FileNotFoundException {
        File inappropriateFile = null;
        File unreadableFile = null;
        s = s.replace(File.separator, "/");
        String s_dotted = s.replace("/", ".");
        if (s.startsWith("/")) {
            File f = new File(s);
            if (f.isFile()) {
                if (f.canRead()) {
                    return f;
                }
                unreadableFile = f;
            } else if (f.exists()) {
                inappropriateFile = f;
            }
        } else {
            for (File d : this.dirs) {
                File f = this.munch(d, s, s_dotted);
                if (f == null) continue;
                return f;
            }
        }
        if (unreadableFile != null) {
            throw new FileNotFoundException("Readable file " + s + " not found in directories " + this.dirs + "; the last unreadable match was " + unreadableFile);
        }
        if (inappropriateFile != null) {
            throw new FileNotFoundException("Normal file " + s + " not found in directories " + this.dirs + "; the last abnormal match was " + inappropriateFile);
        }
        throw new FileNotFoundException("File " + s + " not found in directories " + this.dirs);
    }

    public String findDirName(String s, String defaultDir) {
        try {
            return this.findDir(s).getCanonicalPath();
        }
        catch (IOException ex) {
            return defaultDir;
        }
    }

    public File findDir(String s) throws FileNotFoundException {
        File inappropriateFile = null;
        if (s.startsWith("/") || s.startsWith(File.separator)) {
            File f = new File(s);
            if (f.isDirectory()) {
                return f;
            }
            if (f.exists()) {
                inappropriateFile = f;
            }
        } else {
            for (File d : this.dirs) {
                File f = new File(d, s);
                if (f.isDirectory()) {
                    return f;
                }
                if (!f.exists()) continue;
                inappropriateFile = f;
            }
        }
        if (inappropriateFile != null) {
            throw new FileNotFoundException("Directory " + s + " not found in directories " + this.dirs + "; the last non-directory name match was " + inappropriateFile);
        }
        throw new FileNotFoundException("File " + s + " not found in directories " + this.dirs);
    }

    public int length() {
        return this.dirs.size();
    }
}

