/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import java.util.List;
import kr.ac.kaist.jsaf.nodes.IRAbstractNode;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRAbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRFunDecl;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor;
import kr.ac.kaist.jsaf.nodes.IRNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.IRSpanInfo;
import kr.ac.kaist.jsaf.nodes.IRStmt;
import kr.ac.kaist.jsaf.nodes.IRVarStmt;
import kr.ac.kaist.jsaf.nodes.TreeWalker;

public class IRRoot
extends IRAbstractNode {
    private final List<IRFunDecl> _fds;
    private final List<IRVarStmt> _vds;
    private final List<IRStmt> _irs;

    public IRRoot(IRSpanInfo in_info, List<IRFunDecl> in_fds, List<IRVarStmt> in_vds, List<IRStmt> in_irs) {
        super(in_info);
        if (in_fds == null) {
            throw new IllegalArgumentException("Parameter 'fds' to the IRRoot constructor was null");
        }
        this._fds = in_fds;
        if (in_vds == null) {
            throw new IllegalArgumentException("Parameter 'vds' to the IRRoot constructor was null");
        }
        this._vds = in_vds;
        if (in_irs == null) {
            throw new IllegalArgumentException("Parameter 'irs' to the IRRoot constructor was null");
        }
        this._irs = in_irs;
    }

    public final List<IRFunDecl> getFds() {
        return this._fds;
    }

    public final List<IRVarStmt> getVds() {
        return this._vds;
    }

    public final List<IRStmt> getIrs() {
        return this._irs;
    }

    @Override
    public <RetType> RetType accept(IRAbstractNodeVisitor<RetType> visitor) {
        return visitor.forIRRoot(this);
    }

    @Override
    public <RetType> RetType accept(IRNodeVisitor<RetType> visitor) {
        return visitor.forIRRoot(this);
    }

    @Override
    public void accept(IRAbstractNodeVisitor_void visitor) {
        visitor.forIRRoot(this);
    }

    @Override
    public void accept(IRNodeVisitor_void visitor) {
        visitor.forIRRoot(this);
    }

    public boolean equals(Object obj) {
        List<IRStmt> casted_irs;
        List<IRVarStmt> casted_vds;
        List<IRFunDecl> casted_fds;
        IRSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IRRoot casted = (IRRoot)obj;
        IRSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        List<IRFunDecl> temp_fds = this.getFds();
        if (temp_fds != (casted_fds = casted.getFds()) && !temp_fds.equals(casted_fds)) {
            return false;
        }
        List<IRVarStmt> temp_vds = this.getVds();
        if (temp_vds != (casted_vds = casted.getVds()) && !temp_vds.equals(casted_vds)) {
            return false;
        }
        List<IRStmt> temp_irs = this.getIrs();
        return temp_irs == (casted_irs = casted.getIrs()) || temp_irs.equals(casted_irs);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        IRSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        List<IRFunDecl> temp_fds = this.getFds();
        code ^= temp_fds.hashCode();
        List<IRVarStmt> temp_vds = this.getVds();
        code ^= temp_vds.hashCode();
        List<IRStmt> temp_irs = this.getIrs();
        return code ^= temp_irs.hashCode();
    }

    protected IRRoot() {
        this._fds = null;
        this._vds = null;
        this._irs = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IRRoot", 4)) {
            List<IRStmt> temp_irs;
            List<IRVarStmt> temp_vds;
            List<IRFunDecl> temp_fds;
            IRSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("fds", temp_fds = this.getFds())) {
                if (w.visitIterated(temp_fds)) {
                    int i_temp_fds = 0;
                    for (IRFunDecl elt_temp_fds : temp_fds) {
                        if (w.visitIteratedElement(i_temp_fds, elt_temp_fds)) {
                            if (elt_temp_fds == null) {
                                w.visitNull();
                            } else {
                                elt_temp_fds.walk(w);
                            }
                        }
                        ++i_temp_fds;
                    }
                    w.endIterated(temp_fds, i_temp_fds);
                }
                w.endNodeField("fds", temp_fds);
            }
            if (w.visitNodeField("vds", temp_vds = this.getVds())) {
                if (w.visitIterated(temp_vds)) {
                    int i_temp_vds = 0;
                    for (IRVarStmt elt_temp_vds : temp_vds) {
                        if (w.visitIteratedElement(i_temp_vds, elt_temp_vds)) {
                            if (elt_temp_vds == null) {
                                w.visitNull();
                            } else {
                                elt_temp_vds.walk(w);
                            }
                        }
                        ++i_temp_vds;
                    }
                    w.endIterated(temp_vds, i_temp_vds);
                }
                w.endNodeField("vds", temp_vds);
            }
            if (w.visitNodeField("irs", temp_irs = this.getIrs())) {
                if (w.visitIterated(temp_irs)) {
                    int i_temp_irs = 0;
                    for (IRStmt elt_temp_irs : temp_irs) {
                        if (w.visitIteratedElement(i_temp_irs, elt_temp_irs)) {
                            if (elt_temp_irs == null) {
                                w.visitNull();
                            } else {
                                elt_temp_irs.walk(w);
                            }
                        }
                        ++i_temp_irs;
                    }
                    w.endIterated(temp_irs, i_temp_irs);
                }
                w.endNodeField("irs", temp_irs);
            }
            w.endNode(this, "IRRoot", 4);
        }
    }
}

