/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.analysis.visualization;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import kr.ac.kaist.jsaf.analysis.cfg.CFG;
import kr.ac.kaist.jsaf.exceptions.JSAFError$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CGWriter$
implements ScalaObject {
    public static final CGWriter$ MODULE$;

    static {
        new CGWriter$();
    }

    public String NormalNodeShape() {
        return "fontname=\"Consolas\" shape=record, fontsize=10";
    }

    public String NormalEdgeStyle() {
        return "fontname=\"Consolas\" style=solid";
    }

    public String ExcEdgeStyle() {
        return "fontname=\"Consolas\" style=dashed,label=\"exc\"";
    }

    public String call2AftcallEdgeStyle() {
        return "fontname=\"Consolas\" style=dotted,color=gray,dir=none";
    }

    public String exit2ExcExitEdgeStyle() {
        return "fontname=\"Consolas\" style=invis,dir=none";
    }

    public String newLine() {
        return ";\n\t";
    }

    public String nodeShape(String shape) {
        return new StringBuilder().append((Object)"[").append((Object)shape).append((Object)"]").toString();
    }

    public String edgeStyle(String style) {
        return new StringBuilder().append((Object)"[").append((Object)style).append((Object)"]").toString();
    }

    public String escape(char[] src) {
        char[] cs$1 = Array$.MODULE$.apply('<', (Seq)Predef$.MODULE$.wrapCharArray(new char[]{'>', '|', '\"', '\\'}));
        ObjectRef sb$1 = new ObjectRef((Object)new StringBuilder());
        Predef$.MODULE$.charArrayOps(src).foreach((Function1)new Serializable(cs$1, sb$1){
            public static final long serialVersionUID;
            private final char[] cs$1;
            private final ObjectRef sb$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(char ch) {
                return Predef$.MODULE$.charArrayOps(this.cs$1).contains((Object)BoxesRunTime.boxToCharacter((char)ch)) ? ((StringBuilder)this.sb$1.elem).append(new StringBuilder().append((Object)"\\").append((Object)BoxesRunTime.boxToCharacter((char)ch)).toString()) : ((StringBuilder)this.sb$1.elem).append(ch);
            }
            {
                this.cs$1 = cArray;
                this.sb$1 = objectRef;
            }
        });
        return ((StringBuilder)sb$1.elem).toString();
    }

    public String name(CFG cfg, int fid) {
        return this.escape((char[])Predef$.MODULE$.augmentString(cfg.getFuncName(fid)).toArray((ClassManifest)Manifest$.MODULE$.Char()));
    }

    public String drawEdge(CFG cfg$1, int caller, Set<Object> callees) {
        StringBuilder sb$2 = new StringBuilder();
        sb$2.append(new StringBuilder().append((Object)"\"").append((Object)this.name(cfg$1, caller)).append((Object)"\"").toString()).append("->{");
        callees.foreach((Function1)new Serializable(cfg$1, sb$2){
            public static final long serialVersionUID;
            private final CFG cfg$1;
            private final StringBuilder sb$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(int callee) {
                return this.sb$2.append(new StringBuilder().append((Object)"\"").append((Object)CGWriter$.MODULE$.name(this.cfg$1, callee)).append((Object)"\"").toString()).append(";");
            }
            {
                this.cfg$1 = cFG;
                this.sb$2 = stringBuilder;
            }
        });
        sb$2.append("}").append(this.edgeStyle(this.NormalEdgeStyle()));
        return sb$2.toString();
    }

    public String drawNode(CFG cfg$2, int caller, Set<Object> callees) {
        ObjectRef sb$3 = new ObjectRef((Object)new StringBuilder());
        ((StringBuilder)sb$3.elem).append(new StringBuilder().append((Object)"\"").append((Object)this.name(cfg$2, caller)).append((Object)"\"]").append((Object)this.nodeShape(this.NormalNodeShape())).append((Object)this.newLine()).toString());
        callees.foreach((Function1)new Serializable(cfg$2, sb$3){
            public static final long serialVersionUID;
            private final CFG cfg$2;
            private final ObjectRef sb$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(int callee) {
                return ((StringBuilder)this.sb$3.elem).append(new StringBuilder().append((Object)"\"").append((Object)CGWriter$.MODULE$.name(this.cfg$2, callee)).append((Object)"\"").append((Object)CGWriter$.MODULE$.nodeShape(CGWriter$.MODULE$.NormalNodeShape())).append((Object)CGWriter$.MODULE$.newLine()).toString());
            }
            {
                this.cfg$2 = cFG;
                this.sb$3 = objectRef;
            }
        });
        return ((StringBuilder)sb$3.elem).toString();
    }

    public String drawGraph(CFG cfg$3, Map<Object, Set<Object>> m) {
        StringBuilder sb$4 = new StringBuilder();
        sb$4.append("digraph \"CallGraph\" {\n");
        sb$4.append("\tfontsize=12;node [fontsize=12];edge [fontsize=12];\n\t");
        m.foreach((Function1)new Serializable(cfg$3, sb$4){
            public static final long serialVersionUID;
            private final CFG cfg$3;
            private final StringBuilder sb$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(Tuple2<Object, Set<Object>> call) {
                this.sb$4.append(CGWriter$.MODULE$.drawNode(this.cfg$3, call._1$mcI$sp(), (Set<Object>)((Set)call._2())));
                return this.sb$4.append(CGWriter$.MODULE$.drawEdge(this.cfg$3, call._1$mcI$sp(), (Set<Object>)((Set)call._2())));
            }
            {
                this.cfg$3 = cFG;
                this.sb$4 = stringBuilder;
            }
        });
        return sb$4.append("\n}\n").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spawnDot(String dotExe, String outputFile, File dotFile) {
        String[] cmdarray = (String[])((Object[])new String[]{dotExe, "-Tsvg", "-o", outputFile, "-v", dotFile.getAbsolutePath()});
        System.out.println(new StringBuilder().append((Object)"Spawning process").append(Predef$.MODULE$.refArrayOps((Object[])cmdarray).foldLeft((Object)"", (Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String r, String s) {
                return new StringBuilder().append((Object)r).append((Object)" ").append((Object)s).toString();
            }
        })).toString());
        try {
            Process p = Runtime.getRuntime().exec(cmdarray);
            BufferedInputStream output = new BufferedInputStream(p.getInputStream());
            BufferedInputStream error = new BufferedInputStream(p.getErrorStream());
            boolean repeat = true;
            while (repeat) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (output.available() > 0) {
                    ListBuffer data = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    int nRead = output.read((byte[])data.toArray((ClassManifest)Manifest$.MODULE$.Byte()));
                }
                if (error.available() > 0) {
                    ListBuffer data = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    int nRead = error.read((byte[])data.toArray((ClassManifest)Manifest$.MODULE$.Byte()));
                }
                try {
                    p.exitValue();
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    repeat = true;
                }
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw JSAFError$.MODULE$.error("IOException DotUtil.");
        }
    }

    public File writeDotFile(CFG cfg, Map<Object, Set<Object>> m, String dotfile) {
        File exceptionResult1 = null;
        try {
            File f = new File(dotfile);
            FileWriter fw = new FileWriter(f);
            String str = this.drawGraph(cfg, m);
            fw.write(str);
            fw.close();
            exceptionResult1 = f;
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            throw JSAFError$.MODULE$.error(new StringBuilder().append((Object)"Error writing dot file ").append((Object)dotfile).append((Object)".").toString());
        }
    }

    public void write(CFG cfg, Map<Object, Set<Object>> callgraph, String dotFile, String outputFile, String dotExe) {
        this.spawnDot(dotExe, outputFile, this.writeDotFile(cfg, callgraph, dotFile));
    }

    private CGWriter$() {
        MODULE$ = this;
    }
}

