/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import kr.ac.kaist.jsaf.analysis.cfg.CFG;
import kr.ac.kaist.jsaf.analysis.cfg.LBlock;
import kr.ac.kaist.jsaf.analysis.cfg.LEntry$;
import kr.ac.kaist.jsaf.analysis.cfg.LExit$;
import kr.ac.kaist.jsaf.analysis.cfg.LExitExc$;
import kr.ac.kaist.jsaf.analysis.cfg.Label;
import kr.ac.kaist.jsaf.analysis.typing.Worklist;
import kr.ac.kaist.jsaf.analysis.typing.Worklist$;
import kr.ac.kaist.jsaf.exceptions.JSAFError$;
import kr.ac.kaist.jsaf.nodes_util.DotUtil$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotUtil$
implements ScalaObject {
    public static final DotUtil$ MODULE$;
    private final int MAX_LABEL_LENGTH;

    static {
        new DotUtil$();
    }

    private int MAX_LABEL_LENGTH() {
        return this.MAX_LABEL_LENGTH;
    }

    public void dotify(CFG g, String dotFile, String outputFile, String dotExe) {
        Worklist wo = Worklist$.MODULE$.computes(g);
        TreeMap<Tuple2<Object, Label>, Object> o = wo.getOrder();
        this.spawnDot(dotExe, outputFile, this.writeDotFile(g, o, dotFile));
    }

    public File writeDotFile(CFG g, TreeMap<Tuple2<Object, Label>, Object> o, String dotfile) {
        File exceptionResult1 = null;
        try {
            File f = new File(dotfile);
            FileWriter fw = new FileWriter(f);
            fw.write(this.dotOutput(g, o));
            fw.close();
            exceptionResult1 = f;
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw JSAFError$.MODULE$.error(new StringBuilder().append((Object)"Error writing dot file ").append((Object)dotfile).append((Object)".").toString());
        }
    }

    public String getLabel(Tuple2<Object, Label> n, TreeMap<Tuple2<Object, Label>, Object> o) {
        Option option;
        block6: {
            Tuple2<Object, Label> tuple2;
            block7: {
                block12: {
                    String label;
                    block9: {
                        String string;
                        Label label2;
                        int n2;
                        String order;
                        block11: {
                            block10: {
                                block8: {
                                    String string2;
                                    block5: {
                                        block4: {
                                            option = o.get(n);
                                            if (!(option instanceof Some)) break block4;
                                            string2 = new StringBuilder().append((Object)"[").append(((Some)option).x()).append((Object)"]").toString();
                                            break block5;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option2 = option;
                                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                                        string2 = "";
                                    }
                                    order = string2;
                                    tuple2 = n;
                                    if (tuple2 == null) break block7;
                                    n2 = BoxesRunTime.unboxToInt((Object)tuple2._1());
                                    label2 = (Label)tuple2._2();
                                    LEntry$ lEntry$ = LEntry$.MODULE$;
                                    Label label3 = label2;
                                    if (lEntry$ != null ? !lEntry$.equals(label3) : label3 != null) break block8;
                                    string = new StringBuilder().append((Object)"\"").append((Object)order).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)n2)).append((Object)", ").append((Object)"LEntry)\"").toString();
                                    break block9;
                                }
                                LExit$ lExit$ = LExit$.MODULE$;
                                Label label4 = label2;
                                if (lExit$ != null ? !lExit$.equals(label4) : label4 != null) break block10;
                                string = new StringBuilder().append((Object)"\"").append((Object)order).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)n2)).append((Object)", ").append((Object)"LExit)\"").toString();
                                break block9;
                            }
                            LExitExc$ lExitExc$ = LExitExc$.MODULE$;
                            Label label5 = label2;
                            if (lExitExc$ != null ? !lExitExc$.equals(label5) : label5 != null) break block11;
                            string = new StringBuilder().append((Object)"\"").append((Object)order).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)n2)).append((Object)", ").append((Object)"LExitExc)\"").toString();
                            break block9;
                        }
                        if (!(label2 instanceof LBlock)) break block12;
                        string = label = new StringBuilder().append((Object)"\"").append((Object)order).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)n2)).append((Object)", ").append((Object)"LBlock(").append((Object)BoxesRunTime.boxToInteger((int)((LBlock)label2).id())).append((Object)"))\"").toString();
                    }
                    if (label.length() >= this.MAX_LABEL_LENGTH()) {
                        label = new StringBuilder().append((Object)label.substring(0, this.MAX_LABEL_LENGTH() - 3)).append((Object)"...").toString();
                    }
                    return label;
                }
                throw new MatchError(tuple2);
            }
            throw new MatchError(tuple2);
        }
        throw new MatchError((Object)option);
    }

    public String dotOutput(CFG g$1, TreeMap<Tuple2<Object, Label>, Object> o$1) {
        StringBuilder s$1 = new StringBuilder();
        s$1.append("digraph \"DirectedGraph\" {\n");
        s$1.append("center=true;fontsize=12;node [fontsize=12];edge [fontsize=12];\n");
        List<Tuple2<Object, Label>> dotNodes = g$1.getNodes();
        dotNodes.foreach((Function1)new Serializable(o$1, s$1){
            public static final long serialVersionUID;
            private final TreeMap o$1;
            private final StringBuilder s$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(Tuple2<Object, Label> n) {
                return this.s$1.append("   ").append(DotUtil$.MODULE$.getLabel(n, (TreeMap<Tuple2<Object, Label>, Object>)this.o$1)).append(DotUtil$.MODULE$.decorateNode(n));
            }
            {
                this.o$1 = treeMap;
                this.s$1 = stringBuilder;
            }
        });
        dotNodes.foreach((Function1)new Serializable(g$1, o$1, s$1){
            public static final long serialVersionUID;
            private final CFG g$1;
            public final TreeMap o$1;
            public final StringBuilder s$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Object, Label> n$1) {
                this.g$1.getSucc(n$1).foreach((Function1)new Serializable(this, n$1){
                    public static final long serialVersionUID;
                    private final anonfun.dotOutput.2 $outer;
                    private final Tuple2 n$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final StringBuilder apply(Tuple2<Object, Label> m) {
                        return this.$outer.s$1.append(" ").append(DotUtil$.MODULE$.getLabel((Tuple2<Object, Label>)this.n$1, (TreeMap<Tuple2<Object, Label>, Object>)this.$outer.o$1)).append(" -> ").append(DotUtil$.MODULE$.getLabel(m, (TreeMap<Tuple2<Object, Label>, Object>)this.$outer.o$1)).append(" \n");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.n$1 = tuple2;
                    }
                });
            }
            {
                this.g$1 = cFG;
                this.o$1 = treeMap;
                this.s$1 = stringBuilder;
            }
        });
        s$1.append("\n}");
        return s$1.toString();
    }

    public String decorateNode(Tuple2<Object, Label> n) {
        StringBuilder s = new StringBuilder();
        s.append(" [shape=\"box\" color=\"blue\"").append("]\n");
        return s.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spawnDot(String dotExe, String outputFile, File dotFile) {
        String[] cmdarray = (String[])((Object[])new String[]{dotExe, "-Tps", "-o", outputFile, "-v", dotFile.getAbsolutePath()});
        System.out.println(new StringBuilder().append((Object)"Spawning process").append(Predef$.MODULE$.refArrayOps((Object[])cmdarray).foldLeft((Object)"", (Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String r, String s) {
                return new StringBuilder().append((Object)r).append((Object)" ").append((Object)s).toString();
            }
        })).toString());
        try {
            Process p = Runtime.getRuntime().exec(cmdarray);
            BufferedInputStream output = new BufferedInputStream(p.getInputStream());
            BufferedInputStream error = new BufferedInputStream(p.getErrorStream());
            boolean repeat = true;
            while (repeat) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (output.available() > 0) {
                    ListBuffer data = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    int nRead = output.read((byte[])data.toArray((ClassManifest)Manifest$.MODULE$.Byte()));
                }
                if (error.available() > 0) {
                    ListBuffer data = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    int nRead = error.read((byte[])data.toArray((ClassManifest)Manifest$.MODULE$.Byte()));
                }
                try {
                    p.exitValue();
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    repeat = true;
                }
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw JSAFError$.MODULE$.error("IOException DotUtil.");
        }
    }

    private DotUtil$() {
        MODULE$ = this;
        this.MAX_LABEL_LENGTH = 75;
    }
}

