/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import kr.ac.kaist.jsaf.nodes.ASTSpanInfo;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor;
import kr.ac.kaist.jsaf.nodes.AbstractNodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.Expr;
import kr.ac.kaist.jsaf.nodes.If;
import kr.ac.kaist.jsaf.nodes.NodeVisitor;
import kr.ac.kaist.jsaf.nodes.NodeVisitor_void;
import kr.ac.kaist.jsaf.nodes.Stmt;
import kr.ac.kaist.jsaf.nodes.TreeWalker;
import kr.ac.kaist.jsaf.nodes_util.Span;

public class IfSS
extends If {
    private final Span _elseSpan;

    public IfSS(ASTSpanInfo in_info, Expr in_cond, Stmt in_trueBranch, Option<Stmt> in_falseBranch, Span in_elseSpan) {
        super(in_info, in_cond, in_trueBranch, in_falseBranch);
        if (in_elseSpan == null) {
            throw new IllegalArgumentException("Parameter 'elseSpan' to the IfSS constructor was null");
        }
        this._elseSpan = in_elseSpan;
    }

    public final Span getElseSpan() {
        return this._elseSpan;
    }

    @Override
    public <RetType> RetType accept(AbstractNodeVisitor<RetType> visitor) {
        return visitor.forIfSS(this);
    }

    @Override
    public <RetType> RetType accept(NodeVisitor<RetType> visitor) {
        return visitor.forIfSS(this);
    }

    @Override
    public void accept(AbstractNodeVisitor_void visitor) {
        visitor.forIfSS(this);
    }

    @Override
    public void accept(NodeVisitor_void visitor) {
        visitor.forIfSS(this);
    }

    @Override
    public boolean equals(Object obj) {
        Option<Stmt> casted_falseBranch;
        Stmt casted_trueBranch;
        Expr casted_cond;
        ASTSpanInfo casted_info;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        IfSS casted = (IfSS)obj;
        ASTSpanInfo temp_info = this.getInfo();
        if (temp_info != (casted_info = casted.getInfo()) && !temp_info.equals(casted_info)) {
            return false;
        }
        Expr temp_cond = this.getCond();
        if (temp_cond != (casted_cond = casted.getCond()) && !temp_cond.equals(casted_cond)) {
            return false;
        }
        Stmt temp_trueBranch = this.getTrueBranch();
        if (temp_trueBranch != (casted_trueBranch = casted.getTrueBranch()) && !temp_trueBranch.equals(casted_trueBranch)) {
            return false;
        }
        Option<Stmt> temp_falseBranch = this.getFalseBranch();
        return temp_falseBranch == (casted_falseBranch = casted.getFalseBranch()) || temp_falseBranch.equals(casted_falseBranch);
    }

    @Override
    public int generateHashCode() {
        int code = this.getClass().hashCode();
        ASTSpanInfo temp_info = this.getInfo();
        code ^= temp_info.hashCode();
        Expr temp_cond = this.getCond();
        code ^= temp_cond.hashCode();
        Stmt temp_trueBranch = this.getTrueBranch();
        code ^= temp_trueBranch.hashCode();
        Option<Stmt> temp_falseBranch = this.getFalseBranch();
        return code ^= temp_falseBranch.hashCode();
    }

    protected IfSS() {
        this._elseSpan = null;
    }

    @Override
    public void walk(TreeWalker w) {
        if (w.visitNode(this, "IfSS", 5)) {
            Span temp_elseSpan;
            Option<Stmt> temp_falseBranch;
            Stmt temp_trueBranch;
            Expr temp_cond;
            ASTSpanInfo temp_info = this.getInfo();
            if (w.visitNodeField("info", temp_info)) {
                temp_info.walk(w);
                w.endNodeField("info", temp_info);
            }
            if (w.visitNodeField("cond", temp_cond = this.getCond())) {
                temp_cond.walk(w);
                w.endNodeField("cond", temp_cond);
            }
            if (w.visitNodeField("trueBranch", temp_trueBranch = this.getTrueBranch())) {
                temp_trueBranch.walk(w);
                w.endNodeField("trueBranch", temp_trueBranch);
            }
            if (w.visitNodeField("falseBranch", temp_falseBranch = this.getFalseBranch())) {
                if (temp_falseBranch.isNone()) {
                    w.visitEmptyOption(temp_falseBranch);
                } else if (w.visitNonEmptyOption(temp_falseBranch)) {
                    Stmt elt_temp_falseBranch = (Stmt)temp_falseBranch.unwrap();
                    if (elt_temp_falseBranch == null) {
                        w.visitNull();
                    } else {
                        elt_temp_falseBranch.walk(w);
                    }
                    w.endNonEmptyOption(temp_falseBranch);
                }
                w.endNodeField("falseBranch", temp_falseBranch);
            }
            if (w.visitNodeField("elseSpan", temp_elseSpan = this.getElseSpan())) {
                w.visitUnknownObject(temp_elseSpan);
                w.endNodeField("elseSpan", temp_elseSpan);
            }
            w.endNode(this, "IfSS", 5);
        }
    }
}

