/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.IdentityWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitLogSink
implements LogSink,
Composite {
    private final Set<IdentityWrapper<LogSink>> _sinkSet = new HashSet<IdentityWrapper<LogSink>>();
    private volatile Iterable<LogSink> _sinks;

    public SplitLogSink(LogSink ... sinks) {
        this(IterUtil.asIterable(sinks));
    }

    public SplitLogSink(Iterable<? extends LogSink> sinks) {
        this.add(sinks);
    }

    public void add(LogSink ... toAdd) {
        for (LogSink s : toAdd) {
            this._sinkSet.add(IdentityWrapper.make(s));
        }
        this.refreshSinks();
    }

    public void add(Iterable<? extends LogSink> toAdd) {
        for (LogSink logSink : toAdd) {
            this._sinkSet.add(IdentityWrapper.make(logSink));
        }
        this.refreshSinks();
    }

    public void remove(LogSink ... toRemove) {
        for (LogSink s : toRemove) {
            this._sinkSet.remove(IdentityWrapper.make(s));
        }
        this.refreshSinks();
    }

    public void remove(Iterable<? extends LogSink> toRemove) {
        for (LogSink logSink : toRemove) {
            this._sinkSet.remove(IdentityWrapper.make(logSink));
        }
        this.refreshSinks();
    }

    private void refreshSinks() {
        this._sinks = IterUtil.snapshot(IterUtil.valuesOf(this._sinkSet));
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._sinks) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._sinks) + 1;
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        for (LogSink s : this._sinks) {
            try {
                s.close();
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void log(LogSink.StandardMessage m) {
        for (LogSink s : this._sinks) {
            s.log(m);
        }
    }

    @Override
    public void logStart(LogSink.StartMessage m) {
        for (LogSink s : this._sinks) {
            s.logStart(m);
        }
    }

    @Override
    public void logEnd(LogSink.EndMessage m) {
        for (LogSink s : this._sinks) {
            s.logEnd(m);
        }
    }

    @Override
    public void logError(LogSink.ErrorMessage m) {
        for (LogSink s : this._sinks) {
            s.logError(m);
        }
    }

    @Override
    public void logStack(LogSink.StackMessage m) {
        for (LogSink s : this._sinks) {
            s.logStack(m);
        }
    }
}

