/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.swing;

import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletComponent
extends JComponent {
    private final Applet _applet;
    private final Map<String, String> _params;
    private final URL _root;
    private State _state;

    public AppletComponent(Applet applet) {
        this(applet, null, Collections.emptyMap());
    }

    public AppletComponent(Applet applet, URL root, Map<String, String> params) {
        this._applet = applet;
        this._params = params;
        if (root == null) {
            try {
                this._root = IOUtil.WORKING_DIRECTORY.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Can't convert the working dir to a URL");
            }
        } else {
            this._root = root;
        }
        this._state = State.FRESH;
        this.add(this._applet);
        this._applet.setStub(new Stub());
    }

    public AppletComponent(Applet applet, int width, int height) {
        this(applet, width, height, null, Collections.emptyMap());
    }

    public AppletComponent(Applet applet, int width, int height, URL root, Map<String, String> params) {
        this(applet, root, params);
        this._applet.setSize(width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.updateState();
        super.paintComponent(g);
    }

    private void updateState() {
        if (!this._state.equals((Object)State.RUNNING)) {
            if (this._state.equals((Object)State.FRESH)) {
                this._applet.init();
                this._state = State.PAUSED;
            }
            this._applet.start();
            this._state = State.RUNNING;
        }
        if (!this._applet.getSize().equals(this.getSize())) {
            this._applet.setSize(this.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stub
    implements AppletStub,
    AppletContext {
        private final Map<String, InputStream> _streams = new HashMap<String, InputStream>();

        @Override
        public boolean isActive() {
            return AppletComponent.this._state.equals((Object)State.RUNNING);
        }

        @Override
        public URL getDocumentBase() {
            return AppletComponent.this._root;
        }

        @Override
        public URL getCodeBase() {
            return AppletComponent.this._root;
        }

        @Override
        public String getParameter(String name) {
            return (String)AppletComponent.this._params.get(name);
        }

        @Override
        public AppletContext getAppletContext() {
            return this;
        }

        @Override
        public void appletResize(int width, int height) {
            AppletComponent.this.setSize(width, height);
        }

        @Override
        public AudioClip getAudioClip(URL url) {
            return new AudioClip(){

                public void play() {
                }

                public void loop() {
                }

                public void stop() {
                }
            };
        }

        @Override
        public Image getImage(URL url) {
            return Toolkit.getDefaultToolkit().getImage(url);
        }

        @Override
        public Applet getApplet(String name) {
            return null;
        }

        @Override
        public Enumeration<Applet> getApplets() {
            return IterUtil.asEnumeration(IterUtil.singleton(AppletComponent.this._applet).iterator());
        }

        @Override
        public void showDocument(URL url) {
        }

        @Override
        public void showDocument(URL url, String target) {
        }

        @Override
        public void showStatus(String status) {
        }

        @Override
        public void setStream(String key, InputStream stream) {
            this._streams.put(key, stream);
        }

        @Override
        public InputStream getStream(String key) {
            return this._streams.get(key);
        }

        @Override
        public Iterator<String> getStreamKeys() {
            return this._streams.keySet().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        FRESH,
        PAUSED,
        RUNNING;

    }
}

