/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.wcv;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import kr.ac.kaist.jsaf.ProjectProperties;
import kr.ac.kaist.jsaf.exceptions.UserError;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ApiWhiteList {
    private static JSONObject cfgRules;
    private static JSONObject astRules;
    private static JSONObject cssRules;
    private static JSONArray localeSet;
    private static String BasePath;

    private static void loadJSON(String jsonFile, Rules rules) throws UserError {
        String jsonPath = BasePath + File.separator + "bin" + File.separator + "widget_validator" + File.separator;
        JSONParser parser = new JSONParser();
        try {
            File file = new File(jsonPath + jsonFile);
            if (!file.exists()) {
                throw new UserError("# Widget Validator Error : Can't find Json file.\n   * " + file.getAbsolutePath());
            }
            FileReader freader = new FileReader(file.getAbsoluteFile());
            switch (rules) {
                case CFG: {
                    cfgRules = (JSONObject)parser.parse((Reader)freader);
                    break;
                }
                case AST: {
                    astRules = (JSONObject)parser.parse((Reader)freader);
                    break;
                }
                case CSS: {
                    cssRules = (JSONObject)parser.parse((Reader)freader);
                    break;
                }
                case LOCALE: {
                    JSONObject obj = (JSONObject)parser.parse((Reader)freader);
                    Object support = obj.get((Object)"support");
                    localeSet = (JSONArray)support;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static int checkApiCFG(String typ, String func) throws UserError {
        if (null == cfgRules) {
            ApiWhiteList.loadJSON("wcv_apis.json", Rules.CFG);
        }
        if (cfgRules.containsKey((Object)typ)) {
            JSONObject obj = (JSONObject)cfgRules.get((Object)typ);
            return ApiWhiteList.checkInheritedApi(obj, func, false);
        }
        return -1;
    }

    public static int checkApiAST(String typ, String func) throws UserError {
        if (null == astRules) {
            ApiWhiteList.loadJSON("wcv_apis_ast.json", Rules.AST);
        }
        if (astRules.containsKey((Object)typ)) {
            JSONObject obj = (JSONObject)astRules.get((Object)typ);
            return ApiWhiteList.checkInheritedApi(obj, func, true);
        }
        return -1;
    }

    private static int checkInheritedApi(JSONObject obj, String func, boolean isAST) {
        Object nativeApi = obj.get((Object)"native");
        if (null != nativeApi && ((JSONArray)nativeApi).contains((Object)func)) {
            return 1;
        }
        Object inheritedApi = obj.get((Object)"inherited");
        if (null != inheritedApi) {
            Iterator inheritApiIter = ((JSONArray)inheritedApi).iterator();
            while (inheritApiIter.hasNext()) {
                JSONObject inheritObj;
                if (!(isAST ? ApiWhiteList.checkInheritedApi(inheritObj = (JSONObject)astRules.get(inheritApiIter.next()), func, isAST) > 0 : ApiWhiteList.checkInheritedApi(inheritObj = (JSONObject)cfgRules.get(inheritApiIter.next()), func, isAST) > 0)) continue;
                return 1;
            }
        }
        return 0;
    }

    public static ArrayList getCSSAllowedValue(String property) throws UserError {
        Object properties;
        JSONObject obj;
        if (null == cssRules) {
            ApiWhiteList.loadJSON("DOMStyles.json", Rules.CSS);
        }
        if (null != (obj = (JSONObject)cssRules.get((Object)"style")) && null != (properties = obj.get((Object)property))) {
            return (JSONArray)properties;
        }
        return null;
    }

    public static ArrayList<String> getSubLocaleList(String rootPath) throws UserError {
        if (null == localeSet) {
            ApiWhiteList.loadJSON("locale.json", Rules.LOCALE);
        }
        if (rootPath == null || rootPath.isEmpty()) {
            throw new UserError("# Widget Validator Error : Analysis target path.\n   * Path : " + rootPath);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(rootPath);
        File root = new File(rootPath);
        File locales = new File(root.getAbsolutePath() + File.separator + "locales");
        if (locales.exists() && locales.isDirectory()) {
            File[] subLocales;
            for (File dir : subLocales = locales.listFiles(new FileFilter(){

                @Override
                public boolean accept(File subFile) {
                    String subPath = subFile.getAbsolutePath();
                    String langName = subPath.substring(subPath.lastIndexOf(File.separator) + 1, subPath.length());
                    return localeSet.contains((Object)langName);
                }
            })) {
                list.add(dir.getAbsolutePath());
            }
        }
        return list;
    }

    static {
        BasePath = ProjectProperties.BASEDIR();
    }

    public static enum Rules {
        CFG,
        AST,
        CSS,
        LOCALE;

    }
}

