/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import com.ibm.wala.cast.js.html.IHtmlCallback;
import com.ibm.wala.cast.js.html.ITag;
import com.ibm.wala.cast.js.html.IUrlResolver;
import com.ibm.wala.cast.js.html.SourceRegion;
import com.ibm.wala.cast.js.html.UnicodeReader;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.util.collections.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;

public class DomLessSourceExtractor {
    private static final Pattern LEGAL_JS_IDENTIFIER_REGEXP = Pattern.compile("[a-zA-Z$_][a-zA-Z\\d$_]*");

    public static String getScriptName(String file) throws MalformedURLException {
        int lastIdxOfSlash = file.lastIndexOf(47);
        file = lastIdxOfSlash == -1 ? file : file.substring(lastIdxOfSlash + 1);
        return file;
    }

    protected static class HtmlCallback
    implements IGeneratorCallback {
        protected final URL entrypointUrl;
        protected final IUrlResolver urlResolver;
        protected final SourceRegion scriptRegion;
        protected final SourceRegion domRegion;
        protected final SourceRegion entrypointRegion;
        private ITag currentScriptTag;
        private int counter = 0;

        public HtmlCallback(URL entrypointUrl, IUrlResolver urlResolver) {
            this.entrypointUrl = entrypointUrl;
            this.urlResolver = urlResolver;
            this.scriptRegion = new SourceRegion();
            this.domRegion = new SourceRegion();
            this.entrypointRegion = new SourceRegion();
        }

        protected CAstSourcePositionMap.Position makePos(int lineNumber, ITag governingTag) {
            return this.makePos(this.entrypointUrl, lineNumber, governingTag);
        }

        protected CAstSourcePositionMap.Position makePos(URL url, int lineNumber, ITag governingTag) {
            return governingTag.getElementPosition();
        }

        public void handleEndTag(ITag tag) {
            if (tag.getName().equalsIgnoreCase("script")) {
                assert (this.currentScriptTag != null);
                this.currentScriptTag = null;
            }
        }

        public void handleText(CAstSourcePositionMap.Position p, String text) {
            if (this.currentScriptTag != null) {
                if (text.startsWith("<![CDATA[")) {
                    assert (text.endsWith("]]>"));
                    text = text.substring(9, text.length() - 11);
                }
                this.scriptRegion.println(text, this.currentScriptTag.getContentPosition(), this.entrypointUrl);
            }
        }

        public void handleStartTag(ITag tag) {
            if (tag.getName().equalsIgnoreCase("script")) {
                this.handleScript(tag);
                assert (this.currentScriptTag == null);
                this.currentScriptTag = tag;
            }
            this.handleDOM(tag);
        }

        protected void handleDOM(ITag tag) {
            Pair idAttribute = tag.getAttributeByName("id");
            String funcName = idAttribute != null && LEGAL_JS_IDENTIFIER_REGEXP.matcher((CharSequence)idAttribute.fst).matches() ? (String)idAttribute.fst : "node" + this.counter++;
            this.handleDOM(tag, funcName);
        }

        protected void handleDOM(ITag tag, String funcName) {
            Map attributeSet = tag.getAllAttributes();
            for (Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> entry : attributeSet.entrySet()) {
                this.handleAttribute(entry, funcName, tag);
            }
        }

        private void handleAttribute(Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> a, String funcName, ITag tag) {
            URL url = this.entrypointUrl;
            try {
                url = new URL(this.entrypointUrl, "#" + tag.getElementPosition().getFirstOffset());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            CAstSourcePositionMap.Position pos = (CAstSourcePositionMap.Position)a.getValue().snd;
            String attName = a.getKey();
            String attValue = (String)a.getValue().fst;
            if (attName.toLowerCase().startsWith("on") || attValue != null && attValue.toLowerCase().startsWith("javascript:")) {
                String fName = tag.getName().toLowerCase() + "_" + attName + "_" + funcName;
                String signatureLine = "function " + fName + "(event) {";
                this.domRegion.println(signatureLine + "\n" + this.extructJS(attValue) + "\n}", pos, url);
                this.entrypointRegion.println("\t" + fName + "(null);", pos, url);
            }
        }

        private String[] extructJS(String attValue) {
            if (attValue == null) {
                return new String[0];
            }
            String content = attValue.toLowerCase().equals("javascript:") ? attValue.substring("javascript:".length()) : attValue;
            return content.split("\\n");
        }

        protected void handleScript(ITag tag) {
            Pair value = tag.getAttributeByName("src");
            try {
                if (value != null) {
                    this.getScriptFromUrl((String)value.fst, tag);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading script file: " + e.getMessage());
            }
        }

        private String getAbsoluteUrl(String baseUrl, String filePath) {
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            } else if (filePath.startsWith("./")) {
                filePath = filePath.substring(2);
            }
            return baseUrl + filePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getScriptFromUrl(String urlAsString, ITag scriptTag) throws IOException, MalformedURLException {
            String url = this.getAbsoluteUrl(this.entrypointUrl.toString(), urlAsString);
            System.out.println(" > " + url);
            URL absoluteUrl = new URL(url);
            URL scriptSrc = this.urlResolver.resolve(absoluteUrl);
            if (scriptSrc == null) {
                return;
            }
            try (InputStream scriptInputStream = scriptSrc.openConnection().getInputStream();){
                String line;
                BufferedReader scriptReader = new BufferedReader((Reader)new UnicodeReader(scriptInputStream, "UTF8"));
                while ((line = scriptReader.readLine()) != null) {
                    this.scriptRegion.println(line, scriptTag.getElementPosition(), scriptSrc);
                }
            }
        }

        @Override
        public void writeToFinalRegion(SourceRegion finalRegion) {
            finalRegion.println("window.__MAIN__ = function __WINDOW_MAIN__(){");
            finalRegion.write(this.scriptRegion);
            finalRegion.write(this.domRegion);
            finalRegion.println("  document.URL = new String(\"" + this.entrypointUrl + "\");");
            finalRegion.println("while (true){ ");
            finalRegion.write(this.entrypointRegion);
            finalRegion.println("} // while (true)");
            finalRegion.println("} // end of window.__MAIN__");
            finalRegion.println("window.__MAIN__();");
        }
    }

    static interface IGeneratorCallback
    extends IHtmlCallback {
        public void writeToFinalRegion(SourceRegion var1);
    }
}

