/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.DirectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestOutputStream
extends DirectOutputStream {
    private final MessageDigest _messageDigest;

    public MessageDigestOutputStream(MessageDigest messageDigest) {
        this._messageDigest = messageDigest;
    }

    public byte[] digest() {
        return this._messageDigest.digest();
    }

    public void close() {
    }

    public void flush() {
    }

    public void write(byte[] bbuf) {
        this._messageDigest.update(bbuf);
    }

    public void write(byte[] bbuf, int offset, int len) {
        this._messageDigest.update(bbuf, offset, len);
    }

    public void write(int b) {
        this._messageDigest.update((byte)b);
    }

    public static MessageDigestOutputStream makeMD5() {
        try {
            return new MessageDigestOutputStream(MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static MessageDigestOutputStream makeSHA1() {
        try {
            return new MessageDigestOutputStream(MessageDigest.getInstance("SHA-1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static MessageDigestOutputStream makeSHA256() {
        try {
            return new MessageDigestOutputStream(MessageDigest.getInstance("SHA-256"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

