/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.webwidget.support;

import java.util.HashSet;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tizen.common.ui.dialog.PopupDialog;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.WidgetContent;
import org.tizen.web.config.schema.model.WidgetLabel;
import org.tizen.web.config.schema.model.WidgetMetadata;
import org.tizen.web.config.schema.model.WidgetSize;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.EditorFormToolkit;
import org.tizen.web.editor.configuration.tizen.webwidget.support.AddMetaDataDialog;
import org.tizen.web.editor.configuration.tizen.webwidget.support.MetaDataContentProvider;
import org.tizen.web.editor.configuration.tizen.webwidget.support.MetaDataLabelProvider;

public class EditWebWidgetDialog
extends PopupDialog {
    private AppWidget widget = null;
    private WidgetLabel widgetLabel = null;
    private WidgetContent widgetContent = null;
    private WidgetSize widgetSize = null;
    private Text txID = null;
    private Text txLabel = null;
    private Text txContent = null;
    private Text txPreview = null;
    private Combo cbPrimary = null;
    private Spinner spInstance = null;
    private TableViewer metaDataTableViewer = null;
    private EditorFormToolkit editorToolkit = null;
    private IProject project = null;

    public EditWebWidgetDialog(Shell parentShell, AppWidget widget, IProject project) {
        super(parentShell, Messages.TizenPage_WebWidgetEditTitle);
        this.widget = widget;
        this.project = project;
        this.parseAppWidget();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.editorToolkit = new EditorFormToolkit(newShell.getDisplay());
    }

    public void create() {
        super.create();
        this.update();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 30;
        this.createIDControl(composite);
        this.createPrimaryControl(composite);
        this.createInstanceControl(composite);
        this.createLabelControl(composite);
        this.createContentControl(composite);
        this.createPreviewControl(composite);
        this.createMetaDataComposite(composite);
        return composite;
    }

    private void createIDControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetIdLabel);
        GridData data = new GridData(1, 0x1000000, false, false);
        data.widthHint = 105;
        label.setLayoutData((Object)data);
        this.txID = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 335;
        this.txID.setLayoutData((Object)data);
    }

    private void createPrimaryControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetPrimaryLabel);
        this.cbPrimary = new Combo(parent, 2056);
        GridData layoutData = new GridData(768);
        this.cbPrimary.setLayoutData((Object)layoutData);
    }

    private void createInstanceControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetMaxInstanceLabel);
        this.spInstance = new Spinner(parent, 2048);
        GridData layoutData = new GridData(768);
        this.spInstance.setLayoutData((Object)layoutData);
    }

    private void createLabelControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetLabelLabel);
        this.txLabel = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        this.txLabel.setLayoutData((Object)layoutData);
    }

    private void createContentControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetContentLabel);
        Composite contentComposite = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 10;
        contentComposite.setLayout((Layout)grid);
        contentComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txContent = new Text(contentComposite, 2048);
        this.txContent.setLayoutData((Object)new GridData(4, 2, true, false));
        Button btBrowse = new Button(contentComposite, 0);
        btBrowse.setText(Messages.TizenPage_WebWidgetBrowseLabel);
        btBrowse.setLayoutData((Object)new GridData(3, 2, false, false));
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(EditWebWidgetDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dlg.setInput((Object)EditWebWidgetDialog.this.project);
                dlg.setAllowMultiple(false);
                dlg.setMessage(Messages.TizenPage_WebWidgetContentBrowseDescription);
                dlg.setTitle(Messages.TizenPage_WebWidgetContentBrowseTitle);
                dlg.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 0) {
                            return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                        }
                        if (selection[0] instanceof File) {
                            return new Status(0, "org.tizen.common.ui", "");
                        }
                        return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                    }
                });
                if (dlg.open() == 0) {
                    IResource resource = (IResource)dlg.getFirstResult();
                    String path = resource.getProjectRelativePath().toPortableString();
                    EditWebWidgetDialog.this.txContent.setText(path);
                }
            }
        });
    }

    private void createPreviewControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetPreviewLabel);
        Composite previewComposite = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 10;
        previewComposite.setLayout((Layout)grid);
        previewComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txPreview = new Text(previewComposite, 2048);
        this.txPreview.setLayoutData((Object)new GridData(4, 2, true, false));
        Button btBrowse = new Button(previewComposite, 0);
        btBrowse.setText(Messages.TizenPage_WebWidgetBrowseLabel);
        btBrowse.setLayoutData((Object)new GridData(3, 2, false, false));
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(EditWebWidgetDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dlg.setInput((Object)EditWebWidgetDialog.this.project);
                dlg.setAllowMultiple(false);
                dlg.setMessage(Messages.TizenPage_WebWidgetPreviewBrowseDescription);
                dlg.setTitle(Messages.TizenPage_WebWidgetPreviewBrowseTitle);
                dlg.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 0) {
                            return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                        }
                        if (selection[0] instanceof File) {
                            return new Status(0, "org.tizen.common.ui", "");
                        }
                        return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                    }
                });
                if (dlg.open() == 0) {
                    IResource resource = (IResource)dlg.getFirstResult();
                    String path = resource.getProjectRelativePath().toPortableString();
                    EditWebWidgetDialog.this.txPreview.setText(path);
                }
            }
        });
    }

    private void createMetaDataComposite(Composite parent) {
        Composite base = new Composite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        base.setLayoutData((Object)data);
        this.createMetaDataButtons(base);
        this.createMetaDataTable(base);
    }

    private void createMetaDataButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginTop = 10;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginBottom = 0;
        grid.marginWidth = 0;
        composite.setLayout((Layout)grid);
        composite.setLayoutData((Object)new GridData(768));
        Label metaLabel = new Label(composite, 64);
        metaLabel.setText(Messages.TizenPage_MetadataLabel);
        GridData data = new GridData(1, 1, true, false);
        metaLabel.setLayoutData((Object)data);
        Composite tableBtns = new Composite(composite, 0);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(128));
        ImageButton btAdd = this.editorToolkit.createAddButton(tableBtns);
        btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                HashSet<String> keySet = new HashSet<String>();
                TableItem[] tableItemArray = items = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    WidgetMetadata data = (WidgetMetadata)item.getData();
                    keySet.add(data.getKey());
                    ++n2;
                }
                AddMetaDataDialog dlg = new AddMetaDataDialog(EditWebWidgetDialog.this.getShell(), keySet, null);
                if (dlg.open() == 0) {
                    WidgetMetadata newMetadata = new WidgetMetadata();
                    newMetadata.setKey(dlg.getNewKey());
                    newMetadata.setValue(dlg.getNewValue());
                    EditWebWidgetDialog.this.widget.getContent().add(newMetadata);
                    EditWebWidgetDialog.this.metaDataTableViewer.refresh();
                }
            }
        });
        ImageButton btEdit = this.editorToolkit.createEditButton(tableBtns);
        btEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] selection = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getSelection();
                if (selection.length <= 0) {
                    return;
                }
                WidgetMetadata metadata = (WidgetMetadata)selection[0].getData();
                HashSet<String> keySet = new HashSet<String>();
                TableItem[] tableItemArray = items = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    WidgetMetadata data = (WidgetMetadata)item.getData();
                    keySet.add(data.getKey());
                    ++n2;
                }
                AddMetaDataDialog dlg = new AddMetaDataDialog(EditWebWidgetDialog.this.getShell(), keySet, metadata);
                if (dlg.open() == 0) {
                    metadata.setKey(dlg.getNewKey());
                    metadata.setValue(dlg.getNewValue());
                    EditWebWidgetDialog.this.metaDataTableViewer.refresh();
                }
            }
        });
        ImageButton btRemove = this.editorToolkit.createRemoveButton(tableBtns);
        btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getSelection();
                if (selection.length <= 0) {
                    return;
                }
                WidgetMetadata metadata = (WidgetMetadata)selection[0].getData();
                EditWebWidgetDialog.this.widget.getContent().remove(metadata);
                EditWebWidgetDialog.this.metaDataTableViewer.refresh();
            }
        });
    }

    private void createMetaDataTable(Composite parent) {
        this.metaDataTableViewer = new TableViewer(parent, 68356);
        Table table = this.metaDataTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 99;
        table.setLayoutData((Object)data);
        TableViewerColumn keyColumn = new TableViewerColumn(this.metaDataTableViewer, 0);
        keyColumn.getColumn().setText(Messages.TizenPage_Metadata_KeyLabel);
        TableViewerColumn valueColumn = new TableViewerColumn(this.metaDataTableViewer, 0);
        valueColumn.getColumn().setText(Messages.TizenPage_Metadata_ValueLabel);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        table.setLayout((Layout)tableLayout);
        this.metaDataTableViewer.setContentProvider((IContentProvider)new MetaDataContentProvider());
        this.metaDataTableViewer.setLabelProvider((IBaseLabelProvider)new MetaDataLabelProvider());
    }

    private void parseAppWidget() {
        for (Object obj : this.widget.getContent()) {
            if (obj instanceof WidgetLabel) {
                this.widgetLabel = (WidgetLabel)obj;
            }
            if (!(obj instanceof WidgetContent)) continue;
            this.widgetContent = (WidgetContent)obj;
        }
        if (this.widgetContent != null) {
            for (Object obj : this.widgetContent.getContent()) {
                if (!(obj instanceof WidgetSize)) continue;
                this.widgetSize = (WidgetSize)obj;
            }
        }
    }

    private void update() {
        DataBoolean[] values = DataBoolean.values();
        String[] items = new String[values.length];
        DataBoolean[] dataBooleanArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DataBoolean value = dataBooleanArray[n2];
            items[value.ordinal()] = value.value();
            ++n2;
        }
        this.cbPrimary.setItems(items);
        if (this.widget != null) {
            this.txID.setText(this.widget.getId());
            int idxPrimary = this.widget.getPrimary().ordinal();
            this.cbPrimary.select(idxPrimary);
            Integer instance = this.widget.getMaxInstance();
            if (instance != null) {
                this.spInstance.setSelection(instance.intValue());
            }
        }
        if (this.widgetLabel != null) {
            this.txLabel.setText(this.widgetLabel.getContent());
        }
        if (this.widgetContent != null) {
            this.txContent.setText(this.widgetContent.getSrc());
        }
        if (this.widgetSize != null) {
            this.txPreview.setText(this.widgetSize.getPreview());
        }
        this.metaDataTableViewer.setInput((Object)this.widget.getContent());
    }

    protected void okPressed() {
        this.modifyWidget();
        super.okPressed();
    }

    private void modifyWidget() {
        String id = this.txID.getText();
        String primary = this.cbPrimary.getText();
        int maxInstance = this.spInstance.getSelection();
        String label = this.txLabel.getText();
        String content = this.txContent.getText();
        String preview = this.txPreview.getText();
        this.widget.setId(id);
        this.widget.setPrimary(DataBoolean.fromValue((String)primary));
        this.widget.setMaxInstance(Integer.valueOf(maxInstance));
        this.widgetLabel.setContent(label);
        this.widgetContent.setSrc(content);
        this.widgetSize.setPreview(preview);
    }

    public boolean close() {
        this.editorToolkit.dispose();
        return super.close();
    }
}

