/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.deployer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.zimlaunch.constants.LaunchType;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.deployer.IStepFactory;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.step.DebugInspectorOpenStep;
import org.tizen.web.zimlaunch.step.DebugPortSettingStep;
import org.tizen.web.zimlaunch.step.DebugStep;
import org.tizen.web.zimlaunch.step.DebugURLSettingStep;
import org.tizen.web.zimlaunch.step.InstallStep;
import org.tizen.web.zimlaunch.step.KillStep;
import org.tizen.web.zimlaunch.step.PackageStep;
import org.tizen.web.zimlaunch.step.RdsDeltaInputStep;
import org.tizen.web.zimlaunch.step.RdsStep;
import org.tizen.web.zimlaunch.step.RunStep;
import org.tizen.web.zimlaunch.step.TransferStep;
import org.tizen.web.zimlaunch.step.UnInstallStep;
import org.tizen.web.zimlaunch.step.UpdateStep;
import org.tizen.web.zimlaunch.step.WidgetKillStep;
import org.tizen.web.zimlaunch.step.WidgetRunStep;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class StepFactory
implements IStepFactory {
    protected ILaunchConfiguration config;
    protected String mode;

    @Override
    public IStep createStep(ILaunchConfiguration config, String mode, boolean isInstalled) throws CoreException, ConfigurationException {
        this.config = config;
        this.mode = mode;
        IProject project = LaunchUtil.getProject((ILaunchConfiguration)config);
        if (project == null) {
            TizenWebIDEException.abort(LaunchMessages.PROJECT_NOT_FOUND, null, new TizenWebNotifier[0]);
        }
        CompositeStep fullstep = null;
        boolean isRdsMode = LaunchUtil.isRdsMode(LaunchUtil.getProject((ILaunchConfiguration)config));
        boolean isUpdateMode = config.getAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, false);
        fullstep = !isInstalled ? new CompositeStep(this.newPackageStep(), new TransferStep(), this.newInstallStep(), this.getRunOrDebugSteps(config, project, mode)) : (StepFactory.needToFullInstall(config, project, mode) ? new CompositeStep(this.newPackageStep(), new TransferStep(), this.newKillStep(), new UnInstallStep(), this.newInstallStep(), this.getRunOrDebugSteps(config, project, mode)) : (isUpdateMode && !isRdsMode ? new CompositeStep(this.newPackageStep(), new TransferStep(), this.newKillStep(), new UpdateStep(), this.getRunOrDebugSteps(config, project, mode)) : (isRdsMode ? new CompositeStep(new KillStep(), this.newRdsStep(), this.getRunOrDebugSteps(config, project, mode)) : new CompositeStep(this.newPackageStep(), new TransferStep(), this.newKillStep(), new UnInstallStep(), this.newInstallStep(), this.getRunOrDebugSteps(config, project, mode)))));
        return fullstep;
    }

    protected KillStep newKillStep() throws CoreException {
        IProject project = LaunchUtil.getProject((ILaunchConfiguration)this.config);
        if (ProjectUtil.isWebWidgetProject((IProject)project)) {
            return new WidgetKillStep();
        }
        return new KillStep();
    }

    protected InstallStep newInstallStep() {
        return new InstallStep(new RdsDeltaInputStep());
    }

    protected PackageStep newPackageStep() {
        return new PackageStep();
    }

    protected DebugStep newDebugStep() {
        return new DebugStep(null, null, null);
    }

    protected RdsStep newRdsStep() {
        return new RdsStep();
    }

    protected static boolean needToFullInstall(ILaunchConfiguration config, IProject project, String mode) throws CoreException, ConfigurationException {
        boolean isLiveEditingMode = config.getAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, false);
        int lastLaunchType = StepFactory.getLastLaunchType(project, config);
        int currentLaunchType = LaunchUtil.getCurrentLaunchType(config, project, mode);
        return ProjectUtil.isCompanionApp((IProject)project) || ProjectUtil.isHybridApp((IProject)project) || isLiveEditingMode && !"debug".equals(mode) || currentLaunchType != lastLaunchType || LaunchUtil.needFullInstall(project);
    }

    protected static int getLastLaunchType(IProject project, ILaunchConfiguration config) throws CoreException {
        IResource resource = (IResource)project.getAdapter(IResource.class);
        String property = resource.getPersistentProperty(new QualifiedName("org.tizen.web.zimlaunch", String.valueOf(TizenWebLaunchConstants.ATTR_LATEST_LAUNCH_TYPE) + config.getAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", "")));
        if (property == null) {
            return LaunchType.UNKNOWN.ordinal();
        }
        return Integer.parseInt(property);
    }

    protected IStep getRunOrDebugSteps(ILaunchConfiguration config, IProject project, String mode) throws ConfigurationException, CoreException {
        CompositeStep steps = null;
        if (!LaunchUtil.canRun(project)) {
            return null;
        }
        if (ProjectUtil.isWebWidgetProject((IProject)project)) {
            steps = new CompositeStep(new WidgetRunStep());
        } else if (config.getType().getName().equals("Tizen Web Unit Test")) {
            steps = new CompositeStep(this.newDebugStep());
        } else if ("run".equals(mode)) {
            steps = new CompositeStep(new RunStep());
        } else if ("debug".equals(mode)) {
            steps = new CompositeStep(this.getCommonDebugSteps());
        }
        return steps;
    }

    protected IStep getCommonDebugSteps() {
        return new DebugStep(new DebugPortSettingStep(), new DebugURLSettingStep(), new DebugInspectorOpenStep());
    }
}

