/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.file.IResource;
import org.tizen.common.launch.TizenPackageInstaller;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class TransferStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(TransferStep.class);
    public static final String name = Messages.TRANSFER_PACKAGE;
    protected ILaunchConfiguration config;
    protected CommandLauncher launcher;
    protected ZimLaunchResource resource;
    protected TizenWebNotifier notifier;
    protected int percent;
    private IResource packageResource;

    public TransferStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        this.preExecuteStep(ctx);
        this.handleCancelEvent(this.notifier, this.notifier.getMonitor());
        UserLogger.start((String)"web.launch", (String)".transfer");
        IDevice device = this.resource.getDeviceinfo().getDevice();
        String dirPKG = TizenPlatformConstants.getAppTmpDirectory((IDevice)device);
        String cmd = "";
        cmd = this.makeCreateCommand(dirPKG);
        this.launcher.runCommand(cmd, false);
        this.handleCancelEvent(this.notifier, this.notifier.getMonitor());
        this.transferPackage(this.packageResource);
        this.handleCancelEvent(this.notifier, this.notifier.getMonitor());
        IProject project = this.resource.getAppinfo().getProject();
        this.copyDeviceProfileToDevice(project, device);
        UserLogger.end((String)"web.launch", (String)".transfer");
    }

    private void copyDeviceProfileToDevice(IProject project, IDevice device) throws CoreException {
        String profileName = SigningProfileUtil.getActiveProfileName();
        TizenPackageInstaller installer = new TizenPackageInstaller(project, device, profileName);
        installer.installDeviceProfile();
    }

    protected String makeCreateCommand(String dirPKG) {
        return "mkdir -p " + dirPKG;
    }

    private void transferPackage(IResource packageResource) throws CoreException, IOException {
        String errMsg = "";
        int code = 0;
        InputStream packageIs = null;
        SyncService service = null;
        try {
            packageIs = packageResource.getContents();
            IDevice device = this.resource.getDeviceinfo().getDevice();
            String destPath = String.valueOf(TizenPlatformConstants.getAppTmpDirectory((IDevice)device)) + "/" + this.resource.getAppinfo().getAppFile().getName();
            service = device.getSyncService();
            SyncResult syncSuccess = service.doPush(packageIs, device.getFileEntry(destPath), null, this.launcher.getTimeout());
            code = syncSuccess.getCode();
            if (!syncSuccess.isOk()) {
                errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.TRANSFER_PACKAGE);
                TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE), new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
            }
            this.notifier.notifyContents(NLS.bind((String)Messages.TRANSFERRED_PACKAGE, (Object)"wgt stream", (Object)destPath), this.getWorkCount(100));
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{packageIs, service});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{packageIs, service});
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.packageResource = (IResource)ctx.getValue((Object)"package");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.packageResource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_CONFIG.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.config = (ILaunchConfiguration)ctx.getValue((Object)"config");
        if (this.config == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_CONFIG.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

