/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.rest.template;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.tizen.web.rest.template.ITemplateConstants;

public class TemplateManager {
    private static TemplateManager instance;
    private Configuration cfg;

    public static TemplateManager getInstance() {
        if (instance == null) {
            instance = new TemplateManager();
        }
        return instance;
    }

    private TemplateManager() {
        this.initialize();
    }

    private void initialize() {
        this.cfg = new Configuration();
        StringTemplateLoader loader = new StringTemplateLoader();
        this.loadTemplate(loader);
        this.cfg.setTemplateLoader((TemplateLoader)loader);
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
    }

    private void loadTemplate(StringTemplateLoader loader) {
        loader.putTemplate("TEMPLATE_KEY_FUNCTION_CALL", "${functionName}();");
        loader.putTemplate("TEMPLATE_KEY_FUNCTION_GET", ITemplateConstants.TEMPLATE_FUNCTION_GET);
        loader.putTemplate("TEMPLATE_KEY_FUNCTION_POST", ITemplateConstants.TEMPLATE_FUNCTION_POST);
        loader.putTemplate("TEMPLATE_KEY_FUNCTION_PUT", ITemplateConstants.TEMPLATE_FUNCTION_PUT);
        loader.putTemplate("TEMPLATE_KEY_FUNCTION_DELETE", ITemplateConstants.TEMPLATE_FUNCTION_DELETE);
        loader.putTemplate("TEMPLATE_KEY_FUNCTION_POST_FILE", ITemplateConstants.TEMPLATE_FUNCTION_POST_FILE);
    }

    public Template getTemplate(String templateName) throws IOException {
        return this.cfg.getTemplate(templateName);
    }

    public void process(Template template, Writer writer, Object data) throws TemplateException, IOException {
        template.process(data, writer);
    }

    public void process(String templateName, Writer writer, Object data) throws TemplateException, IOException {
        Template template = this.getTemplate(templateName);
        this.process(template, writer, data);
    }

    public String process(String templateName, Object data) throws TemplateException, IOException {
        String result = "";
        Template template = this.getTemplate(templateName);
        StringWriter writer = new StringWriter();
        try {
            this.process(template, (Writer)writer, data);
            result = ((Object)writer).toString();
        }
        finally {
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
        return result;
    }
}

