/*
 * Decompiled with CFR 0.152.
 */
package json.util.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import json.util.JsonCharUtility;
import json.util.reader.JsonReader;
import json.util.reader.JsonReaderException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class JsonFileReader
implements JsonReader {
    private Reader reader;
    private char previous;
    private char current;
    private int position;
    private IFile iFile;
    private File file;

    public JsonFileReader(IFile iFile) throws CoreException {
        this.iFile = iFile;
        InputStream stream = iFile.getContents();
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    public JsonFileReader(File file) throws FileNotFoundException {
        this.file = file;
        FileInputStream stream = new FileInputStream(file);
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    public char getPrevious() {
        return this.previous;
    }

    @Override
    public char getCurrent() {
        return this.current;
    }

    @Override
    public char getNextClean() throws JsonReaderException {
        char ch = ' ';
        while (JsonCharUtility.isWhiteSpace(ch)) {
            ch = this.next();
        }
        this.previous = this.current;
        this.current = ch;
        return this.current;
    }

    @Override
    public char getNextChar() throws JsonReaderException {
        char ch = this.next();
        this.previous = this.current;
        this.current = ch;
        return this.current;
    }

    private char next() throws JsonReaderException {
        try {
            ++this.position;
            char ch = (char)this.reader.read();
            return ch;
        }
        catch (IOException iOException) {
            throw new JsonReaderException();
        }
    }

    @Override
    public int getPosition() {
        return this.position - 1;
    }

    public IFile getIFile() {
        return this.iFile;
    }

    public File getFile() {
        return this.file;
    }
}

