/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.editor.widl.util.PrivilegeUtil;
import org.tizen.web.privilege.core.Modules;
import org.tizen.web.privilege.core.PrivilegeCheckHelper;
import org.tizen.web.privilege.core.PrivilegeIDLReader;
import org.tizen.web.privilege.visitor.JsASTVisitor;

public class PrivilegeCheckUtil
extends PrivilegeUtil {
    protected static final Logger logger = LoggerFactory.getLogger(PrivilegeCheckUtil.class);
    private static final String[] JS_FILE_NAMES_OF_LIB = new String[]{"tizen.js", "ExtraTizen.js"};
    public static final String PRIVILEGE_CHECK_EXTENSION_ID = "org.tizen.web.privilege.check";

    public static String[] getExcludes() throws CoreException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(WebConstant.DEFAULT_EXCLUDING_RESOURCES));
        excludes.addAll(Arrays.asList(PrivilegeCheckHelper.getExcludeFolders()));
        return excludes.toArray(new String[0]);
    }

    public static Modules getUsableLibs(IProject project) {
        PrivilegeIDLReader pidlr = new PrivilegeIDLReader();
        Collection docs = PrivilegeCheckUtil.getWidlProcXmls((IProject)project);
        for (Document doc : docs) {
            pidlr.addModules(doc);
        }
        Modules modules = pidlr.getModules();
        PrivilegeCheckUtil.setSymboles(modules, project);
        return modules;
    }

    private static void setSymboles(Modules modules, IProject project) {
        ArrayList<Object> libFileNames = new ArrayList();
        libFileNames = PrivilegeCheckUtil.getPrivilegeJsLibFileNames(project);
        try {
            JsASTVisitor jsAstVisitor = new JsASTVisitor(modules);
            IJavaScriptProject currentJavaScriptProject = PrivilegeCheckUtil.getJavaScriptProject(project);
            List<IJavaScriptElement> includedJavaScriptLibraries = PrivilegeCheckUtil.getIncludedJavaScriptLibraries(currentJavaScriptProject);
            if (includedJavaScriptLibraries != null && includedJavaScriptLibraries.size() > 0) {
                for (IJavaScriptElement javaScriptUnit : includedJavaScriptLibraries) {
                    String elementName;
                    if (!(javaScriptUnit instanceof ClassFile) || !libFileNames.contains(elementName = ((ClassFile)javaScriptUnit).getElementName())) continue;
                    JavaScriptUnit jsDomUnit = (JavaScriptUnit)PrivilegeCheckUtil.parseJavaScript((ICompilationUnit)javaScriptUnit);
                    jsDomUnit.accept((ASTVisitor)jsAstVisitor);
                }
            }
        }
        catch (JavaScriptModelException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static ArrayList<String> getPrivilegeJsLibFileNames(IProject project) {
        ArrayList<String> libFileNames = new ArrayList<String>();
        libFileNames.addAll(Arrays.asList(JS_FILE_NAMES_OF_LIB));
        return libFileNames;
    }

    private static IJavaScriptProject getJavaScriptProject(IProject project) throws JavaScriptModelException {
        JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
        IJavaScriptProject[] javaScriptProjects = javaModel.getJavaScriptProjects();
        if (javaScriptProjects != null) {
            IJavaScriptProject[] iJavaScriptProjectArray = javaScriptProjects;
            int n = javaScriptProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaScriptProject javaScriptProject = iJavaScriptProjectArray[n2];
                IProject tempProject = javaScriptProject.getProject();
                if (tempProject != null && tempProject.equals((Object)project)) {
                    return javaScriptProject;
                }
                ++n2;
            }
        }
        return null;
    }

    private static List<IJavaScriptElement> getIncludedJavaScriptLibraries(IJavaScriptProject project) throws JavaScriptModelException {
        List<IJavaScriptElement> javaScriptUnits = new ArrayList<IJavaScriptElement>();
        IPackageFragmentRoot[] allPackageFragmentRoots = project.getAllPackageFragmentRoots();
        if (allPackageFragmentRoots != null && allPackageFragmentRoots.length > 0) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots;
            int n = allPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaScriptElement[] packageFragments;
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IJavaScriptProject thisJavaScriptProject = packageFragmentRoot.getJavaScriptProject();
                if ((packageFragmentRoot instanceof LibraryFragmentRoot || !thisJavaScriptProject.equals(project)) && (packageFragments = packageFragmentRoot.getChildren()) != null && packageFragments.length > 0) {
                    IJavaScriptElement[] iJavaScriptElementArray = packageFragments;
                    int n3 = packageFragments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaScriptElement javaScriptElement = iJavaScriptElementArray[n4];
                        if (javaScriptElement instanceof IPackageFragment) {
                            IPackageFragment packageFragment = (IPackageFragment)javaScriptElement;
                            if (packageFragment instanceof LibraryPackageFragment) {
                                IClassFile[] classFiles = packageFragment.getClassFiles();
                                if (classFiles != null && classFiles.length > 0) {
                                    IClassFile[] iClassFileArray = classFiles;
                                    int n5 = classFiles.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IClassFile classFile = iClassFileArray[n6];
                                        javaScriptUnits.add((IJavaScriptElement)classFile);
                                        ++n6;
                                    }
                                }
                            } else {
                                javaScriptUnits = PrivilegeCheckUtil.getJavaScriptUnits(javaScriptUnits, packageFragment);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return javaScriptUnits;
    }

    private static List<IJavaScriptElement> getJavaScriptUnits(List<IJavaScriptElement> javaScriptUnits, IPackageFragment packageFragment) throws JavaScriptModelException {
        IJavaScriptElement[] packageFragmentChildren = packageFragment.getChildren();
        if (packageFragmentChildren != null && packageFragmentChildren.length > 0) {
            IJavaScriptElement[] iJavaScriptElementArray = packageFragmentChildren;
            int n = packageFragmentChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaScriptElement javaScriptElement = iJavaScriptElementArray[n2];
                if (javaScriptElement instanceof IJavaScriptUnit) {
                    javaScriptUnits.add(javaScriptElement);
                } else {
                    PrivilegeCheckUtil.getJavaScriptUnits(javaScriptUnits, (IPackageFragment)javaScriptElement);
                }
                ++n2;
            }
        }
        return javaScriptUnits;
    }

    public static ASTNode parseJavaScript(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        if (unit instanceof IClassFile) {
            parser.setSource((IClassFile)unit);
        } else {
            parser.setSource((IJavaScriptUnit)unit);
        }
        parser.setResolveBindings(true);
        ASTNode node = null;
        try {
            node = parser.createAST(null);
        }
        catch (Exception exception) {
            logger.error("Faild to parse \"" + String.copyValueOf(unit.getFileName()) + "\"");
        }
        return node;
    }

    public static ArrayList<String> getCheckingPrivilegeApis(IProject project) {
        ArrayList<String> supportApis = new ArrayList<String>();
        IConfigurationElement[] ces = PluginUtil.getExtensionConfigurationElements((String)PRIVILEGE_CHECK_EXTENSION_ID);
        if (ces == null) {
            return supportApis;
        }
        TizenProjectDescription tproject = ProjectUtil.getTizenProjectDescription((IProject)project);
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement checkApiElement = iConfigurationElementArray[n2];
            String apiName = checkApiElement.getAttribute("apiName");
            if (apiName != null) {
                Object[] supportProfileElements = checkApiElement.getChildren();
                if (ArrayUtil.isEmpty((Object[])supportProfileElements)) {
                    supportApis.add(apiName);
                } else {
                    Object[] objectArray = supportProfileElements;
                    int n3 = supportProfileElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object supportProfileElement = objectArray[n4];
                        String supportProfileName = supportProfileElement.getAttribute("name");
                        if (tproject.getProfileName().equals(supportProfileName)) {
                            supportApis.add(apiName);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return supportApis;
    }
}

