/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.server;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.tizen.web.server.TizenHTTPServer;

public class TizenHTTPServerManager {
    private static final TizenHTTPServerManager manager = new TizenHTTPServerManager();
    private static TizenHTTPServer tizenHTTPserver = new TizenHTTPServer();

    private TizenHTTPServerManager() {
    }

    public static TizenHTTPServerManager getInstance() {
        if (tizenHTTPserver.isStopped()) {
            tizenHTTPserver.start();
        }
        return manager;
    }

    public TizenHTTPServer getServer() {
        return tizenHTTPserver;
    }

    public void addProjectHandler(IProject project) {
        if (!this.isLinkedProject(project)) {
            return;
        }
        String projectFullPath = project.getLocation().toOSString();
        String projectPath = project.getFullPath().toOSString();
        HashMap<String, String> contextMap = tizenHTTPserver.getContextPathMap();
        if (!contextMap.containsKey(projectPath)) {
            tizenHTTPserver.addHandler(projectPath, projectFullPath, true);
        }
    }

    public void addHandler(String contextPath, String deployPath) {
        tizenHTTPserver.addHandler(contextPath, deployPath, true);
    }

    public boolean isHanderExist(String contextPath) {
        return tizenHTTPserver.getContextPathMap().containsKey(contextPath);
    }

    public String getURL() {
        return tizenHTTPserver.getServerBaseURL();
    }

    public String getURL(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project can't be null");
        }
        return String.valueOf(tizenHTTPserver.getServerBaseURL()) + project.getFullPath().toString();
    }

    public boolean isLinkedProject(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project can't be null");
        }
        ArrayList<IProject> list = this.getLinkedProjects();
        if (list == null) {
            return false;
        }
        return list.contains(project);
    }

    public boolean isLinkedProject(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        ArrayList<IProject> list = this.getLinkedProjects();
        if (list == null) {
            return false;
        }
        for (IProject project : list) {
            if (!name.equals(project.getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<IProject> getLinkedProjects() {
        ArrayList<IProject> list = new ArrayList<IProject>();
        String workspaceFullPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects == null) {
            return null;
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectPath;
            IProject project = iProjectArray[n2];
            String projectFullPath = project.getLocation().toOSString();
            if (!workspaceFullPath.equals(projectFullPath.substring(0, projectFullPath.indexOf(projectPath = project.getFullPath().toOSString())))) {
                list.add(project);
            }
            ++n2;
        }
        return list;
    }
}

